#include "FuncEnter.h"

/*
	AddPropDlg.cpp
	Add User Property Dialog
	1-24-01
*/

#include "AddPropDlg.h"
#include "../PropEdit/ParseFuncs.h"
#include "Resource.h"

AddPropDlg::AddPropDlg(HINSTANCE hInstance,HWND hwndParent) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_ADDPROP),hwndParent)
{ FUNC_ENTER("AddPropDlg::AddPropDlg"); 
	fpOkCB=NULL;
	pOkCBData=NULL;
	iUserData=0;

	// Add all the property types to the combo box
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"Edit Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"List Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"Extensible List Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"Slider Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"Script Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"File Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"Color Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"Check Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"SpinEdit Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"Static Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"SliderNum Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"Node Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"MultiList Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"Flag Selector Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"Material Field");
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_ADDSTRING,(WPARAM)0,(LPARAM)"ColorPopup Field");

	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_SETCURSEL,(WPARAM)0,0);	
	CheckDlgButton(hwnd, IDC_USECURCAT, BST_CHECKED);
}

AddPropDlg::~AddPropDlg()
{ FUNC_ENTER("AddPropDlg::~AddPropDlg"); 

}

bool AddPropDlg::UseCategory()
{ FUNC_ENTER("AddPropDlg::UseCategory"); 
	if (IsDlgButtonChecked(hwnd, IDC_USECURCAT) == BST_CHECKED)
		return true;

	return false;
}

BOOL AddPropDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("AddPropDlg::DlgProc"); 
	switch(msg)
	{
	case WM_ACTIVATE:
		if (LOWORD(wParam)==WA_INACTIVE)
			EnableAccelerators();
		else
			DisableAccelerators();
		
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			if (GetWindowTextLength(GetDlgItem(hwnd,IDC_PROPNAME))==0)
			{
				MessageBox(hwnd,"Your property must have a name","Invalid entry",MB_ICONWARNING|MB_OK);
				return TRUE;
			}

			if (CorrectText())
			{
				MessageBox(hwnd,"You've entered invalid characters, your text has been converted to an alpha-numeric format.\nReview the correction and press OK to submit it.","Invalid entry",MB_ICONWARNING|MB_OK);
				return TRUE;
			}

			if (fpOkCB)
				fpOkCB(this,pOkCBData);

			Hide();

			return TRUE;

		case IDCANCEL:
			Hide();
			return TRUE;
		}
	}

	return FALSE;
}

void AddPropDlg::SetOKCB(void(*func)(AddPropDlg*,void*),void* pData)
{ FUNC_ENTER("AddPropDlg::SetOKCB"); 
	fpOkCB=func;
	pOkCBData=pData;
}

CStr AddPropDlg::GetProp()
{ FUNC_ENTER("AddPropDlg::GetPropA"); 
	char buf[256];
	GetDlgItemText(hwnd,IDC_PROPNAME,buf,256);
	return CStr(buf);
}

CStr AddPropDlg::GetValue()
{ FUNC_ENTER("AddPropDlg::GetValue"); 
	char buf[256];
	GetDlgItemText(hwnd,IDC_PROPVALUE,buf,256);
	return CStr(buf);
}

CStr AddPropDlg::GetDesc()
{ FUNC_ENTER("AddPropDlg::GetDesc"); 
	char buf[256];
	GetDlgItemText(hwnd,IDC_PROPDESC,buf,256);
	return CStr(buf);
}

PropType AddPropDlg::GetType()
{ FUNC_ENTER("AddPropDlg::GetType"); 
	int index=SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_GETCURSEL,0,0);

	return (PropType)(index+1);
}

void AddPropDlg::SetTitle(CStr str)
{ FUNC_ENTER("AddPropDlg::SetTitle"); 
	SetWindowText(hwnd,(char*)str);
}

void AddPropDlg::SetProp(CStr str)
{ FUNC_ENTER("AddPropDlg::SetPropA"); 
	SetDlgItemText(hwnd,IDC_PROPNAME,(char*)str);
}

void AddPropDlg::SetValue(CStr str)
{ FUNC_ENTER("AddPropDlg::SetValue"); 
	SetDlgItemText(hwnd,IDC_PROPVALUE,(char*)str);
}

void AddPropDlg::SetDesc(CStr str)
{ FUNC_ENTER("AddPropDlg::SetDesc"); 
	SetDlgItemText(hwnd,IDC_PROPDESC,(char*)str);
}

void AddPropDlg::SetType(PropType type)
{ FUNC_ENTER("AddPropDlg::SetType"); 
	SendDlgItemMessage(hwnd,IDC_PROPTYPE,CB_SETCURSEL,(WPARAM)type-1,0);
}

bool AddPropDlg::CorrectText()
{ FUNC_ENTER("AddPropDlg::CorrectText"); 
	char buf[256];
	CStr newBuf;
	int  selStart,selEnd;
	SendDlgItemMessage(hwnd,IDC_PROPNAME,EM_GETSEL,(WPARAM)&selStart,(LPARAM)&selEnd);
	GetDlgItemText(hwnd,IDC_PROPNAME,buf,255);
	newBuf=MakeAlphaNum(buf);

	if (newBuf==CStr(buf))
		return false;
	
	SetDlgItemText(hwnd,IDC_PROPNAME,(char*)newBuf);
	SendDlgItemMessage(hwnd,IDC_PROPNAME,EM_SETSEL,(WPARAM)selStart,(LPARAM)selEnd);

	return true;
}
