/*
	Overlap.h
	A Utility plugin for performing better merges of materials and geom
*/

#ifndef __OVERLAP_H__
#define __OVERLAP_H__

#include "max.h"
#include "iparamb2.h"
#include "utilapi.h"

#define vOVERLAPTOOL_CLASS_ID   Class_ID(0xd344562, 0x73e2f66)
#define vOVERLAPTOOL_SHORTCUT_ID       0x73e2f66

ClassDesc2* GetOverlapToolDesc();
ActionTable* GetOverlapActions( void );
bool RegOverlapActionAccelerators();
void UnRegOverlapActionAccelerators();

class OverlapActionCB : public ActionCallback {
public:
	BOOL ExecuteAction(int id);
};


class OverlapTool: public UtilityObj
{
	Interface* ip;				// MAX Interface pointer
	IUtil*     iu;				// Utility object interface pointer

	int            nodeProg;
	int            numNodes;

	float		   nodeTolerance;	// in pct form
	float		   objectTolerance;	// in pct form

	HWND		   hRollup;			// The rollup window
	
	static int CALLBACK DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
	
public:
	OverlapTool();
	~OverlapTool();

	void BeginEditParams(Interface *ip,IUtil *iu);
	void EndEditParams(Interface *ip,IUtil *iu);
	void DeleteThis() { delete this; }	

	void Begin();
};

class OverlapToolClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new OverlapTool(); }
	const TCHAR *	ClassName() {return _T("NeverSoft Overlap Tool"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return vOVERLAPTOOL_CLASS_ID;}
	const TCHAR* 	Category() {return _T("OverlapTool");}
	const TCHAR*	InternalName() { return _T("OverlapTool"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle	

	int           NumActionTables()     { return 1; }
	ActionTable*  GetActionTable(int i) { return GetOverlapActions(); }
};

#endif
