/*
	MtlEditor.h
	Custom Neversoft Material Editor
	(Allows changing groups of material properties)

	aml - 9-9-03
*/

#ifndef __MTLEDITOR_H__
#define __MTLEDITOR_H__

#include "max.h"
#include "utilapi.h"

#define vNSMTLEDITOR_CLASS_ID   Class_ID(0x73a13baa, 0x3b4753f7)

class MtlEditorDlg;

class MtlEditor: public UtilityObj
{
	MtlEditorDlg*  pMtlEditorDlg;

public:
	MtlEditor();
	~MtlEditor();

	void BeginEditParams(Interface *ip,IUtil *iu);
	void EndEditParams(Interface *ip,IUtil *iu);
	void SelectionSetChanged(Interface *ip,IUtil *iu);
	void DeleteThis() { delete this; }
};

class MtlEditorClassDesc: public ClassDesc
{
public:
	int       	 IsPublic(void) 			{ return TRUE; }
	void*	     Create(BOOL loading=FALSE) { return new MtlEditor; }
	const TCHAR* ClassName(void)			{ return _T("Neversoft Material Editor"); }
	SClass_ID    SuperClassID(void)			{ return UTILITY_CLASS_ID; }
	Class_ID     ClassID(void)				{ return vNSMTLEDITOR_CLASS_ID; }
	const TCHAR* Category(void)				{ return ""; }
};

#endif
