#include "FuncEnter.h"

/**********************************************************************
 *<
	FILE: multi.cpp

	DESCRIPTION:  Composite material

	CREATED BY: Dan Silva

	HISTORY: UPdated to Param2 1/11/98 Peter Watje

	         Modified to handle sparse arrays without having to have all the
			   intervening nulls. 6/19/00  Dan Silva

 *>	Copyright (c) 1994, All Rights Reserved.
 **********************************************************************/

// use hash-table for lookup speed
#define USE_HASHING 1

//#include "mtlhdr.h"
//#include "mtlres.h"
#include <Next.h>
#include "multi.h"
// begin - ke/mjm - 03.16.00 - merge reshading code
//#include "iReshade.h"
// end - ke/mjm - 03.16.00 - merge reshading code
#include "macrorec.h"
#include "gport.h"

extern HINSTANCE hInstance;
extern ClassDesc2* GetNExtMatDesc( void );

//###########################################################################
// pblock conversions for maxscript mtl id fixes

class MultiIDDimension : public ParamDimension 
{
public:
	DimType DimensionType() { FUNC_ENTER("MultiIDDimension::DimensionType");  return DIM_CUSTOM; }
	float Convert(float value) { FUNC_ENTER("MultiIDDimension::Convert");  return value+1; };
	float UnConvert(float value) { FUNC_ENTER("MultiIDDimension::UnConvert");  return value-1; };
};

static MultiIDDimension theMultiIDDim;





#define NSUBMTLS 10
static Class_ID multiClassID = vNEXT_MULTI_MATERIAL_CLASS_ID;

class Multi;
class MultiDlg;
class DelSubRestore;


#define  SRM_CLASS_ID 0xB8073421
class SingleRefMaker: public ReferenceMaker {
	public:
		RefTargetHandle rtarget;
		SingleRefMaker() { FUNC_ENTER("SingleRefMaker::SingleRefMaker");  rtarget = NULL; }
		~SingleRefMaker() { FUNC_ENTER("SingleRefMaker::~SingleRefMaker");  
			DeleteAllRefsFromMe(); 
			}
		void SetRef(RefTargetHandle rt) { FUNC_ENTER("SingleRefMaker::SetRef"); 
			theHold.Suspend();
			ReplaceReference(0,rt);
			theHold.Resume();
			}
		RefTargetHandle GetRef() { FUNC_ENTER("SingleRefMaker::GetRef");  return rtarget; }
		// ReferenceMaker 
		RefResult NotifyRefChanged( Interval changeInt,RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message ) { FUNC_ENTER("SingleRefMaker::NotifyRefChanged");  
			if (message==REFMSG_TARGET_DELETED) {
				if (hTarget==rtarget) 
					rtarget = NULL;
				}
		   	return REF_SUCCEED; 
		   	}
		void DeleteThis() { FUNC_ENTER("SingleRefMaker::DeleteThis");  delete this; }

		SClass_ID  SuperClassID() { FUNC_ENTER("SingleRefMaker::SuperClassID");  return SRM_CLASS_ID; }
		// From ref
		int NumRefs() { FUNC_ENTER("SingleRefMaker::NumRefs");  return 1; }
		RefTargetHandle GetReference(int i) { FUNC_ENTER("SingleRefMaker::GetReference");  return rtarget; }
		void SetReference(int i, RefTargetHandle rtarg) { FUNC_ENTER("SingleRefMaker::SetReference");  rtarget = rtarg;			}
		BOOL CanTransferReference(int i) { FUNC_ENTER("SingleRefMaker::CanTransferReference"); return FALSE;}
	};


#define PBLOCK_REF	0
#define MTL_REF		1

class MultiDlg: public ParamDlg {
	public:		
		HWND hwmedit;	 // window handle of the materials editor dialog
		HFONT hFont;
		IMtlParams *ip;
		Multi *theMtl;	 // current mtl being edited.
		HWND hPanelBasic; // Rollup pane		
		HWND hScroll;
		TimeValue curTime; 
		int isActive;
		BOOL valid;
		ICustButton *iBut[NSUBMTLS];
		ICustEdit *iName[NSUBMTLS];
		ICustEdit *iIndex[NSUBMTLS];
		BOOL isDup[NSUBMTLS];
		MtlDADMgr dadMgr;
				
		MultiDlg(HWND hwMtlEdit, IMtlParams *imp, Multi *m); 
		~MultiDlg();
		BOOL BasicPanelProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );
		void VScroll(int code, short int cpos );
		void DrawPStampBlackBorder(HDC hdc, Rect &rect);
		void DrawPStampHilite( int i, BOOL on);
		void DrawPStampHilite(HDC hdc, BOOL on, Rect &rect );
		void DrawPStamp(HDC hdc, Rect &rect, int i );
		void RemovePStampHilite();
		void DrawDupIndicators();
		void SetIsDup(int i);
		void SelectMtl(int i);
		void UpdateSubMtlNames();
		void UpdateColorSwatches();
		void LoadDialog(BOOL draw);  // stuff params into dialog
		void Invalidate() { FUNC_ENTER("MultiDlg::Invalidate"); 
			valid = FALSE;
			Rect rect;
			rect.left = rect.top = 0;
			rect.right = rect.bottom = 10;
			InvalidateRect(hPanelBasic,&rect,FALSE);
			}
		void ReloadDialog();
		void UpdateMtlDisplay() { FUNC_ENTER("MultiDlg::UpdateMtlDisplay");  ip->MtlChanged(); }
		void ActivateDlg(BOOL onOff) { FUNC_ENTER("MultiDlg::ActivateDlg"); }
		void SetNumMats(HWND hWnd);
		void DragAndDrop(int ifrom, int ito);
		int SubMtlNumFromNameID(int id);

		// methods inherited from ParamDlg:
		Class_ID ClassID() { FUNC_ENTER("MultiDlg::ClassID"); return multiClassID;  }
		void SetThing(ReferenceTarget *m);
		ReferenceTarget* GetThing() { FUNC_ENTER("MultiDlg::GetThing");  return (ReferenceTarget *)theMtl; }
		void DeleteThis() { FUNC_ENTER("MultiDlg::DeleteThis");  delete this;  }	
		void SetTime(TimeValue t);
		int FindSubMtlFromHWND(HWND hw);
	};


// Parameter block indices
#define PB_THRESH		0
#define PB_WIDTH		1

//-----------------------------------------------------------------------------
//  Multi
//-----------------------------------------------------------------------------

Class_ID Multi::ClassID()	{ FUNC_ENTER("Multi::ClassID");  return multiClassID; }

int numMultis = 0;
class MultiClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() { FUNC_ENTER("MultiClassDesc::IsPublic");  return 1; }
	void *			Create(BOOL loading) { FUNC_ENTER("MultiClassDesc::Create");  	return new Multi(loading); }
	const TCHAR *	ClassName() { FUNC_ENTER("MultiClassDesc::ClassName");  return "NExt Multi-Material"; } // mjm - 2.3.99
	SClass_ID		SuperClassID() { FUNC_ENTER("MultiClassDesc::SuperClassID");  return MATERIAL_CLASS_ID; }
	Class_ID 		ClassID() { FUNC_ENTER("MultiClassDesc::ClassID");  return multiClassID; }
	const TCHAR* 	Category() { FUNC_ENTER("MultiClassDesc::Category");  return _T("");  }
// PW: new descriptor data accessors added.  Note that the 
//      internal name is hardwired since it must not be localized.
	const TCHAR*	InternalName() { FUNC_ENTER("MultiClassDesc::InternalName");  return _T("NextMultiSubMaterial"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { FUNC_ENTER("MultiClassDesc::HInstance");  return hInstance; }			// returns owning module handle

	};

static MultiClassDesc multiCD;

ClassDesc* GetMultiDesc() { FUNC_ENTER("GetMultiDesc");  
	return &multiCD;  
	}


// per instance param block
static ParamBlockDesc2 multi_param_blk ( multi_params, _T("parameters"),  0, &multiCD, P_AUTO_CONSTRUCT + P_AUTO_UI, PBLOCK_REF, 
	//rollout
	IDD_MULTI, IDS_DS_MULTI_PARAMS, 0, 0, NULL, 
	// params
	multi_mtls,	_T("materialList"),	TYPE_MTL_TAB,	10,		P_OWNERS_REF + P_VARIABLE_SIZE,	IDS_RB_MATERIAL2,	
		p_refno,		MTL_REF, 
		end,
	multi_ons,	_T("mapEnabled"), TYPE_BOOL_TAB,	10,		P_VARIABLE_SIZE,				IDS_JW_MAP1ENABLE,
		p_default,		TRUE,
		end,
	multi_names, _T("names"), TYPE_STRING_TAB,		10,		P_VARIABLE_SIZE,				IDS_DS_MAP,
		end,
	multi_ids,	_T("materialIDList"),	TYPE_INT_TAB,	10,	  P_VARIABLE_SIZE,				IDS_DS_INDEX,	
		p_dim, &theMultiIDDim,									// 4/24/01 3:33pm --MQM-- add ParameterDimension function to fix maxscript #'s 
		end,
	end
);


static INT_PTR CALLBACK  PanelDlgProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam) { FUNC_ENTER("PanelDlgProc"); 
	MultiDlg *theDlg;
	if (msg==WM_INITDIALOG) {
		theDlg = (MultiDlg*)lParam;
		theDlg->hPanelBasic = hwndDlg;
		SetWindowLongPtr(hwndDlg, GWLP_USERDATA,lParam);
		}
	else {
	    if ( (theDlg = (MultiDlg *)GetWindowLongPtr(hwndDlg, GWLP_USERDATA) ) == NULL )
			return FALSE; 
		}
	theDlg->isActive = 1;
	int	res = theDlg->BasicPanelProc(hwndDlg,msg,wParam,lParam);
	theDlg->isActive = 0;
	return res;
	}


int MultiDlg::FindSubMtlFromHWND(HWND hw) { FUNC_ENTER("MultiDlg::FindSubMtlFromHWND"); 
	for (int i=0; i<NSUBMTLS; i++) {
		if (hw == iBut[i]->GetHwnd()) {
			int j = i+theMtl->offset;
			int id;
			Interval iv;
			theMtl->pblock->GetValue(multi_ids,0,id,iv,j); 
			return id;
			}
		}	
	return -1;
	}

void MultiDlg::DragAndDrop(int ifrom, int ito) { FUNC_ENTER("MultiDlg::DragAndDrop"); 
	theMtl->CopySubMtl(hPanelBasic,ifrom+theMtl->offset, ito+theMtl->offset);
	theMtl->NotifyChanged();
	UpdateMtlDisplay();
	}

//-------------------------------------------------------------------

MultiDlg::MultiDlg(HWND hwMtlEdit, IMtlParams *imp, Multi *m) { FUNC_ENTER("MultiDlg::MultiDlg");  
	dadMgr.Init(this);
	hwmedit = hwMtlEdit;
	ip = imp;
	hPanelBasic = NULL;
	theMtl = m; 
	isActive = 0;
	valid = FALSE;
	theMtl->ClampOffset();
	for (int i=0; i<NSUBMTLS; i++) {	
		iBut[i] = NULL;
		iName[i] = NULL;
		iIndex[i] = NULL;
		isDup[i] = FALSE;
		}
	hFont = CreateFont(14,0,0,0,FW_BOLD,0,0,0,0,0,0,0, VARIABLE_PITCH | FF_SWISS, _T(""));
	hPanelBasic = ip->AddRollupPage( 
		hInstance,
		MAKEINTRESOURCE(IDD_MULTI),
		PanelDlgProc, 
		GetString(IDS_DS_MULTI_PARAMS), 
		(LPARAM)this );		
	curTime = imp->GetTime();
	}

void MultiDlg::ReloadDialog() { FUNC_ENTER("MultiDlg::ReloadDialog"); 
	Interval valid;
	theMtl->Update(curTime,valid);
	LoadDialog(FALSE);
	}

void MultiDlg::SetTime(TimeValue t) { FUNC_ENTER("MultiDlg::SetTime"); 
	if (t!=curTime) {
		Interval valid;
		curTime = t;
		theMtl->Update(curTime,valid);
		// Since nothing is time varying, can skip this
		//InvalidateRect(hPanelBasic,NULL,0);
		}
	}

MultiDlg::~MultiDlg() { FUNC_ENTER("MultiDlg::~MultiDlg"); 
	theMtl->SetParamDlg(NULL);	
	SetWindowLongPtr(hPanelBasic, GWLP_USERDATA, NULL);
	hPanelBasic =  NULL;
	for (int i=0; i<NSUBMTLS; i++) {
		ReleaseICustButton(iBut[i]);
		ReleaseICustEdit(iName[i]);
		ReleaseICustEdit(iIndex[i]);
		iBut[i] = NULL; 
		iName[i] = NULL;
		iIndex[i] = NULL;
		}
	DeleteObject(hFont);
	}


static int subMtlId[NSUBMTLS] = {
	IDC_MULTI_MTL0,
	IDC_MULTI_MTL1,
	IDC_MULTI_MTL2,
	IDC_MULTI_MTL3,
	IDC_MULTI_MTL4,
	IDC_MULTI_MTL5,
	IDC_MULTI_MTL6,
	IDC_MULTI_MTL7,
	IDC_MULTI_MTL8,
	IDC_MULTI_MTL9
	};


static int subNameId[NSUBMTLS] = {
	IDC_MTL_NAME0,
	IDC_MTL_NAME1,
	IDC_MTL_NAME2,
	IDC_MTL_NAME3,
	IDC_MTL_NAME4,
	IDC_MTL_NAME5,
	IDC_MTL_NAME6,
	IDC_MTL_NAME7,
	IDC_MTL_NAME8,
	IDC_MTL_NAME9
	};

static int subIndex[NSUBMTLS] = {
	IDC_MTL_ID0,
	IDC_MTL_ID1,
	IDC_MTL_ID2,
	IDC_MTL_ID3,
	IDC_MTL_ID4,
	IDC_MTL_ID5,
	IDC_MTL_ID6,
	IDC_MTL_ID7,
	IDC_MTL_ID8,
	IDC_MTL_ID9
	};


static int mapOnIDs[] = {
	IDC_MAPON1,
	IDC_MAPON2,
	IDC_MAPON3,
	IDC_MAPON4,
	IDC_MAPON5,
	IDC_MAPON6,
	IDC_MAPON7,
	IDC_MAPON8,
	IDC_MAPON9,
	IDC_MAPON10,
	};
/*
static int numIDs[] = {
	IDC_MULT_NUM1,
	IDC_MULT_NUM2,
	IDC_MULT_NUM3,
	IDC_MULT_NUM4,
	IDC_MULT_NUM5,
	IDC_MULT_NUM6,
	IDC_MULT_NUM7,
	IDC_MULT_NUM8,
	IDC_MULT_NUM9,
	IDC_MULT_NUM10,
	};	
*/

static int mtlPStampIDs[] = {
	IDC_PSTAMP1,
	IDC_PSTAMP2,
	IDC_PSTAMP3,
	IDC_PSTAMP4,
	IDC_PSTAMP5,
	IDC_PSTAMP6,
	IDC_PSTAMP7,
	IDC_PSTAMP8,
	IDC_PSTAMP9,
	IDC_PSTAMP10,
	};

static int indexIDs[] = {
	IDC_MTL_ID0,
	IDC_MTL_ID1,
	IDC_MTL_ID2,
	IDC_MTL_ID3,
	IDC_MTL_ID4,
	IDC_MTL_ID5,
	IDC_MTL_ID6,
	IDC_MTL_ID7,
	IDC_MTL_ID8,
	IDC_MTL_ID9
	};

static int SubMtlNumFromPStampID(int id) { FUNC_ENTER("SubMtlNumFromPStampID"); 
	for (int i=0; i<NSUBMTLS; i++) {
		if (mtlPStampIDs[i]==id) return i;
		}
	return 0;
	}


int MultiDlg::SubMtlNumFromNameID(int id) { FUNC_ENTER("MultiDlg::SubMtlNumFromNameID"); 
	for (int i=0; i<NSUBMTLS; i++) {
		if (subNameId[i]==id) return i;
		}
	return 0;
	}


static int SubMtlNumIndexID(int id) { FUNC_ENTER("SubMtlNumIndexID"); 
	for (int i=0; i<NSUBMTLS; i++) {
		if (indexIDs[i]==id) return i;
		}
	return 0;
	}

void MultiDlg::RemovePStampHilite() { FUNC_ENTER("MultiDlg::RemovePStampHilite"); 
	for (int i=0; i<NSUBMTLS; i++) {
		DrawPStampHilite( i, FALSE);
		}
//	if (theMtl->selected>=0) 
//		DrawPStampHilite( theMtl->selected-theMtl->offset, FALSE);
	}

void MultiDlg::VScroll(int code, short int cpos ) { FUNC_ENTER("MultiDlg::VScroll"); 
	for (int i=0; i<NSUBMTLS; i++) {
		if (iIndex[i]->HasFocus()||iName[i]->HasFocus()) 
			SetFocus(NULL);
		}
	RemovePStampHilite();
	switch (code) {
		case SB_LINEUP: 	theMtl->offset--;		break;
		case SB_LINEDOWN:	theMtl->offset++;		break;
		case SB_PAGEUP:		theMtl->offset -= NSUBMTLS;	break;
		case SB_PAGEDOWN:	theMtl->offset += NSUBMTLS;	break;
		
		case SB_THUMBPOSITION: 
		case SB_THUMBTRACK:
			theMtl->offset = cpos;
			break;
		}

	theMtl->ClampOffset();
	UpdateSubMtlNames();						
	}

#define DORECT(x) Rectangle( hdc, rect.left-(x), rect.top-(x), rect.right+(x), rect.bottom+(x) )

void MultiDlg::DrawPStampBlackBorder(HDC hdc, Rect &rect) { FUNC_ENTER("MultiDlg::DrawPStampBlackBorder"); 
	SelectObject( hdc, GetStockObject( NULL_BRUSH ) );
	SelectObject(hdc,GetStockObject(BLACK_PEN));
	DORECT(0);
	}

void MultiDlg::DrawPStampHilite(HDC hdc, BOOL on, Rect &rect) { FUNC_ENTER("MultiDlg::DrawPStampHilite"); 
	SelectObject( hdc, GetStockObject( NULL_BRUSH ) );
	HPEN hGray = CreatePen( PS_SOLID, 0, GetCustSysColor( COLOR_BTNFACE ) );
	SelectObject(hdc, hGray);
	if (on) SelectObject(hdc, GetStockObject(WHITE_PEN));
	DORECT(1);
	if (on) SelectObject(hdc, GetStockObject(BLACK_PEN));
	DORECT(2);
	DeleteObject( hGray);
	}

void MultiDlg::DrawPStampHilite( int i, BOOL on) { FUNC_ENTER("MultiDlg::DrawPStampHilite"); 
	HWND hwStamp = GetDlgItem(hPanelBasic, mtlPStampIDs[i]);
	HDC hdc = GetDC(hwStamp);
	Rect rect;
	GetClientRect(hwStamp,&rect);
	DrawPStampHilite(hdc, on, rect);
	}

void MultiDlg::DrawDupIndicators() { FUNC_ENTER("MultiDlg::DrawDupIndicators"); 
	Rect rp;
	GetWindowRect(hPanelBasic, &rp);
	HDC hdc = GetDC(hPanelBasic);
	HPEN hGray = CreatePen( PS_SOLID, 0, GetCustSysColor( COLOR_BTNFACE));
	HPEN hRed = CreatePen( PS_SOLID, 0, RGB(255,0,0));
	SelectObject( hdc, GetStockObject( NULL_BRUSH ) );
	for (int i=0; i<NSUBMTLS; i++) {
		Rect rect;
		HWND hw = iIndex[i]->GetHwnd();
		GetWindowRect( hw, &rect );
		rect.left -= rp.left;		rect.right -= rp.left;
		rect.top -= rp.top;	 		rect.bottom -= rp.top;
		SelectObject(hdc, isDup[i]? hRed: hGray); 
		DORECT(1);
		DORECT(2);
		}
	DeleteObject( hGray);
	DeleteObject( hRed);
	ReleaseDC(hPanelBasic,hdc);
	}

void MultiDlg::SetIsDup(int i) { FUNC_ENTER("MultiDlg::SetIsDup"); 
	if (i>=0&&i<NSUBMTLS)
		isDup[i] = TRUE;
	}

void MultiDlg::DrawPStamp(HDC hdc, Rect &rect, int i ) { FUNC_ENTER("MultiDlg::DrawPStamp"); 
	i += theMtl->offset; 
	if (i>=theMtl->subMtl.Count()) 
		return;
	Mtl *m = theMtl->subMtl[i];
	if (m==NULL) {
	    HBRUSH hOldbrush = (HBRUSH)SelectObject(hdc,GetCustSysColorBrush(COLOR_BTNFACE));
		DORECT(0);
	    SelectObject(hdc,hOldbrush);
		}
	else {
		PStamp *ps = m->GetPStamp(PS_TINY);
		if (!ps) 
			ps = m->CreatePStamp(PS_TINY,TRUE);
		int w = ps->Width();
		int h = ps->Height();
		int scanw = ByteWidth(w);
		int nb = scanw*h;
		UBYTE *workImg = new UBYTE[nb];
		ps->GetImage(workImg);

		GetGPort()->DisplayMap(hdc, rect, 0, 0, workImg, scanw); 
		delete workImg;

/*
		int h = rect.bottom-rect.top; 
		int w = rect.right-rect.left;
		if (w>h) w = h;
		if (h>w) h = w;
		int scanw = ByteWidth(w);
		int nb = scanw*h;
		UBYTE *workImg = new UBYTE[nb];
		
		// Need to put this into Interface with separate w,h
		GetCOREInterface()->Execute(I_EXEC_RENDER_MTL_SAMPLE,(ULONG_PTR)m, (ULONG_PTR)w, (ULONG_PTR)workImg);
		GetGPort()->DisplayMap(hdc, rect, 0, 0, workImg, scanw); 
		delete workImg;
*/
		}
	DrawPStampBlackBorder(hdc, rect);
	if (i==theMtl->selected) {
		DrawPStampHilite(hdc, TRUE, rect);
		}
	}													   

void MultiDlg::SelectMtl(int i) { FUNC_ENTER("MultiDlg::SelectMtl"); 
	if (theMtl->selected>=0)
		DrawPStampHilite(theMtl->selected-theMtl->offset,FALSE);
	theMtl->selected = i+theMtl->offset;
	if (i>=0)
		DrawPStampHilite(i, TRUE);
	}

static LRESULT CALLBACK PStampWndProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam ) 
{ FUNC_ENTER("PStampWndProc"); 
	int id = SubMtlNumFromPStampID(GetWindowLongPtr(hwnd,GWL_ID));
	HWND hwParent = GetParent(hwnd);
	MultiDlg *theDlg = (MultiDlg *)GetWindowLongPtr(hwParent, GWLP_USERDATA);
	if (theDlg==NULL) return FALSE;

    switch (msg) {
		case WM_COMMAND: 	
		case WM_MOUSEMOVE: 	
		case WM_CREATE:
		case WM_DESTROY: 
		break;

		case WM_LBUTTONUP: 
			theDlg->SelectMtl( id );
			break;

		case WM_PAINT: 	
		{
			PAINTSTRUCT ps;
			Rect rect;
			HDC hdc = BeginPaint( hwnd, &ps );
			if (!IsRectEmpty(&ps.rcPaint)) {
				GetClientRect( hwnd, &rect );
				theDlg->DrawPStamp( hdc, rect, id )	;
				}
			EndPaint( hwnd, &ps );
		}													
		break;
	}
	return DefWindowProc(hwnd,msg,wParam,lParam);
} 


LRESULT CALLBACK DupMsgWndProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam ) 
{ FUNC_ENTER("DupMsgWndProc"); 
    switch (msg) {
		case WM_PAINT: 	
			{
			PAINTSTRUCT ps;
			Rect rect;
			HDC hdc = BeginPaint( hwnd, &ps );
			if (!IsRectEmpty(&ps.rcPaint)) {
				SetTextColor(hdc, RGB(255,0,0));
				SetBkMode(hdc, TRANSPARENT);
				TCHAR buf[256];
				GetWindowText(hwnd,buf,sizeof(buf));					
				TextOut(hdc, 0, 0, buf, _tcslen(buf));
				}
			EndPaint( hwnd, &ps );
			}													
		break;
		default:
			break;
	}
	return DefWindowProc(hwnd,msg,wParam,lParam);
} 

static BOOL ignoreKillFocus = FALSE;

BOOL MultiDlg::BasicPanelProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam ) { FUNC_ENTER("MultiDlg::BasicPanelProc"); 
	int id = LOWORD(wParam);
	int code = HIWORD(wParam);
    switch (msg)    {
		case WM_INITDIALOG:	 {		
			hScroll	= GetDlgItem(hwndDlg,IDC_MULTI_SCROLL);
			SetScrollRange(hScroll,SB_CTL,0,theMtl->subMtl.Count()-NSUBMTLS,FALSE);
			SetScrollPos(hScroll,SB_CTL,theMtl->offset,TRUE);
			EnableWindow(hScroll,theMtl->subMtl.Count()>NSUBMTLS);
			SendDlgItemMessage(hwndDlg,IDC_DUP_IDS,WM_SETFONT,(WPARAM)hFont,TRUE);
			ShowWindow(GetDlgItem(hwndDlg,IDC_DUP_IDS),theMtl->AnyDupIDs()?SW_SHOW:SW_HIDE);
			for (int i=0; i<NSUBMTLS; i++) {
				iBut[i] = GetICustButton(GetDlgItem(hwndDlg,subMtlId[i]));
				iBut[i]->SetDADMgr(&dadMgr);
				iName[i] = GetICustEdit( GetDlgItem(hwndDlg,subNameId[i]));
				iName[i]->SetLeading(2); //??
				iIndex[i] = GetICustEdit(GetDlgItem(hwndDlg,subIndex[i]));
				iIndex[i]->SetLeading(2); //??
				iIndex[i]->WantReturn(TRUE);
				if (i+theMtl->offset<theMtl->subMtl.Count()) {
					TCHAR *name;
					int id;
					Interval iv;
					theMtl->pblock->GetValue(multi_names,0,name,iv,i+theMtl->offset);
					iName[i]->SetText(name);
					theMtl->pblock->GetValue(multi_ids,0,id,iv,i+theMtl->offset); //??????
					iIndex[i]->SetText(id+1); //?????

//					iName[i]->SetText(theMtl->subNames[i+theMtl->offset]);
					}
//				TSTR buf;
//				buf.printf("%d:",i+theMtl->offset+1);
//				SetDlgItemText(hwndDlg,numIDs[i],buf);
				int onCount = theMtl->pblock->Count(multi_ons);
				if (i-theMtl->offset<onCount)
					{
					int on;
					Interval iv;
					theMtl->pblock->GetValue(multi_ons,0,on,iv,i+theMtl->offset);
					SetCheckBox(hwndDlg, mapOnIDs[i], on);
					}
//				if (i-theMtl->offset<theMtl->mapOn.Count())
//					SetCheckBox(hwndDlg, mapOnIDs[i], theMtl->mapOn[i+theMtl->offset]);

				HWND hwnd = GetDlgItem(hwndDlg, mtlPStampIDs[i]);
				SetWindowLongPtr( hwnd, GWLP_WNDPROC, (LONG_PTR)PStampWndProc);
				SetWindowLongPtr( hwnd, GWLP_USERDATA, (LONG_PTR)this);

				hwnd = GetDlgItem(hwndDlg, IDC_DUP_IDS);
				SetWindowLongPtr( hwnd, GWLP_WNDPROC, (LONG_PTR)DupMsgWndProc);

				}
			DrawDupIndicators();
			}
			return TRUE;
		case WM_VSCROLL:
			VScroll(LOWORD(wParam),(short int)HIWORD(wParam));
			break;
			
		case WM_COMMAND:  
		    switch (id) {
				case IDC_MULTI_MTL0: 
				case IDC_MULTI_MTL1: 
				case IDC_MULTI_MTL2: 
				case IDC_MULTI_MTL3: 
				case IDC_MULTI_MTL4: 
				case IDC_MULTI_MTL5: 
				case IDC_MULTI_MTL6: 
				case IDC_MULTI_MTL7: 
				case IDC_MULTI_MTL8: 
				case IDC_MULTI_MTL9: {
					int i = id-IDC_MULTI_MTL0 + theMtl->offset;
					if (i < theMtl->subMtl.Count()) {
						int mtlid;
						Interval iv;
						theMtl->pblock->GetValue(multi_ids,0,mtlid,iv,i); 
						PostMessage(hwmedit,WM_SUB_MTL_BUTTON, mtlid ,(LPARAM)theMtl);
						}
					}
					break;
				
				case IDC_MAPON1:							
				case IDC_MAPON2:							
				case IDC_MAPON3:							
				case IDC_MAPON4:							
				case IDC_MAPON5:							
				case IDC_MAPON6:
				case IDC_MAPON7:
				case IDC_MAPON8:
				case IDC_MAPON9:
				case IDC_MAPON10:
//					theMtl->mapOn[id-IDC_MAPON1+theMtl->offset] = GetCheckBox(hwndDlg, id);
					{
					int on = GetCheckBox(hwndDlg, id);
					Interval iv;
					theMtl->pblock->SetValue(multi_ons,0,on,id-IDC_MAPON1+theMtl->offset);

					theMtl->NotifyChanged();
					break;
					}

				case IDC_MULTI_SETNUM:
					SetNumMats(hwndDlg);
					break;

				case IDC_MULTI_ADD:
					if ( theMtl->MaxSubMtlID() >= 1000 )		// 4/24/01 1:50pm --MQM-- don't allow new materials when id's are above 1000
						break;
					RemovePStampHilite();
					theHold.Begin();
					theMtl->AddMtl();
					theHold.Accept(GetString(IDS_DS_ADD_SUBMTL));
					UpdateSubMtlNames();		
					UpdateMtlDisplay();	  
					break;

				case IDC_MULTI_DELETE:
					if ( theMtl->subMtl.Count() == 1 )			// 4/12/01 11:10am --MQM-- don't let the user delete the last material
						break;
					RemovePStampHilite();
					theHold.Begin();
					theMtl->DeleteSelMtl();
					theHold.Accept(GetString(IDS_DS_DELSUBMAT));
					theMtl->UpdateHashTable();					// 4/10/01 11:57am --MQM-- force update before redisplay
					UpdateSubMtlNames();		
					UpdateMtlDisplay();	  
					break;

				case IDC_MULTI_SORT:
					RemovePStampHilite();
					theMtl->SortMtlsByID();
					UpdateSubMtlNames();
					UpdateMtlDisplay();	  
					break;

				case IDC_MULTI_ALPHASORT:
					RemovePStampHilite();
					theMtl->SortMtlsByName();
					UpdateSubMtlNames();
					UpdateMtlDisplay();	  
					break;

				case IDC_MULTI_NAMESORT:
					RemovePStampHilite();
					theMtl->SortMtlsBySlotName();
					UpdateSubMtlNames();
					UpdateMtlDisplay();	  
					break;


				case IDC_MTL_NAME0: 
				case IDC_MTL_NAME1: 
				case IDC_MTL_NAME2: 
				case IDC_MTL_NAME3: 
				case IDC_MTL_NAME4: 
				case IDC_MTL_NAME5: 
				case IDC_MTL_NAME6: 
				case IDC_MTL_NAME7: 
				case IDC_MTL_NAME8: 
				case IDC_MTL_NAME9: 
					if (HIWORD(wParam)==EN_CHANGE) {
						TCHAR buf[200];
						int n = SubMtlNumFromNameID(id);
						iName[n]->GetText(buf,199);
//						theMtl->subNames.SetName(n+theMtl->offset, buf);
						theMtl->pblock->SetValue(multi_names,0,buf,n+theMtl->offset);
#if USE_HASHING
//						theMtl->UpdateHashTable();
						theMtl->hashTabDirty = 1;
#endif
						}
					break;

				case IDC_MTL_ID0: 
				case IDC_MTL_ID1: 
				case IDC_MTL_ID2: 
				case IDC_MTL_ID3: 
				case IDC_MTL_ID4: 
				case IDC_MTL_ID5: 
				case IDC_MTL_ID6: 
				case IDC_MTL_ID7: 
				case IDC_MTL_ID8: 
				case IDC_MTL_ID9: 

					// if user exits from this material ID box, or the control was
					// changed by someone else, take care of updating the value in the pblock
					if ( ( HIWORD(wParam)==EN_KILLFOCUS && !ignoreKillFocus ) ||
						 HIWORD(wParam)==EN_CHANGE ) 
					{
						int n = SubMtlNumIndexID( id );
						if ( HIWORD(wParam)==EN_KILLFOCUS || iIndex[n]->GotReturn() ) 
						{
							// get the old ID from the pblock for comparison purposes
							Interval iv;
							int oldMtlId;
							theMtl->pblock->GetValue( multi_ids, 0, oldMtlId, iv, n+theMtl->offset );

							// and grab the new ID from the edit control
							int newMtlId = iIndex[n]->GetInt()-1;

							// ignore notify messages
							theMtl->ignoreNotify = TRUE;

							// if the new ID is different than the old one, set it in the pblock
							if ( newMtlId != oldMtlId )
							{
								// disable the macro recorder, since it will spit out the WRONG id#
								macroRec->Disable();

#if USE_HASHING
								// id has changed, we need to recompute hash table!!!
								theMtl->hashTabDirty = 1; 
#endif
								// set the new ID value in the pblock
								theMtl->pblock->SetValue( multi_ids, 0, newMtlId, n+theMtl->offset );

								// now turn the macro recorder back on, and spit out the "correct" material id
								// it was getting it directly from the pblock, so we need to add +1 to it!
								macroRec->Enable();
								macroRecorder->Assign(mr_index, mr_prop, _T("materialIDList"), mr_reftarg, theMtl, mr_int, n+theMtl->offset+1 , mr_int, newMtlId+1 ); 
							}

							// turn back on notify
							theMtl->ignoreNotify = FALSE;

							// check for duplicate id's
							ShowWindow( GetDlgItem(hwndDlg,IDC_DUP_IDS), theMtl->AnyDupIDs() ? SW_SHOW : SW_HIDE );
							DrawDupIndicators();
								
/*
							if (theMtl->IsIDDup(n)) {
								TCHAR msg[128];
								wsprintf(msg,GetString(IDS_DUP_WARNING), newMtlId+1);
								ignoreKillFocus = TRUE;
								MessageBox(NULL, msg, GetString(IDS_RB_MULTISUBOBJECT), MB_TASKMODAL);
								ignoreKillFocus = FALSE;
								}
*/
						}
					}
					break;

				}
			break;
		case WM_PAINT:
			if (!valid) {
				valid = TRUE;
				ReloadDialog();
				}
			{
			PAINTSTRUCT ps;
			Rect rect;
			HDC hdc = BeginPaint( hwndDlg, &ps );
			if (!IsRectEmpty(&ps.rcPaint)) {
				DrawDupIndicators();
				}
			EndPaint( hwndDlg, &ps );
			}													
			return FALSE;
		case WM_CLOSE:
			break;       
		case WM_DESTROY: 
			break;		


		case CC_COLOR_BUTTONDOWN:
			theHold.Begin();
			break;
		case CC_COLOR_BUTTONUP:
			if (HIWORD(wParam)) theHold.Accept(GetString(IDS_DS_PARAMCHG));
			else theHold.Cancel();
			break;

		case CC_COLOR_CHANGE: {
			if (HIWORD(wParam)) theHold.Begin();
			int i = LOWORD(wParam)-IDC_MULTI_COLOR1+theMtl->offset;
			IColorSwatch *cs = (IColorSwatch*)lParam;
			if (i>=0 && i<theMtl->subMtl.Count()&&theMtl->subMtl[i]) {
				theMtl->subMtl[i]->SetDiffuse(
					cs->GetColor(),curTime);
				}
			UpdateColorSwatches();
			if (HIWORD(wParam)) {
				theHold.Accept(GetString(IDS_DS_PARAMCHG));
			    UpdateMtlDisplay();
				}
			break;
			}

		case WM_CUSTEDIT_ENTER: {
			// mask keyboard input for sub material id#'s
			for (int x=0; x<NSUBMTLS; x++) {	// check all the controls
				if (subIndex[x] == id) {		// this control is the one
					int val = iIndex[x]->GetInt();
					if (val<1)					// restrict to 1..1000     
						val=1;
					else if (val>1000)
						val=1000;
					iIndex[x]->SetText(val);
				}
			}
			UpdateMtlDisplay();
			break;
			}

		case CC_SPINNER_BUTTONUP: 
		    UpdateMtlDisplay();
			break;

    	}
	return FALSE;
	}

static BOOL CALLBACK  BasicPanelDlgProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam) {
	MultiDlg *theDlg;
	if (msg==WM_INITDIALOG) {
		theDlg = (MultiDlg*)lParam;
		theDlg->hPanelBasic = hwndDlg;
		SetWindowLongPtr(hwndDlg, GWLP_USERDATA,lParam);
		}
	else {
	    if ( (theDlg = (MultiDlg *)GetWindowLongPtr(hwndDlg, GWLP_USERDATA) ) == NULL )
			return FALSE; 
		}
	theDlg->isActive = 1;
	int	res = theDlg->BasicPanelProc(hwndDlg,msg,wParam,lParam);
	theDlg->isActive = 0;
	return res;
	}

void MultiDlg::UpdateColorSwatches() { FUNC_ENTER("MultiDlg::UpdateColorSwatches"); 

	for (int i=0; i<theMtl->subMtl.Count()-theMtl->offset && i<NSUBMTLS; i++) {
		Mtl *m = theMtl->subMtl[i+theMtl->offset];
			
		TSTR nm, label;
			if (m) 	nm = m->GetFullName();
			else 	nm = GetString(IDS_DS_NONE);
		if (m) {
			IColorSwatch *cs = GetIColorSwatch(GetDlgItem(hPanelBasic,IDC_MULTI_COLOR1+i),
				m->GetDiffuse(),nm);
			cs->SetColor(m->GetDiffuse());
			ReleaseIColorSwatch(cs);
			}
		}

	}


void MultiDlg::UpdateSubMtlNames() { FUNC_ENTER("MultiDlg::UpdateSubMtlNames"); 
	IColorSwatch *cs;	
	int ct = theMtl->pblock->Count(multi_names);

	if (theMtl->selected<0)
		theMtl->selected = theMtl->subMtl.Count()-1;

	ShowWindow(GetDlgItem(hPanelBasic,IDC_DUP_IDS),theMtl->AnyDupIDs()?SW_SHOW:SW_HIDE);
	DrawDupIndicators();

	for (int i=0; i<theMtl->subMtl.Count()-theMtl->offset && i<NSUBMTLS; i++) {
		Mtl *m = theMtl->subMtl[i+theMtl->offset];
		TSTR nm, label;
		if (m) 
			nm = m->GetFullName();
		else 
			nm = GetString(IDS_DS_NONE);
		
		HWND hx = GetDlgItem(hPanelBasic, IDC_PSTAMP1); 
		ShowWindow(GetDlgItem(hPanelBasic, IDC_MULTI_MTL0+i), SW_SHOW);
		ShowWindow(GetDlgItem(hPanelBasic, IDC_MULTI_COLOR1+i), SW_SHOW);

		if ((m==NULL)||(m->IsMultiMtl()||m->NumSubMtls()>0))
			EnableWindow(GetDlgItem(hPanelBasic, IDC_MULTI_COLOR1+i), FALSE);
		else 
			EnableWindow(GetDlgItem(hPanelBasic, IDC_MULTI_COLOR1+i), TRUE);
		ShowWindow(GetDlgItem(hPanelBasic, subNameId[i]), SW_SHOW);
		ShowWindow(GetDlgItem(hPanelBasic,mapOnIDs[i]),SW_SHOW);
		ShowWindow(GetDlgItem(hPanelBasic,subIndex[i]),SW_SHOW); 
		ShowWindow(GetDlgItem(hPanelBasic,mtlPStampIDs[i]),SW_SHOW); 

		int on;
		Interval iv;

		if ((i+theMtl->offset)<ct)
			{
			theMtl->pblock->GetValue(multi_ons,0,on,iv,i+theMtl->offset);

			SetCheckBox(hPanelBasic, mapOnIDs[i], on);
			}
//		SetCheckBox(hPanelBasic, mapOnIDs[i], theMtl->mapOn[i+theMtl->offset]);

//		SetDlgItemText(hPanelBasic, IDC_MULTI_MTL0+i, nm.data());
		iBut[i]->SetText(nm.data());

		if (m) {
			cs = GetIColorSwatch(GetDlgItem(hPanelBasic,IDC_MULTI_COLOR1+i),
				m->GetDiffuse(),nm);
			cs->SetColor(m->GetDiffuse());
			ReleaseIColorSwatch(cs);
			}

		TCHAR *name;
		Interval niv;
		if ((i+theMtl->offset)<ct)
			{
			theMtl->pblock->GetValue(multi_names,0,name,niv,i+theMtl->offset);
			if (name) {
				TCHAR buf[256];
				iName[i]->GetText(buf,255);
				if (_tcscmp(name,buf))
					iName[i]->SetText(name);
				}
			else iName[i]->SetText(_T(""));
			int theid;
			theMtl->pblock->GetValue(multi_ids,0,theid,niv,i+theMtl->offset);
			iIndex[i]->SetText(theid+1); //?????
			}
//		TSTR buf;
//		buf.printf("%d:",i+theMtl->offset+1);
//		SetDlgItemText(hPanelBasic,numIDs[i],buf);

		HWND hwps = GetDlgItem(hPanelBasic,mtlPStampIDs[i]);
		InvalidateRect(hwps, NULL, FALSE);
		}
	for ( ; i<NSUBMTLS; i++) {
		ShowWindow(GetDlgItem(hPanelBasic, IDC_MULTI_MTL0+i), SW_HIDE);
		ShowWindow(GetDlgItem(hPanelBasic, IDC_MULTI_COLOR1+i), SW_HIDE);
		ShowWindow(GetDlgItem(hPanelBasic, subNameId[i]), SW_HIDE);
		ShowWindow(GetDlgItem(hPanelBasic,mapOnIDs[i]),SW_HIDE);
		ShowWindow(GetDlgItem(hPanelBasic,subIndex[i]),SW_HIDE); 
		ShowWindow(GetDlgItem(hPanelBasic,mtlPStampIDs[i]),SW_HIDE); 
		//		TSTR buf;
//		SetDlgItemText(hPanelBasic,numIDs[i],buf);
		}
	TSTR buf;
	buf.printf(_T("%d"),theMtl->subMtl.Count());
	SetDlgItemText(hPanelBasic,IDC_MULTI_NUMMATS,buf);
	SetScrollRange(hScroll,SB_CTL,0,theMtl->subMtl.Count()-NSUBMTLS,FALSE);
	SetScrollPos(hScroll,SB_CTL,theMtl->offset,TRUE);
	EnableWindow(hScroll,theMtl->subMtl.Count()>NSUBMTLS);
	}

void MultiDlg::LoadDialog(BOOL draw) { FUNC_ENTER("MultiDlg::LoadDialog"); 
	if (theMtl) {
		Interval valid;
		theMtl->Update(curTime,valid);
		UpdateSubMtlNames();		
		}
	}

void MultiDlg::SetThing(ReferenceTarget *m) { FUNC_ENTER("MultiDlg::SetThing"); 
	assert (m->ClassID()==multiClassID);
	assert (m->SuperClassID()==MATERIAL_CLASS_ID);
	RemovePStampHilite();
	if (theMtl) theMtl->paramDlg = NULL;
	theMtl = (Multi *)m;
	if (theMtl) theMtl->paramDlg = this;
	LoadDialog(TRUE);
	}

static int addNum = 5;

static INT_PTR CALLBACK NumMatsDlgProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{ FUNC_ENTER("NumMatsDlgProc"); 
	switch (msg) {
		case WM_INITDIALOG: {
			ISpinnerControl *spin = 
				SetupIntSpinner(
					hWnd,IDC_MULTI_NUMMATSSPIN,IDC_MULTI_NUMMATS,
					1,1000,(int)lParam);
			ReleaseISpinner(spin);
			CenterWindow(hWnd,GetParent(hWnd));
			break;
			}

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDOK: {
					ISpinnerControl *spin = 
						GetISpinner(GetDlgItem(hWnd,IDC_MULTI_NUMMATSSPIN));
					EndDialog(hWnd,spin->GetIVal());
					ReleaseISpinner(spin);
					break;
					}

				case IDCANCEL:
					EndDialog(hWnd,-1);
					break;
				}
			break;

		default:
			return FALSE;
		}
	return TRUE;
	}

void MultiDlg::SetNumMats(HWND hWnd)
	{ FUNC_ENTER("MultiDlg::SetNumMats"); 
	int res = DialogBoxParam(
		hInstance,
		MAKEINTRESOURCE(IDD_MULTI_SETNUM),
		hPanelBasic,
		NumMatsDlgProc,
		(LPARAM)theMtl->subMtl.Count());
	if (res>=0) {
		if (res<=0) res = 1;
		if (res>1000) res = 1000;
		if (res==theMtl->subMtl.Count())
			return;
		RemovePStampHilite();
		HCURSOR c = SetCursor(LoadCursor(NULL,IDC_WAIT));
		theHold.Begin();
		theMtl->SetNumSubMtls(res);
		theHold.Accept(GetString(IDS_DS_SET_NSUB));
		SetCursor(c);
		UpdateSubMtlNames();
		UpdateMtlDisplay();
		}
	}



//-----------------------------------------------------------------------------
//  Multi
//-----------------------------------------------------------------------------



static ParamBlockDesc pbdesc[] = {
	{ TYPE_FLOAT, NULL, TRUE } };   // blend

void Multi::Init() { FUNC_ENTER("Multi::Init"); 
	ivalid.SetEmpty();
	offset = 0;
	maxMtlId = -1;
	hashTabDirty = 1;
#if USE_HASHING
	hashTab.Initialize( 10 );
#endif
	}

void Multi::Reset() { FUNC_ENTER("Multi::Reset"); 
	Init();
//	multiCD.Reset(this, TRUE);	// reset all pb2's   <-- 4/10/01 11:27am --MQM-- this line not needed
//	for (int i=0; i<subMtl.Count(); i++)
//		DeleteReference(i+1);
	SetNumSubMtls(NSUBMTLS);
	for (int i=0; i<subMtl.Count(); i++) {
		ReplaceReference(i+1,(ReferenceTarget*)GetNExtMatDesc()->Create());
		GetCOREInterface()->AssignNewName(subMtl[i]);
		pblock->SetValue(multi_ids,0,i,i);  
		}
	}

void* Multi::GetInterface(ULONG id)
{ FUNC_ENTER("Multi::GetInterface"); 
	if( id == IID_IReshading )
		return (IReshading*)( this );
	else if ( id == IID_IValidityToken )
		return (IValidityToken*)( this );
	else
		return Mtl::GetInterface(id);
}

void Multi::NotifyChanged() { FUNC_ENTER("Multi::NotifyChanged"); 
	ivalid.SetEmpty();
	NotifyDependents(FOREVER, PART_ALL, REFMSG_CHANGE);
	}

Multi::Multi(BOOL loading, BOOL createDefaultSubMtls) : mReshadeRQ(RR_None) // mjm - 06.02.00 // mjm - 10.11.99 - added createDefaultSubMtls parameter
{ FUNC_ENTER("Multi::Multi"); 
	paramDlg = NULL;
	Param1 = FALSE;
	ignoreNotify = FALSE;
	selected = -1;
	
	/*
	subMtl.SetCount(NSUBMTLS);
	for (int i=0; i<NSUBMTLS; i++)  subMtl[i] = NULL;
	*/
	pblock = NULL;

	loadingOld = FALSE;
	multiCD.MakeAutoParamBlocks(this);	// make and intialize paramblock2
	Init();

	if (!loading && createDefaultSubMtls) // mjm - 10.11.99
		SetNumSubMtls(NSUBMTLS);

	pblock->DefineParamAlias(_T("material1"), multi_mtls, 0);  // JBW 5/24/99, add alias for base material to support macroRecording
}

Mtl *Multi::UseMtl() { FUNC_ENTER("Multi::UseMtl"); 
	Mtl* m = NULL;
	for (int i=0; i<subMtl.Count(); i++) if (subMtl[i]) { m = subMtl[i]; break; }
	return m;
	}

void Multi::ClampOffset()
	{ FUNC_ENTER("Multi::ClampOffset"); 
	if (offset>subMtl.Count()-NSUBMTLS) {
		offset=subMtl.Count()-NSUBMTLS;
		}
	if (offset<0) offset = 0;
	}

// These allow the real-time renderer to display a material appearance.
Color Multi::GetAmbient(int mtlNum, BOOL backFace) { FUNC_ENTER("Multi::GetAmbient");  
	int j = FindSubMtlMod(mtlNum);
	if(j<0)
		return 0.0f;
	if (subMtl[j]) return subMtl[j]->GetAmbient(mtlNum,backFace);
	return UseMtl()?UseMtl()->GetAmbient(mtlNum,backFace):Color(0,0,0);
	}		

Color Multi::GetDiffuse(int mtlNum, BOOL backFace){ FUNC_ENTER("Multi::GetDiffuse");  
	int j = FindSubMtlMod(mtlNum);
	if(j<0)
		return 0.0f;
	if (subMtl[j]) return subMtl[j]->GetDiffuse(mtlNum,backFace);
	return UseMtl()?UseMtl()->GetDiffuse():Color(0,0,0);
	}				

Color Multi::GetSpecular(int mtlNum, BOOL backFace){ FUNC_ENTER("Multi::GetSpecular"); 
	int j = FindSubMtlMod(mtlNum);
	if(j<0)
		return 0.0f;
	if (subMtl[j]) return subMtl[j]->GetSpecular(mtlNum,backFace);
	return UseMtl()?UseMtl()->GetSpecular():Color(0,0,0);
	}		

float Multi::GetXParency(int mtlNum, BOOL backFace) { FUNC_ENTER("Multi::GetXParency"); 
	int j = FindSubMtlMod(mtlNum);
	if(j<0)
		return 0.0f;
	if (subMtl[j]) return subMtl[j]->GetXParency(mtlNum,backFace);
	return UseMtl()?UseMtl()->GetXParency():0.0f;
	}

float Multi::GetShininess(int mtlNum, BOOL backFace) { FUNC_ENTER("Multi::GetShininess"); 
	int j = FindSubMtlMod(mtlNum);
	if(j<0)
		return 0.0f;
	if (subMtl[j]) return subMtl[j]->GetShininess(mtlNum,backFace);
	return UseMtl()?UseMtl()->GetShininess():0.0f;
	}		

float Multi::GetShinStr(int mtlNum, BOOL backFace) { FUNC_ENTER("Multi::GetShinStr"); 
	int j = FindSubMtlMod(mtlNum);
	if(j<0)
		return 0.0f;
	if (subMtl[j]) return subMtl[mtlNum]->GetShinStr(mtlNum,backFace);
	return UseMtl()?UseMtl()->GetShinStr():0.0f;
	}

float Multi::WireSize(int mtlNum, BOOL backFace) { FUNC_ENTER("Multi::WireSize"); 
	int j = FindSubMtlMod(mtlNum);
	if(j<0)
		return 0.0f;
	if (subMtl[j]) return subMtl[j]->WireSize(mtlNum,backFace);
	return UseMtl()?UseMtl()->WireSize():0.0f;
	}

RefTargetHandle Multi::Clone(RemapDir &remap) { FUNC_ENTER("Multi::Clone"); 
	Multi *mnew = new Multi(FALSE, FALSE); // mjm - 10.11.99 - don't create default subMtls
	*((MtlBase*)mnew) = *((MtlBase*)this);  // copy superclass stuff
	mnew->ivalid.SetEmpty();
	int nsub = subMtl.Count();
	mnew->subMtl.SetCount(nsub);
//	mnew->mapOn.SetCount(nsub);
//	mnew->subNames.SetSize(nsub);
	mnew->offset = offset;
	mnew->ReplaceReference(PBLOCK_REF,remap.CloneRef(pblock));
	mnew->pblock->SetCount(multi_mtls, nsub);
	mnew->pblock->SetCount(multi_ons, nsub);
	mnew->pblock->SetCount(multi_names, nsub);
	mnew->pblock->SetCount(multi_ids, nsub);

	for (int i = 0; i<nsub; i++)
	{
		mnew->subMtl[i] = NULL;
		if (subMtl[i]) {
			mnew->ReplaceReference(i+1,remap.CloneRef(subMtl[i]));
//			mnew->pblock->SetValue(multi_mtls,0,mnew->subMtl[i],i);
			}
//		mnew->mapOn[i] = mapOn[i];
	}
#if USE_HASHING
//	mnew->UpdateHashTable();
	mnew->hashTabDirty = 1;										// MQM 3/5/01 - 11:44am - faster?
#endif
	BaseClone(this, mnew, remap);
	return (RefTargetHandle)mnew;
}


ParamDlg* Multi::CreateParamDlg(HWND hwMtlEdit, IMtlParams *imp) { FUNC_ENTER("Multi::CreateParamDlg"); 
	MultiDlg *dm = new MultiDlg(hwMtlEdit, imp, this);
	dm->LoadDialog(TRUE);	
	SetParamDlg(dm);
	return dm;	
	}

void Multi::Update( TimeValue t, Interval &valid ) 
{ FUNC_ENTER("Multi::Update"); 		
	int		count;												// num sub materials
	int		id;													// id of current sub mat
	Interval iv;												// current interval
	int		i;													// loop var

	// update all submaterials
	if ( !ivalid.InInterval( t ) ) 
	{
//#if USE_HASHING
//		hashTab.Clean();
//#endif

		ivalid.SetInfinite();

		// loop through and update all sub materials
		maxMtlId = -1;
		count = subMtl.Count();
		for ( i = 0;  i < count;  i++ ) 
		{
			// tell sub material to update
			if ( subMtl[i] )
				subMtl[i]->Update( t, ivalid );

			// get the material id from the sub material
			pblock->GetValue( multi_ids, 0, id, iv, i ); 
			if ( id > maxMtlId )
				maxMtlId = id;									// UPDATE - cache max id#

//#if USE_HASHING
//			hashTab.AddAssociation( id, i );
//#endif
		}
	}
	valid &= ivalid;
}

Interval Multi::Validity(TimeValue t) { FUNC_ENTER("Multi::Validity"); 
	Interval valid;
	Update(t,valid);
	return ivalid;
	}

void Multi::GetSubMtlName(int mtlid, TSTR &s) { FUNC_ENTER("Multi::GetSubMtlName"); 	
	TCHAR *name;
	int j = FindSubMtl(mtlid);
	if (j>=0) {
		Interval iv;
		pblock->GetValue(multi_names,0,name,iv,j);
		s = name;
		}
	else 
		s = _T("");
	}



struct sortEl{
	int i;
	Mtl *mtl;
	BOOL on;
	int mtlid; 
	TCHAR name[100];
	};

static int __cdecl cmpIDs( const void *arg1, const void *arg2 ) { FUNC_ENTER("cmpIDs"); 
	sortEl *s1 = (sortEl *)arg1;
	sortEl *s2 = (sortEl *)arg2;
	int id1 = s1->mtlid;
	int id2 = s2->mtlid;
	return id2<id1? 1: id1<id2? -1:0;
	}

static int __cdecl cmpNames( const void *arg1, const void *arg2 ) { FUNC_ENTER("cmpNames"); 
	sortEl *s1 = (sortEl *)arg1;
	sortEl *s2 = (sortEl *)arg2;
	int id1 = s1->mtlid;
	int id2 = s2->mtlid;
	Mtl * m1 = s1->mtl;
	Mtl * m2 = s2->mtl;
	if (m1&&m2) {
		int res = _tcsicmp(m1->GetFullName(), m2->GetFullName());
		if (res == 0) goto useid;
		return res;
		}
	if (m1) return -1;
	if (m2) return 1;
	useid:
		return id2<id1? 1: id1<id2? -1:0;
	}

static int __cdecl cmpSlotNames( const void *arg1, const void *arg2 ) { FUNC_ENTER("cmpSlotNames"); 
	sortEl *s1 = (sortEl *)arg1;
	sortEl *s2 = (sortEl *)arg2;
	int id1 = s1->mtlid;
	int id2 = s2->mtlid;
	int res = _tcsicmp(s1->name, s2->name);
	if (res != 0) 
		return res;
	return id2<id1? 1: id1<id2? -1:0;
	}

void Multi::SortMtlsByName() { FUNC_ENTER("Multi::SortMtlsByName"); 
	SortMtls(cmpNames);
	}

void Multi::SortMtlsByID() { FUNC_ENTER("Multi::SortMtlsByID"); 
	SortMtls(cmpIDs);
	}

void Multi::SortMtlsBySlotName() { FUNC_ENTER("Multi::SortMtlsBySlotName"); 
	SortMtls(cmpSlotNames);
	}

// Retrieves a material ID from the material: NeverSoft: aml
int Multi::GetMtlID(Mtl* mtl)
{ FUNC_ENTER("Multi::GetMtlID"); 
	int n = subMtl.Count();
	for(int i=0;i<n;i++)
	{
		if (subMtl[i] == mtl)
		{
			int      id;
			Interval iv;
			pblock->GetValue(multi_ids,0,id,iv,i);
			return id;
		}
	}

	return -1;
}

BOOL Multi::AnyDupIDs() { FUNC_ENTER("Multi::AnyDupIDs"); 
	if (paramDlg == NULL)
		return 0;
	for (int j=0; j<NSUBMTLS; j++)
		paramDlg->isDup[j] = FALSE;
	Tab<sortEl> sortlist;
	int n = subMtl.Count();
	sortlist.SetCount(n);
	for (int i=0; i<n; i++) {
		sortEl &s = sortlist[i];
		s.i = i;
		Interval iv;
		pblock->GetValue(multi_ids,0, s.mtlid,iv,i); 
		}
	sortlist.Sort(cmpIDs);
	int lastid = -999;
	int lastIndex = -1;
	BOOL anyDups = FALSE;
	for ( i=0; i<n; i++) {
		sortEl &s = sortlist[i];
		int id = s.mtlid;
		int indx = s.i;
		if (id==lastid) {
			anyDups = TRUE;
			paramDlg->SetIsDup(lastIndex-offset);
			paramDlg->SetIsDup(s.i-offset);
			}
		lastid = id;
		lastIndex = s.i;
		}
	return anyDups;
	}

void Multi::SortMtls(CompareFnc cmp) { FUNC_ENTER("Multi::SortMtls"); 
	Tab<sortEl> sortlist;
	int n = subMtl.Count();
	sortlist.SetCount(n);
	for (int i=0; i<n; i++) {
		sortEl s;
		Interval iv;
		pblock->GetValue(multi_ids,0, s.mtlid,iv,i); 
		pblock->GetValue(multi_mtls, 0, s.mtl,iv,i);
		pblock->GetValue(multi_ons, 0, s.on,iv,i);
		TCHAR *name;
		pblock->GetValue(multi_names,0,name,iv,i);
		if (name) 
			_tcscpy(s.name,name);
		else s.name[0] = 0;

		sortlist[i] = s;
		if (subMtl[i]) subMtl[i]->SetAFlag(A_LOCK_TARGET);
		}
	sortlist.Sort(cmp);
	for ( i=0; i<n; i++) {
		sortEl &s = sortlist[i];
		pblock->SetValue(multi_ids,0,s.mtlid,i);
		pblock->SetValue(multi_mtls,0,s.mtl,i);
		pblock->SetValue(multi_ons,0,s.on,i);
		pblock->SetValue(multi_names,0,s.name,i);
		subMtl[i] = s.mtl;
		}		
	for ( i=0; i<n; i++) {
		if (subMtl[i]) subMtl[i]->ClearAFlag(A_LOCK_TARGET);
		}
#if USE_HASHING
	hashTabDirty = 1;											// MQM 3/5/01 - 11:45am - faster?
//	UpdateHashTable();
#endif
	NotifyChanged();
	}



class DelSubRestore: public RestoreObj {
	Multi *mtl;
	SingleRefMaker subm;
	int nsub;
	TSTR name;
	BOOL on;
	int id;
	public:
		DelSubRestore() { }
		DelSubRestore(Multi *m, int i);
		~DelSubRestore(){ FUNC_ENTER("DelSubRestore::~DelSubRestore"); }
		void Restore(int isUndo);
		void Redo();
		TSTR Description() { FUNC_ENTER("DelSubRestore::Description"); 
			TCHAR buf[100];
			_stprintf(buf,_T("DelSubMtlRestore"));
			return(TSTR(buf));
			}
	};

DelSubRestore::DelSubRestore(Multi *m,  int i) { FUNC_ENTER("DelSubRestore::DelSubRestore"); 
	theHold.Suspend();
	nsub = i;
	mtl = m;
	subm.SetRef(m->subMtl[i]);
	Interval iv;
	mtl->pblock->GetValue(multi_ids,0,id,iv,i);
	mtl->pblock->GetValue(multi_ons,0,on,iv,i);
	TCHAR *pname;
	mtl->pblock->GetValue(multi_names,0,pname,iv,i);
	name = pname;
	theHold.Resume();
	}

void DelSubRestore::Restore(int isUndo) { FUNC_ENTER("DelSubRestore::Restore"); 
	if (isUndo) {
		Mtl *foo = NULL;
		if (mtl->paramDlg)
			mtl->paramDlg->RemovePStampHilite();
		mtl->subMtl.Insert(nsub, 1, &foo);
		Mtl *sm = (Mtl *)subm.GetRef();
		mtl->ReplaceReference(nsub+1, sm);
		mtl->pblock->Insert(multi_mtls, nsub, 1, &sm);
		mtl->pblock->Insert(multi_ons, nsub,  1, &on);
		TCHAR *pname = name.data();
		mtl->pblock->Insert(multi_names, nsub, 1, &pname);
		mtl->pblock->Insert(multi_ids, nsub, 1, &id);
		mtl->selected = nsub;
#if USE_HASHING
		mtl->hashTabDirty = 1;									// MQM 3/5/01 - 11:45am - faster?
//		mtl->UpdateHashTable();
#endif
		mtl->NotifyChanged();
		}
	}

void DelSubRestore::Redo() { FUNC_ENTER("DelSubRestore::Redo"); 
	if (mtl->paramDlg)
		mtl->paramDlg->RemovePStampHilite();
	mtl->ReplaceReference(nsub+1, NULL);
	mtl->subMtl.Delete(nsub, 1);
	mtl->pblock->Delete(multi_mtls, nsub, 1);
	mtl->pblock->Delete(multi_ons, nsub, 1);
	mtl->pblock->Delete(multi_names, nsub, 1);
	mtl->pblock->Delete(multi_ids, nsub, 1);
	if (mtl->selected>=mtl->subMtl.Count())
			mtl->selected = mtl->subMtl.Count() -1;
#if USE_HASHING
	mtl->hashTabDirty = 1;										// MQM 3/5/01 - 11:45am - faster?
//	mtl->UpdateHashTable();
#endif
	mtl->NotifyChanged();
	}

class AddMtlsRestore : public RestoreObj {
	public:
		Multi *m;
		int num;
		AddMtlsRestore(Multi *mul, int n) { FUNC_ENTER("AddMtlsRestore::AddMtlsRestore"); 
			m  = mul;
			num = n;
			}
		void Restore(int isUndo) { FUNC_ENTER("AddMtlsRestore::Restore"); 
			for (int i=0; i<num; i++) {
				m->selected = m->subMtl.Count()-1;
				m->DeleteSelMtl();
				}			
			}
		void Redo() { FUNC_ENTER("AddMtlsRestore::Redo"); 
			for (int i=0; i<num; i++) 
				m->AddMtl();
			m->offset = m->subMtl.Count()-NSUBMTLS;
			m->ClampOffset();
			}
		TSTR Description() { FUNC_ENTER("AddMtlsRestore::Description"); 
			TCHAR buf[100];
			_stprintf(buf,_T("AddMtlsRestore"));
			return(TSTR(buf));
			}
	};

void Multi::AddMtl() { FUNC_ENTER("Multi::AddMtl"); 
	if (theHold.Holding()) 
		theHold.Put(new AddMtlsRestore(this,1));
	theHold.Suspend();
	int n = subMtl.Count()+1;
	int maxid = MaxSubMtlID();
	subMtl.SetCount(n);
#if USE_HASHING
	maxMtlId++;				// 5/2/01 1:26pm --MQM-- moved from #if block below to fix callback/out-of-sync problems
#endif
	macroRec->Disable();	// DS 10/13/00
	pblock->SetCount(multi_ons, n);
	pblock->SetCount(multi_names, n);
	pblock->SetCount(multi_ids, n);
	macroRec->Enable();    // DS 10/13/00
	pblock->SetCount(multi_mtls, n);
	n--;
	subMtl[n] = NULL;
 	pblock->SetValue(multi_ons,0,TRUE,n);
 	pblock->SetValue(multi_ids,0,maxid+1,n);
 	pblock->SetValue(multi_names,0,_T(""),n); // LAM 11/21/00
	ReplaceReference(n+1,(ReferenceTarget*)GetNExtMatDesc()->Create());
	GetCOREInterface()->AssignNewName(subMtl[n]);
	NotifyChanged();
	theHold.Resume();
#if USE_HASHING
	if ( hashTabDirty )
		UpdateHashTable();
	else
		hashTab.AddAssociation( maxMtlId, n );
#endif
	}

void Multi::SetNumSubMtls(int num) { FUNC_ENTER("Multi::SetNumSubMtls"); 
	int n = num-subMtl.Count();
	if (n>0) {
		if (theHold.Holding()) 
			theHold.Put(new AddMtlsRestore(this,n));
		theHold.Suspend();
		for (int i=0; i<n; i++) 
			AddMtl();
		theHold.Resume();
		}
	else if (n<0) {
		n = -n;
		for (int i=0; i<n; i++) {
			selected = subMtl.Count()-1;
			DeleteSelMtl();
			}			
		selected = subMtl.Count()-1;
		}
	offset = subMtl.Count()-NSUBMTLS;
	ClampOffset();
#if USE_HASHING
	hashTabDirty = 1;										// MQM 3/5/01 - 11:45am - faster?
//	UpdateHashTable();   // clean up when removing mats
#endif
	}
	
void Multi::DeleteSelMtl() { FUNC_ENTER("Multi::DeleteSelMtl"); 
	if (selected>=0&&selected<subMtl.Count()) {
		if (theHold.Holding())
			theHold.Put(new DelSubRestore(this, selected));
		theHold.Suspend();
		ReplaceReference(selected+1, NULL);
		subMtl.Delete(selected, 1);
		macroRec->Disable();	// DS 10/13/00
		pblock->Delete(multi_ons, selected, 1);
		pblock->Delete(multi_names, selected, 1);
		pblock->Delete(multi_ids, selected, 1);
		macroRec->Enable();	// DS 10/13/00
		pblock->Delete(multi_mtls, selected, 1);
		if (selected>=subMtl.Count())
			selected = subMtl.Count() -1;
#if USE_HASHING
		hashTabDirty = 1;										// MQM 3/5/01 - 11:46am - faster?
//		UpdateHashTable();
#endif
		ClampOffset();
		NotifyChanged();
		theHold.Resume();
		}
	}

// aml - Neversoft
void Multi::DeleteSubMtl(int sel) { FUNC_ENTER("Multi::DeleteSubMtl"); 
	if (sel>=0&&sel<subMtl.Count()) {
		/*
		if (theHold.Holding())
			theHold.Put(new DelSubRestore(this, sel));
		theHold.Suspend();
		*/
		ReplaceReference(sel+1, NULL);
		subMtl.Delete(sel, 1);
		//macroRec->Disable();	// DS 10/13/00
		//pblock->Delete(multi_ons, sel, 1);
		//pblock->Delete(multi_names, sel, 1);
		//pblock->Delete(multi_ids, sel, 1);
		//macroRec->Enable();	// DS 10/13/00
		//pblock->Delete(multi_mtls, sel, 1);
		if (sel>=subMtl.Count())
			sel = subMtl.Count() -1;
#if USE_HASHING
		hashTabDirty = 1;										// MQM 3/5/01 - 11:46am - faster?
//		UpdateHashTable();
#endif
		ClampOffset();
		NotifyChanged();
		//theHold.Resume();
		}
	}
 
// aml - Neversoft
bool Multi::DeleteSubMtl(Mtl* mtl)
{ FUNC_ENTER("Multi::DeleteSubMtl"); 
	for(int i=0;i<subMtl.Count();i++)
	{
		if (subMtl[i]==mtl)
		{
			DeleteSubMtl(i);
			return true;
		}
	}

	return false;
}

// aml - Neversoft
bool Multi::DeleteSubMtl(TSTR name)
{ FUNC_ENTER("Multi::DeleteSubMtl"); 
	for (int i=0;i<subMtl.Count();i++)
	{
		if (subMtl[i]->GetName()==name)
		{
			DeleteSubMtl(i);
			return true;
		}
	}

	return false;
}

//need to remap references since we added a paramblock
int Multi::RemapRefOnLoad(int iref) 
{ FUNC_ENTER("Multi::RemapRefOnLoad"); 
if (Param1) iref += 1;
return iref;
}

RefTargetHandle Multi::GetReference(int i) { FUNC_ENTER("Multi::GetReference"); 
	if (loadingOld) {
		if (i==0) return NULL;
		else return subMtl[i-1];
		}
	else 
		{
		if (i==PBLOCK_REF) return pblock;
		else return subMtl[i-1];
		}
	}

void Multi::SetReference(int i, RefTargetHandle rtarg) { FUNC_ENTER("Multi::SetReference"); 
	if ((i-1)>=subMtl.Count()) {
		int n = subMtl.Count();
		SetNumSubMtls(i+1);
//		subMtl.SetCount(i+1);
//		for (int j=n; j<=i; j++) // mjm - 10,11.99
//			subMtl[j] = NULL;    // mjm - 10,11.99 - default subMtl created in SetNumSubMtls()
	}
	if (loadingOld) {
		if (i==0|| (rtarg&&!IsMtl(rtarg)))  
			{ } //pblock = (IParamBlock *)rtarg;
		else 
			subMtl[i-1] = (Mtl *)rtarg;
		}
	else 
		{
		if (i==PBLOCK_REF) 
			pblock = (IParamBlock2 *)rtarg;
 		else subMtl[i-1] = (Mtl *)rtarg;
		}
	}



class SetSubRestore: public RestoreObj {
	Multi *multi;
	Mtl *mtl;
	SingleRefMaker subold;
	SingleRefMaker subnew;
	int nsub;
	int mtlid;
	TSTR oldnm;
	TSTR newnm;
	BOOL doname;
	public:
		SetSubRestore() { }
		SetSubRestore(Multi *m, int i, Mtl *mt, int mid, TCHAR *newName=NULL) { FUNC_ENTER("SetSubRestore::SetSubRestore"); 
			multi = m;
			nsub = i;
			mtl = mt;
			mtlid = mid;
			doname = FALSE;
			if (newName) {
				doname = TRUE;
				newnm = newName; 
				if (nsub>=0) {
					TCHAR *pname;
					Interval niv;
					multi->pblock->GetValue(multi_names,0,pname,niv,nsub);
					oldnm = pname;
					}
				}
			theHold.Suspend();
			if (i>=0)
				subold.SetRef(multi->subMtl[i]);
			subnew.SetRef(mt);
			theHold.Resume();
			}
		~SetSubRestore(){ FUNC_ENTER("SetSubRestore::~SetSubRestore"); }
		void Restore(int isUndo) { FUNC_ENTER("SetSubRestore::Restore"); 
			if (nsub>=0) {
				Mtl *sm = (Mtl *)subold.GetRef();
				multi->ReplaceReference(nsub+1, sm);
				if (doname) {
					TCHAR *pname = oldnm.data();
					multi->pblock->SetValue(multi_names,0,pname,nsub);
					}
				}
			else {
				int n = multi->subMtl.Count();
				multi->SetNumSubMtls(n-1);
				}
			if (multi->paramDlg)	  
				multi->paramDlg->UpdateSubMtlNames();
			}
		void Redo() { FUNC_ENTER("SetSubRestore::Redo"); 
			Mtl *sm = (Mtl *)subnew.GetRef();
			multi->SetSubMtlAndName(mtlid,sm,newnm);
			if (doname) 
				multi->SetSubMtlAndName(mtlid,sm,newnm);
			else 
				multi->SetSubMtl(mtlid,sm);
			}
		TSTR Description() { FUNC_ENTER("SetSubRestore::Description"); 
			TCHAR buf[100];
			_stprintf(buf,_T("SetSubMtlRestore"));
			return(TSTR(buf));
			}
	};

void Multi::SetSubMtlAndName(int mtlid, Mtl *m, TSTR &nm) { FUNC_ENTER("Multi::SetSubMtlAndName"); 
	int j = FindSubMtl(mtlid);
	if (theHold.Holding()) 
		theHold.Put(new SetSubRestore(this,j,m,mtlid,nm.data()));
	theHold.Suspend();
	if (j>=0) {
		ReplaceReference(j+1,m);
		TCHAR *pname = nm.data();
		pblock->SetValue(multi_names,0,pname,j);
		}
	else {
		int n = subMtl.Count();
		SetNumSubMtls(n+1);
		ReplaceReference(n+1,m);
		// set the n-th mtl to have mtlid for its mtl ID.
		pblock->SetValue(multi_ids,0,mtlid,n);
		pblock->SetValue(multi_names,0,nm.data(),n);
#if USE_HASHING
		if ( mtlid > maxMtlId )									// 5/22/01 3:31pm --MQM-- bug #252504, NumSubMtls() getting called but maxMtlId not updated
			maxMtlId = mtlid;
		hashTabDirty = 1;											// MQM 3/5/01 - 11:47am - faster?
#endif
		}
	if (paramDlg)	  
		paramDlg->UpdateSubMtlNames();
#if USE_HASHING
//	UpdateHashTable();
#endif
	theHold.Resume();
	}

void Multi::SetSubMtl(int i, Mtl *m) { FUNC_ENTER("Multi::SetSubMtl"); 
	int j = FindSubMtl(i);
	if (theHold.Holding()) 
		theHold.Put(new SetSubRestore(this,j,m,i));
	theHold.Suspend();
	if (j>=0) {
		ReplaceReference(j+1,m);
		}
	else {
		int n = subMtl.Count();
		SetNumSubMtls(n+1);
		ReplaceReference(n+1,m);
		// set the n-th mtl to have i for its mtlID.
		pblock->SetValue(multi_ids,0,i,n);
#if USE_HASHING
		if ( i > maxMtlId )										// 5/22/01 3:31pm --MQM-- bug #252504, NumSubMtls() getting called but maxMtlId not updated
			maxMtlId = i;
		hashTabDirty = 1;											// MQM 3/5/01 - 11:47am - faster?
#endif
		}
	if (paramDlg)	  
		paramDlg->UpdateSubMtlNames();
#if USE_HASHING
//	UpdateHashTable();
#endif
	theHold.Resume();
	}

TSTR Multi::GetSubMtlSlotName(int i) { FUNC_ENTER("Multi::GetSubMtlSlotName"); 
	TSTR s;
	TCHAR *name;
	Interval iv;

	int j = FindSubMtl(i);
	if (j>=0) {
		pblock->GetValue(multi_names,0,name,iv,j);
		if (name) 
			s.printf("(%d) %s",i+1,name);
		else 
			s.printf("(%d)",i+1);
		}

	else 
		s.printf("(%d)",i+1);
	return s;
	}

Animatable* Multi::SubAnim(int i) { FUNC_ENTER("Multi::SubAnim"); 
//	if (i==PBLOCK_REF) return pblock;
//	else return subMtl[i-1]; 
	return subMtl[i]; 
	}

TSTR Multi::SubAnimName(int i) { FUNC_ENTER("Multi::SubAnimName"); 
//	return GetSubMtlTVName(i);
	TCHAR *name;
	Interval iv;
	int id;
	pblock->GetValue(multi_names,0,name,iv,i);
	pblock->GetValue(multi_ids,0,id,iv,i);
	TSTR s;
	if (name) 
		s.printf("(%d) %s",id+1,name);
	else 
		s.printf("(%d)",id+1);
	TSTR nm;
	if (subMtl[i]) 
		nm.printf(_T("%s: %s"), s.data(),  subMtl[i]->GetFullName().data() );
	else 
		nm.printf(_T("%s: None"), s.data());
	return nm;
	}

RefResult Multi::NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
   PartID& partID, RefMessage message ) { FUNC_ENTER("Multi::NotifyRefChanged"); 
	switch (message) {
		case REFMSG_CHANGE:
			if (ignoreNotify)
				return REF_SUCCEED; // succeed????
//				return REF_STOP;
			ivalid.SetEmpty();
			if (hTarget == pblock){
				ParamID changing_param = pblock->LastNotifyParamID();
				multi_param_blk.InvalidateUI(changing_param);
				if( (changing_param == multi_ons )
					||(changing_param == multi_ids ))
					mReshadeRQ = RR_NeedReshade;

				// 6/1/01 10:58am --MQM-- 
				// maxscript or other has changed a sub-mtl id
				if ( changing_param == multi_ids )
				{
					// if the dialog is open, update it to
					// reflect the changes
					if ( paramDlg != NULL )
						paramDlg->Invalidate();

					// hash table is now dirty, since the
					// max mtl id may be different now
					hashTabDirty = 1;
				}
			}

			if (IsMtl(hTarget)) {
				int n = subMtl.Count();
				for (int i=0; i<n; i++) {
					if (subMtl[i] && ((Mtl *)hTarget==subMtl[i])) {
						subMtl[i]->DiscardPStamp(PS_TINY);
						IReshading* r = static_cast<IReshading*>(subMtl[i]->GetInterface(IID_IReshading));
						mReshadeRQ = r == NULL ? RR_None : r->GetReshadeRequirements();
						break;
					}
				}
			}

			// following by JBW 45/21/99 to allow scripter-setting of submtl counts (any count change updates others)
			if ( pblock )
			{
				int newCount = -1;
				
				if      ( pblock->LastNotifyParamID()  == multi_ons  &&
						  pblock->Count( multi_ons )   != subMtl.Count() )
				{
					newCount = pblock->Count( multi_ons );
				}
				else if ( pblock->LastNotifyParamID()  == multi_names  &&
						  pblock->Count( multi_names ) != subMtl.Count() )
				{
					newCount = pblock->Count( multi_names );
				}
				else if ( pblock->LastNotifyParamID()  == multi_ids &&
						  pblock->Count( multi_ids )   != subMtl.Count() )
				{
					newCount=pblock->Count( multi_ids );
				}
				else if ( pblock->LastNotifyParamID()  == multi_mtls &&
						  pblock->Count( multi_mtls )  != subMtl.Count() )
				{
					newCount=pblock->Count( multi_mtls );
				}

				// count has changed
				if ( newCount != -1 ) 
				{	
					ignoreNotify = TRUE;
					pblock->SetCount( pblock->LastNotifyParamID(), subMtl.Count() ); // to make DelSubRestore happy
					SetNumSubMtls( newCount );
					mReshadeRQ = RR_NeedReshade;
					if ( paramDlg != NULL )
					{
						paramDlg->RemovePStampHilite();
						paramDlg->Invalidate();
						paramDlg->UpdateMtlDisplay();
					}
					ignoreNotify = FALSE;
				}
			}


			if (hTarget != NULL) {
				switch (hTarget->SuperClassID()) {
					case MATERIAL_CLASS_ID: {
						IReshading* r = static_cast<IReshading*>(hTarget->GetInterface(IID_IReshading));
						mReshadeRQ = r == NULL ? RR_None : r->GetReshadeRequirements();
					} break;
				}
			}
			break;

		case REFMSG_SUBANIM_STRUCTURE_CHANGED:
			if( hTarget != this )
				return REF_SUCCEED;

			mReshadeRQ = RR_NeedPreshade;
			NotifyChanged();
			break;

//		case REFMSG_SUSPEND_STRUCTURE_CHANGED:
//			ignoreNotify = TRUE;
//			break;
//
//		case REFMSG_RESUME_STRUCTURE_CHANGED:
//			ignoreNotify = FALSE;
//			break;

		case REFMSG_GET_PARAM_DIM: 
		{
			GetParamDim *gpd = (GetParamDim*)partID;
			switch ( gpd->index )								// 4/24/01 3:22pm --MQM-- fix for maxscript #'s to match
			{
			case multi_mtls: 
			case multi_ons:
			case multi_names: 
				gpd->dim = defaultDim;
				break;

			case multi_ids: 
				gpd->dim = &theMultiIDDim;
				break;
			}
			return REF_STOP; 
		}

		case REFMSG_GET_PARAM_NAME: {
			GetParamName *gpn = (GetParamName*)partID;
			return REF_STOP; 
			}
		}
	return(REF_SUCCEED);
	}


inline void Clamp(Color &c) {
	if (c.r > 1.0f) c.r = 1.0f;
	if (c.g > 1.0f) c.g = 1.0f;
	if (c.b > 1.0f) c.b = 1.0f;
	}

static Color black(0,0,0);

Sampler*  Multi::GetPixelSampler(int mtlNum, BOOL backFace )
{ FUNC_ENTER("Multi::GetPixelSampler"); 
	int j = FindSubMtlMod( mtlNum );
	Mtl* subM = (j>=0)? subMtl[j] : NULL;
	if ( subM )
		return subM->GetPixelSampler( mtlNum, backFace );
	return NULL;
}

void Multi::PreShade(ShadeContext& sc, IReshadeFragment* pFrag)
{ FUNC_ENTER("Multi::PreShade"); 
	IReshading* pReshading;
	int mtlnum = sc.mtlNum, ct = subMtl.Count();
	// NOTE: preshade each submaterial to allow user to switch among them during reshading
	if (ct)
	{
		int j = FindSubMtlMod(mtlnum);
		Mtl* subm = (j>=0)?subMtl[j]:NULL;
		if ( subm )
		{
			// store sub-material number and preshade it
			pFrag->AddIntChannel(mtlnum);
			pReshading = (IReshading*)(subm->GetInterface(IID_IReshading));
			if( pReshading ) 
				pReshading->PreShade(sc, pFrag);

		}
		else
		{
			// -1 indicates no submaterial used
			pFrag->AddIntChannel(-1);
		}
	}
	else
	{
		// -1 indicates no submaterial used
		pFrag->AddIntChannel(-1);
	}
}

void Multi::PostShade(ShadeContext& sc, IReshadeFragment* pFrag, int& nextTexIndex, IllumParams*)
{ FUNC_ENTER("Multi::PostShade"); 
	int mtlnum = pFrag->GetIntChannel(nextTexIndex++);
	if (mtlnum == -1)
	{
		// no submaterial was used
		sc.out.c.Black();
		sc.out.t.Black();
		return;
	}

	// submaterial used, let it postshade
	int j = FindSubMtlMod(mtlnum);
	Mtl *subm = NULL;

	IReshading* pReshading;
	if (j>=0) {
		subm = subMtl[j];
		if (subm) {
			// always shade to skip
			pReshading = (IReshading*)(subm->GetInterface(IID_IReshading));
			if( pReshading ) 
				pReshading->PostShade(sc, pFrag, nextTexIndex);

			int on;
			// then see if it's on
			pblock->GetValue(multi_ons,0,on,FOREVER,j);
			if (!on) 
				subm = NULL;
		}// if subm
	} // j >= 0

	// black for no or off material
	if (!subm){
		sc.out.c.Black();
		sc.out.t.Black();
	}
}



// if this function changes, please also check SupportsReShading, PreShade and PostShade
// end - ke/mjm - 03.16.00 - merge reshading code
// [attilas|29.5.2000] if this function changes, please also check EvalColorStdChannel
void Multi::Shade(ShadeContext& sc) { FUNC_ENTER("Multi::Shade"); 
	if (gbufID) sc.SetGBufferID(gbufID);
	int mtlnum = sc.mtlNum, ct = subMtl.Count();
	if (ct)
	{

//		if (mtlnum < 0)	mtlnum = 0;
//		if (mtlnum >= ct) mtlnum = mtlnum % ct;		
//		Mtl* subm = subMtl[mtlnum];

		int j = FindSubMtlMod(mtlnum);
		if (j<0) 
			return;
		Mtl* subm = subMtl[j];
		int on;
		Interval iv;
		pblock->GetValue(multi_ons,0,on,iv,j);
		if (subm&&on) 
			subm->Shade(sc);	//no handling for render elements needed
		}
	}

float Multi::EvalDisplacement( ShadeContext& sc ) 
{ FUNC_ENTER("Multi::EvalDisplacement"); 
	if ( subMtl.Count() ) 
	{
		// find the submaterial
		int j = FindSubMtlMod( sc.mtlNum );
		if ( j < 0 )											// bail out now if material doesn't exist
			return 0.0f;
		Mtl* subm = subMtl[j];

		int on;
		Interval iv;
		pblock->GetValue( multi_ons, 0, on, iv, j );
		if ( on )
			return subm->EvalDisplacement( sc );		
	}

	return 0.0f;
}

Interval Multi::DisplacementValidity(TimeValue t){ FUNC_ENTER("Multi::DisplacementValidity"); 
	int ct = subMtl.Count();
	Interval iv;
	iv.SetInfinite();
	for (int i=0; i<ct; i++) {
		Mtl* subm = subMtl[i];
		int on;
		Interval iv;
		pblock->GetValue(multi_ons,0,on,iv,i);
		if (subm&&on) 
			iv &= subm->DisplacementValidity(t);		
		}
	return iv;
	} 

#define MTL_HDR_CHUNK 0x4000
#define MULTI_NUM_OLD 0x4001
#define MULTI_NUM 0x4002
#define MULTI_NAMES 0x4010
#define MAPOFF_CHUNK 0x1000
#define PARAM2_CHUNK 0x4003
#define PARAM2_NEW_CHUNK 0x4005  // Started saving this 6/19/00 to indicate the new array structure

IOResult Multi::Save(ISave *isave) { FUNC_ENTER("Multi::Save");  
	IOResult res;
	ULONG nb;
	isave->BeginChunk(MTL_HDR_CHUNK);
	res = MtlBase::Save(isave);
	if (res!=IO_OK) return res;
	isave->EndChunk();

	isave->BeginChunk(PARAM2_NEW_CHUNK);
	isave->EndChunk();

	//int numSubs = NSUBMTLS;
	int numSubs = subMtl.Count();
	isave->BeginChunk(MULTI_NUM);
	isave->Write(&numSubs,sizeof(numSubs),&nb);			
	isave->EndChunk();


//	isave->BeginChunk(MULTI_NAMES);
//	subNames.Save(isave);
//	isave->EndChunk();

/*
	for (int i=0; i<subMtl.Count(); i++) {
		if (mapOn[i]==0) {
			isave->BeginChunk(MAPOFF_CHUNK+i);
			isave->EndChunk();
			}
		}
*/

	return IO_OK;
	}	


//2-18-96
class MultiPostLoad : public PostLoadCallback {
	public:
		Multi *m;
		MultiPostLoad(Multi *b) { FUNC_ENTER("MultiPostLoad::MultiPostLoad"); m=b;}
		void proc(ILoad *iload) { FUNC_ENTER("MultiPostLoad::proc");   
			m->loadingOld = FALSE; 
			delete this; 
			} 
	};

//watje
class Multi2PostLoadCallback:public  PostLoadCallback
{
public:
	Multi      *s;
	Tab<BOOL> ons;
//	NameTab subNames;

	int Param1,oldArray;
	Multi2PostLoadCallback(Multi *r, BOOL b, Tab<BOOL> bl, BOOL oldA/*,	NameTab sNames*/) { FUNC_ENTER("Multi2PostLoadCallback::Multi2PostLoadCallback"); s=r;Param1 = b;ons = bl; oldArray = oldA; /*subNames = sNames;*/}
	void proc(ILoad *iload);
};

void Multi2PostLoadCallback::proc(ILoad *iload)
{ FUNC_ENTER("Multi2PostLoadCallback::proc"); 
	if (Param1)
		{
		s->pblock->SetCount(multi_ons,ons.Count());
		s->pblock->SetCount(multi_names,ons.Count());
		s->pblock->SetCount(multi_mtls,ons.Count());
		s->pblock->SetCount(multi_ids,ons.Count());
		for (int i=0; i<s->subMtl.Count(); i++) {
			s->pblock->SetValue(multi_ons,0,ons[i],i);
			if (s->subNames[i])
				s->pblock->SetValue(multi_names,0,s->subNames[i],i);
			s->pblock->SetValue(multi_ids,0,i,i);
			}
		}
	else
		{
		if (s->pblock->Count(multi_mtls) != s->subMtl.Count())
			{
			s->pblock->SetCount(multi_mtls,s->subMtl.Count());
			s->pblock->SetCount(multi_names,s->subMtl.Count());
			s->pblock->SetCount(multi_ons,s->subMtl.Count());
			}
		if (oldArray) {
			s->pblock->SetCount(multi_ids,s->subMtl.Count());
			for (int i=0; i<s->pblock->Count(multi_mtls); i++) {
				s->pblock->SetValue(multi_ids,0,i,i);
				}
			}
		}
                
#if USE_HASHING
	s->hashTabDirty = 1;										// MQM 3/5/01 - 11:47am - faster?
//	s->UpdateHashTable();
#endif

	delete this;
}
	  
IOResult Multi::Load(ILoad *iload) { FUNC_ENTER("Multi::Load");  
	ULONG nb;
	IOResult res;
	Param1 = TRUE;
	BOOL oldArray = TRUE;

	Tab<BOOL>mapOn;
//	NameTab subNames;


	while (IO_OK==(res=iload->OpenChunk())) {
		int id = iload->CurChunkID();

		if (id>=MAPOFF_CHUNK&&id<=MAPOFF_CHUNK+0x1000) {
			mapOn[id-MAPOFF_CHUNK] = FALSE; 
			}
		else 

		switch(id)  {
			case MTL_HDR_CHUNK:
				res = MtlBase::Load(iload);
				break;
			case MULTI_NUM_OLD: 
				iload->SetObsolete();
				iload->RegisterPostLoadCallback(new MultiPostLoad(this));
				loadingOld = TRUE;
			case MULTI_NUM: {
				int numSubs;
				iload->Read(&numSubs,sizeof(numSubs),&nb);			
				subMtl.SetCount(numSubs);
				mapOn.SetCount(numSubs);
				subNames.SetSize(numSubs);

				for (int i=0; i<numSubs; i++) {	
					subMtl[i] = NULL;
					mapOn[i] = TRUE;
					}
				}
				break;
			case MULTI_NAMES:
				res = subNames.Load(iload);	
				subNames.SetSize(subMtl.Count());
				break;
			case PARAM2_NEW_CHUNK:
				oldArray = FALSE;				
				// fall thru...
			case PARAM2_CHUNK:
				Param1 = FALSE;
				break;
			}
		iload->CloseChunk();
		if (res!=IO_OK) 
			return res;
		}

	Multi2PostLoadCallback* multiplcb = new Multi2PostLoadCallback(this,Param1,mapOn,oldArray);
	iload->RegisterPostLoadCallback(multiplcb);
	return IO_OK;
	}

//
// Returns true if the submaterial specified in the shade context is constant

bool Multi::IsOutputConst
( 
	ShadeContext& sc, // describes context of evaluation
	int stdID				// must be ID_AM, ect
)
{ FUNC_ENTER("Multi::IsOutputConst"); 
	int mtlnum = sc.mtlNum, ct = subMtl.Count();
	if (ct)
	{
//		if (mtlnum < 0)
//			mtlnum = 0;
//		if (mtlnum >= ct)
//			mtlnum = mtlnum % ct;		
//		Mtl* subm = subMtl[mtlnum];

		int j = FindSubMtlMod(mtlnum);
		Mtl* subm = j>=0?subMtl[j]:NULL;

		int on;
		Interval iv;
		pblock->GetValue(multi_ons,0,on,iv,j);
		if ( subm && on ) 
			return subm->IsOutputConst( sc, stdID );		
	}
	return true;
}

//
// Evaluates the material on a single texmap channel. 
// For a mono channel, the value is copied in all 3 components of the 
// output color.
// 
bool Multi::EvalColorStdChannel
( 
	ShadeContext& sc, // describes context of evaluation
	int stdID,				// must be ID_AM, ect
	Color& outClr			// output var
)
{ FUNC_ENTER("Multi::EvalColorStdChannel"); 
	int mtlnum = sc.mtlNum, ct = subMtl.Count();
	if (ct)
	{
//		if (mtlnum < 0)
//			mtlnum = 0;
//		if (mtlnum >= ct)
//			mtlnum = mtlnum % ct;		
//		Mtl* subm = subMtl[mtlnum];

		int j = FindSubMtlMod(mtlnum);
		Mtl* subm = j>=0?subMtl[j]:NULL;

		int on;
		Interval iv;
		pblock->GetValue(multi_ons,0,on,iv,j);
		if ( subm && on ) 
			return subm->EvalColorStdChannel( sc, stdID, outClr );
	}
	return false;
}

//
// Evaluates the material on a single texmap channel. 
//
bool Multi::EvalMonoStdChannel
( 
	ShadeContext& sc, // describes context of evaluation
	int stdID,				// must be ID_AM, ect
	float& outVal			// output var
)
{ FUNC_ENTER("Multi::EvalMonoStdChannel"); 
	int mtlnum = sc.mtlNum, ct = subMtl.Count();
	if (ct)
	{
//		if (mtlnum < 0)
//			mtlnum = 0;
//		if (mtlnum >= ct)
//			mtlnum = mtlnum % ct;		
//		Mtl* subm = subMtl[mtlnum];

		int j = FindSubMtlMod(mtlnum);
		Mtl* subm = j>=0?subMtl[j]:NULL;

		int on;
		Interval iv;
		pblock->GetValue(multi_ons,0,on,iv,j);
		if ( subm && on ) 
			return subm->EvalMonoStdChannel( sc, stdID, outVal );
	}
	return false;
}





/*

class SetNumMtlsRestore : public RestoreObj {
	public:
		Multi *multi;
		Tab<Mtl*> undo, redo;
//		Tab<BOOL> undoMO, redoMO;
		SetNumMtlsRestore(Multi *m) {
			multi  = m;
			undo   = multi->subMtl;
//			undoMO = multi->mapOn;
			}
   		
		void Restore(int isUndo) {
			if (isUndo) {
				redo   = multi->subMtl;
//				redoMO = multi->mapOn;
				}
			multi->subMtl = undo;
//			multi->mapOn  = undoMO;
			}
		void Redo() {
			multi->subMtl = redo;
//			multi->mapOn  = redoMO;
			}
	};

void Multi::SetNumSubMtls(int n)
	{
	int ct = subMtl.Count();
	if (n!=ct) {
		if (n<ct) {
			for (int i=n; i<ct; i++) {
				if (subMtl[i])
					subMtl[i]->DeactivateMapsInTree();
				ReplaceReference(i+1,NULL);
				}
			}
		subMtl.SetCount(n);
//		subNames.SetSize(n);
//		mapOn.SetCount(n);
//		pblock->SetCount(multi_mtls,n);
		if (n>ct) {
			for (int i=ct; i<subMtl.Count(); i++) {
				subMtl[i] = NULL;
				ReplaceReference(i+1,(ReferenceTarget*)GetStdMtl2Desc()->Create());
				GetCOREInterface()->AssignNewName(subMtl[i]);

//				pblock->SetValue(multi_ons,0,TRUE,i);
//				mapOn[i] = TRUE;
				}
//have to do this sepperate because setvalue causes an update and all the references are not in place yet
			macroRec->Disable();	// JBW 4/21/99, just record on count change
			pblock->SetCount(multi_ons,n);
			pblock->SetCount(multi_names,n);
			pblock->SetCount(multi_ids,n);
			macroRec->Enable();
			pblock->SetCount(multi_mtls,n);
			for (i=ct; i<subMtl.Count(); i++) {
				pblock->SetValue(multi_ons,0,TRUE,i);
				pblock->SetValue(multi_ids,0,i,i);  
//				mapOn[i] = TRUE;
				}

			}		
		else 
			{
			macroRec->Disable();	// JBW 4/21/99, just record on count change
			pblock->SetCount(multi_ons,n);
			pblock->SetCount(multi_names,n);
			pblock->SetCount(multi_ids,n);
			macroRec->Enable();
			pblock->SetCount(multi_mtls,n);

			}

		ClampOffset();
		NotifyChanged();
		if (paramDlg&&!paramDlg->isActive) {
			paramDlg->ReloadDialog();
			paramDlg->UpdateMtlDisplay();	  // DS 9/2/99
			}
		}
	}
 
*/
