#include "FuncEnter.h"

#include "Trigger/Trigger.h"
#include <max.h>
#include <maxicon.h>
#include <resource.h>

#include "LinkUI.h"
#include "LinkMan.h"
#include "LinkOptions.h"
#include "misc/llist.h"

#include <utilapi.h>
#include <imacroscript.h>

#ifdef TRUE
#undef TRUE
#define TRUE 1
#endif

#ifdef FALSE
#undef FALSE
#define FALSE 0
#endif


static int numSelChange=0;

//#define TBITEM(type, bmi, cmd) \
		//ToolButtonItem(type,bmi,bmi,bmi,bmi,GetCUIFrameMgr()->GetImageSize(),GetCUIFrameMgr()->GetImageSize(),GetCUIFrameMgr()->GetButtonWidth(),GetCUIFrameMgr()->GetButtonHeight(),cmd,0)
#define TBITEM(type, pIcon, cmd) \
		ToolButtonItem(type,pIcon,GetCUIFrameMgr()->GetImageSize(),GetCUIFrameMgr()->GetImageSize(),GetCUIFrameMgr()->GetButtonWidth(),GetCUIFrameMgr()->GetButtonHeight(),cmd,0)
#define TBMACRO(md) \
		ToolMacroItem(0, GetCUIFrameMgr()->GetButtonHeight(), md)
#define NumElements(array) (sizeof(array) / sizeof(array[0]))

// Here a large value is used so it won't conflict with the IDs used
// by MAX.  If the ProcessMessage() method of the handler returns FALSE
// MAX will use the default CUI toolbar processing and this could invoke
// a MAX command unintentionally.  Note that this is only the case if
// it returns FALSE.
#define ID_TB_MANY_TO_ONE	  10000
#define ID_TB_ONE_TO_MANY	  10001
#define ID_TB_UNLINK		  10002
#define ID_TB_LINK_OPTIONS	  10003
#define ID_TB_CHAIN_CLOSED	  10004
#define ID_TB_CHAIN_OPEN	  10005
#define ID_TB_BW_CHAIN_OPEN	  10006
#define ID_TB_SELECT_CHILDREN 10007
#define ID_TB_SELECT_PARENTS  10008
#define ID_TB_SELECT_GRAPH    10009
#define ID_TB_AUTO_UPDATE	  10020

extern HINSTANCE hInstance;

const ActionTableId link_actions = vLINK_SHORTCUT_ID;
const ActionContextId link_actions_context = vLINK_SHORTCUT_ID;

static HWND hToolbar = NULL;
static HIMAGELIST hButtons = NULL;
static int display_counter = 0;
static LinkOptionsDlg *link_dlg = NULL;
static LinkObjClassDesc link_class_desc;
static LinkActionCB *accel = NULL;

ClassDesc	*GetLinkObjClassDesc() { FUNC_ENTER("GetLinkObjClassDesc");  return &link_class_desc; }

static LinkUIClassDesc LinkUIDesc;
ClassDesc* GetLinkUIDesc() { FUNC_ENTER("GetLinkUIDesc");  return &LinkUIDesc; }

class TBMsgHandler : public CUIFrameMsgHandler 
{
	LinkUI *ct;	
  public:
	TBMsgHandler(LinkUI *ctst)	{ FUNC_ENTER("TBMsgHandler::TBMsgHandler");  this->ct = ctst; }
	int ProcessMessage(UINT message, WPARAM wParam, LPARAM lParam);

};	
static TBMsgHandler *tbMsgHandler;

int TBMsgHandler::ProcessMessage(UINT message, WPARAM wParam, LPARAM lParam) { FUNC_ENTER("TBMsgHandler::ProcessMessage"); 
	switch(message) {
	case WM_COMMAND:
		switch (LOWORD(wParam)) 
		{
		case ID_TB_MANY_TO_ONE:
		{
			if( gInterface->GetSelNodeCount() > 0 )
			{
				GetLinkMan()->ManyToOneLink();
			}
			return TRUE;
		}
		case ID_TB_ONE_TO_MANY:
		{
			if( gInterface->GetSelNodeCount() > 0 )
			{
				GetLinkMan()->OneToManyLink();
			}
			return TRUE;
		}
		case ID_TB_UNLINK:
		{
			if( gInterface->GetSelNodeCount() > 0 )
			{
				GetLinkMan()->Unlink();
			}
			return TRUE;
		}
		case ID_TB_CHAIN_CLOSED:
		{
			if( gInterface->GetSelNodeCount() > 0 )
			{
				GetLinkMan()->ChainLink( true );
			}
			return TRUE;
		}
		case ID_TB_CHAIN_OPEN:
		{
			if( gInterface->GetSelNodeCount() > 0 )
			{
				GetLinkMan()->ChainLink( false );
			}
			return TRUE;
		}
		case ID_TB_BW_CHAIN_OPEN:
		{
			if( gInterface->GetSelNodeCount() > 0 )
			{
				GetLinkMan()->ReverseChainLink( false );
			}
			return TRUE;
		}
		case ID_TB_SELECT_CHILDREN:
		{
			bool select_children_on;

			select_children_on = GetLinkMan()->GetSelectChildren();
			if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
			{			
				GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_ALL );					
			}
			GetLinkMan()->SetSelectChildren( !select_children_on );
			ct->Refresh();

			gInterface->ForceCompleteRedraw();
			return TRUE;
		}
		case ID_TB_SELECT_PARENTS:
		{
			bool select_parents_on;

			select_parents_on = GetLinkMan()->GetSelectParents();
			if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
			{			
				GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_ALL );					
			}
			GetLinkMan()->SetSelectParents( !select_parents_on );	
			ct->Refresh();
			gInterface->ForceCompleteRedraw();
			return TRUE;
		}
		case ID_TB_SELECT_GRAPH:
		{
			bool select_children_on, select_parents_on;
			
			select_children_on = GetLinkMan()->GetSelectChildren();
			select_parents_on  = GetLinkMan()->GetSelectParents();

			{
				GetLinkMan()->SetSelectChildren( TRUE );
				GetLinkMan()->SetSelectParents( TRUE );

				//ct->iSelectChildren->SetCheck( TRUE );
				//ct->iSelectParents->SetCheck( TRUE );
			}

			ct->Refresh();
			gInterface->ForceCompleteRedraw();

			// Restore the original mode
			GetLinkMan()->SetSelectChildren( select_children_on );
			GetLinkMan()->SetSelectParents( select_parents_on );
			ct->Refresh();

			return TRUE;
		}
		case ID_TB_AUTO_UPDATE:
		{
			GetLinkMan()->EnableAutoUpdate( !GetLinkMan()->AutoUpdateEnabled());				
			return TRUE;
		}		
		case ID_TB_LINK_OPTIONS:
		{
			if( link_dlg == NULL )
			{
				link_dlg = new LinkOptionsDlg;
				link_dlg->Show();
			}
			return TRUE;
		}
		default: // ID not recognized -- use default CUI processing
			return FALSE;
		}
	}
	return FALSE;
}

void	DestroyLinkOptionsDialog( void )
{ FUNC_ENTER("DestroyLinkOptionsDialog"); 
	link_dlg->Hide();
	delete link_dlg;
	link_dlg = NULL;
}

static void link_post_open_handler(void *param, NotifyInfo *info ) 
{ FUNC_ENTER("link_post_open_handler"); 
	OutputDebugString("HANDLER: link_post_open_handler\n");
	GetLinkMan()->OnPostOpen();	

	// Destroy any old trigger data
	TriggerUI::DestroyRetainedData();
}

static void link_pre_merge_handler(void *param, NotifyInfo* info )
{ FUNC_ENTER("link_pre_merge_handler"); 
	OutputDebugString("HANDLER: link_pre_merge_handler\n");
	GetLinkMan()->OnPreMerge();	
}

static void link_post_merge_handler(void *param, NotifyInfo* info )
{ FUNC_ENTER("link_post_merge_handler"); 
	OutputDebugString("HANDLER: link_post_merge_handler\n");
	GetLinkMan()->OnPostMerge();	
}

static void link_pre_save_handler(void *param, NotifyInfo* info )
{ FUNC_ENTER("link_pre_save_handler"); 
	OutputDebugString("HANDLER: link_pre_save_handler\n");
	GetLinkMan()->OnPreSave();	
}

struct NChange {
	TCHAR *oldname;
	TCHAR *newname;
	}; 

static void link_rename_handler(void* param, NotifyInfo* info )
{ FUNC_ENTER("link_rename_handler"); 
	OutputDebugString("HANDLER: link_rename_handler\n");
	NChange* pnc = (NChange*) info->callParam;

	if( strstr( pnc->oldname, "TriggerLink" ))
	{
		strcpy( pnc->newname, pnc->oldname );
	}
}

void LinkUI::GetChildren(INodeTab& tab, INode* node)
{ FUNC_ENTER("LinkUI::GetChildren"); 
	INode* nextNode = node;
	
	while(nextNode)
	{
		tab.Append(1, &nextNode);
		nextNode = FindNextLink(nextNode);

		// Handle cyclical references
		for(int i = 0; i < tab.Count(); i++)
		{
			if (tab[i] == nextNode)
				return;
		}
	}
}

void LinkUI::GetParents(INodeTab& tab, INode* node)
{ FUNC_ENTER("LinkUI::GetParents"); 
	INode* lastNode = node;
	
	while(lastNode)
	{
		tab.Append(1, &lastNode);
		lastNode = FindLastLink(lastNode);

		// Handle cyclical references
		for(int i = 0; i < tab.Count(); i++)
		{
			if (tab[i] == lastNode)
				return;
		}
	}
}

void LinkUI::link_selchange_handler(void* param, NotifyInfo* info )
{ FUNC_ENTER("LinkUI::link_selchange_handler"); 
	OutputDebugString("HANDLER: link_selchange_handler\n");
	LinkUI* pLinkUI=(LinkUI*)param;

	if (!pLinkUI)
		return;

	if (pLinkUI->bLockSelChange || GetLinkMan()->IsLocked())
		return;

	LinkList<INode*>      nodelist;
	INodeTab              linknodelist;
	INodeTab              parentlist, childlist;
	INodeTab              deselectList;

	// If a link
	GetLinkMan()->SetLock(true);
	pLinkUI->bLockSelChange=true;

	// Remove selection update notification if the selection set is locked to speed up trigger select
	UnRegisterNotification( link_selchange_handler, pLinkUI, NOTIFY_SELECTIONSET_CHANGED);

	// Notify all the link objects that were updated in this selection
	int numNodes = gInterface->GetSelNodeCount();

	int i;
	
	//////////
	for(i = 0; i < numNodes; i++)
	{
		INode* node = gInterface->GetSelNode(i);

		// Select parents/children if appropriate
		if (GetLinkMan()->GetSelectParents())
			GetParents(parentlist, node);

		if (GetLinkMan()->GetSelectChildren())
			GetChildren(childlist, node);
	}
	//////////

	/*
	gInterface->SelectNodeTab(parentlist, TRUE, FALSE);
	gInterface->SelectNodeTab(childlist, TRUE, FALSE);

	GetLinkMan()->SetLock(false);
	pLinkUI->bLockSelChange=false;

	// Restore trigger link selection change notification
	RegisterNotification( link_selchange_handler, pLinkUI, NOTIFY_SELECTIONSET_CHANGED);
	return;
	*/
	/////////////////////////////////////////////////////////////////////////////////////////////

	numNodes = gInterface->GetSelNodeCount();

	for(i = 0; i < numNodes; i++)
	{
		INode* node = gInterface->GetSelNode(i);

		Object* obj = node->EvalWorldState(gInterface->GetTime()).obj;

		if (obj)
		{
			if (obj->ClassID()==vTRIGGER_CLASS_ID)
			{
				Trigger* tobj    = (Trigger*)obj;
				RefList& reflist = node->GetRefList();

				RefListItem* refItem = reflist.FirstItem();

				while(refItem)
				{	
					if (refItem->maker && refItem->maker->ClassID()==vLINK_OBJ_CLASS_ID)
					{
						nodelist.AddUnique(&node);
						LinkObject* lobj = (LinkObject*)refItem->maker;

						// The link may only be added to the selection set if the
						// object that the link links to is also included in the selection set
						if (lobj->from_node == node &&
							lobj->link_node)
						{
							for(int chknode = 0; chknode < numNodes; chknode++)
							{
								if (gInterface->GetSelNode(chknode) == lobj->to_node)
								{
									linknodelist.Append(1, &lobj->link_node);
									break;
								}
							}
						}

						//linkobjlist.AddUnique(&lobj);
					}

					if (refItem->maker && refItem->maker->SuperClassID()==BASENODE_CLASS_ID)
					{
						INode* refNode=(INode*)refItem->maker;
						Object* refObj=refNode->EvalWorldState(gInterface->GetTime()).obj;

						CStr name      = refNode->GetName();
						Class_ID  cid  = refObj->ClassID();
						SClass_ID scid = refObj->SuperClassID();

						if (refObj->ClassID()==vLINK_OBJ_CLASS_ID)
							nodelist.AddUnique(&node);
					}

					refItem=refItem->next;
				}
			}

			if (obj->ClassID()==vLINK_OBJ_CLASS_ID)
			{
				nodelist.AddUnique(&node);
				
				// Any former TriggerLinks selected should be cleared when the selection changes
				deselectList.Append(1, &node);
			}
		}
	}

	// Turn off screen redraw.  If we're in Modify mode it redraws the display with each
	// newly selected node and kills our performance
	gInterface->DisableSceneRedraw();

	// Now process the updates
	Link<INode*>* link = nodelist.GetHead();
	Link<INode*>* head = link;

	while(link)
	{
		LinkObject* lobj=(LinkObject*)link->data->EvalWorldState(gInterface->GetTime()).obj;
		lobj->NotifyDependents(FOREVER,0,REFMSG_LINK_SELECTED);

		//lobj->SelUpdate(link->data);
		link=link->next;
	}

	gInterface->SelectNodeTab(deselectList, FALSE, FALSE);
	gInterface->SelectNodeTab(linknodelist, TRUE, FALSE);

	gInterface->EnableSceneRedraw();

	GetLinkMan()->SetLock(false);

	// Restore trigger link selection change notification
#ifndef DISABLE_NOTIFICATIONS
	RegisterNotification( link_selchange_handler, pLinkUI, NOTIFY_SELECTIONSET_CHANGED);
#endif

	if (head)
		gInterface->SelectNode(head->data, 0);	// Do another select to force updates

	gInterface->SelectNodeTab(parentlist, TRUE, FALSE);
	gInterface->SelectNodeTab(childlist, TRUE, FALSE);

	pLinkUI->bLockSelChange=false;
}

// Activate and Stay Resident
// The GUPRESULT_KEEP tells MAX that we want to remain loaded in the system
// Check the SDK Help File for other returns, to change the behavior
DWORD LinkUI::Start( ) 
{ FUNC_ENTER("LinkUI::Start"); 
	ICustButton* button;
	HWND hParent = MaxWnd();
	bool existed;
	
	bLockSelChange=false;

#ifndef DISABLE_NOTIFICATIONS
	RegisterNotification( link_post_open_handler, NULL, NOTIFY_FILE_POST_OPEN );
	RegisterNotification( link_pre_merge_handler, NULL, NOTIFY_FILE_PRE_MERGE );
	RegisterNotification( link_post_merge_handler, NULL, NOTIFY_FILE_POST_MERGE );
	RegisterNotification( link_pre_save_handler, NULL, NOTIFY_FILE_PRE_SAVE );
	RegisterNotification( link_rename_handler, NULL, NOTIFY_NODE_RENAMED );
	RegisterNotification( link_selchange_handler, this, NOTIFY_SELECTIONSET_CHANGED);
#endif

	// Check to see if a frame already exists
	// one will be there if the toolbars have been 
	// loaded through the system window identifier
	ICUIFrame *exFrame = NULL;

	existed = false;
	if( GetCUIFrameMgr()->GetICUIFrame(_T("LinkUI Toolbar")))
	{
		existed = true;
	}
	hWnd = CreateCUIFrameWindow(hParent, _T("LinkUI Toolbar"), 0, 0, 250, 100);
	exFrame = GetCUIFrameMgr()->GetICUIFrame(_T("LinkUI Toolbar"));
	
	iFrame = ::GetICUIFrame(hWnd);
	iFrame->SetContentType(CUI_TOOLBAR);
	iFrame->SetPosType(CUI_HORIZ_DOCK | CUI_VERT_DOCK | CUI_FLOATABLE | CUI_SM_HANDLES );
	// Register me in menu dropdown
	iFrame->SetMenuDisplay(CUI_MENU_SHOW_ENABLED);
	iFrame->SetSystemWindow(TRUE);

	// -- Now create the toolbar window
	hToolbar = CreateWindow
	(
		CUSTTOOLBARWINDOWCLASS,
		NULL,
		WS_CHILD | WS_VISIBLE,
		0, 0, 250, 100,
		hWnd,
		NULL,
		hInstance,
		NULL);

	// -- Now link the toolbar to the CUI frame
	ICustToolbar *link_toolbar = GetICustToolbar(hToolbar);
	link_toolbar->LinkToCUIFrame(hWnd, NULL);
	link_toolbar->SetBottomBorder(FALSE);
	link_toolbar->SetTopBorder(FALSE);

	// Install the message handler to process the controls we'll add...
	tbMsgHandler = new TBMsgHandler(this);
	iFrame->InstallMsgHandler(tbMsgHandler);

	// -- Toss in a few controls of various sorts...
	//link_toolbar->SetImage(GetCUIFrameMgr()->GetDefaultImageList());
	//hButtons = ImageList_Create(16, 15, ILC_COLOR16 | ILC_MASK, 7, 0);
	//LoadMAXFileIcon("LinkUI", hButtons, kBackground, FALSE);
	// Get the index into the entire image list of the CUITest icons.
	int iconIndex;// = GetCUIFrameMgr()->GetGroupStartIndex(_T("LinkUI"));
	// Add a push button
	// This one docks and undocks the toolbar if clicked...
	iconIndex = 1;
	MaxBmpFileIcon* pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex );
	//link_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex, ID_TB_MANY_TO_ONE ));
	link_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_MANY_TO_ONE));
	
	button = link_toolbar->GetICustButton( ID_TB_MANY_TO_ONE );
	button->SetTooltip( TRUE, &(_T("Link Many To One")));
	ReleaseICustButton( button );

	pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex + 1 );
	link_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_ONE_TO_MANY));
	//link_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+1, ID_TB_ONE_TO_MANY ));

	button = link_toolbar->GetICustButton( ID_TB_ONE_TO_MANY );
	button->SetTooltip( TRUE, &(_T("Link One To Many" )));
	ReleaseICustButton( button );

	pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex + 4 );
	link_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_CHAIN_CLOSED));
	//link_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+4, ID_TB_CHAIN_CLOSED ));

	button = link_toolbar->GetICustButton( ID_TB_CHAIN_CLOSED );
	button->SetTooltip( TRUE, &(_T("Closed Chain Link" )));
	ReleaseICustButton( button );

	pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex + 5 );
	link_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_CHAIN_OPEN));
	//link_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+5, ID_TB_CHAIN_OPEN ));

	button = link_toolbar->GetICustButton( ID_TB_CHAIN_OPEN );
	button->SetTooltip( TRUE, &(_T("Open Chain Link" )));
	ReleaseICustButton( button );

	pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex + 6 );
	link_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_BW_CHAIN_OPEN));
	//link_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+6, ID_TB_BW_CHAIN_OPEN ));

	button = link_toolbar->GetICustButton( ID_TB_BW_CHAIN_OPEN );
	button->SetTooltip( TRUE, &(_T("Reverse Open Chain Link" )));
	ReleaseICustButton( button );

	pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex + 7 );
	link_toolbar->AddTool(TBITEM(CTB_CHECKBUTTON, pIcon, ID_TB_SELECT_CHILDREN));
	//link_toolbar->AddTool( TBITEM( CTB_CHECKBUTTON, iconIndex+7, ID_TB_SELECT_CHILDREN ));

	iSelectChildren = link_toolbar->GetICustButton( ID_TB_SELECT_CHILDREN );
	iSelectChildren->SetTooltip( TRUE, &(_T("Select Children" )));

	pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex + 8 );
	link_toolbar->AddTool(TBITEM(CTB_CHECKBUTTON, pIcon, ID_TB_SELECT_PARENTS));
	//link_toolbar->AddTool( TBITEM( CTB_CHECKBUTTON, iconIndex+8, ID_TB_SELECT_PARENTS ));

	iSelectParents = link_toolbar->GetICustButton( ID_TB_SELECT_PARENTS );
	iSelectParents->SetTooltip( TRUE, &(_T("Select Parents" )));

	pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex + 9 );
	link_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_SELECT_GRAPH));

	button = link_toolbar->GetICustButton( ID_TB_SELECT_GRAPH );
	button->SetTooltip( TRUE, &(_T("Select Parents and Children" )));
	ReleaseICustButton( button );

	// Add a separator
	link_toolbar->AddTool( ToolSeparatorItem( 8 ));
	
	pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex + 2 );
	link_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_UNLINK));
	//link_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+2, ID_TB_UNLINK ));

	button = link_toolbar->GetICustButton( ID_TB_UNLINK );
	button->SetTooltip( TRUE, &(_T("Unlink" )));
	ReleaseICustButton( button );

	// Add a separator
	link_toolbar->AddTool( ToolSeparatorItem( 8 ));
	
	pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex + 3 );
	link_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_LINK_OPTIONS));
	//link_toolbar->AddTool( TBITEM(CTB_PUSHBUTTON, iconIndex+3, ID_TB_LINK_OPTIONS ));

	button = link_toolbar->GetICustButton( ID_TB_LINK_OPTIONS );
	button->SetTooltip( TRUE, &(_T("Options" )));
	ReleaseICustButton( button );

	pIcon = new MaxBmpFileIcon(_T("LinkUI"), iconIndex + 10 );
	link_toolbar->AddTool(TBITEM(CTB_CHECKBUTTON, pIcon, ID_TB_AUTO_UPDATE));
	button = link_toolbar->GetICustButton( ID_TB_AUTO_UPDATE );
	button->SetTooltip( TRUE, &(_T("Auto Update" )));
	ReleaseICustButton( button );
	
	// -- Set the initial floating position
	// if the utility hasn't been run before, this will become the position
	// the user sees. otherwise, it will get overwritten by the loaded 
	// data below
	SIZE sz; RECT rect;
	link_toolbar->GetFloatingCUIFrameSize(&sz);
	rect.top = 200; rect.left = 200;
	rect.right = rect.left+sz.cx; rect.bottom = rect.top+sz.cy;
	GetCUIFrameMgr()->FloatCUIWindow(hWnd, &rect);
	MoveWindow(hWnd, rect.left, rect.right, sz.cx, sz.cy, TRUE);

	if( existed )
	{
		// SHELF SEARCH - STILL FLAKY!
		ICUIFrame *shelf = GetCUIFrameMgr()->GetICUIFrame(_T("Tab Panel"));
		int nTools = shelf->GetToolbarCount();
		BOOL weInTabBar = FALSE;
		int posInTabBar = -1;
		int i;

		// Search the shelf for instance
		for(i=0;i<nTools;i++)
		{
			if( stricmp(shelf->GetTabName(i),_T("LinkUI Toolbar"))==0 )
			{
				shelf->DeleteToolbarTab(i);
				posInTabBar = i;
				weInTabBar = TRUE;
				break;
			}
		}
		// SHELF SEARCH - STILL FLAKY!



		// restore position and docking if the tab panel had saved data
		if(!weInTabBar)
		{
			iFrame->Hide(FALSE);

			// If one already exists - copy its positional data and kill it
			// this would happen if the utility had been run before and therefore
			// the tab panel would get to save itself into the CUI file
			if(exFrame)
			{
				DWORD cPos = exFrame->GetCurPosition();
				if(cPos==CUI_FLOATING)
				{
					// frame was floating - get pos and copy
					Rect sz;
					GetWindowRect(exFrame->GetHwnd(),&sz);
					GetCUIFrameMgr()->FloatCUIWindow(iFrame->GetHwnd(), &sz);
					DestroyWindow(exFrame->GetHwnd());
				}
				else
				{
					// frame was docked - just redock
					DestroyWindow(exFrame->GetHwnd());
					GetCUIFrameMgr()->DockCUIWindow(iFrame->GetHwnd(),cPos);
				}
			}


		}


		// SHELF SEARCH - STILL FLAKY!
		if(weInTabBar)
		{

			shelf->AddToolbarTab(iFrame->GetContentHandle(), tbMsgHandler, iFrame->GetName());
			SetParent(iFrame->GetContentHandle(), shelf->GetHwnd());
			DestroyWindow(iFrame->GetHwnd());
			shelf->SetCurrentTab(shelf->GetCurrentTab());
		}
		// SHELF SEARCH - STILL FLAKY!


		// Force a CUI complete update
		GetCUIFrameMgr()->RecalcLayout(TRUE);
	}


	// We are done, release the toolbar and frame handles
	ReleaseICustToolbar(link_toolbar);
	ReleaseICUIFrame(iFrame);
	iFrame = NULL;

	accel = new LinkActionCB;
	accel->m_LinkUI = this;
	gInterface->GetActionManager()->ActivateActionTable( accel, link_actions );

	return GUPRESULT_KEEP;
}


// We do nothing when the GUP unloads
void LinkUI::Stop( ) 
{ FUNC_ENTER("LinkUI::Stop"); 	
	ReleaseICustButton(iSelectParents);
	ReleaseICustButton(iSelectChildren);
}

void LinkUI::Refresh()
{ FUNC_ENTER("LinkUI::Refresh"); 
	link_selchange_handler(this,NULL);
}

DWORD LinkUI::Control( DWORD parameter ) { FUNC_ENTER("LinkUI::Control"); 
	return 0;
}

void	LinkUI::SetSelectChildren( bool on )
{ FUNC_ENTER("LinkUI::SetSelectChildren"); 
	ICustToolbar *link_toolbar;
	ICustButton* button;

	link_toolbar = GetICustToolbar( hToolbar );
	button = link_toolbar->GetICustButton( ID_TB_SELECT_CHILDREN );
	button->SetCheck( on );
	ReleaseICustButton( button );
	ReleaseICustToolbar(link_toolbar);
}

void	LinkUI::SetSelectParents( bool on )
{ FUNC_ENTER("LinkUI::SetSelectParents"); 
	ICustToolbar *link_toolbar;
	ICustButton* button;

	link_toolbar = GetICustToolbar( hToolbar );
	button = link_toolbar->GetICustButton( ID_TB_SELECT_PARENTS );
	button->SetCheck( on );
	ReleaseICustButton( button );
	ReleaseICustToolbar(link_toolbar);
}

// action table
static ActionDescription s_link_actions[] = {

	ID_SELECT_CHILDREN,
    IDS_SELECT_CHILDREN,
    IDS_SELECT_CHILDREN,
    IDS_LINK_ACTIONS,

    ID_OPEN_CHAIN_LINK,
    IDS_OPEN_CHAIN_LINK,
    IDS_OPEN_CHAIN_LINK,
    IDS_LINK_ACTIONS,

    ID_MANY_TO_ONE_LINK,
    IDS_MANY_TO_ONE_LINK,
    IDS_MANY_TO_ONE_LINK,
    IDS_LINK_ACTIONS,

    ID_ONE_TO_MANY_LINK,
    IDS_ONE_TO_MANY_LINK,
    IDS_ONE_TO_MANY_LINK,
    IDS_LINK_ACTIONS,

    ID_SELECT_PARENTS,
    IDS_SELECT_PARENTS,
    IDS_SELECT_PARENTS,
    IDS_LINK_ACTIONS,

    ID_REV_OPEN_CHAIN_LINK,
    IDS_REV_OPEN_CHAIN_LINK,
    IDS_REV_OPEN_CHAIN_LINK,
    IDS_LINK_ACTIONS,

	ID_UNLINK,
    IDS_UNLINK,
    IDS_UNLINK,
    IDS_LINK_ACTIONS,

	ID_CLOSED_CHAIN_LINK,
    IDS_CLOSED_CHAIN_LINK,
    IDS_CLOSED_CHAIN_LINK,
    IDS_LINK_ACTIONS,

	// Add Select Graph
	ID_SELECT_GRAPH,
	IDS_SELECT_GRAPH,
	IDS_SELECT_GRAPH,
	IDS_LINK_ACTIONS,
};

ActionTable* GetLinkActions( void )
{ FUNC_ENTER("GetLinkActions"); 
    TSTR name = GetString(IDS_LINK_ACTIONS);
    HACCEL hAccel = LoadAccelerators(hInstance,
                                     MAKEINTRESOURCE(IDR_LINK_ACCELERATOR));
    int numOps = NumElements( s_link_actions );
    ActionTable* pTab;
    pTab = new ActionTable( link_actions, link_actions_context, name, hAccel, numOps,
                             s_link_actions, hInstance);
    GetCOREInterface()->GetActionManager()->RegisterActionContext( link_actions_context, name.data());

    return pTab;
}

BOOL LinkActionCB::ExecuteAction( int id )
{ FUNC_ENTER("LinkActionCB::ExecuteAction"); 
	switch( id )
	{
	case ID_SELECT_CHILDREN:
		GetLinkMan()->SetSelectChildren( !GetLinkMan()->GetSelectChildren());
		LinkUI::SetSelectChildren( GetLinkMan()->GetSelectChildren());
		m_LinkUI->Refresh();
		gInterface->ForceCompleteRedraw();
		break;
	case ID_SELECT_PARENTS:
		GetLinkMan()->SetSelectParents( !GetLinkMan()->GetSelectParents());
		LinkUI::SetSelectParents( GetLinkMan()->GetSelectParents());
		m_LinkUI->Refresh();
		gInterface->ForceCompleteRedraw();
		break;	
	case ID_SELECT_GRAPH:
		{
			bool select_children_on, select_parents_on;
			
			select_children_on = GetLinkMan()->GetSelectChildren();
			select_parents_on  = GetLinkMan()->GetSelectParents();

			{
				GetLinkMan()->SetSelectChildren( TRUE );
				GetLinkMan()->SetSelectParents( TRUE );

				//ct->iSelectChildren->SetCheck( TRUE );
				//ct->iSelectParents->SetCheck( TRUE );
			}

			m_LinkUI->Refresh();
			gInterface->ForceCompleteRedraw();

			// Restore the original mode
			GetLinkMan()->SetSelectChildren( select_children_on );
			GetLinkMan()->SetSelectParents( select_parents_on );
			m_LinkUI->Refresh();
		}
		break;
	case ID_OPEN_CHAIN_LINK:
		GetLinkMan()->ChainLink( false );
		break;
	case ID_MANY_TO_ONE_LINK:
		GetLinkMan()->ManyToOneLink();
		break;
	case ID_ONE_TO_MANY_LINK:
		GetLinkMan()->OneToManyLink();
		break;
	case ID_REV_OPEN_CHAIN_LINK:
		GetLinkMan()->ReverseChainLink( false );
		break;
	case ID_UNLINK:
		GetLinkMan()->Unlink();
		break;
	case ID_CLOSED_CHAIN_LINK:
		GetLinkMan()->ChainLink( true );
		break;
	}

	return TRUE;
}

static void MakeTri( Face *f, int a,  int b , int c )
{ FUNC_ENTER("MakeTri"); 
	f[0].setVerts( a, b, c);
	//f[0].setSmGroup(sg);
	f[0].setEdgeVisFlags(1,1,1);
}

void LinkObject::BuildMesh( void )
{ FUNC_ENTER("LinkObject::BuildMesh"); 
	int nverts = 5;
	int nfaces = 4;
	mesh.setNumVerts(nverts);
	mesh.setNumFaces(nfaces);
	float len = (float)5.0;
	float w = (float)8.0;
	float d = w*(float).8;
	float e = d*(float).5;
	float f = d*(float).8;
	float l = w*(float).8;

	mesh.setVert( 0, Point3( -3, -3, -3 ));
	mesh.setVert( 1, Point3( -3, 3, -3 ));
	mesh.setVert( 2, Point3( 3, 3, -3 ));
	mesh.setVert( 3, Point3( 3, -3, -3 ));
	mesh.setVert( 4, Point3( 0, 0, 8 ));
	//MakeTri(&(mesh.faces[ 0]), 0,1,2 );
	//MakeTri(&(mesh.faces[ 1]), 1,2,3 );
	MakeTri(&(mesh.faces[ 0]), 3,4,2 );
	MakeTri(&(mesh.faces[ 1]), 2,4,1 );
	MakeTri(&(mesh.faces[ 2]), 1,4,0 );
	MakeTri(&(mesh.faces[ 3]), 0,4,3 );
	
	// whoops- rotate 180 about x to get it facing the right way
	/*Matrix3 mat;
	mat.IdentityMatrix();
	mat.RotateX(DegToRad(180.0));
	for (int i=0; i<nverts; i++)
		mesh.getVert(i) = mat*mesh.getVert(i);*/
	mesh.buildNormals();
	mesh.EnableEdgeList(1);
	//meshBuilt = 1;
}

class MyDepEnumProc : public DependentEnumProc 
{
	INode** node;
	Object* obj;
 public:
	MyDepEnumProc(INode** n, Object* o) :
		node(n), obj(o) {}

	int proc(ReferenceMaker *rmaker);
};

int MyDepEnumProc::proc(ReferenceMaker *rmaker) 
{ FUNC_ENTER("MyDepEnumProc::proc"); 
	if(rmaker->SuperClassID()==BASENODE_CLASS_ID)
		if( ((INode*)rmaker)->GetObjectRef() == obj)
			*node = (INode*)rmaker;

	return 0; // return a zero to continue the enumeration	
}

// 
// this finds the scene node associated with a given object.. if one
// actually exisits.
//
INode* GetObjectNode(Object* obj)
{ FUNC_ENTER("GetObjectNode"); 
	ULONG handle;	

	obj->NotifyDependents(FOREVER, (PartID)&handle, REFMSG_GET_NODE_HANDLE);
	
	return gInterface->GetINodeByHandle( handle );
}

void LinkObject::SelUpdate(INode* node)
{ FUNC_ENTER("LinkObject::SelUpdate"); 
	// REFMSG_LINK_SELECTED:

	// After cloning, for example, a new link object is created but it doesn't have a link_node
	// yet. So this will patch it up
	if( link_node == NULL )
	{
		link_node = GetObjectNode( this );
	}

	if( node->Selected())
	{
		node->NotifyDependents( FOREVER, 0, REFMSG_SELECT_REFERRING_LINKS );
	}
#ifdef DESELECT_LINK_NODES
	else
	{
		node->NotifyDependents( FOREVER, PART_ALL, REFMSG_DESELECT_REFERRING_LINKS );
	}
#endif
	if(	from_node->Selected())
	{
		if( link_dlg )
		{
			link_dlg->SwatchSetColor( m_Color );
		}
	}
	if( node->Selected())
	{			
		if( GetLinkMan()->GetSelectChildren())
		{
			if( from_node && from_node->Selected())
			{
				if( to_node )
				{
					//gInterface->SelectNode( to_node, 0 );
				}
			}				
		}

		if( GetLinkMan()->GetSelectParents())
		{
			if( to_node && to_node->Selected())
			{
				if( from_node )
				{
					//gInterface->SelectNode( from_node, 0 );
				}
			}				
		}
	}
	
	if( !( GetLinkMan()->GetSelectChildren() || GetLinkMan()->GetSelectParents()))
	{
		if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
		{			
			GetLinkMan()->IncrementSystemSelectOpID();

			if( node )
			{
				if( node->Selected())
				{
					node->NotifyDependents( FOREVER, PART_ALL, REFMSG_SELECT_SURROUNDING_NODES );
				}
				else
				{
					node->NotifyDependents( FOREVER, PART_ALL, REFMSG_DESELECT_SURROUNDING_NODES );
				}
			}
			return /*REF_FAIL*/;
		}
	}
}

RefResult LinkObject::NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, 
										PartID& partID,RefMessage message )
{ FUNC_ENTER("LinkObject::NotifyRefChanged"); 

	switch( message )
	{
		/*
		case REFMSG_SELECT_REFERRING_LINKS:
		{
			if( to_node->Selected() && from_node->Selected())
			{
				if( link_node && link_node->Selected() == false )
				{
					gInterface->SelectNode( link_node, 0 );
				}				
			}
			break;
		}

		case REFMSG_DESELECT_REFERRING_LINKS:
		{
			if( !to_node->Selected() || !from_node->Selected())
			{
				if( link_node && link_node->Selected())
				{
					gInterface->DeSelectNode( link_node );
				}
			}
			break;
		}
		// This is an internally used message and shouldn't be used in a plugin
		// As a result, we were getting selection change messages that didn't coincide
		// with the selection change events, causing a lot of extra redraw.  (aml)
		//case REFMSG_TARGET_SELECTIONCHANGE:	
*/
		case REFMSG_LINK_SELECTED:
		{
			INode *node = (INode *) hTarget;

			// aml new
			if (GetLinkMan()->GetSelectChildren() &&
				link_node &&
				(from_node==0 || from_node==node))
				gInterface->SelectNode( link_node, 0 );

			if (GetLinkMan()->GetSelectParents() &&
				link_node)
				gInterface->SelectNode( link_node, 0 );

			
			//if (GetLinkMan()->GetSelectParents() &&
			//	link_node &&
			//	(to_node==0 || to_node==node))
			//	gInterface->SelectNode( link_node, 0 );

			// After cloning, for example, a new link object is created but it doesn't have a link_node
			// yet. So this will patch it up
			if( link_node == NULL )
			{
				link_node = GetObjectNode( this );
			}

			if( node->Selected())
			{
				node->NotifyDependents( FOREVER, 0, REFMSG_SELECT_REFERRING_LINKS );
			}
		#ifdef DESELECT_LINK_NODES
			else
			{
				node->NotifyDependents( FOREVER, PART_ALL, REFMSG_DESELECT_REFERRING_LINKS );
			}
		#endif
			if(	from_node && from_node->Selected())
			{
				if( link_dlg )
				{
					link_dlg->SwatchSetColor( m_Color );	
				}
			}
			if( node && node->Selected())
			{			
				if( GetLinkMan()->GetSelectChildren())
				{
					if( from_node && from_node->Selected())
					{
						if( to_node )
						{
							gInterface->SelectNode( to_node, 0 );
							
							// Self propagate the message since we no longer have the benefit
							// of max sending a REFMSG_TARGET_SELECTIONCHANGE to every node
							to_node->NotifyDependents( FOREVER, PART_ALL, REFMSG_SELECT_CHILDREN);
						}
					}				
				}

				if( GetLinkMan()->GetSelectParents())
				{
					if( to_node && to_node->Selected())
					{
						if( from_node )
						{
							gInterface->SelectNode( from_node, 0 );

							// Self propagate the message since we no longer have the benefit
							// of max sending a REFMSG_TARGET_SELECTIONCHANGE to every node
							from_node->NotifyDependents( FOREVER, PART_ALL, REFMSG_SELECT_PARENTS);
						}
					}				
				}
			}
			
			if( !( GetLinkMan()->GetSelectChildren() || GetLinkMan()->GetSelectParents()))
			{
				if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
				{			
					GetLinkMan()->IncrementSystemSelectOpID();

					if( node )
					{
						if( node->Selected())
						{
							node->NotifyDependents( FOREVER, PART_ALL, REFMSG_SELECT_SURROUNDING_NODES );
						}
						else
						{
							node->NotifyDependents( FOREVER, PART_ALL, REFMSG_DESELECT_SURROUNDING_NODES );
						}
					}
					return REF_FAIL;
				}
			}
			break;
		}

		case REFMSG_SELECT_CHILDREN:
		{
			if (to_node && !to_node->Selected())
			{
				gInterface->SelectNode(to_node,0);
				gInterface->SelectNode(link_node,0);
				to_node->NotifyDependents( FOREVER, PART_ALL, REFMSG_SELECT_CHILDREN);
			}
			break;
		}

		case REFMSG_SELECT_PARENTS:
		{
			if (from_node && !from_node->Selected())
			{
				gInterface->SelectNode(from_node,0);
				gInterface->SelectNode(link_node,0);
				from_node->NotifyDependents( FOREVER, PART_ALL, REFMSG_SELECT_PARENTS);
			}
			break;
		}

		case REFMSG_SELECT_SURROUNDING_NODES:
		{
			INode *node = (INode *) hTarget;

			if( sel_op_id == GetLinkMan()->GetSystemSelectID())
			{
				break;
			}
			sel_op_id = GetLinkMan()->GetSystemSelectID();
			IncRef();
			if( node == to_node )
			{
				from_node->NotifyDependents( FOREVER, PART_ALL, REFMSG_SELECT_SURROUNDING_NODES );
			}
			else if( node == from_node )
			{
				to_node->NotifyDependents( FOREVER, PART_ALL, REFMSG_SELECT_SURROUNDING_NODES );
			}
			NotifyDependents( FOREVER, PART_ALL, REFMSG_CHANGE );			
			break;
		}

		case REFMSG_DESELECT_SURROUNDING_NODES:
		{
			INode *node = (INode *) hTarget;
			
			if( sel_op_id == GetLinkMan()->GetSystemSelectID())
			{
				break;
			}
			
			sel_op_id = GetLinkMan()->GetSystemSelectID();
			DecRef();
			if( node == to_node )
			{
				from_node->NotifyDependents( FOREVER, PART_ALL, REFMSG_DESELECT_SURROUNDING_NODES );
			}
			else if( node == from_node )
			{
				to_node->NotifyDependents( FOREVER, PART_ALL, REFMSG_DESELECT_SURROUNDING_NODES );
			}

			NotifyDependents( FOREVER, PART_ALL, REFMSG_CHANGE );			
			break;
		}

		case REFMSG_TARGET_DELETED: 
		{
			INode *node = (INode *) hTarget;

			if( link_node )
			{
				// If we're merging and it's writing over the old object
				// set its node pointers to NULL to signify that we need to
				// reattach these particular links
				if( GetLinkMan()->IsMerging())
				{					
					to_node = NULL;
					from_node = NULL;
				}
				else
				{
					// I used to delete the node here if either of its refereces was deleted.
					// But now, since links are selected when both references are selected,
					// and since by this point you can't tell if both references were selected,
					// I don't delete the link since it could be part of the selection and will
					// also be deleted by the system.  So, I've decided not to delete the node, but instead
					// to just delete references from the node and remove dead nodes on post open. - SG
					if( to_node == node )
					{
						to_node = NULL;
						DeleteReference( REF_ID_FROM );
					}
					else if( from_node == node )
					{					
						from_node = NULL;
						DeleteReference( REF_ID_TO );
					}
					
					//if( link_node->Selected() == false )
					//{
					//	link_node->SetTMController( NULL );
					//	gInterface->DeleteNode( link_node );
					//	link_node = NULL;
					//}
				}
			}
			break;
		}

	}

	return REF_SUCCEED;
}

void LinkObject::RefAdded(RefMakerHandle rm)
{ FUNC_ENTER("LinkObject::RefAdded"); 
	if (rm->ClassID()==Class_ID(BASENODE_CLASS_ID,0) && cloneRefCount > 0)
	{
		INode* node = (INode*)rm;

		// Ensure that the node contains a link object before selecting it
		Object* obj = node->EvalWorldState(0).obj;

		if (obj->ClassID() == vLINK_OBJ_CLASS_ID)
		{
			char buf[256];
			sprintf(buf, "LinkObject Selected: %s\n", (char*)node->GetName());
			OutputDebugString(buf);

			gInterface->SelectNode(node, FALSE);
			cloneRefCount--;
		}
	}
}

RefTargetHandle LinkObject::Clone( RemapDir &remap )
{ FUNC_ENTER("LinkObject::Clone"); 
	LinkObject* trig = new LinkObject;
	INode* clone;
	
	if( to_node )
	{
		clone = (INode*) remap.FindMapping( to_node );
		if( clone == NULL )
		{
			clone = (INode*) remap.CloneRef( to_node );
		}
		if( clone )
		{
			trig->ReplaceReference( REF_ID_TO, clone );
			CStr name = clone->GetName();
		}
	}

	if( from_node )
	{
		clone = (INode*) remap.FindMapping( from_node );
		if( clone == NULL )
		{
			clone = (INode*) remap.CloneRef( from_node );
		}
		if( clone )
		{
			trig->ReplaceReference( REF_ID_FROM, clone );
			CStr name = clone->GetName();
		}		
	}

	if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
	{	
		GetLinkMan()->RecalculateReferences();
	}

	trig->cloneRefCount++;
	return trig;	
}

int MyHitTest( TimeValue t, INode* inode, ViewExp *vpt ) 
{ FUNC_ENTER("MyHitTest"); 
	int savedLimits, res = FALSE;
	RECT rect;
	GraphicsWindow *gw = vpt->getGW();
	Matrix3 ntm = inode->GetNodeTM(t);
	HitRegion hr;
	//gw->getUpdateRect( &rect );
	
	rect.top = 0;
	rect.left = 0;
	rect.right = gw->getWinSizeX();
	rect.bottom = gw->getWinSizeY();

	MakeHitRegion( hr, RECT_RGN, 0, 4, (IPoint2 *) &rect );
	gw->setHitRegion( &hr );
	gw->setRndLimits(((savedLimits =
		gw->getRndLimits()) | GW_PICK) & ~GW_ILLUM);
	gw->clearHitCode();

	gw->setTransform(Matrix3(inode->GetObjectTM(t)));
	Point3 v[3];
	
	v[0] = v[1] = Point3( 0, 0, 0 );
	gw->polyline( 2, v, NULL, NULL, TRUE, NULL );
	if (gw->checkHitCode()) 
	{
		res = TRUE;
		vpt->CtrlLogHit( inode, gw->getHitDistance(), 0, 0 );		
	}
	
	gw->clearHitCode();	
	gw->setRndLimits(savedLimits);
	return res;
}

int LinkObject::Display( TimeValue t, INode* inode, ViewExp *vpt, int flags )
{ FUNC_ENTER("LinkObject::Display"); 	
	bool from_visible, to_visible;

	display_counter = GetLinkMan()->GetSystemSelectID();
	//GetLinkMan()->IncrementSystemSelectOpID();
	if( from_node && to_node)
	{		
		if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_OFF )
		{
			return 0;
		}
		if( from_node->IsHidden() || to_node->IsHidden())
		{
			return 0;
		}
		if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SELECTED )
		{
			if(( from_node->Selected() == FALSE ) && ( to_node->Selected() == FALSE ))
			{
				return 0;
			}			
		}
		if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
		{
			if( ref_count <= 0 )
			{
				return 0;
			}
		}		

		GraphicsWindow *gw = vpt->getGW();
		Point3 arrow_origin, from, to, direction;
		float length;
		
		DWORD rlim = gw->getRndLimits();
		//gw->setRndLimits(GW_WIREFRAME);		
		gw->setRndLimits(GW_FLAT | GW_BACKCULL);		

		from_visible = (BOOL)MyHitTest( t, from_node, vpt ) == TRUE;
		to_visible = (BOOL)MyHitTest( t, to_node, vpt ) == TRUE;
		
		from = from_node->GetObjectTM(t).GetTrans();
		to = to_node->GetObjectTM(t).GetTrans();
				
		direction = from - to;
		length = direction.Length();
		direction = direction.Normalize();
		
		if( from_visible && to_visible )
		{
			arrow_origin = to + ( direction * ( length / 3 ));
			DrawLink(	t, 
						from,
						to,
						vpt, 
						true, 
						arrow_origin, 
						( (BOOL)from_node->Selected() == TRUE ));
		}
		else if( from_visible )
		{
			
#ifdef NO_SCALE
			float scaleFactor = vpt->NonScalingObjectSize()*vpt->GetVPWorldWidth( from ) / 360.0f;
			arrow_origin = from - ( direction * ( 40 * scaleFactor ));
#else
			arrow_origin = from - ( direction * 40 );
#endif
			
			DrawLink(	t, 
						from,
						to,
						vpt, 
						true, 
						arrow_origin,
						( (BOOL)from_node->Selected() == TRUE ));
		}
		else if( to_visible )
		{			
#ifdef NO_SCALE
			float scaleFactor = vpt->NonScalingObjectSize()*vpt->GetVPWorldWidth( to ) / 360.0f;
			arrow_origin = to + ( direction * ( 20 * scaleFactor ));
#else
			arrow_origin = to + ( direction * 20 );
#endif
			DrawLink(	t, 
						from,
						to,
						vpt, 
						true, 
						arrow_origin,
						( (BOOL)from_node->Selected() == TRUE ));
		}
		else
		{
			DrawLink(	t, 
						from_node->GetObjectTM(t).GetTrans(),	
						to_node->GetObjectTM(t).GetTrans(),
						vpt, 
						false, 
						arrow_origin,
						( (BOOL)from_node->Selected() == TRUE ));

		}		
		
		gw->setRndLimits(rlim);
	}
	return 0;
}

int LinkObject::DrawLink(TimeValue t, Point3& from, Point3& to, ViewExp *vpt,
							bool draw_arrow, Point3& arrow_origin, bool from_selected ) 
{ FUNC_ENTER("LinkObject::DrawLink"); 
//	Matrix3 tm = inodefrom->GetObjectTM(t);
	GraphicsWindow *gw;

	gw = vpt->getGW();
	gw->setTransform(Matrix3(TRUE));
	
	Point3 pt,v[3];

	v[0]=from;
	v[1]=to;

	float length;
	Point3 direction, up, normal, normal2;

	direction = from - to;
	length = direction.Length();
	direction = direction.Normalize();
	up = Point3(0, 0, 1);

	normal = direction ^ up;
	normal = normal.Normalize();
	normal2 = direction ^ normal;

	int es[5];
	es[0]=es[1]=es[2]=es[3]=GW_EDGE_VIS;

	if( from_selected )
	{
		gw->setColor( LINE_COLOR, Color( 255, 0, 0 ));
	}
	else
	{
		gw->setColor( LINE_COLOR, m_Color );
	}

	gw->polyline( 2, v, NULL, NULL, FALSE, es );

	if( draw_arrow )
	{
		Point3 arrow[5];	
		Matrix3 tm( 1 );
		
#ifdef NO_SCALE
		tm.NoScale();
#endif
		tm.SetFromToUp( to, from, Point3( 0, 0, -1 ));
		tm.SetTrans( arrow_origin );
	
#ifdef NO_SCALE
		float scaleFactor = vpt->NonScalingObjectSize()*vpt->GetVPWorldWidth( tm.GetTrans()) / 360.0f;
		if( scaleFactor != 1.0f )
		{
			tm.Scale( Point3( scaleFactor, scaleFactor, scaleFactor ));
		}
#endif
		gw->setTransform( tm );		
		mesh.render( gw, gw->getMaterial(), NULL, COMP_ALL);
	}
	
	return 0;
}														

void	LinkObject::IncRef( void )
{ FUNC_ENTER("LinkObject::IncRef"); 
	ref_count++;
}

void	LinkObject::DecRef( void )
{ FUNC_ENTER("LinkObject::DecRef"); 
	ref_count--;
	assert( ref_count >= 0 );
}

void LinkObject::GetWorldBoundBox(TimeValue t, INode *inode, ViewExp* vpt, Box3& box )
{ FUNC_ENTER("LinkObject::GetWorldBoundBox"); 
	/*
	Matrix3 mat = inode->GetObjectTM(t);
	//BuildMesh();
	box = mesh.getBoundingBox();		
	box = box * mat;*/

	CStr name = inode->GetName();

	if(( to_node == NULL ) || ( from_node == NULL ) || ( link_node == NULL ))
	{
		return;
	}

	Matrix3 mat;

	box.Init();
	mat = to_node->GetNodeTM(0);
	box += mat.GetTrans();

	mat = from_node->GetNodeTM(0);
	box += mat.GetTrans();	

	return;

}

void LinkObject::GetLocalBoundBox(TimeValue t, INode *inode,ViewExp* vpt,  Box3& box ) 
{ FUNC_ENTER("LinkObject::GetLocalBoundBox"); 
	box.pmin = Point3(0.0f, 0.0f, 0.0f);
	box.pmax = Point3(0.0f, 0.0f, 0.0f);
	return;
	BuildMesh();
	box = mesh.getBoundingBox();
	//box.pmin = box.pmax;
}