/*
	InterLinkCodes.h
	This file lists common notification codes and structures
	that should be shared and used during communication protocol
	with the MAX Plugin and external Level Editor
*/

#ifndef __INTERLINKCODES__
#define __INTERLINKCODES__

#define NOTIFYDATA_NUMNODES		1
#define NOTIFYDATA_NEWGEOM		2
#define NOTIFYDATA_NEWGEOMBUILD 3

#define NOTIFYDATA_NEWOBJ		4
#define NOTIFYDATA_NEWMTL		5

///  SYSTEM STARTUP/SHUTDOWN MESSAGES
#define WM_IML_ATTACH           WM_USER + 1	// Sent to MAX to inform that the Level Editor has started
											// and located the plugin
											//
											// wParam = unused   lParam = HWND of Level Editor

#define WM_IML_ATTACH_ACK	    WM_USER + 2	// Sent by MAX to inform that the Level Editor has been registered
											// with the system
											//
											// No Params

#define WM_IML_DETACH		    WM_USER + 3	// Sent by LevEdit when the level editor is shutting down and comm
											// services with it should be terminated
											//
											// No Params

#define WM_IML_DETACH_ACK	    WM_USER + 4	// Sent by MAX to inform that the Level Editor has been disconnected
											// and may properly shutdown
											//
											// No Params

#define WM_IML_MAX_SHUTDOWN	    WM_USER + 5	// Sent by MAX to inform that MAX is shuting down
											//
											// No Params

#define WM_IML_MAX_SHUTDOWN_ACK WM_USER + 6	// Sent by LevEdit to inform that the plugin has been disconnected
											// and may safely shutdown
											//
											// No Params

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/// COMM MESSAGES
#define WM_IML_MTLEXISTS		WM_USER + 7	// Sent to check if a material currently exists in the active
											// material database.
											//	
											// wParam = material CRC
											// Returns: TRUE/FALSE

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
