/*
	GLRenderer.h
	A Quick OpenGL renderer for displaying scene previews
	(or Lightmapped geometry for now)
*/

#ifndef __GLRENDERER__
#define __GLRENDERER__

#include "max.h"
#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include <gl/glext.h>

class ImageData;

class GLRenderer
{
	HWND  hwnd;
	HDC   hdc;
	RECT  rect;
	HGLRC hglrc;
	void  (*fpUpdate)(GLRenderer*,void*);
	void* pUpdateData;
	bool  bMultiTextureSupport;

	int   lastTexID;

	static LRESULT CALLBACK GLWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

public:
	GLRenderer();
	~GLRenderer();

	HWND InitWindow();						// Use this function to initialize if rendering to a visible window
	void ShowWindow();
	HDC  InitContext(HDC context = NULL);	// Use this function to initialize if rendering to a non-visible device context

	void SetCallback(void (*fp)(GLRenderer*,void*), void* pData);
	void DrawModel(Mesh*  mesh,
		           Point3 pos);

	int  UploadTexture(ImageData* img);

	inline bool SupportsMultiTexture() { return bMultiTextureSupport; }

	void Update();
	void MakeCurrent();
	void EndCurrent();

	PFNGLACTIVETEXTUREARBPROC   glActiveTextureARB;
	PFNGLMULTITEXCOORD2FARBPROC glMultiTexCoord2fARB;
};

#endif
