#ifndef __EXPORT_TEXTUREEXPORTER_H__
#define __EXPORT_TEXTUREEXPORTER_H__

#include <next.h>
#include "../../genlib/virtualfile.h"

class NxTexture;

class ITextureExporter
{
public:
	virtual	void	Reset( void ) = 0;
	virtual	bool	AddTexture( Texmap* map, int flags, unsigned long checksum_array[vNUM_PLATFORMS],
									bool allow_mips = true ) = 0;
	virtual bool	LoadTextureData( void ) = 0;
	
	virtual bool	SaveTextureDictionary( char* dict_path, 
		                                   char* usg_path,
										   IoUtils::CVirtualOutputFile* udef_file     = NULL, 
										   IoUtils::CVirtualOutputFile* udef_usg_file = NULL) = 0;

	virtual bool    VerifyTexturePaths( char* path ) = 0;
	virtual NxTexture*	GetTextureByChecksum( unsigned long checksum ) = 0;		

	bool			m_WarnedAboutDupeMaterials;
	CStr            m_LastWarnedMatName;

	virtual	void	OnPostOpen( void ) = 0;
	virtual void    MarkAsDirty( void ) = 0;
	virtual void    ResetInitialExport( void ) = 0;
};

ITextureExporter* GetTextureExporter( void );

#endif // __EXPORT_TEXTUREEXPORTER_H__