/*
	QNEditor.h
	Cutscene QN display dialog
	6-10-03  aml
*/

#ifndef __QNEDITOR__
#define __QNEDITOR__

#include "../misc/llist.h"
#include "../UI/ModalDlg.h"
#include "max.h"

class RTFEditor;
class CutsceneExportDlg;

class QNEditor: public ModalDlgWindow
{
	RTFEditor*         pRTFEditor;
	LinkList<INode*>*  pNodeList;
	CutsceneExportDlg* pCutsceneDlg;

	BOOL DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void InitNodeList();
	void InitQNList();
	void AddNodes();
	void RemoveNodes();
	void UpdateQNView();

public:
	QNEditor(HINSTANCE hInstance, HWND hwndParent, CutsceneExportDlg* pCutsceneDlg);
	~QNEditor();

	void AddNodes(INodeTab& nodeList);
};

#endif
