#include "FuncEnter.h"

/*
	PartialAnimEditor.cpp
	Partial Animation Editor
	6-25-03
*/

#include "PartialAnimEditor.h"
#include "Resource.h"
#include "../UI/InputDlg.h"

extern Interface* gInterface;

class BoneAddCallback: public HitByNameDlgCallback
{
	PartialAnimEditor  *pPartialAnimEditor;			// Pointer to MAX interface class

public:
	BoneAddCallback(PartialAnimEditor* pPartialAnimEditor) { FUNC_ENTER("BoneAddCallback::BoneAddCallback");  this->pPartialAnimEditor = pPartialAnimEditor; }

	TCHAR *dialogTitle()	{ FUNC_ENTER("BoneAddCallback::dialogTitle");  return _T("Select bones that should be exported"); }
	TCHAR *buttonText() 	{ FUNC_ENTER("BoneAddCallback::buttonText");  return _T("Add"); }
	BOOL singleSelect()		{ FUNC_ENTER("BoneAddCallback::singleSelect");  return FALSE; }
	BOOL useFilter()		{ FUNC_ENTER("BoneAddCallback::useFilter");  return TRUE; }
	int filter(INode *node)	{ FUNC_ENTER("BoneAddCallback::filter");  return TRUE; }
	BOOL useProc()			{ FUNC_ENTER("BoneAddCallback::useProc");  return TRUE; }
	void proc(INodeTab &nodeTab);
	BOOL doCustomHilite()	{ FUNC_ENTER("BoneAddCallback::doCustomHilite");  return FALSE; }
	BOOL doHilite(INode *node)	{ FUNC_ENTER("BoneAddCallback::doHilite");  return FALSE; }
	BOOL showHiddenAndFrozen()	{ FUNC_ENTER("BoneAddCallback::showHiddenAndFrozen");  return FALSE; }
};

void BoneAddCallback::proc(INodeTab &nodeTab)
{ FUNC_ENTER("BoneAddCallback::proc"); 
	assert(pPartialAnimEditor);

	int iSel = SendDlgItemMessage(pPartialAnimEditor->hWnd(), IDC_SETLIST, LB_GETCURSEL, 0, 0);
	Link<PartialAnimSet>* link;

	if (iSel == -1)
		return;
	else
		link = (Link<PartialAnimSet>*)SendDlgItemMessage(pPartialAnimEditor->hWnd(), IDC_SETLIST, LB_GETITEMDATA, (WPARAM)iSel, 0);

	for(int i = 0; i < nodeTab.Count(); i++)
	{
		CStr name = nodeTab[i]->GetName();
		Link<CStr>* linkBone = link->data.bones.Add(&name);
		iSel = SendDlgItemMessage(pPartialAnimEditor->hWnd(), IDC_BONELIST, LB_ADDSTRING, 0, (LPARAM)(char*)name);

		SendDlgItemMessage(pPartialAnimEditor->hWnd(), IDC_BONELIST, LB_SETITEMDATA, (WPARAM)iSel, (LPARAM)linkBone);
	}
}

PartialAnimEditor::PartialAnimEditor(HINSTANCE hInstance, HWND hwndParent) :
	ModalDlgWindow(hInstance, MAKEINTRESOURCE(IDD_PARTIALANIMEDITOR), hwndParent)
{ FUNC_ENTER("PartialAnimEditor::PartialAnimEditor"); 

}

PartialAnimEditor::~PartialAnimEditor()
{ FUNC_ENTER("PartialAnimEditor::~PartialAnimEditor"); 

}

BOOL PartialAnimEditor::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{ FUNC_ENTER("PartialAnimEditor::DlgProc"); 
	switch(msg)
	{
	case WM_INITDIALOG:
		LoadAnimSets();
		return TRUE;

	case WM_CLOSE:
		EndDialog(hwnd, 0);
		return TRUE;

	case WM_COMMAND:

		switch(LOWORD(wParam))
		{
		case IDC_ADDBONE:
			AddBone();
			return TRUE;

		case IDC_REMOVEBONE:
			RemoveBone();
			return TRUE;

		case IDC_ADDSET:
			AddSet();
			return TRUE;

		case IDC_REMOVESET:
			RemoveSet();
			return TRUE;

		case IDC_OK:
			EndDialog(hwnd, 0);
			SaveAnimSets();
			return TRUE;

		case IDC_CANCEL:
			EndDialog(hwnd, 0);
			return TRUE;

		case IDC_SETLIST:
			switch(HIWORD(wParam))
			{
			case LBN_SELCHANGE:
				PopulateAnimBoneList();
				return TRUE;

			case LBN_DBLCLK:
				RenameSet();				
				return TRUE;
			}
		}
	};

	return FALSE;
}

void PartialAnimEditor::AddBone()
{ FUNC_ENTER("PartialAnimEditor::AddBone"); 
	// Bring up node selection dialog and add selected items to the list
	BoneAddCallback pBoneAddCallback(this);
	gInterface->DoHitByNameDialog(&pBoneAddCallback);
}

void PartialAnimEditor::RemoveBone()
{ FUNC_ENTER("PartialAnimEditor::RemoveBone"); 
	int item;
	Link<CStr>* linkBone;

	// Determine the partial anim set that the bones belong to
	int iSel = SendDlgItemMessage(hwnd, IDC_SETLIST, LB_GETCURSEL, 0, 0);

	if (iSel == -1)
		return;

	Link<PartialAnimSet>* linkAnimSet = (Link<PartialAnimSet>*)SendDlgItemMessage(hwnd, IDC_SETLIST, LB_GETITEMDATA, (WPARAM)iSel, 0);
	assert(linkAnimSet);

	// Remove all the bones in the bone list that are currently selected
	while (SendDlgItemMessage(hwnd, IDC_BONELIST, LB_GETSELCOUNT, 0, 0) > 0)
	{
		SendDlgItemMessage(hwnd, IDC_BONELIST, LB_GETSELITEMS, (WPARAM)1, (LPARAM)&item);
		linkBone = (Link<CStr>*)SendDlgItemMessage(hwnd, IDC_BONELIST, LB_GETITEMDATA, (WPARAM)item, 0);
		linkAnimSet->data.bones.Remove(linkBone);

		SendDlgItemMessage(hwnd, IDC_BONELIST, LB_DELETESTRING, (WPARAM)item, 0);
	}
}

void PartialAnimEditor::AddSet()
{ FUNC_ENTER("PartialAnimEditor::AddSet"); 
	InputDlg inputDlg(hInstance, hwnd, "Name", "", "Enter name for PartialAnim Set");
	inputDlg.Show();

	if (inputDlg.WasCancelled())
		return;

	PartialAnimSet newSet;
	newSet.name = inputDlg.GetInput();
	
	// Change any spaces in the name to underscores
	for(int i = 0; i < newSet.name.Length(); i++)
		if (newSet.name[i] == ' ')
			newSet.name[i] = '_';

	Link<PartialAnimSet>* link = db.Add(&newSet);

	int iItem = SendDlgItemMessage(hwnd, IDC_SETLIST, LB_ADDSTRING, 0, (WPARAM)(char*)newSet.name);
	SendDlgItemMessage(hwnd, IDC_SETLIST, LB_SETITEMDATA, (WPARAM)iItem, (LPARAM)link);

	SendDlgItemMessage(hwnd, IDC_BONELIST, LB_RESETCONTENT, 0, 0);
	SendDlgItemMessage(hwnd, IDC_SETLIST, LB_SETCURSEL, (WPARAM)-1, 0);
}

void PartialAnimEditor::RemoveSet()
{ FUNC_ENTER("PartialAnimEditor::RemoveSet"); 
	int iSel = SendDlgItemMessage(hwnd, IDC_SETLIST, LB_GETCURSEL, 0, 0);
	
	if (iSel != -1)
	{
		Link<PartialAnimSet>* link = (Link<PartialAnimSet>*)
			SendDlgItemMessage(hwnd, IDC_SETLIST, LB_GETITEMDATA, (WPARAM)iSel, 0);

		db.Remove(link);

		SendDlgItemMessage(hwnd, IDC_SETLIST, LB_DELETESTRING, (WPARAM)iSel, 0);
	}

	SendDlgItemMessage(hwnd, IDC_BONELIST, LB_RESETCONTENT, 0, 0);
}

bool PartialAnimEditor::LoadAnimSets()
{ FUNC_ENTER("PartialAnimEditor::LoadAnimSets"); 
	CStr appDir = gInterface->GetDir(APP_PLUGCFG_DIR);

	FILE* fp = fopen(appDir + "\\PartialAnims.ini", "r");
	
	if (!fp)
		return false;

	db.Clear();

	// Abort on zero length files
	fseek(fp, 0, SEEK_END);
	long offset = ftell(fp);
	fseek(fp, 0, SEEK_SET);

	if (offset == 0)
	{
		fclose(fp);
		PopulateAnimSetList();
		return true;
	}

	char name[256];
	int  nItems = 0;

	while(!feof(fp))
	{
		fscanf(fp, "%s\n", name);
		fscanf(fp, "%i\n", &nItems);

		PartialAnimSet partialAnimSet;
		partialAnimSet.name = name;

		for(int i = 0; i < nItems; i++)
		{
			CStr itemName;
			fscanf(fp, "%s\n", name);
			itemName = name;

			partialAnimSet.bones.Add(&itemName);
		}

		db.Add(&partialAnimSet);
	}

	fclose(fp);
	PopulateAnimSetList();

	return true;
}

bool PartialAnimEditor::SaveAnimSets()
{ FUNC_ENTER("PartialAnimEditor::SaveAnimSets"); 
	CStr appDir = gInterface->GetDir(APP_PLUGCFG_DIR);

	FILE* fp = fopen(appDir + "\\PartialAnims.ini", "w");

	if (!fp)
		return false;

	Link<PartialAnimSet>* linkSet = db.GetHead();

	while(linkSet)
	{
		fprintf(fp, "%s\n%i\n", (char*)linkSet->data.name, linkSet->data.bones.GetSize());

		Link<CStr>* linkBone = linkSet->data.bones.GetHead();

		while(linkBone)
		{
			fprintf(fp, "%s\n", (char*)linkBone->data);
			linkBone = linkBone->next;
		}

		linkSet = linkSet->next;
	}

	fclose(fp);

	return true;
}

void PartialAnimEditor::PopulateAnimSetList()
{ FUNC_ENTER("PartialAnimEditor::PopulateAnimSetList"); 
	SendDlgItemMessage(hwnd, IDC_SETLIST, LB_RESETCONTENT, 0, 0);

	Link<PartialAnimSet>* linkSet = db.GetHead();
	int iItem;

	while(linkSet)
	{
		iItem = SendDlgItemMessage(hwnd, IDC_SETLIST, LB_ADDSTRING, 0, (LPARAM)(char*)linkSet->data.name);
		SendDlgItemMessage(hwnd, IDC_SETLIST, LB_SETITEMDATA, (WPARAM)iItem, (LPARAM)linkSet);
		linkSet = linkSet->next;
	}
}

void PartialAnimEditor::PopulateAnimBoneList()
{ FUNC_ENTER("PartialAnimEditor::PopulateAnimBoneList"); 
	SendDlgItemMessage(hwnd, IDC_BONELIST, LB_RESETCONTENT, 0, 0);

	int iSel = SendDlgItemMessage(hwnd, IDC_SETLIST, LB_GETCURSEL, 0, 0);
	Link<PartialAnimSet>* link = (Link<PartialAnimSet>*)SendDlgItemMessage(hwnd, IDC_SETLIST, LB_GETITEMDATA, (WPARAM)iSel, 0);

	Link<CStr>* linkBone = link->data.bones.GetHead();

	int iItem;

	while(linkBone)
	{
		iItem = SendDlgItemMessage(hwnd, IDC_BONELIST, LB_ADDSTRING, 0, (LPARAM)(char*)linkBone->data);
		SendDlgItemMessage(hwnd, IDC_BONELIST, LB_SETITEMDATA, (WPARAM)iItem, (LPARAM)linkBone);

		linkBone = linkBone->next;
	}
}

void PartialAnimEditor::RenameSet()
{ FUNC_ENTER("PartialAnimEditor::RenameSet"); 
	int iSel = SendDlgItemMessage(hwnd, IDC_SETLIST, LB_GETCURSEL, 0, 0);
	Link<PartialAnimSet>* link = (Link<PartialAnimSet>*)SendDlgItemMessage(hwnd, IDC_SETLIST, LB_GETITEMDATA, (WPARAM)iSel, 0);

	InputDlg inputDlg(hInstance, hwnd, "Name", link->data.name, "Enter new name for PartialAnim Set");
	inputDlg.Show();

	link->data.name = inputDlg.GetInput();

	// Update the list box to show the new name
	int iSel2 = SendDlgItemMessage(hwnd, IDC_SETLIST, LB_INSERTSTRING, (WPARAM)iSel, (LPARAM)(char*)link->data.name);
	SendDlgItemMessage(hwnd, IDC_SETLIST, LB_SETITEMDATA, (WPARAM)iSel2, (LPARAM)link);
	SendDlgItemMessage(hwnd, IDC_SETLIST, LB_DELETESTRING, (WPARAM)iSel, 0);
}

bool PartialAnimEditor::IsExportableBone(CStr partialAnimName, CStr boneName)
{ FUNC_ENTER("PartialAnimEditor::IsExportableBone"); 
	// First locate the partial anim name
	Link<PartialAnimSet>* link = db.GetHead();

	while(link)
	{
		if (link->data.name == partialAnimName)
		{
			// Check if the bone name exists as one of the exported bones in this partial set
			if (link->data.IsExportableBone(boneName))
				return true;

			return false;
		}

		link = link->next;
	}

	return false;
}

PartialAnimSet* PartialAnimEditor::GetPartialAnimSet(CStr partialAnimName)
{ FUNC_ENTER("PartialAnimEditor::GetPartialAnimSet"); 
	Link<PartialAnimSet>* link = db.GetHead();

	while(link)
	{
		if (link->data.name = partialAnimName)
			return &link->data;

		link = link->next;
	}

	return NULL;
}

bool PartialAnimSet::IsExportableBone(CStr boneName)
{ FUNC_ENTER("PartialAnimSet::IsExportableBone"); 
	// Check if the bone name exists as one of the exported bones in this partial set
	Link<CStr>* linkBone = bones.GetHead();

	while(linkBone)
	{
		if (linkBone->data == boneName)
			return true;

		linkBone = linkBone->next;
	}

	return false;
}
