#ifndef __EXPORT_MODELEXPORTOPTIONS_H__
#define __EXPORT_MODELEXPORTOPTIONS_H__

// Export options are starting to take on variable 
#include "../misc/Saveable.h"

class ModelExportOptions: public Saveable
{
public:

	enum
	{
		vVERSION_NUMBER = 0x000E,
	};

	enum
	{
		vEXPORT_ALL,
		vEXPORT_VISIBLE,
		vEXPORT_SELECTION,
		vEXPORT_GROUP,
	};

	enum
	{
		vMAX_LENGTH_MODEL_NAME	= 64,
		vMAX_LENGTH_DIR_NAME = 128,
		vMAX_LENGTH_GROUP_NAME = 64,
	};

	ModelExportOptions( void );
	~ModelExportOptions( void );

	void SetNumLODLevels(unsigned int nLevels);

	int		m_Version;
	bool	m_Optimized;
	TSTR	m_ModelName;
	bool    m_ExportQN;				// aml
	bool    m_DirWarn;				// aml
	bool    m_ExportToSceneDir;		// aml   Export to data/models/scene
	TSTR    m_ModelDir;				// aml
	bool    m_IncSkelData;			// aml   True if skeletal animation data should be exported
	bool    m_FlipVerts;			// aml   True if local verts should be flipped (X,Z,-Y) skel anim only
	int     m_ExportMode;			// aml   v8
	TSTR    m_GroupName;			// aml   v8  The group to export
	bool    m_AlwaysLOD;			// aml   v9  True if MultiRes LOD data should be constructed even if there isn't
									//           currently a MultiRes modifier on the object (one will be added)
	
	float   m_LODLowerLimit;		// aml   v9  Lower LOD limit
	int     m_LODNumLevels;			// aml   v9  Number of LOD levels to export
	bool    m_LODProgressive;		// aml   v9  True if LOD data changes should be exported for each vert
	bool    m_ExportByName;			// aml   v10 True if all models that contain the ModelExportName property should be exported
	bool    m_NoNormals;			// aml   v11 True if no normals should be exported

	float*  m_LODDistances;			// aml	 v12 Customly handled array holding m_LODNumLevels elements
	bool    m_DumpDebugData;		// aml	 v13 True if debug data should be dumped
	bool    m_AllowPropOverrides;	// aml   v14 Allow the default assigned level change distances to be altered by LOD properties in the exported object

	// From Saveable
	int  GetSize();
	void Store(void* data);
	void Retrieve(void* data);
};


class ModelOptionsDlg
{
public:
	void Show( void );
	void Hide( void );	
private:
	HWND m_wnd;	
};

int	GetSizeModelExportOptions( void );
void GetModelExportOptions( ModelExportOptions* options );
void SetModelExportOptions( ModelExportOptions* options );

#endif // __EXPORT_MODELEXPORTOPTIONS_H__