/*
	CutsceneExport.h
	Cutscene exporter
*/

#ifndef __CUTSCENEEXPORTER__
#define __CUTSCENEEXPORTER__

#define CUTSCENEEXPORTERUI_CLASS_ID     Class_ID(0x60fd7d5b, 0x37704016)

#include "max.h"
#include "utilapi.h"
#include "iparamb2.h"
#include "../UI/ColorListBox.h"

class CutsceneExporter: public UtilityObj
{
	Interface*    ip;
	IUtil*        iu;

	HWND          hwnd;			// The main rollup window
	ColorListBox* objListbox;	// The object list box UI

	static BOOL __stdcall DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

public:
	CutsceneExporter();
	~CutsceneExporter();

	void BeginEditParams(Interface *ip,IUtil *iu);
	void EndEditParams(Interface *ip,IUtil *iu);
	void SelectionSetChanged(Interface *ip,IUtil *iu);
	void DeleteThis() { delete this; }
	void SetStartupParam(TSTR param) {}
};

class CutsceneExporterClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new CutsceneExporter(); }
	const TCHAR *	ClassName() {return _T("NeverSoft Cutscene Exporter"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return CUTSCENEEXPORTERUI_CLASS_ID;}
	const TCHAR* 	Category() {return _T("CutsceneExporter");}
	const TCHAR*	InternalName() { return _T("CutsceneExporter"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }					// returns owning module handle	
};

#endif
