#include "FuncEnter.h"

#include "../Engine/Engine.h"
#include <Sk/Gamenet/ExportMsg.h>
#include <core/defines.h>
#include <sys/timer.h>
#include <gel/mainloop.h>

#include <gel/net/net.h>
#include <gel/net/server/netserv.h>
#include <gel/net/client/netclnt.h>

#include "../next.h"

Net::Client* gClient;
Net::Conn*   gConn;

#define MAINLOOP_MEMMARKER 16

enum
{
	EVENT_TIMER_TICK
};

//static	Spt::SingletonPtr< Tgt::Manager >	*tgt_manager;	// aml: Target no longer exists
static	Spt::SingletonPtr< Mlp::Manager >	*mlp_manager;
static	Spt::SingletonPtr< Net::Manager >	*net_manager;

VOID CALLBACK	MainLoopTimerProc(  HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime )
{ FUNC_ENTER("MainLoopTimerProc"); 
	if( idEvent == EVENT_TIMER_TICK )
	{
		(*mlp_manager)->DoGameLogic();
	}
}
 
	
Engine::Engine( void )
{ FUNC_ENTER("Engine::Engine"); 
	char* server_ip;

	Dbg::SetUp();
	Mem::Manager::sSetUp();
	Mem::Manager::sHandle().InitOtherHeaps();
	Mem::Manager::sHandle().BottomUpHeap()->PushContext();
	Mem::Manager::sHandle().PushMemoryMarker(MAINLOOP_MEMMARKER);
	//tgt_manager = new Spt::SingletonPtr< Tgt::Manager > ( true );	
	mlp_manager = new Spt::SingletonPtr< Mlp::Manager > ( true );
	net_manager = new Spt::SingletonPtr< Net::Manager > ( true );
	//Spt::SingletonPtr< Tgt::Manager >	tgt_manager( true );	// aml: Target no longer exists
	//Spt::SingletonPtr< Mlp::Manager >	mlp_manager( true );
	//Spt::SingletonPtr< Net::Manager >	net_manager( true );

	gClient = (*net_manager)->CreateNewAppClient( 0, "NExt Max4", Net::vEXPORT_COMM_PORT, inet_addr((*net_manager)->GetLocalIP()),
										Net::App::mACCEPT_FOREIGN_CONN );
	
	server_ip = getenv( vSERVER_IP_VARIABLE );
	if( server_ip == NULL )
	{
		MessageBox( gInterface->GetMAXHWnd(), "You must set up your VIEWER_IP environment variable if you want real-time updates",
						"Warning", MB_OK|MB_TASKMODAL);		
	}
	else
	{
		gClient->ConnectToServer( inet_addr( server_ip ), Net::vEXPORT_COMM_PORT );
		gConn = gClient->NewConnection( inet_addr( server_ip ), Net::vEXPORT_COMM_PORT );
	}

	SetTimer( gInterface->GetMAXHWnd(), EVENT_TIMER_TICK, 33, MainLoopTimerProc );
}