/*
	TreeView.h
	A class to encapsulate TreeView control functionality
	
	Note: This class assumes that you've already initialized common controls
	      at the start of the application

	Note2: The class also assumes you'll send it WM_NOTIFY messages through its ProcMessage
	       (I would have subclassed this, but it would have added some unwanted complexity)
		   [ Might make this SubClass the parent later ] or make a baseclass that does it
		    
	12-12-01
*/

#ifndef __TREEVIEW__
#define __TREEVIEW__

//#define  HASHTABLE_NOASSERTIFCLASH
#include <core/hashtable.h>
#include <windows.h>
#include <commctrl.h>
#include <misc/llist.h>

#define TV_SORT   0x1								// Added entry should be sorted

class TreeView;

class TVItem
{
	HTREEITEM hTreeItem;							// Windows Handle to TreeView entry
	TreeView* tree;									// The tree that contains this item

public:
	friend class TreeView;

	// Adds a subentry under this one
	TVItem* AddItem(char* FieldName,void* pData=NULL,int flags=0);
	TVItem* GetParent();
};

class TreeView
{
	HINSTANCE hInstance;							// Handle to application
	HWND      hwnd;									// Handle to the TreeView Control
	int       ID;									// ID of the TreeView window

	LinkList<TVItem>             litems;			// List to delete item references

	Lst::StringHashTable<TVItem> items;				// This list hangs onto the data for each item
													// in the TreeView control so subdata can  be added 
													// by simply passing in the string name of the parent

	void (*SelChangeFunc)(TreeView*);				// Function called when selection changes

public:
	friend class TVItem;

	TreeView(HINSTANCE hInstance,HWND hwndTreeView);
	~TreeView();

	TVItem* AddField(char* FieldName,void* pData=NULL,char* ParentName=NULL,int flags=0);
	TVItem* AddField(TVItem* tviParent,char* FieldName,void* pData=NULL,int flags=0);
	TVItem* GetTVItem(char* FieldName,void* pData=NULL) { return items.GetItem(FieldName); }
	void   DeleteField(TVItem* tvitem);

	inline void RegSelChange(void(*Func)(TreeView*))    { SelChangeFunc=Func;    }

	void* GetSelection();
	void  SetItemData(TVItem* tvitem,void* val);
	void* GetItemData(TVItem* tvitem);

	BOOL ProcMessage(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void DisableRedraw();							// Call this before adding a lot of fields to speed it up
	void EnableRedraw();							// Call this after you've added your fields
};

#endif
