/*
	OKtoAll.cpp
	This is a replacement for MessageBox that includes an OK to All button
	It will keep track of it's context and
*/

#include "OKtoAll.h"
#include "misc/llist.h"
#include "UI/ModalDlg.h"
#include "max.h"
#include "Resource.h"

extern HINSTANCE  hInstance;
extern Interface* gInterface;

enum Mode
{
	MODE_OKCANCEL,
	MODE_OK,
	MODE_YESNO,
};

class CMessageBox: public ModalDlgWindow
{
	friend int MessageBoxAll(HWND hwnd,char* text,char* title,int flags);

	int   Result;
	char* title;
	char* text;

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
	static BOOL CALLBACK DlgProc2(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

public:
	CMessageBox(char* text,char* title,Mode mode);
	~CMessageBox();

	inline int GetResult() { return Result; }
};

CMessageBox::CMessageBox(char* text, char* title, Mode mode) :
	//ModalDlgWindow(hInstance,MAKEINTRESOURCE( ((mode == MODE_OKCANCEL) ? IDD_MB_OKCANCEL : IDD_MB_OKONLY) ),gInterface->GetMAXHWnd())
	ModalDlgWindow(hInstance,MAKEINTRESOURCE(IDD_MERGECONFLICT),gInterface->GetMAXHWnd())
{
	this->title = new char[strlen(title)+1];
	strcpy(this->title,title);

	this->text = new char[strlen(text)+1];
	strcpy(this->text,text);
}

CMessageBox::~CMessageBox()
{
	if (title)
		delete [] title;

	if (text)
		delete [] text;
}

BOOL CMessageBox::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	CMessageBox* pthis = (CMessageBox*)GetWindowLong(hwnd,GWL_USERDATA);

	switch(msg)
	{
	case WM_INITDIALOG:
		SetWindowText(hwnd,pthis->title);
		SetWindowText(GetDlgItem(hwnd,IDC_MSG),pthis->text);
		return TRUE;

	case WM_COMMAND:

		switch(LOWORD(wParam))
		{
		case IDOK:
		case IDOKTOALL:
		case IDCANCEL:
			Result = LOWORD(wParam);
			EndDialog(hwnd,Result);
			return TRUE;
		}
	}

	return FALSE;
}

BOOL CMessageBox::DlgProc2(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	CMessageBox* pthis = (CMessageBox*)GetWindowLong(hwnd,GWL_USERDATA);

	switch(msg)
	{
	case WM_INITDIALOG:
		SetWindowLong(hwnd,GWL_USERDATA,(LONG)lParam);
		pthis = (CMessageBox*)lParam;
		SetWindowText(hwnd,pthis->title);
		SetWindowText(GetDlgItem(hwnd,IDC_MSG),pthis->text);
		return TRUE;

	case WM_COMMAND:

		switch(LOWORD(wParam))
		{
		case IDOK:
		case IDOKTOALL:
		case IDYES:
		case IDYESTOALL:
		case IDNO:
		case IDNOTOALL:
		case IDCANCEL:
			pthis->Result = LOWORD(wParam);
			EndDialog(hwnd,pthis->Result);
			return TRUE;
		}
	}

	return FALSE;
}

struct MessageBoxEntry
{
	char* text;
	bool  bPrompt;
	int   lastResult;

	MessageBoxEntry()
	{
		text = NULL;
		bPrompt = true;
	}

	MessageBoxEntry(MessageBoxEntry& src)
	{
		text = new char[strlen(src.text)+1];
		strcpy(text,src.text);
		bPrompt = src.bPrompt;
		lastResult = src.lastResult;
	}

	MessageBoxEntry& operator = (MessageBoxEntry& right)
	{
		text = new char[strlen(right.text)+1];
		strcpy(text,right.text);
		bPrompt = right.bPrompt;
		lastResult = right.lastResult;

		return *this;
	}

	MessageBoxEntry(char* text)
	{
		this->text = new char[strlen(text)+1];
		strcpy(this->text,text);

		bPrompt = true;
	}

	MessageBoxEntry(char* text,bool bPrompt)
	{
		this->text = new char[strlen(text)+1];
		strcpy(this->text,text);

		this->bPrompt = bPrompt;
	}

	~MessageBoxEntry()
	{
		if (text)
			delete [] text;
	}

	bool operator ==(MessageBoxEntry& right)
	{
		if (strcmp(text,right.text)==0)
			return true;

		return false;
	}
};

class MessageBoxManager
{
	LinkList<MessageBoxEntry> list;

public:
	void AddBox(char* text, bool bPrompt)
	{
		MessageBoxEntry mbe(text,bPrompt);
		Link<MessageBoxEntry>* link = list.Find(&mbe);

		if (link)
			link->data.bPrompt = bPrompt;
		else
			list.AddToTail(&mbe);
	}

	bool ShouldPrompt(char* text)
	{
		MessageBoxEntry mbe(text);
		Link<MessageBoxEntry>* link = list.Find(&mbe);

		if (link)
			return link->data.bPrompt;

		return true;
	}

	void SetNoPrompt(char* text)
	{
		MessageBoxEntry mbe(text);
		Link<MessageBoxEntry>* link = list.Find(&mbe);

		if (link)
		{
			link->data.bPrompt = false;
			return;
		}

		mbe.bPrompt = false;
		list.Add(&mbe);
	}

	void SetPrompt(char* text)
	{
		MessageBoxEntry mbe(text);
		Link<MessageBoxEntry>* link = list.Find(&mbe);

		if (link)
		{
			link->data.bPrompt = true;
			return;
		}

		mbe.bPrompt = true;
		list.Add(&mbe);
	}

	int GetResult(char* text)
	{
		MessageBoxEntry mbe(text);
		Link<MessageBoxEntry>* link = list.Find(&mbe);

		return link->data.lastResult;
	}

	void SetResult(char* text,int Result)
	{
		MessageBoxEntry mbe(text);
		Link<MessageBoxEntry>* link = list.Find(&mbe);

		if (link)
			link->data.lastResult = Result;
		else
		{
			mbe.lastResult = Result;
			list.Add(&mbe);
		}
	}

	void Reset(char* text)
	{
		MessageBoxEntry mbe(text);
		Link<MessageBoxEntry>* link = list.Find(&mbe);
		
		if (link)
			list.Remove(link);
	}

	void ResetAll()
	{
		list.Clear();
	}
};

static MessageBoxManager mbManager;

BOOL CALLBACK TempCB(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParma)
{
	switch(msg)
	{
	case WM_COMMAND:
		
		return TRUE;
	}

	return FALSE;
}

int MessageBoxAll(HWND hwnd,char* text,char* title,int flags)
{
	if (mbManager.ShouldPrompt(title))
	{
		Mode mode;

		if (flags & MB_OKCANCEL)
			mode = MODE_OKCANCEL;
		else if (flags & MB_YESNO)
			mode = MODE_YESNO;
		else
			mode = MODE_OK;


		CMessageBox* mbox = new CMessageBox(text,title,mode);
		int Result;

		switch(mode)
		{
		case MODE_OKCANCEL:
			Result = DialogBoxParam(hInstance,MAKEINTRESOURCE(IDD_MB_OKCANCEL),gInterface->GetMAXHWnd(),CMessageBox::DlgProc2,(LPARAM)mbox);
			break;

		case MODE_OK:
			Result = DialogBoxParam(hInstance,MAKEINTRESOURCE(IDD_MB_OKONLY),gInterface->GetMAXHWnd(),CMessageBox::DlgProc2,(LPARAM)mbox);
			break;

		case MODE_YESNO:
			Result = DialogBoxParam(hInstance,MAKEINTRESOURCE(IDD_MB_YESNO),gInterface->GetMAXHWnd(),CMessageBox::DlgProc2,(LPARAM)mbox);
			break;
		}	

		delete mbox;

		if (Result == IDOKTOALL)
		{
			Result = IDOK;
			mbManager.SetNoPrompt(title);
		}

		if (Result == IDYESTOALL)
		{
			Result = IDYES;
			mbManager.SetNoPrompt(title);
		}

		if (Result == IDNOTOALL)
		{
			Result = IDNO;
			mbManager.SetNoPrompt(title);
		}

		mbManager.SetResult(title,Result);

		return Result;
	}
	else
		return mbManager.GetResult(title);
}

void MessageBoxReset(char* text)
{
	mbManager.Reset(text);
}

void MessageBoxResetAll()
{
	mbManager.ResetAll();
}
