/*
	NodeSelect.cpp
	Node selector control
	Assigns node name by clicking on a node in the viewport
*/

#include "NodeSelect.h"
#define  CUSTIDC_BUTTON         1
#define  CUSTIDC_BUTTONCHOOSER  2
#define  CUSTIDC_EDIT           3
#define  CUSTIDC_BUTTONSELECT   4

extern Interface* gInterface;

class NSAddCallback: public HitByNameDlgCallback
{
	NodeSelect *ns;

public:
	NSAddCallback(NodeSelect* ns) { this->ns = ns; }

	void  SetNodeSelect(NodeSelect* ns) { this->ns = ns; }
	TCHAR *dialogTitle()	{ return _T("Select node (DynUI)"); }
	TCHAR *buttonText() 	{ return _T("Add"); }
	//BOOL singleSelect()		{ return TRUE; }
	BOOL singleSelect()		{ return FALSE; }
	BOOL useFilter()		{ return TRUE; }
	int filter(INode *node)	{ return TRUE; }
	BOOL useProc()			{ return TRUE; }
	void proc(INodeTab &nodeTab) { if (ns) ns->SetNode(nodeTab[0]); }
	BOOL doCustomHilite()	{ return FALSE; }
	BOOL doHilite(INode *node)	{ return FALSE; }
	BOOL showHiddenAndFrozen()	{ return FALSE; }
};

class NodeSelectPicker : public PickModeCallback,
		public PickNodeCallback 
{
public:			
	NodeSelect *ns;
	NodeSelectPicker() { ns = NULL; }
	BOOL HitTest(IObjParam *ip,HWND hWnd,ViewExp *vpt,IPoint2 m,int flags);		
	BOOL Pick(IObjParam *ip,ViewExp *vpt);		
	void EnterMode(IObjParam *ip);
	void ExitMode(IObjParam *ip);
	BOOL Filter(INode *node);
	PickNodeCallback *GetFilter() {return this;}
	BOOL RightClick(IObjParam *ip,ViewExp *vpt) {return TRUE;}
};

static NodeSelectPicker theNodePickMode;

BOOL NodeSelectPicker::Filter(INode *node)
{
	Object* obj=node->EvalWorldState(0).obj;

	if (obj->SuperClassID()==GEOMOBJECT_CLASS_ID)
		return TRUE;

	return FALSE;
}

BOOL NodeSelectPicker::HitTest(IObjParam *ip,HWND hWnd,ViewExp *vpt,IPoint2 m,int flags)
{	
	if (ip->PickNode(hWnd,m,this))
		return TRUE;
	else
		return FALSE;
}

BOOL NodeSelectPicker::Pick(IObjParam *ip,ViewExp *vpt)
{
	INode *node = vpt->GetClosestHit();
	
	if (node)
	{
		ns->SetNode(node);
		//ExitMode(ip);
		return TRUE;
	}

	return FALSE;
}

void NodeSelectPicker::EnterMode(IObjParam *ip)
{
	if (ns && ns->ibutton)
	{
		ns->ibutton->SetCheck(TRUE);
	}

	GetCOREInterface()->PushPrompt("Select Node Target");
}

void NodeSelectPicker::ExitMode(IObjParam *ip)
{
	if (ns && ns->ibutton)
		ns->ibutton->SetCheck(FALSE);

	GetCOREInterface()->PopPrompt();
}

/////////////////////////////////////////// End picker class

NodeSelect::NodeSelect(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{
	iedit          = NULL;
	ibutton        = NULL;
	ibuttonChooser = NULL;
	ibuttonSelect  = NULL;
	addCB          = NULL;
}

NodeSelect::~NodeSelect()
{
	theNodePickMode.ns = NULL;
	
	if (addCB)
		addCB->SetNodeSelect(NULL);

	gInterface->ClearPickMode();

	if (ibutton)
		ReleaseICustButton(ibutton);

	if (ibuttonChooser)
		ReleaseICustButton(ibuttonChooser);

	if (ibuttonSelect)
		ReleaseICustButton(ibuttonSelect);

	if (iedit)
		ReleaseICustEdit(iedit);

	if (addCB)
		delete addCB;
}

NodeSelect::NodeSelect(NodeSelect& right) :
	UIControl(right.hInstance, CLASS)
{
	iedit             = NULL;
	ibutton           = NULL;
	ibuttonChooser    = NULL;
	ibuttonSelect     = NULL;
	addCB             = NULL;

	hwndButton        = NULL;
	hwndButtonChooser = NULL;
	hwndEdit          = NULL;

	node              = right.node;
	value             = right.value;
}

NodeSelect& NodeSelect::operator = (NodeSelect& right)
{
	iedit             = NULL;
	ibutton           = NULL;
	ibuttonChooser    = NULL;
	addCB             = NULL;

	hwndButton        = NULL;
	hwndButtonChooser = NULL;
	hwndEdit          = NULL;

	ibutton           = NULL;
	ibuttonChooser    = NULL;
	iedit             = NULL;
	node              = right.node;
	value             = right.value;
	
	addCB             = NULL;

	return *this;
}

LRESULT NodeSelect::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case CUSTIDC_BUTTON:
			theNodePickMode.ns = this;
			gInterface->SetPickMode(&theNodePickMode);
			return TRUE;

		case CUSTIDC_BUTTONCHOOSER:
			gInterface->DoHitByNameDialog(addCB);
			return TRUE;

		case CUSTIDC_BUTTONSELECT:
			Select();
			return TRUE;

		case CUSTIDC_EDIT:
			{
				if (HIWORD(wParam) == EN_CHANGE)
				{
					HWND hwndParent = GetParent(this->hwnd);

					int  ID = (int)GetWindowLong(hwnd,GWL_ID);
					//SendMessage(hwndParent,WM_CHILDGOTFOCUS,(WPARAM)ID,0);
					SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
					return TRUE;
				}
			}
		}
	}

	return DefWindowProc(hwnd,msg,wParam,lParam);
}

void NodeSelect::BuildControlUI()
{
	RECT wndRect;
	GetClientRect(hwnd,&wndRect);

	int width = wndRect.right - wndRect.left;

	hwndButton = CreateWindow("CustButton",
		                      "None",
							  WS_CHILD|WS_VISIBLE,
							  width-10,
							  0,
							  10,
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)CUSTIDC_BUTTON,
							  hInstance,
							  NULL);

	hwndButtonChooser = CreateWindow("CustButton",
		                             "None",
							         WS_CHILD|WS_VISIBLE,
							         width-20,
							         0,
							         10,
							         wndRect.bottom - wndRect.top,
							         hwnd,
							         (HMENU)CUSTIDC_BUTTONCHOOSER,
							         hInstance,
							         NULL);

	hwndSelect = CreateWindow("CustButton",
		                      "None",
							  WS_CHILD|WS_VISIBLE,
							  width - 30,
							  0,
							  10,
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)CUSTIDC_BUTTONSELECT,
							  hInstance,
							  NULL);

	hwndEdit = CreateWindow("CustEdit",
		                      "None",
							  WS_CHILD|WS_VISIBLE,
							  0,
							  0,
							  wndRect.right - wndRect.left - 30,
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)CUSTIDC_EDIT,
							  hInstance,
							  NULL);

	ibutton        = GetICustButton(hwndButton);
	ibuttonChooser = GetICustButton(hwndButtonChooser);
	ibuttonSelect  = GetICustButton(hwndSelect);
	iedit          = GetICustEdit(hwndEdit);

	ibutton->SetText("P");
	ibuttonChooser->SetText("C");
	ibuttonSelect->SetText("S");

	ibutton->SetType(CBT_CHECK);
	SetValue(value,FALSE);

	addCB = new NSAddCallback(this);
}

CStr NodeSelect::GetValue()
{
	char buf[256];
	iedit->GetText(buf,255);

	return CStr(buf);
}

void NodeSelect::SetValue(CStr value, bool bNotify)
{
	if (iedit)
	{
		iedit->SetText(value);
	}

	this->value = value;

	if (bNotify)
	{
		HWND hwndParent = GetParent(hwnd);

		int  ID = (int)GetWindowLong(hwnd,GWL_ID);
		//SendMessage(hwndParent,WM_CHILDGOTFOCUS,(WPARAM)ID,0);
		//SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
	}
}

void NodeSelect::SetNode(INode* node)
{
	this->node = node;
	
	if (iedit)
	{
		if (node)
			iedit->SetText(node->GetName());
		else
			iedit->SetText("");

		HWND hwndParent = GetParent(hwnd);

		int  ID = (int)GetWindowLong(hwnd,GWL_ID);
		//SendMessage(hwndParent,WM_CHILDGOTFOCUS,(WPARAM)ID,0);
		SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
	}
}

INode* NodeSelect::GetNode()
{
	CStr name = GetValue();
	return gInterface->GetINodeByName(name);
}

void NodeSelect::Select()
{
	INode* node = GetNode();
	gInterface->SelectNode(node);
	gInterface->ForceCompleteRedraw();
}
