/*
	MultiPropList.cpp
	Multi-Property List.  This is a property list that has categorical control.
	Visually it's a property list with a MultiList on top that lists out the categories and
	will update the property list to correspond to the selected category, it behaves like
	a standard property list though.  This works functionally the same, but categories are
	defined by /'s between levels for each property name
*/

#include "MultiPropList.h"
#include "../PropEdit/ParseFuncs.h"
#define CUSTIDC_MULTILIST  1
#define CUSTIDC_PROPLIST   2

MultiPropList::MultiPropList(HINSTANCE hInstance,HWND hwdParent,int x,int y,int width,int height,CStr DlgText) :
	PropList(hInstance,hwdParent,x,y,width,height,DlgText), UIControl(hInstance, CLASS)
{
	// Copy creation parameters for use in creation of future prop lists
	this->hInstance = hInstance;
	this->hwdParent = hwdParent;
	this->x         = x;
	this->y         = y;
	this->width     = width;
	this->height    = height;
	this->DlgText   = DlgText;
	bExtCreateMethod= true;

	mlist = NULL;

	HasApply(false);
	UIControl::hwnd = PropList::hwnd;
	BuildControlUI();
}

MultiPropList::MultiPropList(HINSTANCE hInstance,int cols) :
	PropList(hInstance,cols), UIControl(hInstance, CLASS)
{
	// Copy creation parameters for use in creation of future prop lists
	this->hInstance = hInstance;
	this->cols      = cols;
	bExtCreateMethod= false;

	mlist = NULL;
}

MultiPropList::~MultiPropList()
{

}

void MultiPropList::BuildNameList()
{
	Link<Property>* curprop = props.GetHead();

	names.Clear();

	while(curprop)
	{
		names.AddToTail(&curprop->data.strPropName);
		curprop = curprop->next;
	}
}

LRESULT MultiPropList::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	InvalidateRect(hwndMultiList,NULL,FALSE);

	switch(msg)
	{
	case WM_CREATE:

		return TRUE;

	case WM_COMMAND:
		switch(HIWORD(wParam))
		{
		case CBN_SELCHANGE:
			switch(LOWORD(wParam))
			{
			case CUSTIDC_MULTILIST:
				CategoryChange();
				return TRUE;
			}
		}
	}

	return PropList::WndProc(hwnd,msg,wParam,lParam);

	//return DefWindowProc(hwnd,msg,wParam,lParam);
}

void MultiPropList::BreakPathRoot(CStr& src, CStr& path, CStr& root)
{
	path = src;
	int  pos  = RInstr(path,"/");

	if (pos == -1)
		path = CStr("");
	else
		path[pos] = 0;

	root = src.Substr(pos+1,src.Length());
}

void MultiPropList::AssignVisibility()
{
	// Scan through the property list and flag any properties that don't exist
	// within this category as invisible
	CStr category = mlist->GetValue();

	bool bAllVisible = true;

	if (category == CStr("All"))
	{
		Link<Property>* curprop = props.GetHead();

		while(curprop)
		{
			curprop->data.bVisible = true;
			curprop = curprop->next;
		}
	}
	else
	{
		if (category == CStr("Default"))
			category = CStr("");

		Link<Property>* curprop = props.GetHead();
		Link<CStr>* curname = names.GetHead();

		assert(props.GetSize() == names.GetSize());

		while(curprop)
		{
			CStr path,root;

			BreakPathRoot(curname->data,path,root);

			if (path == category)
				curprop->data.bVisible = true;
			else
			{
				bAllVisible = false;
				curprop->data.bVisible = false;
			}

			ShowWindow(curprop->data.hwndTxt,SW_HIDE);
			ShowWindow(curprop->data.hwndFld,SW_HIDE);

			curprop = curprop->next;
			curname = curname->next;
		}
	}

	mlist->SetGroupText(!bAllVisible);
}

void MultiPropList::CategoryChange()
{
	AssignVisibility();

	//RestoreValues();
	SaveValues();
	DestroyUI();
	PropList::BuildUI();
	RestoreValues();
}

void MultiPropList::BuildControlUI()
{
	RECT wndRect;
	GetClientRect(UIControl::hwnd,&wndRect);

	mlist = new MultiList(UIControl::hInstance);

	// Create the multilist
	hwndMultiList = CreateWindow("MultiList",
		                         "Default",
								 WS_CHILD|WS_VISIBLE,
								 0,
								 0,
								 wndRect.right - wndRect.left,
								 20,
								 UIControl::hwnd,
								 (HMENU)CUSTIDC_MULTILIST,
								 UIControl::hInstance,
								 mlist);

	// Create the window that will contain the active property list
	hwndPropList = CreateWindow("PropList",
		                        "",
								WS_CHILD|WS_VISIBLE,
								0,
								20,
								wndRect.right - wndRect.left,
								wndRect.bottom - wndRect.top - 20,
								UIControl::hwnd,
								(HMENU)CUSTIDC_PROPLIST,
								UIControl::hInstance,
								NULL);

	DWORD err = GetLastError();

	mlist->Attach(hwndMultiList);
	mlist->DispFullPath(true);
	mlist->EvalFullPath(true);
	mlist->AddItem("Default");
	mlist->AddItem("All");

	//SetWindowLong(PropList::hwnd,GWL_USERDATA,(LONG)this);
	PropList::Attach(hwndPropList);

	//InvalidateRect(UIControl::hwnd,NULL,FALSE);

	// Scan through the prop list and add and categorical properties
/*
	Link<Property>* curprop = props.GetHead();

	while(curprop)
	{
		CStr value;
		CStr name = curprop->data.strPropName;
		
		GetValue(props.GetIndex(curprop),value);

		int pos = RInstr(value,"/");
		if (pos != -1)
		{
			// Seperate the category path from the property
			CStr path = value;
			path[pos] = 0;

			CStr prop = value.Substr(pos+1,value.Length());

			// See if the category exists
			PropEntry srch;
			srch.category = path;
			
			Link<PropEntry>* link = proplists.Find(&srch);

			if (!link)
			{
				link = proplists.Add();	

				if (bExtCreateMethod)
				{
					link->data.proplist = new PropList(hInstance,hwdParent,x,y,width,height,DlgText);
				}
				else
				{
					link->data.proplist = new PropList(hInstance,cols);
				}
			}

			link->data.proplist->AddProperty(&curprop->data);

			proplists.AddToTail();
		}

		curprop = curprop->next;
	}
*/
}

void MultiPropList::BuildUI()
{
	// Scan through the list and build up our own list of names within the list
	// categorized according to any sub levels that may be defined with '/'s
	// we will also change the stored property name to the final name in the hierarchy
	names.Clear();
	mlist->ResetKeepText();
	mlist->AddItem("Default");
	mlist->AddItem("All");

	Link<Property>* curprop = props.GetHead();

	while(curprop)
	{
		CStr name = curprop->data.strPropName;
		CStr path, root;
		BreakPathRoot(curprop->data.strPropName, path, root);

		if (path.Length()>0)
			mlist->AddItemUnique(path);

		curprop->data.strDispName = root;
		names.AddToTail(&name);

		curprop = curprop->next;
	}

	PropList::HasApply(false);
	mlist->SetValue("Default");
	AssignVisibility();
	//CategoryChange();

	//PropList::DestroyUI();
	PropList::BuildUI();
}

void MultiPropList::DestroyUI()
{
	PropList::DestroyUI();
}
