/*
	ViewportTexture.h
	Viewport texture provides a class tailored so that materials can provide
	their own representations for the Interactive Viewport Renderer
	aml  5-28-01
*/

#ifndef __VIEWPORTTEXTURE__
#define __VIEWPORTTEXTURE__

#include <max.h>
#include <imtl.h>
#include <stdmat.h>
#include <bmmlib.h>
#include <texutil.h>
#include <iparamm2.h>
#include <macrorec.h>
#include <notify.h>
#include "BMTex.h"

#define NEXT_VIEWPORTTEX_CLASS_ID   Class_ID(0x447e0b03, 0x44da5814)

class ViewportTexture: public BMTex
{
	Texmap**   tmaps;
	BitmapInfo bi;
	Bitmap*    thebm;			// The combined bitmap that gets displayed in the viewport

public:
	ViewportTexture();
	ViewportTexture(int nmaps);
	~ViewportTexture();

	Class_ID ClassID() { return NEXT_VIEWPORTTEX_CLASS_ID; }

	BOOL SupportTexDisplay() { return TRUE; }
	void AssignBitmap(Bitmap* bmp);

	DWORD_PTR GetActiveTexHandle(TimeValue t, TexHandleMaker& thmaker);
	BITMAPINFO* GetVPDisplayDIB(TimeValue t, TexHandleMaker& thmaker, Interval &valid, BOOL mono=FALSE, BOOL forceW=0, BOOL forceH=0);
};

#endif
