/*
	ScriptIniParser.h
	Script INI File Parser
	1-20-01
*/

#ifndef __SCRIPTINIPARSER__
#define __SCRIPTINIPARSER__

#ifndef HASHINCLUDED
#define HASHINCLUDED
//#define HASHTABLE_NOASSERTIFCLASH			// Prevent the hashtable from asserting if we have duplicates
#pragma warning( push )
#pragma warning( disable : 4002 )
#include <core/hashtable.h>
#pragma warning( pop )
#endif

#include "../misc/llist.h"
#include "ConfigData.h"
#include "../UI/PropList.h"

#define vUNKNOWN "????"
#define vRESTORE_DEFAULT_SEQ "!"

class ScriptIniParser
{
protected:
	LinkList<ConfigClass>	configDB;	// Data read in from scripts.ini

private:
	struct ConfigRec
	{
		LinkList<ConfigProp>   props;
		DWORD                  flags;
		CStr                   strCmds;
		CStr                   strCluster;
		CStr                   strProgram;
	};

	Lst::StringHashTable<ConfigRec>      propDB;	// Default Property Database

	CStr                   DEFBuffer;			// Cache default buffer for speed
	LinkList<ConfigProp>   DEFcprops;			// Cached list of default properties
	DWORD                  DEFcflags;			// Cached default flags
	CStr			  	   DEFunkBuf;			// Cached default unknown buffer
	CStr                   DEFcluster;			// Cached default assigned cluster
	CStr                   lastDEFBuffer;		// Cached default buffer
	CStr                   DEFClass;			// Cached class name for default buffer
	CStr                   DEFType;				// Cached type name for default buffer

											// All new classes/types will use this group string until changed
	CStr                 strCurClassGroup;	// This is the current class group hierarchy string
	CStr                 strCurTypeGroup;	// This is the current type group hierarchy string 

	void ParseClassGroup(FILE* fp,char* lineBuf,int pos);
	void ParseTypeGroup(ConfigClass* pcclass,FILE* fp,char* lineBuf,int pos);
	void ParseClass(FILE* fp,char* lineBuf,int pos);
	void ParseType(ConfigClass* pcclass,FILE* fp,char* lineBuf,int pos);
	void AddGlobalDefaults();

public:
	ScriptIniParser();
	~ScriptIniParser();

	bool  ParseScriptIni(char* filename=NULL);
	CStr  GetDefault(CStr className,CStr typeName,CStr propName);
	bool  GetDefaultProps(LinkList<ConfigProp>* cprops,CStr className,CStr typeName);
	DWORD GetDefaultFlags(CStr className,CStr typeName);
	CStr  GetDynUICmds(CStr className,CStr typeName,CStr propName);
	void  GetDynUIProps(LinkList<ConfigProp>* cprops,CStr className,CStr typeName);
	void  CombineDynUIProps(LinkList<ConfigProp>* cprops,CStr className,CStr typeName);
	void  GetPrograms(LinkList<ConfigProgram>* cprogs,CStr className,CStr typeName);
	CStr  GetTypeRecord(ConfigClass* cclass,CStr typeName);
	CStr  GetClassTypeRecord(CStr className,CStr typeName);
	ConfigClass* GetConfigClass(CStr className);

	bool  ClassExists(CStr className);
	bool  TypeExists(ConfigClass* cclass,CStr typeName);
	bool  TypeExists(CStr className,CStr typeName);

	void ConvertToDefaults(CStr className,CStr typeName,LinkList<ConfigProp>* config);
	void ConvertToDefaultDelim(CStr className,CStr typeName,LinkList<ConfigProp>* config);

	void AddGlobalDefaults(CStr& propBuffer);
	void AddGlobalDefaults(CStr&                   propBuffer,
						   LinkList<ConfigProp>*   cprops,
						   DWORD*                  cflags,
						   CStr*                   unkBuf,
						   CStr&                   className=CStr(""),
						   CStr&                   typeName=CStr(""));

	void RemoveDefaults(CStr origClass,CStr origType,LinkList<ConfigProp>* origProps);

	void Reset();

	// Returns true if all the properties in the given property list are defaulted
	bool IsDefaulted(PropList* plist, CStr className, CStr typeName);

	inline Link<ConfigClass>* GetConfigDBHead() { return configDB.GetHead(); }
	inline Link<ConfigClass>* ConfigDBFind(ConfigClass* cclass) { return configDB.Find(cclass); }
};

#endif
