/*
	QueryBuilder.h
	The query builder generates a list of Find-A-Node queries from level property data
*/

#ifndef __QUERYBUILDER__
#define __QUERYBUILDER__

#include "../UI/MSWindow.h"
#include "max.h"

class PropList;

class QueryBuilderDlg: public MSDlgWindow
{
	Interface* ip;								// The MAX Interface pointer

	void (*fpOkCB)(QueryBuilderDlg*,void*);		// Callback executed when the OK button is pressed
	void *pOkCBData;							// Callback retained data

	PropList* plist;							// The property list containing the query wildcards

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParawm,LPARAM lParam);

	void BuildAPList();							// Construct list of all availabe properties
	void BuildSNList(INode* node=NULL);			// Construct list of all searchable nodes

public:
	QueryBuilderDlg(HINSTANCE hInstance,HWND hwndParent,Interface* ip);
	~QueryBuilderDlg();

	void RegOKCB(void(*Func)(QueryBuilderDlg*,void*),void* pData);

	// Selection set commands
	void SNAll();
	void SNNone();
	void SNInvert();

	void APAll();
	void APNone();
	void APInvert();
};

#endif
