/*
	QueryBuilder.cpp
	The query builder generates a list of Find-A-Node queries from level property data
*/

#include "QueryBuilder.h"
#include "../UI/PropList.h"
#include "Resource.h"

QueryBuilderDlg::QueryBuilderDlg(HINSTANCE hInstance,HWND hwndParent,Interface* ip) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_QUERYBUILDER),hwndParent)
{
	this->ip = ip;

	// Build and attach the property list to Visual UI
	plist = new PropList(hInstance,1);
	plist->Attach(GetDlgItem(hwnd,IDC_QBPROPLIST));

	BuildSNList();
	BuildAPList();
}

QueryBuilderDlg::~QueryBuilderDlg()
{

}

void QueryBuilderDlg::RegOKCB(void(*Func)(QueryBuilderDlg*,void*),void* pData)
{
	fpOkCB    = Func;
	pOkCBData = pData;
}

BOOL QueryBuilderDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_APALL:
			APAll();			
			break;

		case IDC_APNONE:
			APNone();
			break;

		case IDC_APINVERT:
			APInvert();
			break;

		case IDC_SNALL:
			SNAll();
			break;

		case IDC_SNNONE:
			SNNone();
			break;

		case IDC_SNINVERT:
			SNInvert();
			break;
		}
	}

	return FALSE;
}

void QueryBuilderDlg::BuildAPList()
{
	
}

void QueryBuilderDlg::BuildSNList(INode* root)
{
	// Add all the nodes in the scene to the list
	if (!root)
		root = ip->GetRootNode();

	int nKids = root->NumberOfChildren();

	for(int i=0;i<nKids;i++)
	{
		INode* child = root->GetChildNode(i);
		BuildSNList(child);
	}

	if (root != ip->GetRootNode())
	{
		int index = SendDlgItemMessage(hwnd,IDC_SNLIST,LB_ADDSTRING,0,(LPARAM)(char*)root->GetName());
		SendDlgItemMessage(hwnd,IDC_SNLIST,LB_SETITEMDATA,(WPARAM)index,(LPARAM)root);
	}
}

void QueryBuilderDlg::APAll()
{
	int count = SendDlgItemMessage(hwnd,IDC_APLIST,LB_GETCOUNT,0,0);
	SendDlgItemMessage(hwnd,IDC_APLIST,LB_SELITEMRANGE,(WPARAM)TRUE,MAKELPARAM(0,count-1));
}

void QueryBuilderDlg::APNone()
{
	int count = SendDlgItemMessage(hwnd,IDC_APLIST,LB_GETCOUNT,0,0);
	SendDlgItemMessage(hwnd,IDC_APLIST,LB_SELITEMRANGE,(WPARAM)FALSE,MAKELPARAM(0,count-1));
}

void QueryBuilderDlg::APInvert()
{
	int count = SendDlgItemMessage(hwnd,IDC_APLIST,LB_GETCOUNT,0,0);

	for(int i=0;i<count;i++)
	{
		if (SendDlgItemMessage(hwnd,IDC_APLIST,LB_GETSEL,(WPARAM)i,0))
			SendDlgItemMessage(hwnd,IDC_APLIST,LB_SETSEL,(WPARAM)FALSE,(LPARAM)i);
		else
			SendDlgItemMessage(hwnd,IDC_APLIST,LB_SETSEL,(WPARAM)TRUE,(LPARAM)i);
	}
}

void QueryBuilderDlg::SNAll()
{
	int count = SendDlgItemMessage(hwnd,IDC_SNLIST,LB_GETCOUNT,0,0);
	SendDlgItemMessage(hwnd,IDC_SNLIST,LB_SELITEMRANGE,(WPARAM)TRUE,MAKELPARAM(0,count-1));	
}

void QueryBuilderDlg::SNNone()
{
	int count = SendDlgItemMessage(hwnd,IDC_APLIST,LB_GETCOUNT,0,0);
	SendDlgItemMessage(hwnd,IDC_SNLIST,LB_SELITEMRANGE,(WPARAM)FALSE,MAKELPARAM(0,count-1));
}

void QueryBuilderDlg::SNInvert()
{
	int count = SendDlgItemMessage(hwnd,IDC_APLIST,LB_GETCOUNT,0,0);

	for(int i=0;i<count;i++)
	{
		if (SendDlgItemMessage(hwnd,IDC_SNLIST,LB_GETSEL,(WPARAM)i,0))
			SendDlgItemMessage(hwnd,IDC_SNLIST,LB_SETSEL,(WPARAM)FALSE,(LPARAM)i);
		else
			SendDlgItemMessage(hwnd,IDC_SNLIST,LB_SETSEL,(WPARAM)TRUE,(LPARAM)i);
	}
}

