/*
	MultiSearch.cpp
	The multi search dialog window

	Adam Lippmann
	12-20-01
*/

#include "MultiSearch.h"
#include "Resource.h"

MSearchDlg::MSearchDlg(Interface* ip,PropEditor* pPropEdit,HINSTANCE hInstance,HWND hwndParent,MSearchMode mode) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_MULTISEARCHREPLACE),hwndParent)
{
	this->ip=ip;
	this->pPropEdit=pPropEdit;
	this->mode=mode;

	bAbort=FALSE;
	bReplaceAll=FALSE;

	// Fill the listbox with all of the selected MAX Nodes
	ListCount=ip->GetSelNodeCount();

	for(int i=0;i<ListCount;i++)
	{
		INode* node=ip->GetSelNode(i);

		int index=SendDlgItemMessage(hwnd,IDC_MULTILIST,LB_ADDSTRING,0,(LPARAM)(char*)node->GetName());
		SendDlgItemMessage(hwnd,IDC_MULTILIST,LB_SETITEMDATA,(WPARAM)index,(LPARAM)node);
	}
	
	// Select everything in the listbox as the default
	SendDlgItemMessage(hwnd,IDC_MULTILIST,LB_SETSEL,(WPARAM)TRUE,(LPARAM)-1);

	Show();
}

MSearchDlg::~MSearchDlg()
{
	
}

BOOL MSearchDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_ACTIVATE:
		if (LOWORD(wParam)==WA_INACTIVE)
			EnableAccelerators();
		else
			DisableAccelerators();
		
		return TRUE;

	case WM_CLOSE:
		Hide();
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_MULTIOK:
			switch(mode)
			{
			case MSEARCH_SEARCH:
				Search();
				return TRUE;
			
			case MSEARCH_REPLACE:
				Replace();
				return TRUE;
			}

			return TRUE;

		case IDC_MULTICANCEL:
			Hide();
			return TRUE;
		}
	}

	return FALSE;
}

void MSearchDlg::ReplaceAllPressed(void* pData)
{
	MSearchDlg* thisclass=(MSearchDlg*)pData;
	thisclass->bReplaceAll=true;
}

void MSearchDlg::ReplaceComplete(void* pData)
{
	MSearchDlg* thisclass=(MSearchDlg*)pData;

	INode* changeNode=thisclass->LastNode;
	INode* node=thisclass->GetNextSelNode();

	if (node)
	{
		thisclass->pPropEdit->Apply(FALSE,changeNode);
		thisclass->pPropEdit->ParseUserProps(node);
		
		// Scan through the new node without user intervention if ReplaceAll pressed
		if (thisclass->bReplaceAll)
			thisclass->pPropEdit->pRichText->ReplaceAll();
	}
	else
	{
		thisclass->pPropEdit->Apply(FALSE,changeNode);
		thisclass->pPropEdit->pRichText->CloseReplace();
		MessageBox(thisclass->hwnd,"MultiReplace Completed.","MultiReplace",MB_ICONINFORMATION|MB_OK);
		thisclass->Hide();
	}
}

void MSearchDlg::SearchComplete(void* pData)
{
	MSearchDlg* thisclass=(MSearchDlg*)pData;
	
	INode* changeNode=thisclass->LastNode;
	INode* node=thisclass->GetNextSelNode();

	if (node)
	{
		thisclass->pPropEdit->Apply(FALSE,changeNode);
		thisclass->pPropEdit->ParseUserProps(node);
	}
	else
	{
		thisclass->pPropEdit->Apply(FALSE,changeNode);
		thisclass->pPropEdit->pRichText->CloseSearch();
		MessageBox(thisclass->hwnd,"MultiSearch Completed.","MultiSearch",MB_ICONINFORMATION|MB_OK);
		thisclass->Hide();
	}
}

void MSearchDlg::SearchCancelled(void* pData)
{
	MSearchDlg* thisclass=(MSearchDlg*)pData;
	thisclass->bAbort=TRUE;
	thisclass->Hide();
}

void MSearchDlg::Search()
{
	bAbort=FALSE;
	ProcIndex=0;
	INode* node=GetNextSelNode();

	pPropEdit->ParseUserProps(node);

	pPropEdit->pRichText->SearchDlg(SearchComplete,this,
		                            SearchCancelled,this);
}

void MSearchDlg::Replace()
{
	bAbort=FALSE;
	ProcIndex=0;
	INode* node=GetNextSelNode();

	pPropEdit->ParseUserProps(node);

	pPropEdit->pRichText->ReplaceDlg(ReplaceComplete,this,
		                             SearchCancelled,this,
									 ReplaceAllPressed,this);
}

INode* MSearchDlg::GetNextSelNode()
{
	for(;ProcIndex<ListCount;ProcIndex++)
	{
		int bSelected=SendDlgItemMessage(hwnd,IDC_MULTILIST,LB_GETSEL,(WPARAM)ProcIndex,0);

		if (bSelected)
		{
			INode* node=(INode*)SendDlgItemMessage(hwnd,IDC_MULTILIST,LB_GETITEMDATA,(WPARAM)ProcIndex,0);
			LastNode=node;
			ProcIndex++;
			return node;
		}
	}

	return NULL;
}
