/*
	ConfigData.h
	ConfigData structures

	12-20-01
*/

#ifndef __CONFIGDATA__
#define __CONFIGDATA__

#include "max.h"
#include "../misc/llist.h"

// ConfigClass Flags
#define CCLASS_CREATEDATSTART	 0x01
#define CCLASS_ABSENTINNETGAMES  0x02
#define CCLASS_TRICKOBJECT       0x04
#define CCLASS_OCCLUDER          0x08
#define NUM_CCLASSES             4

/////////////////////////// Config file structures
struct ConfigProp
{
	CStr  name;
	CStr  value;
	CStr  extdata;						// Extended data for describing UI information
	DWORD userData;

	bool operator== (ConfigProp& right)
	{
		if (name==right.name)
			return true;

		return false;
	}

	ConfigProp() { userData = 0; }
};

struct ConfigType
{
	CStr                  name;
	CStr                  strCmds;		// Commands/Properties to be added to objects of this type
	CStr                  strGroup;		// Group specifies the submenu hierarchy that this type appears in

	bool operator== (ConfigType& right)
	{
		if (name == right.name)
			return true;

		return false;
	}
};

struct ConfigClass
{
	CStr                  name;			// Name of the class
	CStr                  strCmds;		// Commands/Properties to be added to objects of this class
	CStr                  strGroup;		// Group specifies the submenu hierarchy that this class appears in
	LinkList<ConfigType>  types;		// List of class types

	bool operator== (ConfigClass& right)
	{
		if (name == right.name)
			return true;

		return false;
	}
};

struct ConfigScript
{
	CStr                  name;			// The name of the alternate script
	//CStr                  filename;	// The script file that this script will be written to
	CStr                  buffer;		// The script contents

	bool operator== (ConfigScript& right)
	{
		if (name == right.name)
			return true;

		return false;
	}
};

struct ConfigProgram
{
	CStr  filename;			// The MaxScript file to execute
	CStr  scriptContext;	// The script context that should be created in the PE for this particular program
};

//////////////////////////////////

CStr ParseConfigProps(LinkList<ConfigProp>* cplist,DWORD* flags,CStr& propBuffer,
					  CStr* unkBuf=0,CStr* clusterBuf=0,
					  LinkList<ConfigProgram>* program=0,
					  LinkList<ConfigScript>* scriptList=0);

void ParseArray(LinkList<CStr>* list,CStr value);
CStr GetPropValue(INode* node, CStr propName);
bool RemovePropBufProp(INode* node, CStr propName);
CStr GetClassName(CStr propBuffer);
CStr GetTypeName(CStr propBuffer);

#endif
