#include <next.h>
#include <appdata.h>
#include <Export/ExportOptions.h>
#include <Export/SceneExportOptions.h>

static INT_PTR CALLBACK SceneExportOptionsDlgProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static SceneOptionsDlg *dlg = NULL;
	
	switch(msg) 
	{
		case WM_INITDIALOG:
		{
			SceneExportOptions options;
			ICustEdit* scene_name_ctrl;
			int i;

			dlg = (SceneOptionsDlg*) lParam;

			// Fill the selection set combo box
			for( i = 0; i < gInterface->GetNumNamedSelSets(); i++ )
			{
				SendDlgItemMessage( hWnd, IDC_SELECTION_COMBO, CB_ADDSTRING, 0, 
					(long) gInterface->GetNamedSelSetName( i ));
			}

			GetSceneExportOptions( &options );

			scene_name_ctrl = GetICustEdit( GetDlgItem( hWnd, IDC_SCENE_NAME ));
			scene_name_ctrl->SetText( options.m_SceneName );
			ReleaseICustEdit( scene_name_ctrl );			

			if( options.m_ExportAll )
			{
				SendDlgItemMessage( hWnd, IDC_EXPORT_ALL, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_ExportVisibleOnly )
			{
				SendDlgItemMessage( hWnd, IDC_EXPORT_VISIBLE, BM_SETCHECK, BST_CHECKED, 0 );				
			}
			if( options.m_ExportSelected )
			{
				SendDlgItemMessage( hWnd, IDC_EXPORT_SELECTED, BM_SETCHECK, BST_CHECKED, 0 );				
			}
			if( options.m_Optimized )
			{
				SendDlgItemMessage( hWnd, IDC_OPTIMIZE_GEOMETRY, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_ExportAsSky )
			{
				SendDlgItemMessage( hWnd, IDC_EXPORT_SKY, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_ExportCameras )
			{
				SendDlgItemMessage( hWnd, IDC_EXPORT_CAMS, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_ExportFromOrigin )
			{
				SendDlgItemMessage( hWnd, IDC_EXPORT_CENTERED, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_QuickUpdateSelectedOnly )
			{
				SendDlgItemMessage( hWnd, IDC_QUICK_UPDATE_SELECTED_ONLY, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_DirWarn )
			{
				SendDlgItemMessage( hWnd, IDC_DIRWARN, BM_SETCHECK, BST_CHECKED, 0 );
			}

			if( options.m_ExportSelectionSet )
			{
				HWND sel_combo;
				int index;

				SendDlgItemMessage( hWnd, IDC_EXPORT_SELECTION_SET, BM_SETCHECK, BST_CHECKED, 0 );

				index = SendDlgItemMessage( hWnd, IDC_SELECTION_COMBO, CB_FINDSTRING, 0, (long) (char *) options.m_ExportSet );
				if( index != CB_ERR )
				{
					SendDlgItemMessage( hWnd, IDC_SELECTION_COMBO, CB_SETCURSEL, index, 0 );
				}		

				sel_combo = GetDlgItem( hWnd, IDC_SELECTION_COMBO );
				EnableWindow( sel_combo, TRUE );
			}			
			else
			{
				HWND sel_combo;

				sel_combo = GetDlgItem( hWnd, IDC_SELECTION_COMBO );
				EnableWindow( sel_combo, FALSE );
			}

			ShowWindow( hWnd, SW_SHOW );
			break;
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam)) 
			{
				case IDOK:
				{
					SceneExportOptions options;
					ICustEdit* scene_name_ctrl;
					char scene_name[64];

					scene_name_ctrl = GetICustEdit( GetDlgItem( hWnd, IDC_SCENE_NAME ));
					scene_name_ctrl->GetText( scene_name, 32 );
					options.m_SceneName = TSTR( scene_name );
					ReleaseICustEdit( scene_name_ctrl );			

					options.m_Optimized = SendDlgItemMessage( hWnd, IDC_OPTIMIZE_GEOMETRY, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ExportAsSky = SendDlgItemMessage( hWnd, IDC_EXPORT_SKY, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ExportAll = SendDlgItemMessage( hWnd, IDC_EXPORT_ALL, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ExportCameras = SendDlgItemMessage( hWnd, IDC_EXPORT_CAMS, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ExportFromOrigin = SendDlgItemMessage( hWnd, IDC_EXPORT_CENTERED, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ExportSelected = SendDlgItemMessage( hWnd, IDC_EXPORT_SELECTED, BM_GETCHECK, 0, 0 ) == BST_CHECKED;					
					options.m_ExportVisibleOnly = SendDlgItemMessage( hWnd, IDC_EXPORT_VISIBLE, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_QuickUpdateSelectedOnly = SendDlgItemMessage( hWnd, IDC_QUICK_UPDATE_SELECTED_ONLY, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ExportSelectionSet = SendDlgItemMessage( hWnd, IDC_EXPORT_SELECTION_SET, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_DirWarn = SendDlgItemMessage( hWnd, IDC_DIRWARN, BM_GETCHECK, 0, 0 ) == BST_CHECKED;

					if( options.m_ExportSelectionSet )
					{
						int index;

						index = SendDlgItemMessage( hWnd, IDC_SELECTION_COMBO, CB_GETCURSEL, 0, 0 );
						if( index != CB_ERR )
						{
							char selection_set[128];

							SendDlgItemMessage( hWnd, IDC_SELECTION_COMBO, CB_GETLBTEXT, index, (long) selection_set );
							options.m_ExportSet = selection_set;
						}
					}
					
					SetSceneExportOptions( &options );
					DestroySceneOptionsDialog();
					break;
				}
				case IDCANCEL:
				{					
					DestroySceneOptionsDialog();
					break;
				}
				case IDC_EXPORT_ALL:				
				case IDC_EXPORT_VISIBLE:					
				case IDC_EXPORT_SELECTED:
				{
					HWND sel_combo;

					sel_combo = GetDlgItem( hWnd, IDC_SELECTION_COMBO );
					EnableWindow( sel_combo, FALSE );
					break;
				}
				case IDC_EXPORT_SELECTION_SET:
				{
					HWND sel_combo;

					sel_combo = GetDlgItem( hWnd, IDC_SELECTION_COMBO );
					EnableWindow( sel_combo, TRUE );
					break;
				}
				default:
					break;
			}
		}		
		default:
			return FALSE;
	}

	return TRUE;
}

void	SceneOptionsDlg::Show( void )
{
	m_wnd = CreateDialogParam(
		hInstance,
		MAKEINTRESOURCE(IDD_SCENE_EXPORT_OPTIONS),
		gInterface->GetMAXHWnd(),
		SceneExportOptionsDlgProc,
		(LPARAM)this);	
	TSTR title = "Scene Options";
	SetWindowText( m_wnd, title );
	gInterface->RegisterDlgWnd( m_wnd );
}

void	SceneOptionsDlg::Hide( void )
{
	gInterface->UnRegisterDlgWnd( m_wnd );
	DestroyWindow( m_wnd );	
}

void GetSceneExportOptions( SceneExportOptions* options )
{
	char* options_data;
	
	ReferenceTarget *scene = gInterface->GetScenePointer();
	AppDataChunk* pad = scene->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_SCENE_EXPORT_OPTIONS_ID );

	// Return the export options if they exist
	if( pad && pad->data )
	{
		int version;

		options_data = (char*) pad->data;
		version = *options_data;
		if( version != SceneExportOptions::vVERSION_NUMBER && 
			version != 0x0002 &&
			version != 0x0003 &&
			version != 0x0004)		// We will be backward compat aml
		{
			// for now, don't be backward compatible. This will force the dialog
			// to use the default values
			scene->RemoveAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_SCENE_EXPORT_OPTIONS_ID );			
		}		
		else
		{
			char scene_name[SceneExportOptions::vMAX_LENGTH_SCENE_NAME];
			char set_name[SceneExportOptions::vMAX_LENGTH_EXPORT_SET];

			memcpy( &options->m_Version, options_data, sizeof( int ));
			options_data += sizeof( int );
			memcpy( &options->m_Optimized, options_data, sizeof( bool ));
			options_data += sizeof( bool );
			memcpy( &options->m_ExportAsSky, options_data, sizeof( bool ));
			options_data += sizeof( bool );
			memcpy( &options->m_ExportVisibleOnly, options_data, sizeof( bool ));
			options_data += sizeof( bool );
			memcpy( &options->m_ExportAll, options_data, sizeof( bool ));
			options_data += sizeof( bool );
			memcpy( &options->m_ExportSelected, options_data, sizeof( bool ));
			options_data += sizeof( bool );
			memcpy( &options->m_ExportSelectionSet, options_data, sizeof( bool ));
			options_data += sizeof( bool );

			memcpy( scene_name, options_data, SceneExportOptions::vMAX_LENGTH_SCENE_NAME );
			options_data += SceneExportOptions::vMAX_LENGTH_SCENE_NAME;
			options->m_SceneName = TSTR( scene_name );
			memcpy( set_name, options_data, SceneExportOptions::vMAX_LENGTH_EXPORT_SET );
			options_data += SceneExportOptions::vMAX_LENGTH_EXPORT_SET;
			options->m_ExportSet = set_name;		

			if (version>=0x0003)
			{
				memcpy( &options->m_ExportCameras , options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}

			if (version>=0x0004)
			{
				memcpy( &options->m_ExportFromOrigin, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}

			if (version>=0x0005)
			{
				memcpy( &options->m_QuickUpdateSelectedOnly, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}

			if (version>=0x0006)
			{
				memcpy( &options->m_DirWarn, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}
			else
			{
				*((bool*)options_data) = true;
				options_data += sizeof( bool );
			}
		}
	}
}

void SetSceneExportOptions( SceneExportOptions* options )
{
	char scene_name[SceneExportOptions::vMAX_LENGTH_SCENE_NAME];
	char set_name[SceneExportOptions::vMAX_LENGTH_EXPORT_SET];
	char* options_data;
	AppDataChunk* pad;
	ReferenceTarget *scene;
	int version;

	assert( options );

	scene = gInterface->GetScenePointer();	
	pad = scene->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_SCENE_EXPORT_OPTIONS_ID );
	
	// Having some problems with old chunk size being retained (due to backward compat code)
	// This will now force the chunk to be correct   aml
	scene->RemoveAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_SCENE_EXPORT_OPTIONS_ID );			

	//if( !pad )
	{
		options_data = new char[GetSizeSceneExportOptions()];		
		scene->AddAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_SCENE_EXPORT_OPTIONS_ID, 
								GetSizeSceneExportOptions(), (void*) options_data );	
	}
	//else
	//{
	//	options_data = (char*) pad->data;
	//}

	version = SceneExportOptions::vVERSION_NUMBER;
	memcpy( options_data, &version, sizeof( int ));
	options_data += sizeof( int );
	memcpy( options_data, &options->m_Optimized, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ExportAsSky, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ExportVisibleOnly, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ExportAll, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ExportSelected, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ExportSelectionSet, sizeof( bool ));
	options_data += sizeof( bool );
	strcpy( scene_name, options->m_SceneName );
	memcpy( options_data, scene_name, SceneExportOptions::vMAX_LENGTH_SCENE_NAME );
	options_data += SceneExportOptions::vMAX_LENGTH_SCENE_NAME;
	strcpy( set_name, options->m_ExportSet );
	memcpy( options_data, set_name, SceneExportOptions::vMAX_LENGTH_EXPORT_SET );
	options_data += SceneExportOptions::vMAX_LENGTH_EXPORT_SET;	
	memcpy( options_data, &options->m_ExportCameras, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ExportFromOrigin, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_QuickUpdateSelectedOnly, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_DirWarn, sizeof( bool ));
	options_data += sizeof( bool );
}

int	GetSizeSceneExportOptions( void )
{
	int size;

	size = 0;
	
	size += sizeof( int );	//	int		m_Version;
	size += sizeof( bool );	//	bool	m_Optimized;
	size += sizeof( bool );	//	bool	m_ExportAsSky;
	size += sizeof( bool );	//	bool	m_ExportVisibleOnly;
	size += sizeof( bool );	// 	bool	m_ExportAll;
	size += sizeof( bool );	//	bool	m_ExportSelected;
	size += sizeof( bool );	// 	bool	m_ExportSelectionSet;
	size += SceneExportOptions::vMAX_LENGTH_SCENE_NAME;	//	TSTR	m_SceneName;
	size += SceneExportOptions::vMAX_LENGTH_EXPORT_SET;	//	TSTR	m_ExportSet;
	size += sizeof( bool );	//  bool    m_ExportCameras;
	size += sizeof( bool ); //  bool    m_ExportFromOrigin
	size += sizeof( bool );	//  bool	m_QuickUpdateSelectedOnly
	size += sizeof( bool ); //  bool    m_DirWarn

	return size;
}

SceneExportOptions::SceneExportOptions( void )
{
	m_Optimized = true;
	m_ExportAsSky = false;
	m_SceneName = TSTR( "default" );
	m_ExportVisibleOnly = true;		
	m_ExportAll = false;		
	m_ExportSelected = false;
	m_ExportSelectionSet = false;
	m_ExportSet = "";		
	m_ExportCameras = true;
	m_ExportFromOrigin = false;
	m_QuickUpdateSelectedOnly = true;
	m_DirWarn = true;
}
