/*
	AnimTol.cpp
	AnimTol.ini File Format Structures
	4-11-01
*/

#include "AnimTol.h"
#include "misc/llist.h"
#include "../propedit/parsefuncs.h"

AnimTolFile::AnimTolFile(char* Filename)
{
	Load(Filename);
}

AnimTolFile::AnimTolFile()
{

}

AnimTolFile::~AnimTolFile()
{

}

bool AnimTolFile::Load(char* Filename)
{
	FILE* fp;
	fp = fopen(Filename,"r");

	bool rVal = Load(fp);

	if (fp)
		fclose(fp);

	return rVal;
}


bool AnimTolFile::Load(FILE* fp)
{
	if (!fp)
		return false;

	char              lineBuf[256];
	AniTolFileState   state;
	GlobalTolRecord*  lastRecord;			// The last tolerance record added

	while(!feof(fp))
	{
		CStr strLine;
		fgets(lineBuf,255,fp);
		strLine = lineBuf;

		int cbrackL = Instr(lineBuf,"{");
		int cbrackR = Instr(lineBuf,"}");

		int brackL = Instr(lineBuf,"[");
		int brackR = Instr(lineBuf,"]");

		// Switch to appropriate add section
		if (cbrackL != -1 && cbrackR != -1 && cbrackR > cbrackL)
		{
			CStr strToken = strLine.Substr(cbrackL+1,cbrackR-1);
			strToken.toLower();

			if (strToken==CStr(vANITOL_ROTATION_TOKEN))
				state = vROTATION;

			if (strToken==CStr(vANITOL_TRANSLATION_TOKEN))
				state = vTRANSLATION;

			continue;
		}
		
		// See if we should add a new tolerance record
		if (brackL != -1 && brackR != -1 && brackR > brackL)
		{
			CStr strToken = strLine.Substr(brackL+1,brackR-1);

			GlobalTolRecord newrec;
			newrec.name = strToken;

			Link<GlobalTolRecord>* link = DB.AddToTailFindUnique(&newrec);
			lastRecord = &link->data;
			continue;
		}

		// See if we should add a sub record
		int eqPos = Instr(strLine,"=");
		
		if (eqPos!=-1 && lastRecord)
		{
			TolRecord newrec;
			CStr       value = Right(strLine,eqPos+1);
			
			newrec.name  = Left(strLine,eqPos);
			
			Link<TolRecord>* link = lastRecord->DB.AddToTailFindUnique(&newrec);
			
			switch(state)
			{
			case vROTATION:
				link->data.bHasRot = true;
				link->data.valRot  = atof(value);
				break;

			case vTRANSLATION:
				link->data.bHasTran = true;
				link->data.valTran  = atof(value);
				break;
			}
		}
	}

	return true;
}

bool AnimTolFile::Save(char* Filename)
{
	FILE* fp;
	fp = fopen(Filename,"w");

	bool rVal = Save(fp);

	if (fp)
		fclose(fp);

	return rVal;
}

bool AnimTolFile::Save(FILE* fp)
{
	if (!fp)
		return false;

	// Dump rotation tolerance presets
	if (DB.GetSize()>0)
	{
		Link<GlobalTolRecord>* curGLink = DB.GetHead();

		while(curGLink)
		{
			fprintf(fp,"[%s]\n",(char*)curGLink->data.name);

			fprintf(fp,"{Rotations}\n");

			Link<TolRecord>* curLink = curGLink->data.DB.GetHead();

			while(curLink)
			{
				if (curLink->data.bHasRot)
					fprintf(fp,"%s=%f",(char*)curLink->data.name,curLink->data.valRot);

				curLink=curLink->next;
			}

			fprintf(fp,"{Translations}\n");

			curLink = curGLink->data.DB.GetHead();

			while(curLink)
			{
				if (curLink->data.bHasTran)
					fprintf(fp,"%s=%f",(char*)curLink->data.name,curLink->data.valTran);

				curLink=curLink->next;
			}

			curGLink=curGLink->next;
		}
	}

	return true;
}

void AnimTolFile::Reset()
{
	DB.Clear();
}

AnimSubTolFile::AnimSubTolFile()
{

}
AnimSubTolFile::AnimSubTolFile(char* Filename)
{

}

AnimSubTolFile::~AnimSubTolFile()
{

}

void AnimSubTolFile::Reset()
{
	rotDB.Clear();
	tranDB.Clear();
}

bool AnimSubTolFile::Load(char* Filename)
{
	FILE* fp = fopen(Filename, "r");

	bool rVal = Load(fp);

	if (fp)
		fclose(fp);

	return rVal;
}

bool AnimSubTolFile::Load(FILE* fp)
{
	if (!fp)
		return false;

	char            lineBuf[256];
	CStr            strLine;
	AniTolFileState state;

	while(!feof(fp))
	{
		fgets(lineBuf,255,fp);
		strLine=lineBuf;

		int cbrackL = Instr(lineBuf,"{");
		int cbrackR = Instr(lineBuf,"}");

		// Switch to appropriate add section
		if (cbrackL != -1 && cbrackR != -1 && cbrackR > cbrackL)
		{
			CStr strToken = strLine.Substr(cbrackL+1,cbrackR-1);
			strToken.toLower();

			if (strToken==CStr(vANITOL_ROTATION_TOKEN))
				state = vROTATION;

			if (strToken==CStr(vANITOL_TRANSLATION_TOKEN))
				state = vTRANSLATION;

			continue;
		}

		int pos = Instr(lineBuf,"=");
		if (pos!=-1)
		{
			switch(state)
			{
			case vROTATION:
				{
					Link<TolRecord>* link = rotDB.Add();
					link->data.name  = Left(lineBuf,pos);

					link->data.bHasRot = true;
					link->data.valRot  = atof(Right(lineBuf,pos+1));
				}
				break;
			case vTRANSLATION:
				{
					Link<TolRecord>* link = tranDB.Add();
					link->data.name  = Left(lineBuf,pos);
				
					link->data.bHasTran = true;
					link->data.valTran = atof(Right(lineBuf,pos+1));
				}
				break;
			}
		}
	}

	return true;
}

bool AnimSubTolFile::Save(char* Filename)
{
	FILE* fp = fopen(Filename,"w");
	bool rVal = Save(fp);
	
	if (fp)
		fclose(fp);

	return rVal;
}

bool AnimSubTolFile::Save(FILE* fp)
{
	if (!fp)
		return false;

	// Dump rotations
	fprintf(fp,"{Rotations}\n");

	Link<TolRecord>* curlink = rotDB.GetHead();

	while(curlink)
	{
		if (curlink->data.bHasRot)
			fprintf(fp,"%s=%f\n",curlink->data.name,curlink->data.valRot);

		curlink=curlink->next;
	}

	// Dump translations
	fprintf(fp,"{Translations}\n");

	curlink = tranDB.GetHead();

	while(curlink)
	{
		if (curlink->data.bHasTran)
			fprintf(fp,"%s=%f",curlink->data.name,curlink->data.valTran);

		curlink=curlink->next;
	}

	return true;
}

////////////  TolData

void TolData::Reset()
{
	DB.Clear();
}

bool TolData::Load(char* Filename)
{
	FILE* fp = fopen(Filename,"r");

	bool rVal = Load(fp);

	if (fp)
		fclose(fp);

	return rVal;
}

bool TolData::Load(FILE* fp)
{
	if (!fp)
		return false;

	char            lineBuf[256];
	CStr            strLine;
	AniTolFileState state;

	while(!feof(fp))
	{
		fgets(lineBuf,255,fp);
		strLine=lineBuf;

		if (IsInstr(strLine,"[End]"))
			break;

		int cbrackL = Instr(lineBuf,"{");
		int cbrackR = Instr(lineBuf,"}");

		// Switch to appropriate add section
		if (cbrackL != -1 && cbrackR != -1 && cbrackR > cbrackL)
		{
			CStr strToken = strLine.Substr(cbrackL+1,cbrackR-1);
			strToken.toLower();

			if (strToken==CStr(vANITOL_ROTATION_TOKEN))
				state = vROTATION;

			if (strToken==CStr(vANITOL_TRANSLATION_TOKEN))
				state = vTRANSLATION;

			continue;
		}

		int pos = Instr(lineBuf,"=");
		if (pos!=-1)
		{
			switch(state)
			{
			case vROTATION:
				{
					Link<TolRecord>* link = DB.Add();
					link->data.name  = Left(lineBuf,pos);

					// Does this use a rotation preset?
					if (link->data.name[0]=='+')
					{
						//sscanf(link->data.name,"+%s+%s",presetName,boneName);
						int pos = Instr(((char*)link->data.name)+1,"+");

						if (pos!=-1)
						{
							CStr presetName;
							CStr boneName;
						
							presetName = link->data.name.Substr(1,pos);
							boneName   = link->data.name.Substr(pos+2,link->data.name.Length());

							link->data.bRotPreset    = true;
							link->data.rotPresetName = presetName;
							link->data.name          = boneName;
						}
					}

					link->data.bHasRot = true;
					link->data.valRot  = atof(Right(lineBuf,pos+1));
				}
				break;
			case vTRANSLATION:
				{
					Link<TolRecord>* link = DB.Add();
					link->data.name  = Left(lineBuf,pos);

					// Does this use a rotation preset?
					if (link->data.name[0]=='+')
					{
						char presetName[256];
						char boneName[256];

						sscanf(link->data.name,"+%s+%s",presetName,boneName);
						
						link->data.bTranPreset    = true;
						link->data.tranPresetName = presetName;
						link->data.name           = boneName;
					}

					link->data.bHasTran = true;
					link->data.valTran = atof(Right(lineBuf,pos+1));
				}
				break;
			}
		}
	}

	return true;
}

bool TolData::Save(char* Filename)
{
	FILE* fp = fopen(Filename,"w");
	bool rVal = Save(fp);
	
	if (fp)
		fclose(fp);

	return rVal;
}

bool TolData::Save(FILE* fp)
{
	if (!fp)
		return false;

	// Dump rotations
	fprintf(fp,"{Rotations}\n");

	Link<TolRecord>* curlink = DB.GetHead();

	while(curlink)
	{
		if (curlink->data.bHasRot)
		{
			if (curlink->data.bRotPreset)
				fprintf(fp,"+%s+%s=%f\n",(char*)curlink->data.rotPresetName,curlink->data.name,curlink->data.valRot);
			else
				fprintf(fp,"%s=%f\n",curlink->data.name,curlink->data.valRot);
		}

		curlink=curlink->next;
	}

	// Dump translations
	fprintf(fp,"{Translations}\n");

	curlink = DB.GetHead();

	while(curlink)
	{
		if (curlink->data.bHasTran)
		{
			if (curlink->data.bTranPreset)
				fprintf(fp,"+%s+%s=%f\n",(char*)curlink->data.tranPresetName,curlink->data.name,curlink->data.valTran);
			else
				fprintf(fp,"%s=%f\n",curlink->data.name,curlink->data.valTran);
		}

		curlink=curlink->next;
	}

	fprintf(fp,"[End]\n");

	return true;

}
