/*
	BitArray.cpp
	This class is responsible for traversing arrays at the bit level

	8-19-01 aml
*/

#include "BitArray.h"
#include <assert.h>
#include <memory.h>

BArray::BArray(void* pdata, int bpe)
{
	loc = (unsigned char*)pdata;
	bitsPerEntry = bpe;
}

BArray::BArray(void* pdata)
{
	loc = (unsigned char*)pdata;
	bitsPerEntry = 0;
}

BArray::~BArray()
{

}

bool BArray::operator[](int i)
{
	return (loc[(int)((float)i / 8.0f)] & (0x80 >> (i % 8) )) ? true : false;
}

void BArray::SetBit(int i)
{
	loc[(int)((float)i / 8.0f)] |= 0x80 >> (i % 8);
}

void BArray::ClearBit(int i)
{
	loc[(int)((float)i / 8.0f)] &= ~(0x80 >> (i % 8));
}

void BArray::GetVal(void* val, int idx)
{
	int fBit = idx * bitsPerEntry;
	unsigned char* cval = (unsigned char*)val;

	assert(bitsPerEntry > 0);

	BArray ba(cval);

	for(int i = 0; i < bitsPerEntry; i++)
		if ((*this)[fBit + i])
			ba.SetBit(i);
		else
			ba.ClearBit(i);
}

void BArray::GetVal(void* val, int valSize, int idx)
{
	int fBit = idx * bitsPerEntry;
	unsigned char* cval = (unsigned char*)val;
	int bitStart = (valSize * 8) - bitsPerEntry;

	memset(val,0,valSize);
	assert(bitsPerEntry > 0);

	BArray ba(cval);

	for(int i = 0; i < bitsPerEntry; i++)
		if ((*this)[fBit + i])
			ba.SetBit(bitStart + i);
		else
			ba.ClearBit(bitStart + i);

	SwapEndian( cval, valSize );
}

void BArray::SwapEndian( unsigned char* src, unsigned int numBytes )
{

	unsigned char  tmp[8];  // large enough to hold a double
	unsigned int max, i;

	if( (numBytes == 0) || (numBytes == 1) )
	{
		return;
	}
					
	max = numBytes - 1;
	for(i=0; i< numBytes; i++)
	{
		tmp[(max - i)] = src[i];	
	}
	
	for(i=0; i< numBytes; i++)
	{
		src[i] = tmp[i];
	}
}
