/*
	NExtGlobals.h
	Neversoft global identifiers accessible to MAXScript
	4-17-01  aml
*/

#ifndef __NEXTGLOBALS__
#define __NEXTGLOBALS__

/*
enum
{
	mFD_SKATABLE			= 0x00000001,
	mFD_NOT_SKATABLE		= 0x00000002,
	mFD_WALL_RIDABLE		= 0x00000004,
	mFD_VERT				= 0x00000008,
	mFD_NON_COLLIDABLE		= 0x00000010,
	mFD_DECAL				= 0x00000020,
	mFD_TRIGGER				= 0x00000040,
	mFD_CAMERA_COLLIDABLE	= 0x00000080,
	mFD_NO_SKATER_SHADOW	= 0x00000100,
	mFD_SKATER_SHADOW		= 0x00000200,
	mFD_NO_SKATER_SHADOW_WALL=0x00000400,
	mFD_UNDER_OK			= 0x00000800,
	mFD_INVISIBLE			= 0x00001000,
	mFD_CASFACEFLAGSEXIST   = 0x00002000,	// To be backward compat with non - CAS Face flag versions
											// since versioning data isn't being exported
	mFD_PASS_1_DISABLED     = 0x00004000,	// Set only if pass 1 is turned off (so it defaults on for everything)
	mFD_PASS_2_ENABLED      = 0x00008000,
	mFD_PASS_3_ENABLED      = 0x00010000,
	mFD_PASS_4_ENABLED      = 0x00020000,
};
*/

// These flags must correspond to the specific bit in the NExt.gup's FaceFlags
enum
{
	NSF_SKATABLE,
	NSF_NOT_SKATABLE,
	NSF_WALL_RIDABLE,          
	NSF_VERT,
	NSF_NON_COLLIDABLE,
	NSF_DECAL,
	NSF_TRIGGER,
	NSF_CAMERA_COLLIDABLE,
	NSF_NO_SKATER_SHADOW,    
	NSF_SKATER_SHADOW,     
	NSF_NO_SKATER_SHADOW_WALL,
	NSF_UNDER_OK,
	NSF_INVISIBLE,          
	NSF_CASFACEFLAGSEXIST,      // unused

	NSF_PASS1_DISABLED,	// Note this indicates disabled in the GUP
	NSF_PASS2,
	NSF_PASS3,
	NSF_PASS4,
};

void RegisterGlobals();

#endif
