
// makewad.cpp :
//

#include "stdafx.h"
#include "stdio.h"
#include "string.h"
#include "stdlib.h"
#include "conio.h"

#define SECTOR_SIZE 2048

FILE *listfp=NULL;
FILE *wadfp=NULL;
FILE *hedfp=NULL;
FILE *hedextfp = NULL;
char *pBuf=NULL;
char pPadding[SECTOR_SIZE];

char *pSkate4Path=NULL;

void CleanUp()
{
	if (listfp!=NULL)
	{
		fclose(listfp);
		listfp=NULL;
	}
	if (wadfp!=NULL)
	{
		fclose(wadfp);
		wadfp=NULL;
	}
	if (hedfp!=NULL)
	{
		fclose(hedfp);
		hedfp=NULL;
	}
	if (hedextfp!=NULL)
	{
		fclose(hedextfp);
		hedextfp=NULL;
	}
	if (pBuf!=NULL)
	{
		free(pBuf);
		pBuf=NULL;
	}

}

void Assert(bool Condition, char *pMessage)
{
	if (!Condition)
	{
		printf("MakeWad assertion failed:\n%s",pMessage);
		CleanUp();
		exit(1);
	}
}

// Returns true if pString is prefixed by pPrefix.
bool PrefixedBy(const char *pPrefix, const char *pString)
{
	const char *pA=pPrefix;
	const char *pB=pString;
	while (true)
	{
		if (*pB==0) break;
		if (tolower(*pA)!=tolower(*pB)) break;
		++pA;
		++pB;
	}

	if (*pA==0)
	{
		return true;
	}
	else
	{
		return false;
	}
}

bool PrefixedByPath(const char *pPath, const char *pString)
{
	Assert(pSkate4Path!=NULL,"NULL pSkate4Path");
	char pFullPath[1000];
	sprintf(pFullPath,"%s%s",pSkate4Path,pPath);
	return PrefixedBy(pFullPath,pString);
}

bool IncludeInWad(const char *pFilename)
{
	const char *pExtension=strrchr(pFilename,'.');

	//Assert(pExtension!=NULL,"File name has no extension.");

	if (pExtension == NULL)
	{
		printf ("WARNING: file <%s> has no extension, ignoring\n",pFilename);
		return false;
	}

	++pExtension;

	const char *pName=strrchr(pFilename,'\\');
	if (pName==NULL)
	{
		pName=pFilename;
	}
	else
	{
		++pName;
	}

	if (PrefixedByPath("\\data\\music\\",pFilename)) return false;
	// Only remove data\streams if we don't find dsp.
	if ( strstr( pFilename, "dsp\\" ) == NULL )
	{
		if (PrefixedByPath("\\data\\streams\\",pFilename)) return false;
	}

// Mick: Including sounds for now, as I'm not sure what is going on with
// pre files and such

//	if (PrefixedByPath("\\data\\sounds\\",pFilename)) return false;
// Mick:  we now burn all the images on CD,  to simplify things
//	if (PrefixedByPath("\\data\\images\\FRimages",pFilename)) return false;
//	if (PrefixedByPath("\\data\\images\\GRimages",pFilename)) return false;
//	if (PrefixedByPath("\\data\\images\\PALimages",pFilename)) return false;

	if (PrefixedByPath("\\data\\PALfonts",pFilename)) return false;

	if (PrefixedByPath("\\data\\iopmodules\\",pFilename)) return false;
	if (PrefixedByPath("\\data\\anims\\",pFilename)) return false;
	if (PrefixedByPath("\\data\\dumps\\",pFilename)) return false;
	if (PrefixedByPath("\\data\\screens\\",pFilename)) return false;

	// All subdirectories of the levels directory need to be excluded, apart from
	// certain subdirectories.
	if (PrefixedByPath("\\data\\levels\\",pFilename))
	{
		if (PrefixedByPath("\\data\\levels\\sk3ed",pFilename))
		{
			// OK to include.
		}
		else
		{
//			return false;
			// Actually (Mick), inlcude them for now, as level asset stripping not implemented

			// Ken: ... but now level asset stripping is in again, so don't include them.
			
			// Mick, except for .geoms!!!  as they don't go in the pre files yet.
			if (stricmp(&pExtension[-5],"geom.ps2")==0) return true;   // note the cunning use of -5!!!!
			// Mick .. 
			if (stricmp(&pExtension[-1],".qb")==0) return true;   // note the cunning use of -1!!!!
			
 			return false;
		}
	}

	// All subdirectories of the models directory need to be excluded, apart from
	// the three skater subdirectories.
	if (PrefixedByPath("\\data\\models\\",pFilename))
	{
		if (PrefixedByPath("\\data\\models\\skater_demon",pFilename) ||
			PrefixedByPath("\\data\\models\\skater_f",pFilename) ||
			PrefixedByPath("\\data\\models\\skater_m",pFilename))
		{
			// OK to include.
		}
		else
		{
			// Actually, include all of them, cos it was causing problems.
			//return false;
		}
	}

	// Q script source files.
	if (stricmp(pExtension,"q")==0) return false;
	if (stricmp(pExtension,"qn")==0) return false;

	// Source safe file.
	if (stricmp(pExtension,"scc")==0) return false;

	// Texture library dependency files.
	if (stricmp(pExtension,"dep")==0) return false;

	// Don't include wav's, since they aren't put in the wad but are
	// stored in a separate directory on the CD.
	if (stricmp(pExtension,"wav")==0) return false;

	// Usg files are small, but we still don't need them
	if (stricmp(pExtension,"usg")==0) return false;
	if (stricmp(pExtension,"usg.ps2")==0) return false;


	// ignore non-platform-specific files
	if (stricmp(pExtension,"scn")==0) return false;
	if (stricmp(pExtension,"mdl")==0) return false;
	if (stricmp(pExtension,"tex")==0) return false;
	if (stricmp(pExtension,"skin")==0) return false;


	// png will all be converted to .img.ps2
	if (stricmp(pExtension,"png")==0) return false;


	// fnt and ska files are stored in .pre files rather than the wad.
	//if (stricmp(pExtension,"fnt")==0) return false;
	//if (stricmp(pExtension,"ska")==0) return false;


	// Various script stuff not needed.
	if (stricmp(pName,"qcomp.map")==0) return false;
	if (stricmp(pName,"scripts.ini")==0) return false;
	if (stricmp(pName,"formats.f")==0) return false;
	if (stricmp(pName,"clist.txt")==0) return false;

	// Exclude the CD music hed and wad
	if (stricmp(pExtension,"hed")==0) return false;
	if (stricmp(pExtension,"wad")==0) return false;

	return true;
}

#define MAXFILENAMECHARS 255

#define	MAX_FILE_SIZE		(32*1024*1024)  // Max size is all of the PS2 memory

int main(int argc, char* argv[])
{
	pSkate4Path=getenv("PROJ_ROOT");
	Assert(pSkate4Path!=NULL,"The environment variable PROJ_ROOT is not set.");

	bool hed_only = false;

	if (!(argc==3 || argc==4))
	{
		printf("\n");
		if (argc>4)
		{
			printf("Too many arguments!\n\n");
		}
		printf("MakeWad.exe, %s\n",__DATE__);
		printf("Requires the name of the file listing file,\n");
		printf("followed by the name of the wad file to create, then\n");
		printf("optionally a path to strip from the full filename when\n");
		printf("inserting the filename in the .hed file.\n");
		printf("For example:\n");
		printf("makewad c:\\ps2cd\\data.txt c:\\ps2cd\\Skate5.wad c:\\Skate5\\data\\\n\n");
		exit(1);
	}

	if (argc==4)
	{
		Assert(argv[3][strlen(argv[3])-1]!='\\',"3rd parameter must not end in a '\\'");
	}

	for (int i=0; i<SECTOR_SIZE; ++i)
	{
		pPadding[i]=0;
	}

	listfp=fopen(argv[1],"r");
	Assert(listfp!=NULL,"Could not open listing file.");


	// Check that the extension is .wad.
	char *pExtension=strrchr(argv[2],'.');
	Assert(pExtension!=NULL,"Wad file must have extension .wad");
	++pExtension;
	if (stricmp(pExtension,"hed") == 0)
	{
		hed_only = true;
		printf("Making hed files only\n");
	}
	else
	{
		Assert(stricmp(pExtension,"wad")==0,"Wad file must have extension .wad");
	}

	// Open the wad file for writing.
	if (!hed_only)
	{
		wadfp=fopen(argv[2],"wb");
		Assert(wadfp!=NULL,"Could not open wad file for writing.");

		// Change the extension to .hed
		pExtension[0]='h';
		pExtension[1]='e';
	}
	else
	{
		// Open .hedext file for writing
		char hedext_name[1000];

		strcpy(hedext_name, argv[2]);
		strcat(hedext_name, "ext");

		//hedextfp=fopen(hedext_name,"wb");
		//Assert(hedextfp!=NULL,"Could not open hedext file for writing.");
	}

	// Open .hed for writing.
	hedfp=fopen(argv[2],"wb");
	Assert(hedfp!=NULL,"Could not open hed file for writing.");

	long Offset=0;

	pBuf=(char*)malloc(MAX_FILE_SIZE);
	Assert(pBuf != NULL, "Failed to allocate file read buffer");


    // Check each of the files listed.
    while (true)
    {
        // File name buffer.
        char NameBuf[MAXFILENAMECHARS+1];
        // Make sure it is terminated in case the "too many chars" assert goes off.
        NameBuf[MAXFILENAMECHARS]=0;

        // Load each character into the buffer until end-of-line or end-of-file.
        int i=0;
        while (true)
        {
            Assert(i<=MAXFILENAMECHARS,"Too many chars in filename.");
			char ch=fgetc(listfp);

            // Check if end-of-file or end-of-line.
            if (ch==EOF || ch=='\n')
            {
                // Terminate the current string.
                NameBuf[i]=0;
                break;
            }

			NameBuf[i]=ch;
            ++i;
        }

        if (NameBuf[0])
		{
			if (IncludeInWad(NameBuf))
			{
				FILE *ifp=fopen(NameBuf,"rb");
				Assert(ifp!=NULL,"Could not open file.");

				fseek(ifp,0,SEEK_END);
				long FileSize=ftell(ifp);
				if (FileSize==0)
				{
					printf("The file '%s' has zero size. SKIPPING!\n",NameBuf);
				//	Assert(0,"Error !!!");
				}
				else
				{


					long FilePadSize=FileSize%SECTOR_SIZE;
					if (FilePadSize)
					{
						FilePadSize=SECTOR_SIZE-FilePadSize;
					}
					//Assert(pBuf==NULL,"pBuf not NULL ?");

					if (FileSize > MAX_FILE_SIZE)
					{
						printf ("File %s too big (%d bytes)\n",NameBuf,FileSize);
						Assert(0,"Aborting");
					}

					if (!hed_only)
					{
						fseek(ifp,0,SEEK_SET);
						Assert(fread(pBuf,FileSize,1,ifp)==1,"fread failed");

// zero padding at the end of the file
// so we just need one fwrite for the wad
						char *pZero = pBuf + FileSize;
						for (int z = 0; z<FilePadSize; z++)
						{
							*pZero++ = 0;
						}
						Assert(fwrite(pBuf,FileSize+FilePadSize,1,wadfp)==1,"fwrite failed");

//						if (FilePadSize)
//						{
//							Assert(fwrite(pPadding,FilePadSize,1,wadfp)==1,"fwrite failed (when writing sector padding)");
//						}
					}

					// Write the .hed entry.
					Assert((ftell(hedfp)&3)==0,"Not long word aligned in hedfp");
					Assert((Offset%SECTOR_SIZE)==0,"Offset not sector aligned.");

					Assert(fwrite(&Offset,4,1,hedfp)==1,"fwrite failed writing offset into .hed");
					Assert(fwrite(&FileSize,4,1,hedfp)==1,"fwrite failed writing file size into .hed");

					char *pName=NameBuf;
					// If a path was specified, strip it off the front.
					if (argc==4)
					{
						char *pPath=argv[3];
						while (*pPath && tolower(*pName)==tolower(*pPath))
						{
							++pName;
							++pPath;
						}
						Assert(*pPath==0,"File name does not start with specified path.");
					}

					// Get rid of the dsp folder.
					char * p = strstr( pName, "dsp\\" );
					if ( p )
					{
						strcpy( p, &p[4] );
						// strip off the .vag extension:
						for ( i = strlen( pName ) - 1; i > 0; i-- )
						{
							if ( pName[ i ] == '.' )
							{
								pName[ i ] = '\0';
							}
						}
					}

					int Len=strlen(pName);
					Assert(fwrite(pName,Len+1,1,hedfp)==1,"fwrite failed writing file name into .hed");
					int StringPadSize=(Len+1)&3;
					if (StringPadSize)
					{
						StringPadSize=4-StringPadSize;
					}
					if (StringPadSize)
					{
						Assert(fwrite(pPadding,StringPadSize,1,hedfp)==1,"fwrite failed when writing string padding to .hed");
					}

					printf("%s\n",pName);

					Offset+=FileSize+FilePadSize;
				}
				fclose(ifp);
			}
		}
        else
            break;
    }

	long Terminator=0xffffffff;
	Assert((ftell(hedfp)&3)==0,"Not long word aligned in hedfp when writing terminator.");
	Assert(fwrite(&Terminator,4,1,hedfp)==1,"fwrite failed writing .hed terminator.");


	CleanUp();
	return 0;
}

