/*
	RenderWindow.h
	This window is responsible for rendering the scene
	aml - 9-26-01
*/

#ifndef __RENDERWINDOW__
#define __RENDERWINDOW__

#include "UIControl.h"
#include <gl/gl.h>
#include <gl/glu.h>
#include <gl/glext.h>

#define CLASSNAME_RENDERWINDOW  "RenderWindow"

class RenderWindow: public UIControl
{
	HWND      hwndGL;
	HGLRC     hglrc;		// Main OpenGL Rendering context
	HDC       hdc;

	bool InitGL(HDC hdc);
	void UpdateGL(HDC hdc);
	void ShutdownGL();

public:
	CLASSNAME(CLASSNAME_RENDERWINDOW);

	RenderWindow(HINSTANCE hInstance);
	RenderWindow(HINSTANCE hInstance, HWND hwnd);
	~RenderWindow();

	void BuildControlUI();

	LRESULT WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void Update();
};

#endif
