/*
	RenderWindow.cpp
	This window is responsible for rendering the scene
	aml - 9-26-01
*/

#include "stdafx.h"
#include "RenderWindow.h"
#include <assert.h>
#include "../InterMax/DataNotifyCodes.h"	// InterMax.gup message notification codes for IPC with 3DSMAX
#include "WorldStructs.h"

extern int nVerts, nFaces;
extern imlVert* verts;
extern imlFace* faces;

extern NxObject* pRenderObj;

RenderWindow::RenderWindow(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{
}

RenderWindow::RenderWindow(HINSTANCE hInstance, HWND hwnd) :
	UIControl(hInstance, CLASS)
{
}

RenderWindow::~RenderWindow()
{
	ShutdownGL();
	DestroyWindow(hwndGL);
}

LRESULT CALLBACK GLWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

void RenderWindow::BuildControlUI()
{
	RECT wndRect;
	GetWindowRect(hwnd, &wndRect);

	unsigned int width  = wndRect.right  - wndRect.left;
	unsigned int height = wndRect.bottom - wndRect.top;

	WNDCLASSEX wcex;

	wcex.cbSize         = sizeof(WNDCLASSEX); 
	wcex.style			= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wcex.lpfnWndProc	= (WNDPROC)GLWndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= NULL;
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= "GLRENDERWINDOW";
	wcex.hIconSm		= NULL;

	RegisterClassEx(&wcex);

	hwndGL = CreateWindow("GLRENDERWINDOW", 
		                  "Level Editor",
						  WS_CHILD | WS_VISIBLE,/*WS_OVERLAPPEDWINDOW*/
						  0,
						  0,
						  width, 
						  height,
						  hwnd,
						  NULL,
						  hInstance,
						  NULL);

	hdc = GetDC(hwndGL);
	InitGL(hdc);
}

LRESULT RenderWindow::WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	

	return DefWindowProc(hwnd, msg, wParam, lParam);
}

bool RenderWindow::InitGL(HDC hdc)
{
	PIXELFORMATDESCRIPTOR pfd;
	ZeroMemory(&pfd, sizeof(PIXELFORMATDESCRIPTOR));

	pfd.nSize    = sizeof(PIXELFORMATDESCRIPTOR);
	pfd.nVersion = 1;
	pfd.dwFlags  = PFD_DOUBLEBUFFER   |
		           PFD_SUPPORT_OPENGL |
				   PFD_DRAW_TO_WINDOW;

	pfd.iPixelType = PFD_TYPE_RGBA;
	pfd.cColorBits = 24;
	pfd.cDepthBits = 32;
	pfd.iLayerType = PFD_MAIN_PLANE;

	int nPixelFormat = ChoosePixelFormat(hdc, &pfd);

	if (nPixelFormat == 0)
	{
		MessageBox(NULL, "Failed to initialize OpenGL (ChoosePixelFormat)", "LevelEditor", MB_ICONSTOP|MB_OK);
		return false;
	}

	if (!SetPixelFormat(hdc, nPixelFormat, &pfd))
	{
		MessageBox(NULL, "Failed to initialize OpenGL (SetPixelFormat)", "LevelEditor", MB_ICONSTOP|MB_OK);
		return false;
	}	

	// Initialize OpenGL
	hglrc = wglCreateContext(hdc);
	wglMakeCurrent(hdc, hglrc);

	if (!hglrc)
	{
		MessageBox(NULL, "Failed to intiialize OpenGL (wglCreateContext)", "LevelEditor", MB_ICONSTOP|MB_OK);
		return false;
	}

	return true;
}

void RenderWindow::ShutdownGL()
{
	wglMakeCurrent(NULL, NULL);
}

void RenderWindow::UpdateGL(HDC hdc)
{
	wglMakeCurrent(hdc, hglrc);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(30.0f, 1.0f, 1.0f, 5000.0f);

	glEnable(GL_DEPTH_TEST);

	gluLookAt(0.0f,15.0f,-70.0f,
			  0.0f,15.0f,1.0f,
			  0.0f,1.0f,0.0f);

	glViewport(0,
			   0,
			   640,//rect.right - rect.left,
			   480);//rect.bottom - rect.top);

	glClearColor(0.0f,0.0f,0.0f,1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glColor3f(1.0f,1.0f,1.0f);
	glMatrixMode(GL_MODELVIEW);

	///////////////////

	/*
	glBegin(GL_TRIANGLES);
	glVertex3f(0.5f, 0.0f, 0.0f);
	glVertex3f(0.0f, 1.0f, 0.0f);
	glVertex3f(1.0f, 1.0f, 0.0f);
	glEnd();
	*/

	// Draw currently loaded geom
	/*
	glBegin(GL_TRIANGLES);

		if (verts && faces)
		{
			for(int i = 0; i < nFaces; i++)
			{
				glVertex3f(verts[faces[i].v[0]].x, verts[faces[i].v[0]].y, verts[faces[i].v[0]].z);
				glVertex3f(verts[faces[i].v[1]].x, verts[faces[i].v[1]].y, verts[faces[i].v[1]].z);
				glVertex3f(verts[faces[i].v[2]].x, verts[faces[i].v[2]].y, verts[faces[i].v[2]].z);
			}
		}

	glEnd();
	*/

	if (pRenderObj)
	{
		glBegin(GL_TRIANGLES);

			for(int i = 0; i < pRenderObj->m_NumFaces; i++)
			{
				Point3 v0 = pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[0]].m_Pos;
				Point3 v1 = pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[1]].m_Pos;
				Point3 v2 = pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[2]].m_Pos;

				glColor3f(pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[0]].m_Color[0],
					      pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[0]].m_Color[1],
						  pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[0]].m_Color[2]);

				glVertex3f(v0.x, v0.y, v0.z);

				glColor3f(pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[1]].m_Color[0],
					      pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[1]].m_Color[1],
						  pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[1]].m_Color[2]);

				glVertex3f(v1.x, v1.y, v1.z);

				glColor3f(pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[2]].m_Color[0],
					      pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[2]].m_Color[1],
						  pRenderObj->m_Verts[pRenderObj->m_Faces[i].m_Vertex[2]].m_Color[2]);

				glVertex3f(v2.x, v2.y, v2.z);
			}

		glEnd();
	}

	//////////////////

	SwapBuffers(hdc);
	wglMakeCurrent(NULL, NULL);
}

void RenderWindow::Update()
{
	UpdateGL(hdc);
}
