/*
	LevelEditorDlg.h
	Main Level Editor Dialog Window
	aml - 9-26-03
*/

#ifndef __LEVELEDITORDLG__
#define __LEVELEDITORDLG__

#include "MSWindow.h"
#include "WorldDB.h"

class RenderWindow;

class LevelEditorDlg: public MSDlgWindow,
	                  public MSWindow
{
	HINSTANCE     hInstance;
	HWND          hwndInterLink;		// Comm window for the plugin
	bool          bInterLinkActive;		// True if connection with plugin has been negotiated
	bool          bCloseOnDetach;		// True if Level Editor should shutdown when detach ack message is recieved
										// from the plugin

	WorldDB       worldDB;				// Database responsible for maintaining world data

	RenderWindow* pRenderWindowTL;
	RenderWindow* pRenderWindowTR;
	RenderWindow* pRenderWindowBL;
	RenderWindow* pRenderWindowBR;

	LRESULT WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);	// Responsible for managing messages sent from plugin
	BOOL    DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);	// Responsible for dialog UI management


public:
	LevelEditorDlg(HINSTANCE hInstance, HWND hwndInterLink);
	~LevelEditorDlg();

	// Test Only.   These will be removed
	bool LoadTestPiece(HWND hwnd, char* filename);
	bool LoadTestPiece(HWND hwnd);

	bool SaveTestPiece(HWND hwnd, char* filename);
	bool SaveTestPiece(HWND hwnd);
	///////////////////////////////////////////////////

	bool OpenLevel(HWND hwnd, char* filename);
	bool OpenLevel(HWND hwnd);

	bool SaveLevel(HWND hwnd, char* filename);
	bool SaveLevel(HWND hwnd);

	void Update();
	void PostIML();
};

#endif
