#include <stdlib.h>
#include <fstream.h>
#include "Genlib/Utility.h"
#include "Genlib/VirtualFile.h"
#include <gel/scripting/parse.h>
#include <gel/scripting/symboltable.h>
#include <gel/scripting/array.h>
#include <gel/scripting/struct.h>
#include <gel/scripting/script.h>
#include <gel/scripting/checksum.h>
#include <gel/scripting/component.h>
#include "terrain.h"
#include "levelassetlister.h"

void WriteSoundFileName(const char *p_sound_name)
{
	enum
	{
		MAX_SOUND_FILES=1000
	};
	static uint32 sp_already_written[MAX_SOUND_FILES];
	static int s_num_sound_files_written=0;

	char p_sound_file[_MAX_PATH];
	sprintf(p_sound_file,"%s\\data\\sounds\\",GetProjRoot());

	switch (GetPlatform())
	{
	case Utils::vPLATFORM_PS2:
		strcat( p_sound_file, "vag\\" );
		strcat( p_sound_file, p_sound_name );
		strcat( p_sound_file, ".vag" );
		break;
	case Utils::vPLATFORM_XBOX:
		strcat( p_sound_file, "pcm\\" );
		strcat( p_sound_file, p_sound_name );
		strcat( p_sound_file, ".pcm" );
		break;
	case Utils::vPLATFORM_NGC:
		strcat( p_sound_file, "dsp\\" );
		strcat( p_sound_file, p_sound_name );
		strcat( p_sound_file, ".dsp" );
		break;
	default:
		break;
	}
																									 
	// Do not write it out if it has been written out already
	uint32 name_checksum=Script::GenerateCRC(p_sound_file);
	for (int i=0; i<s_num_sound_files_written; ++i)
	{
		if (sp_already_written[i]==name_checksum)
		{
			return;
		}
	}

	if (TestExistence(p_sound_file,__LINE__,false))
	{
		theOutputFile.WriteString( p_sound_file, true );

		Utils::Assert(s_num_sound_files_written<MAX_SOUND_FILES,"Too many sound files!");
		sp_already_written[s_num_sound_files_written++]=name_checksum;
	}
}

Script::CStruct *FindSoundActions(Script::CArray *p_array, uint32 searchTerrain)
{
	if (!p_array)
	{
		return NULL;
	}

	for (int i=0; i<p_array->GetSize(); ++i)
	{
		Script::CStruct *p_terrain_struct=p_array->GetStructure(i);
		uint32 terrain=0;
		p_terrain_struct->GetChecksum("Terrain",&terrain);
		if (terrain==searchTerrain)
		{
			Script::CStruct *p_sound_actions=NULL;
			p_terrain_struct->GetStructure("SoundActions",&p_sound_actions);
			return p_sound_actions;
		}
	}
	return NULL;
}

bool ScriptLoadTerrainSounds(Script::CStruct *pParams, Script::CScript *pScript)
{
	uint32 terrain=0;
	pParams->GetChecksum("Terrain",&terrain);

	Script::CArray *p_standard_terrain=Script::GetArray("standard_terrain");
	Script::CArray *p_level_terrain=Script::GetArray("level_terrain");

	Script::CStruct soundactions;
	soundactions.AppendStructure(FindSoundActions(p_standard_terrain,0x64967688/*TERRAIN_DEFAULT*/));
	soundactions.AppendStructure(FindSoundActions(p_standard_terrain,terrain));
	soundactions.AppendStructure(FindSoundActions(p_level_terrain,terrain));

	Script::CComponent *p_comp=soundactions.GetNextComponent();
	while (p_comp)
	{
		if (p_comp->mType==ESYMBOLTYPE_STRUCTURE)
		{
			const char *p_sound_name="";
			if (p_comp->mpStructure->GetString("Sound",&p_sound_name))
			{
				WriteSoundFileName(p_sound_name);
			}
		}
		else if (p_comp->mType==ESYMBOLTYPE_ARRAY)
		{
			for (int n=0; n<p_comp->mpArray->GetSize(); n++)
			{
				Script::CStruct* p_struct = p_comp->mpArray->GetStructure(n);

				Script::CComponent* p_sound_comp = p_struct->GetNextComponent();
				while (p_sound_comp && p_sound_comp->mNameChecksum != CRCD(0x25f654c8, "SoundAction"))
				{
					p_sound_comp = p_struct->GetNextComponent(p_sound_comp);
				}
				if (!p_sound_comp) continue;

				if (p_sound_comp->mType==ESYMBOLTYPE_STRUCTURE)
				{
					const char *p_sound_name="";
					if (p_sound_comp->mpStructure->GetString("Sound",&p_sound_name))
					{
						WriteSoundFileName(p_sound_name);
					}
				}
				else if (p_sound_comp->mType==ESYMBOLTYPE_ARRAY)
				{
					for (int m=0; m<p_sound_comp->mpArray->GetSize(); m++)
					{
						const char *p_sound_name="";
                        p_sound_comp->mpArray->GetStructure(m)->GetString("Sound",&p_sound_name);
						WriteSoundFileName(p_sound_name);
					}
				}
			}
		}
		p_comp=soundactions.GetNextComponent(p_comp);
	}

	return true;
}

bool ScriptLoadSound(Script::CStruct *pParams, Script::CScript *pScript)
{
	const char *p_sound_file="";
	if (pParams->GetString(NONAME,&p_sound_file))
	{
		WriteSoundFileName(p_sound_file);
	}
	return true;
}


