#include <stdlib.h>
#include <fstream.h>
#include "Genlib/Utility.h"
#include "Genlib/VirtualFile.h"
#include <gel/scripting/parse.h>
#include <gel/scripting/symboltable.h>
#include <gel/scripting/array.h>
#include <gel/scripting/struct.h>
#include <gel/scripting/script.h>
#include <gel/scripting/checksum.h>
#include <gel/scripting/component.h>
#include "profiles.h"
#include "levelassetlister.h"

void WriteProfiles()
{
	Script::CArray *p_node_array=Script::GetArray("NodeArray",Script::ASSERT);
	for (int i=0; i<p_node_array->GetSize(); ++i)
	{
		Script::CStruct *p_node=p_node_array->GetStructure(i);
		uint32 profile_name=0;
		if (p_node->GetChecksum("Profile",&profile_name))
		{
			OutputProfile(&theOutputPedFile,profile_name);
		}
	}
}
