#include <stdlib.h>
#include <fstream.h>
#include "Genlib/Utility.h"
#include "Genlib/VirtualFile.h"
#include <gel/scripting/parse.h>
#include <gel/scripting/symboltable.h>
#include <gel/scripting/array.h>
#include <gel/scripting/struct.h>
#include <gel/scripting/script.h>
#include <gel/scripting/checksum.h>
#include <gel/scripting/component.h>
#include "particle.h"
#include "levelassetlister.h"

bool ScriptLoadParticleTexture(Script::CStruct *pParams, Script::CScript *pScript)
{
	const char *p_file_name="";
	pParams->GetString(NONAME,&p_file_name);

	char p_full_file_name[_MAX_PATH];
	sprintf(p_full_file_name,"%s\\data\\images\\%s.img",GetProjRoot(),p_file_name);
	strcat(p_full_file_name, GetPlatformExtension());

	if (TestExistence(p_full_file_name,__LINE__,false))
	{
		theOutputFile.WriteString( p_full_file_name, true );
	}

	return true;
}
