/**********************************************************************
 *<
	FILE: dpoint3.h

	DESCRIPTION:

	CREATED BY: Dan Silva

	HISTORY:

 *>	Copyright (c) 1994, All Rights Reserved.
 **********************************************************************/

#ifndef __DPOINT3__ 

#define __DPOINT3__

#include "maxheap.h"
#include "point3.h"

#if _MSC_VER < 1300  // Visual Studio .NET
 class ostream;
#else
 #include <iosfwd>
// using std::ostream;		CA - 10/24/02 - Removed to preserve compatibility for 3rd parties
#endif

class DPoint3: public MaxHeapOperators {
public:
	double x,y,z;

	// Constructors
	DPoint3(){}
	DPoint3(double X, double Y, double Z)  { x = X; y = Y; z = Z;  }
	DPoint3(const DPoint3& a) { x = a.x; y = a.y; z = a.z; } 
	DPoint3(const Point3& a) { x = a.x; y = a.y; z = a.z; } 
	DPoint3(double af[3]) { x = af[0]; y = af[1]; z = af[2]; }

	// Access operators
	double& operator[](int i) { return (&x)[i]; }     
	const double& operator[](int i) const { return (&x)[i]; }  

 	// Conversion function
	operator double*() { return(&x); }

 	// Unary operators
	DPoint3 operator-() const { return(DPoint3(-x,-y,-z)); } 
	DPoint3 operator+() const { return *this; } 

	// Assignment operators
	DllExport DPoint3& operator=(const Point3& a) {	x = a.x; y = a.y; z = a.z;	return *this; }
	DllExport DPoint3& operator-=(const DPoint3&);
	DllExport DPoint3& operator+=(const DPoint3&);
	DllExport DPoint3& operator*=(double);
	DllExport DPoint3& operator/=(double);

	// Binary operators
	DllExport DPoint3 operator-(const DPoint3&) const;
	DllExport DPoint3 operator+(const DPoint3&) const;
	DllExport double operator*(const DPoint3&) const;		// DOT PRODUCT
	DllExport DPoint3 operator^(const DPoint3&) const;	// CROSS PRODUCT

	};

DllExport double Length(const DPoint3&); 
DllExport int MaxComponent(const DPoint3&);  // the component with the maximum abs value
DllExport int MinComponent(const DPoint3&);  // the component with the minimum abs value
DllExport DPoint3 Normalize(const DPoint3&); // Return a unit vector.

DllExport DPoint3 operator*(double, const DPoint3&);	// multiply by scalar
DllExport DPoint3 operator*(const DPoint3&, double);	// multiply by scalar
DllExport DPoint3 operator/(const DPoint3&, double);	// divide by scalar

#if _MSC_VER < 1300  // Visual Studio .NET
DllExport ostream &operator<<(ostream&, const DPoint3&); 
#else
DllExport std::ostream &operator<<(std::ostream&, const DPoint3&); 
#endif
	 
// Inlines:

inline double Length(const DPoint3& v) {	
	return (double)sqrt(v.x*v.x+v.y*v.y+v.z*v.z);
	}

inline DPoint3& DPoint3::operator-=(const DPoint3& a) {	
	x -= a.x;	y -= a.y;	z -= a.z;
	return *this;
	}

inline DPoint3& DPoint3::operator+=(const DPoint3& a) {
	x += a.x;	y += a.y;	z += a.z;
	return *this;
	}

inline DPoint3& DPoint3::operator*=(double f) {
	x *= f;   y *= f;	z *= f;
	return *this;
	}

inline DPoint3& DPoint3::operator/=(double f) { 
	x /= f;	y /= f;	z /= f;	
	return *this; 
	}

inline DPoint3 DPoint3::operator-(const DPoint3& b) const {
	return(DPoint3(x-b.x,y-b.y,z-b.z));
	}

inline DPoint3 DPoint3::operator+(const DPoint3& b) const {
	return(DPoint3(x+b.x,y+b.y,z+b.z));
	}

inline double DPoint3::operator*(const DPoint3& b) const {  
	return(x*b.x+y*b.y+z*b.z);	
	}

inline DPoint3 operator*(double f, const DPoint3& a) {
	return(DPoint3(a.x*f, a.y*f, a.z*f));
	}

inline DPoint3 operator*(const DPoint3& a, double f) {
	return(DPoint3(a.x*f, a.y*f, a.z*f));
	}

inline DPoint3 operator/(const DPoint3& a, double f) {
	return(DPoint3(a.x/f, a.y/f, a.z/f));
	}

DllExport DPoint3 CrossProd(const DPoint3& a, const DPoint3& b);	// CROSS PRODUCT
	
DllExport double DotProd(const DPoint3& a, const DPoint3& b) ;		// DOT PRODUCT

#endif

