/*
	ParseFuncs.cpp
	Helper parsing functions
	(Moved from PropEdit)
	12-19-01
*/

#include "ParseFuncs.h"
#include <stdlib.h>
#include <string.h>

void ucase(char* str)
{
	while(*str != 10 && *str != 13 && *str != 0)
	{
		*str = toupper(*str);
		str++;
	}
}

void lcase(char* str)
{
	while(*str != 10 && *str != 13 && *str != 0)
	{
		*str = tolower(*str);
		str++;
	}
}

int CountChar(char* str,char chr)
{
	int len=strlen(str);
	int count=0;

	for(int i=0;i<len;i++)
		if (str[i]==chr)
			count++;

	return count;
}

int CountStr(char* str, char* search)
{
	char* pos = strstr(str, search);
	int count = 0;

	while(pos)
	{
		pos++;
		count++;
		pos = strstr(pos, search);
	}

	return count;
}

// Adequate space in dest is assumed
void ReplaceStr(char* dest, char* src, char* search, char* replace, bool bCaseSensitive)
{
	int  srcLen          = strlen(src);
	int  searchLen       = strlen(search);
	bool bUsedTempBuffer;

	if (srcLen == 0)
		return;

	// If the destination is the same as the source, we'll make a copy of the
	// source into our own buffer and use that until we're done
	if (dest == src)
	{
		char* oldsrc = src;
		src = (char*)malloc(srcLen + 1);
		memcpy(src, oldsrc, srcLen + 1);
		bUsedTempBuffer = true;
	}
	else
		bUsedTempBuffer = false;

	dest[0] = 0;

	int  bufPos;

	char* buf      = dest;
	char* pOrigBuf = buf;

	if (bCaseSensitive)
	{
		char* pPos     = src;
		char* pOrigPos = pPos;
		char* pTemp;
		int   leftLen;

		// Replaces will be performed all at once for speed
		while(pTemp = strstr(pPos, search))
		{
			bufPos = 0;

			// Copy left
			leftLen = pTemp - pPos;
			memcpy(buf, pPos, leftLen);
			bufPos += leftLen;
			buf[leftLen] = 0;

			// Replace
			strcat(buf, replace);
			bufPos += strlen(replace);

			// Continue
			pPos = pTemp + searchLen;
			buf += bufPos;
		}

		// Fill in remainder
		memcpy(buf, pPos, strlen(pPos) + 1);
	}
	else
	{
		char* newSrc = (char*)malloc(srcLen + 1);
		memcpy(newSrc, src, srcLen + 1);

		char* newSearch = (char*)malloc(searchLen + 1);
		memcpy(newSearch, search, searchLen + 1);
		
		ucase(newSrc);
		ucase(newSearch);

		char* pPos     = src;		// Position within original buffer
		char* pPosNew  = newSrc;	// Compare position
		char* pOrigPos = pPos;
		char* pTemp;
		char* pTempNew;
		int   leftLen;

		// Replaces will be performed all at once for speed
		while(pTempNew = strstr(pPosNew, newSearch))
		{
			pTemp = pPos + (pTempNew - pPosNew);
			bufPos = 0;

			// Copy left
			leftLen = pTemp - pPos;
			memcpy(buf, pPos, leftLen);
			bufPos += leftLen;
			buf[leftLen] = 0;

			// Replace
			strcat(buf, replace);
			bufPos += strlen(replace);

			// Continue
			pPos    = pTemp + searchLen;
			pPosNew = pTempNew + searchLen;
			buf += bufPos;
		}

		// Fill in remainder
		memcpy(buf, pPos, strlen(pPos) + 1);

		// Free up upper case conversion strings
		free(newSrc);
		free(newSearch);
	}

	// Clean up temporary buffer if necessary
	if (bUsedTempBuffer)
		free(src);
}

void StripToken(char* token)
{
	char tmpToken[1024]="";
	int  len=strlen(token);
	int  start,end;
	int  pos=0;

	if (len<2)
	{
		if (token[0] == 10 ||
			token[0] == 13 ||
			token[0] == 32)
			token[0] = 0;

		return;
	}

	// Clear leading spaces
	for(start=0;start<len;start++)
	{
		if (token[start]!=' ' &&
			token[start]!=10  &&
			token[start]!=13  &&
			token[start]!=9)
			break;
	}

	// Clear trailing spaces
	for(end=len-1;end>start;end--)
	{
		if (token[end]!=' ' &&
			token[end]!=10  &&
			token[end]!=13  &&
			token[end]!=9)
			break;
	}

	// Copy string contents into temporary buffer
	for(int i=start;i<=end;i++)
		tmpToken[pos++]=token[i];

	tmpToken[pos]='\0';
	strcpy(token,tmpToken);
}
