/*
	AnimView.cpp
	Animation Viewer Client

*/

#include <gel/net/client/netclnt.h>
#include <sk/GameNet/ExportMsg.h>
#include <core/crc.h>
#include <windows.h>
#include <commctrl.h>
#include <stdlib.h>
#include <stdio.h>
#include <direct.h>
#include <io.h>
#include "AnimView.h"
#include "ListView.h"
#include "Network.h"
#include "llist.h"
#include "Resource.h"

struct AnimRecord
{
	char name[256];		// name of animation
	int  start;			// animation start frame
	int  end;			// animation end frame
	int  active;		// 1 if the animation is active
	int  unloadable;	// 1 if the animation is unloadable    v7
};

HWND gHWnd;									// Main window
ListView* lview;							// Listview control interface
LinkList< LinkList< AnimRecord > >  Db;		// Database info


void SendNetUpdate()
{
	char buf[256];
	int  index;
	Net::MsgViewObjSetAnim msg;

	index=lview->GetSel();
	lview->GetItem(index,buf,256);
	msg.m_AnimName=Crc::GenerateCRCFromString(buf);

	// Rebuild 5-12-03 aml    Updated for new network code to use MsgDesc struct
	Net::MsgDesc msgDesc;
	msgDesc.m_Id     = Net::vMSG_ID_VIEWOBJ_SET_ANIM;
	msgDesc.m_Length = sizeof(Net::MsgViewObjSetAnim);
	msgDesc.m_Data   = &msg;

	gClient->EnqueueMessageToServer( &msgDesc );

	//gClient->EnqueueMessageToServer( Net::vMSG_ID_VIEWOBJ_SET_ANIM, sizeof( Net::MsgViewObjSetAnim ),
	//								 &msg );
}

void UpdateSel()
{
	char strStart[256];
	char strEnd[256];
	char strActive[80];

	int index=SendDlgItemMessage(gHWnd,IDC_GRPLIST,CB_GETCURSEL,0,0);

	if (index==CB_ERR)
		return;

	lview->Clear();

	if (index > Db.GetSize()-1)
		return;

	Link<AnimRecord>* curNode=Db[index].GetHead();
	while(curNode)
	{
		lview->AddItem(curNode->data.name);
		
		_itoa(curNode->data.start,strStart,10);
		_itoa(curNode->data.end,strEnd,10);
		_itoa(curNode->data.active,strActive,10);

		lview->AddSubItem(strStart);
		lview->AddSubItem(strEnd);
		lview->AddSubItem(strActive);

		curNode=curNode->next;
	}
}

BOOL CALLBACK DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	NMHDR* nmhdr;

	switch(msg)
	{
	case WM_CLOSE:
		EndDialog(hwnd,0);
		PostQuitMessage(0);
		return TRUE;

	case WM_NOTIFY:
		nmhdr=(LPNMHDR)lParam;

		switch(nmhdr->code)
		{
		case LVN_ITEMACTIVATE:
			SendNetUpdate();
			return TRUE;
		}

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_GRPLIST:
			switch(HIWORD(wParam))
			{
			case CBN_SELCHANGE:
				UpdateSel();
				return TRUE;
			}
			return FALSE;

		case IDC_UPDATE:

			return TRUE;
		}
	}

	return FALSE;
}

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShow)
{
	MSG  msg;
	Engine* engine;	
	char srchDir[512];
	_finddata_t fdata;

	InitCommonControls();

	OutputDebugString("Pre engine create\n");

	// Initialize network engine
	engine=new Engine;

	OutputDebugString("Post engine create\n");

	// Open the window
	gHWnd=CreateDialog(hInstance,MAKEINTRESOURCE(IDD_ANIMVIEW),NULL,DlgProc);
	lview=new ListView(GetDlgItem(gHWnd,IDC_LIST));

	OutputDebugString("Post window create\n");

	lview->AddColumn("Name",150);
	lview->AddColumn("Start",100);
	lview->AddColumn("End",100);
	lview->AddColumn("Unloadable",18);
	lview->AddColumn("Active",18);

	OutputDebugString("Post column create\n");

	// If no directory is given will use the current working directory
	if (strlen(lpCmdLine)==0)
		_getcwd(srchDir,512);
	else
		strcpy(srchDir,lpCmdLine);

	_chdir(srchDir);
	
	long hFind=_findfirst("*.anr",&fdata);
	int  frVal;
	int  fileID=0;
	int  active=1;

	frVal=hFind;

	OutputDebugString("Begin anr scan\n");

	// scan the given directory for .anr files
	while(frVal!=-1)
	{
		AnimRecord animRec;
		float dummy1=0.0f,dummy2=0.0f;

		Db.Add();

		FILE* fp=fopen(fdata.name,"r");

		if (!fp)
		{
			frVal=_findnext(hFind,&fdata);
			continue;
		}

		char verID[6];
		verID[0]=fgetc(fp);
		verID[1]=fgetc(fp);
		verID[2]=fgetc(fp);
		verID[3]=fgetc(fp);
		verID[4]=fgetc(fp);	// Should be CR

		// Check if this is an animation range version 2/3/4/5 format file
		if (strstr(verID,"AnV2") || strstr(verID,"AnV3") || strstr(verID,"AnV4") || strstr(verID,"AnV5") || strstr(verID,"AnV6") || strstr(verID,"AnV7") || strstr(verID,"AnV8") || strstr(verID,"AnV9"))
		{
			char modelname[80];
			char suffixname[80];

			fscanf(fp,"%s\n%s\n",modelname,suffixname);

			if (strstr(verID,"AnV3") || strstr(verID,"AnV4") || strstr(verID,"AnV5") || strstr(verID,"AnV6") || strstr(verID,"AnV7") || strstr(verID,"AnV8") || strstr(verID, "AnV9"))
			{
				char dirname[80];
				fscanf(fp,"%s\n",dirname);

				char skelname[80];
				fscanf(fp,"%s\n",skelname);

				if (strstr(verID,"AnV8"))
				{
					char boneset[80];
					fscanf(fp,"%s\n",boneset);
				}
			}
		}
		else
		{
			// If this isn't an animation range version 2 or 3 file return to top of file
			fseek(fp,0,SEEK_SET);
		}
		
		SendDlgItemMessage(gHWnd,IDC_GRPLIST,CB_ADDSTRING,0,(LPARAM)fdata.name);

		while(!feof(fp))
		{
			if (strstr(verID, "AnV9"))
			{
				char partialAnim[256];
				fscanf(fp,"%s %i %i %f %f %i %i\n",animRec.name,&animRec.start,&animRec.end,&dummy1,&dummy2,&animRec.active,&animRec.unloadable);
				fgets(partialAnim, 256, fp);
			}
			else if (strstr(verID, "AnV7") || strstr(verID, "AnV8"))
			{
				fscanf(fp,"%s %i %i %f %f %i %i\n",animRec.name,&animRec.start,&animRec.end,&dummy1,&dummy2,&animRec.active,&animRec.unloadable);
			}
			else if (strstr(verID,"AnV6"))
			{
				fscanf(fp,"%s %i %i %f %f %i\n",animRec.name,&animRec.start,&animRec.end,&dummy1,&dummy2,&animRec.active);
			}
			else
			{
				fscanf(fp,"%s %i %i %f %f\n",animRec.name,&animRec.start,&animRec.end,&dummy1,&dummy2);
				animRec.active=1;
			}

			Db[fileID].Add(&animRec);

			// If format version 5, skip over the per bone tolerance information per animation
			if (strstr(verID,"AnV5") || strstr(verID,"AnV6") || strstr(verID,"AnV7") || strstr(verID,"AnV8"))
			{
				char lineBuf[1024];

				do
				{
					fgets(lineBuf,1023,fp);
				} while (strstr(lineBuf,"[End]")==0);
			}
		}

		fclose(fp);

		frVal=_findnext(hFind,&fdata);
		fileID++;
	}

	OutputDebugString("End anr scan\n");

	SendDlgItemMessage(gHWnd,IDC_GRPLIST,CB_SETCURSEL,(WPARAM)0,0);
	UpdateSel();

	if (Db.GetSize()==0)
	{
		char strErr[256];
		sprintf(strErr,"No .anr files were found in the path '%s'.",srchDir);
		MessageBox(gHWnd,strErr,"No files found",MB_ICONWARNING|MB_OK);
		return -1;
	}

	ShowWindow(gHWnd,SW_SHOW);

	while(GetMessage(&msg,NULL,0,0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	// Shutdown network engine
	if (engine)
		delete engine;

	// Shutdown listview display
	if (lview)
		delete lview;

	return 0;
}
