//****************************************************************************
//* MODULE:         Tools/AnimConv
//* FILENAME:       AnimConv.h
//* OWNER:          Gary Jesdanun
//* CREATION DATE:  9/24/2002
//****************************************************************************

#ifndef __ANIMCONV_H__
#define __ANIMCONV_H__

#include "Converter.h"

// forward declarations
struct SIntermediateQKey;
struct SIntermediateTKey;
class CBoneData;

namespace IoUtils
{
	class CVirtualOutputFile;
}

namespace Mth
{
	class Quat;
	class Vector;
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

struct SUniqueItem
{
	short x, y, z, lookupIndex;
};

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

class CompressTable
{
public:
	CompressTable();
	virtual					~CompressTable();

public:
	bool					Init(char* pCompressTableName);
	int						InUniqueTable( short x, short y, short z );
	int						GetCount() { return m_uniqueCount; }

protected:
	enum
	{
		vNUM_COMPRESS_TABLE_BUCKETS = 256
	};

protected:
	SUniqueItem				m_uniqueTable[vNUM_COMPRESS_TABLE_BUCKETS];
	int						m_uniqueCount;
};

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

class AnimConverter : public Utils::CBaseConverter
{
public:
	AnimConverter();
	virtual					~AnimConverter();

public:
	bool					Load(const char* pFileName);
	bool					Save(const char* pFileName, bool reverseByteOrder);
	bool					SaveCompressed(const char* pFileName, CompressTable* pQCompressTable, CompressTable* pTCompressTable, bool reverseByteOrder);

	virtual void			Reset();
	virtual void			PrintUsage() {}

protected:
	bool					load_intermediate(const char* pFileName);
	bool					load_facial_anim(const char* pFileName);

	short 					transToFixedPoint(float src) const;
	short 					quatToFixedPoint(float src) const;

	bool 					write_q_data(IoUtils::CVirtualOutputFile* pOutputFile, bool reverseByteOrder );
	bool 					write_t_data(IoUtils::CVirtualOutputFile* pOutputFile, bool reverseByteOrder );

	bool 					write_compressed_q_data(IoUtils::CVirtualOutputFile* pOutputFile, CompressTable* pCompressTable, bool reverseByteOrder, int patchAddress );
	bool 					write_compressed_t_data(IoUtils::CVirtualOutputFile* pOutputFile, CompressTable* pCompressTable, bool reverseByteOrder, int patchAddress );

	bool					write_partial_anim_data( IoUtils::CVirtualOutputFile* p_outputFile, bool reverseByteOrder );

	bool 					is_hires_data();
	bool 					use_compress_table(CompressTable* pCompressTable);
	CBoneData*				get_bone_data(int bone_index);
	int						get_num_qkeys();
	int						get_num_tkeys();

protected:
	int						ReadCustomKey(unsigned char* pData);

protected:
	unsigned int			m_flags;
	float					m_duration;
	int						m_version;

	int						m_numCustomKeys;
	unsigned char*			mp_customData;
	unsigned int			m_customDataSize;

	int						m_numBones;
	CBoneData*				mp_boneData;
	short					m_lastCameraTimeStamp;
	short					m_secondToLastCameraTimeStamp;

protected:
	enum
	{
		vMAX_MASKS = 10
	};

	int						m_partialAnimTotalBones;
	uint32					m_partialAnimMasks[vMAX_MASKS];
};

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline short AnimConverter::transToFixedPoint(float src) const
{
	return (short)(src*32.0f);
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline short AnimConverter::quatToFixedPoint(float src) const
{
	return (short)(src*16384.0f);
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

#endif
