/******
qrcsample.c
GameSpy Query & Reporting SDK 
  
Copyright 2000 GameSpy Industries, Inc

18002 Skypark Circle
Irvine, CA 92614
(949)798-4200
Fax(949)798-4299
******

 This source file includes a "sample" game shell which demonstrates
 how to use the GameSpy Query & Reporting SDK

 Please see the GameSpy Query & Reporting SDK documentation for more 
 information

******/


/********
INCLUDES
********/
#if defined(applec) || defined(THINK_C) || defined(__MWERKS__) && !defined(__KATANA__) && !defined(__mips64)
	#include ":::nonport.h"
#else
	#include "../../nonport.h"
#endif

#ifdef _MACOS
	#include "::gqueryreporting.h"
#else
	#include "../gqueryreporting.h"
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#if defined(_WIN32) && !defined(UNDER_CE)
#include <conio.h>
#endif

/********
DEFINES
********/
#define GAME_VERSION "2.00"
#define GAME_NAME "gmtest"
#define MAX_PLAYERS 32
#define BASE_PORT 26900

#ifdef _WIN32_WCE
void RetailOutputA(CHAR *tszErr, ...);
#define printf RetailOutputA
#endif

#ifdef __KATANA__
void NUMsg(char *in_format, ...);
#define printf NUMsg
#endif

/********
TYPDEFS
********/
//representative of a game player structure
typedef struct
{
	char pname[80];
	int pfrags;
	int pdeaths;
	int pskill;
	int pping;
	char pteam[80];
} player_t;

//representative of a game data structure
typedef struct
{
	player_t players[MAX_PLAYERS];
	char mapname[20];
	char hostname[120];
	char gamemode[200];
	char gametype[30];
	int locationid;
	int numplayers;
	int maxplayers;
	int fraglimit;
	int timelimit;
	int teamplay;
	int rankingson;
	int hostport;
} gamedata_t;

/********
GLOBAL VARS
********/

//just to give us bogus data
char *constnames[MAX_PLAYERS]={"Joe Player","L33t 0n3","Raptor","Gr81","Flubber","Sarge","Void","runaway","Ph3ar","wh00t","gr1nder","Mace","stacy","lamby","Thrush"};
gamedata_t gamedata;


/*************
basic_callback
sends a (sample) response to the basic query 
includes the following keys:
\gamename\
\gamever\
\location\
*************/
static void basic_callback(char *outbuf, int maxlen, void *userdata)
{
	sprintf(outbuf, "\\gamename\\%s\\gamever\\%s\\location\\%d",
			GAME_NAME,GAME_VERSION,gamedata.locationid);
	printf("Basic callback, sent: %s\n\n",outbuf);
}

/************
info_callback
Sends a (sample) response to the info query 
including the following keys:
\hostname\
\hostport\
\mapname\
\gametype\
\numplayers\
\maxplayers\
\gamemode\
\groupid\ (optional - if supporting group rooms)
************/
static void info_callback(char *outbuf, int maxlen, void *userdata)
{
	char keyvalue[200];

	sprintf(keyvalue,"\\hostname\\%s",gamedata.hostname);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\hostport\\%d",gamedata.hostport);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\mapname\\%s",gamedata.mapname);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\gametype\\%s",gamedata.gametype);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\numplayers\\%d",gamedata.numplayers);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\maxplayers\\%d",gamedata.maxplayers);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\gamemode\\%s",gamedata.gamemode);
	strcat(outbuf, keyvalue);
	printf("Info callback, sent: %s\n\n",outbuf);

}

/***************
rules_callback
Sends a response to the rules query. You may
need to add custom fields for your game in here. Some are provided
as an example 
The following rules are included:
\timelimit\
\fraglimit\
\teamplay\
\rankedserver\
****************/
static void rules_callback(char *outbuf, int maxlen, void *userdata)
{
	char keyvalue[80];

	sprintf(keyvalue,"\\timelimit\\%d",gamedata.timelimit);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\fraglimit\\%d",gamedata.fraglimit);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\teamplay\\%d",gamedata.teamplay);
	strcat(outbuf, keyvalue);
	//sample custom key/value
	sprintf(keyvalue,"\\rankedserver\\%d",gamedata.rankingson);
	strcat(outbuf, keyvalue);
	printf("Rules callback, sent: %s\n\n",outbuf);

}

/***************
players_callback
sends the players and their information. 
Note that \ characters are not stripped out of player names. If
your game allows players or team names with the \ character, you will need
to strip or change it here. 
The following keys are included for each player:
\player_N\
\frags_N\
\deaths_N\
\skill_N\
\ping_N\
\team_N\
***************/
static void players_callback(char *outbuf, int maxlen, void *userdata)
{
	char keyvalue[160];
	int i;

	for (i = 0; i < gamedata.numplayers ; i++)
	{
		sprintf(keyvalue,
			"\\player_%d\\%s\\frags_%d\\%d\\deaths_%d\\%d\\skill_%d\\%d\\ping_%d\\%d\\team_%d\\%s",
			i, gamedata.players[i].pname,
			i, gamedata.players[i].pfrags,
			i, gamedata.players[i].pdeaths,
			i, gamedata.players[i].pskill,
			i, gamedata.players[i].pping,
			i, gamedata.players[i].pteam);
		strcat(outbuf, keyvalue);
	}
	printf("Players callback, sent: %s\n\n",outbuf);

}


/***********
init_game
Initialize the sample data structures with bogus data
************/
static void init_game(void)
{
	int i;
	int team;

	srand((unsigned int) current_time() );
	gamedata.numplayers = rand() % 15;
	gamedata.maxplayers = MAX_PLAYERS;
	for (i = 0 ; i < gamedata.numplayers ; i++)
	{
		strcpy(gamedata.players[i].pname, constnames[i]);
		gamedata.players[i].pfrags = rand() % 32;
		gamedata.players[i].pdeaths = rand() % 32;
		gamedata.players[i].pskill = rand() % 1000;
		gamedata.players[i].pping = rand() % 500;
		team = rand() % 3;
		if (team == 0)
			strcpy(gamedata.players[i].pteam,"Red");
		else if (team == 1)
			strcpy(gamedata.players[i].pteam,"Blue");
		else if (team == 2)
			strcpy(gamedata.players[i].pteam,"");
	}
	strcpy(gamedata.mapname,"gmtmap1");
	strcpy(gamedata.gametype,"arena");
	strcpy(gamedata.hostname,"GameMaster Arena Server");
	strcpy(gamedata.gamemode,"openplaying");
	gamedata.fraglimit = 0;
	gamedata.timelimit = 40;
	gamedata.teamplay = 1;
	gamedata.locationid = 1;
	gamedata.rankingson = 1;
	gamedata.hostport = 25000;
}

/*******
 DoGameStuff
Simulate whatever else a game server does 
********/
void DoGameStuff(void)
{
	msleep(10);
}

/*******************
 main
Simulates a main program loop
First, initializes the Q&R items, then enters a main loop
*****************/
#if defined(__KATANA__) || defined(__mips64)
int test_main(int argc, char **argp)
#else
int main(int argc, char **argp)
#endif
{
	char secret_key[9];
	//set the secret key, in a semi-obfuscated manner
	secret_key[0] = 'H';
	secret_key[1] = 'A';
	secret_key[2] = '6';
	secret_key[3] = 'z';
	secret_key[4] = 'k';
	secret_key[5] = 'S';
	secret_key[6] = '\0';
	//call qr_init with the query port number and gamename, default IP address, and no user data
	if (qr_init(NULL,NULL,BASE_PORT,GAME_NAME, secret_key, basic_callback, 
		info_callback, rules_callback, players_callback, NULL) != 0)
	{
		printf("Error starting query sockets\n");
		return -1;
	}

	init_game();

	printf("Press any key to quit\n");
#if defined(_WIN32) && !defined(UNDER_CE)
	while (!_kbhit())
#else
	while (1)
#endif
	{
		DoGameStuff();
		//check for / process incoming queries
		qr_process_queries(NULL);

	}
	//let gamemaster know we are shutting down
	strcpy(gamedata.gamemode,"exiting");
	qr_send_statechanged(NULL);
	qr_shutdown(NULL);

	return 0;

}
