// @script | load_textures_to_main_memory | loads up all textures needed for the pause menu and other in game menus
script load_textures_to_main_memory
    
	// begin old permanent textures
	
	// generic HUD textures
	LoadTexture no_vram_alloc "PanelSprites/balancemeter"
	LoadTexture no_vram_alloc "PanelSprites/balancearrow_glow"
	LoadTexture no_vram_alloc "PanelSprites/score_small"
	LoadTexture no_vram_alloc "PanelSprites/specialbar"
	LoadTexture no_vram_alloc "PanelSprites/fakie_icon"
	LoadTexture no_vram_alloc "PanelSprites/switch_icon"
	LoadTexture no_vram_alloc "PanelSprites/nollie_icon"
	LoadTexture no_vram_alloc "PanelSprites/pressure_icon"
	LoadTexture no_vram_alloc "PanelSprites/sw_pressure_icon"
	LoadTexture no_vram_alloc "PanelSprites/cash_goal"
	LoadTexture no_vram_alloc "PanelSprites/options_bg"
	LoadTexture no_vram_alloc "PanelSprites/black"
	LoadTexture no_vram_alloc "PanelSprites/white"
	LoadTexture no_vram_alloc "PanelSprites/white2"
	LoadTexture no_vram_alloc "PanelSprites/special"
    LoadTexture no_vram_alloc "PanelSprites/watch"
	LoadTexture no_vram_alloc "PanelSprites/time_1"
	LoadTexture no_vram_alloc "PanelSprites/time_2"
	LoadTexture no_vram_alloc "PanelSprites/time_3"
	LoadTexture no_vram_alloc "PanelSprites/time_4"
	LoadTexture no_vram_alloc "PanelSprites/time_5"
	LoadTexture no_vram_alloc "PanelSprites/time_6"
	LoadTexture no_vram_alloc "PanelSprites/time_7"
	LoadTexture no_vram_alloc "PanelSprites/time_8"
	LoadTexture no_vram_alloc "PanelSprites/hand"
	LoadTexture no_vram_alloc "PanelSprites/hoop"
	LoadTexture no_vram_alloc "PanelSprites/piepiece"
	LoadTexture no_vram_alloc "MainmenuSprites/bg_grain"
	LoadTexture no_vram_alloc "MainmenuSprites/hair"
	
	// 2p game type icons
	LoadTexture no_vram_alloc "PanelSprites/2p_attack"
	LoadTexture no_vram_alloc "PanelSprites/2p_score"
	LoadTexture no_vram_alloc "PanelSprites/2p_mambo"
	LoadTexture no_vram_alloc "PanelSprites/2p_slap"
	LoadTexture no_vram_alloc "PanelSprites/2p_koth"
	LoadTexture no_vram_alloc "PanelSprites/2p_graffiti"
	LoadTexture no_vram_alloc "PanelSprites/2p_horse"
	LoadTexture no_vram_alloc "PanelSprites/2p_free"
	LoadTexture no_vram_alloc "PanelSprites/2p_flag"
	LoadTexture no_vram_alloc "PanelSprites/2p_goal"
	LoadTexture no_vram_alloc "PanelSprites/2p_fire"
	
	// network
	LoadTexture no_vram_alloc "Themes/pa_theme/PA_network"
	LoadTexture no_vram_alloc "MainmenuSprites/regions"
	
	//ESRB
	LoadTexture no_vram_alloc "PanelSprites/esrb"
	
	// speech box textures
	LoadTexture no_vram_alloc "PanelSprites/dialog_frame"
	LoadTexture no_vram_alloc "PanelSprites/dialog_frame_b"
	LoadTexture no_vram_alloc "PanelSprites/dialog_middle"
	
    // goal message textures
	LoadTexture no_vram_alloc "goalsprites/GO_done"
	LoadTexture no_vram_alloc "goalsprites/GO_fail"
	LoadTexture no_vram_alloc "goalsprites/GO_new"
	
	// highlight bar
	LoadTexture no_vram_alloc "MainMenuSprites/SharedSprites/highlight_bar"
	
	// goal status indicator
	LoadTexture no_vram_alloc "PanelSprites/mini_score_HUD"
	
	// snazzy dialog box
	LoadTexture no_vram_alloc "PanelSprites/MemcardSprites/mem_frame_piece"
	LoadTexture no_vram_alloc "PanelSprites/MemcardSprites/mem_bg_piece"
	
	LoadTexture no_vram_alloc "MainMenuSprites/SharedSprites/mouse_cursor"
	
	// end old permanent textures
	
    // bg textures
	LoadTexture no_vram_alloc "PanelSprites/paused"
	
    // Generic theme sprites
	LoadTexture no_vram_alloc "PanelSprites/DE_highlight_bar"
    LoadTexture no_vram_alloc "PanelSprites/DE_top_bar"
	LoadTexture no_vram_alloc "PanelSprites/DE_top_bar_2"
	LoadTexture no_vram_alloc "PanelSprites/DE_top_bar_3"
	LoadTexture no_vram_alloc "PanelSprites/DE_top_bar_4"
	
	// theme menu bg
	LoadTexture no_vram_alloc "PanelSprites/DE_T_L"
	LoadTexture no_vram_alloc "PanelSprites/DE_T_M"
	LoadTexture no_vram_alloc "PanelSprites/DE_T_R"
	LoadTexture no_vram_alloc "PanelSprites/DE_M_L"
	LoadTexture no_vram_alloc "PanelSprites/DE_M_M"
	LoadTexture no_vram_alloc "PanelSprites/DE_M_R"
	LoadTexture no_vram_alloc "PanelSprites/DE_B_L"
	LoadTexture no_vram_alloc "PanelSprites/DE_B_M"
    LoadTexture no_vram_alloc "PanelSprites/DE_B_R"
	
	// theme menu special bg
	LoadTexture no_vram_alloc "PanelSprites/spec_T_L"
	LoadTexture no_vram_alloc "PanelSprites/spec_T_M"
	LoadTexture no_vram_alloc "PanelSprites/spec_T_R"
	LoadTexture no_vram_alloc "PanelSprites/spec_M_L"
	LoadTexture no_vram_alloc "PanelSprites/spec_M_M"
	LoadTexture no_vram_alloc "PanelSprites/spec_M_R"
	LoadTexture no_vram_alloc "PanelSprites/spec_B_L"
	LoadTexture no_vram_alloc "PanelSprites/spec_B_M"
    LoadTexture no_vram_alloc "PanelSprites/spec_B_R"
	
    // view goals textures
	LoadTexture no_vram_alloc "PanelSprites/goal_left"
    LoadTexture no_vram_alloc "PanelSprites/goal_mid"
    LoadTexture no_vram_alloc "PanelSprites/goal_right"
    LoadTexture no_vram_alloc "PanelSprites/goal_line"
	
    // stats textures
	LoadTexture no_vram_alloc "PanelSprites/stats_notch"
	LoadTexture no_vram_alloc "PanelSprites/stats_notch_bg"
	LoadTexture no_vram_alloc "PanelSprites/slider_piece"
	LoadTexture no_vram_alloc "PanelSprites/stats_point"
	
	// newer stats textures
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/framebody"
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/framecap"
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/statbody"
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/statcap"
	
	// keyboard
	LoadTexture no_vram_alloc "PanelSprites/generic_key"
	LoadTexture no_vram_alloc "PanelSprites/key_left"
	LoadTexture no_vram_alloc "PanelSprites/key_middle"
	LoadTexture no_vram_alloc "PanelSprites/key_right"
	
	// arrows
	LoadTexture no_vram_alloc "PanelSprites/SkateSprites/left_arrow"
	LoadTexture no_vram_alloc "PanelSprites/SkateSprites/right_arrow"
	LoadTexture no_vram_alloc "PanelSprites/SkateSprites/up_arrow"
	LoadTexture no_vram_alloc "PanelSprites/SkateSprites/down_arrow"
	
    // mem card file list menu
	LoadTexture no_vram_alloc "PanelSprites/MemCardSprites/mem_career"
	LoadTexture no_vram_alloc "PanelSprites/MemCardSprites/mem_park"
	;LoadTexture no_vram_alloc "PanelSprites/MemCardSprites/mem_replay"
	LoadTexture no_vram_alloc "PanelSprites/MemCardSprites/mem_skater"
	LoadTexture no_vram_alloc "PanelSprites/MemCardSprites/mem_bad"
	LoadTexture no_vram_alloc "PanelSprites/MemCardSprites/mem_net"
	LoadTexture no_vram_alloc "PanelSprites/MemCardSprites/mem_tricks"
	LoadTexture no_vram_alloc "PanelSprites/MemCardSprites/mem_goals"
	
    // statistics menu
    LoadTexture no_vram_alloc "PanelSprites/comp_single_line"
	
    // park editor
	LoadTexture no_vram_alloc "PanelSprites/parked_piece_frame"
	
	// high scores menu
	LoadTexture no_vram_alloc "PanelSprites/HighScore"
	
	// credits
	LoadTexture no_vram_alloc "PanelSprites/bot_gradient"
	LoadTexture no_vram_alloc "PanelSprites/top_gradient"
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/bink"
	
	// competition leader board
	LoadTexture no_vram_alloc "PanelSprites/comp_base_line"
	LoadTexture no_vram_alloc "PanelSprites/comp_fill"
	LoadTexture no_vram_alloc "PanelSprites/comp_end_cap"
	LoadTexture no_vram_alloc "PanelSprites/comp_hori_lines"
	LoadTexture no_vram_alloc "PanelSprites/comp_tall_line"
	LoadTexture no_vram_alloc "PanelSprites/spot_goals"
	LoadTexture no_vram_alloc "PanelSprites/scj_goals"
	LoadTexture no_vram_alloc "PanelSprites/5050_goals"
	LoadTexture no_vram_alloc "Themes/pa_theme/PA_goals"
	LoadTexture no_vram_alloc "PanelSprites/nixon"
	if IsPS2
		LoadTexture no_vram_alloc "PanelSprites/gslogo"
	endif
	
	// new pause menu pieces
	LoadTexture no_vram_alloc "PanelSprites/bg_gradient_1"
	LoadTexture no_vram_alloc "MainmenuSprites/kyron"
	
	// create a trick
	LoadTexture no_vram_alloc "PanelSprites/cat_bar"
	LoadTexture no_vram_alloc "PanelSprites/cat_box"
	LoadTexture no_vram_alloc "PanelSprites/cat_point"
	LoadTexture no_vram_alloc "PanelSprites/cat_anim_rot"
	
    // themed dialog box
	LoadTexture no_vram_alloc "PanelSprites/snaz_t_l"
	LoadTexture no_vram_alloc "PanelSprites/snaz_t_m"
	LoadTexture no_vram_alloc "PanelSprites/snaz_t_r"
	LoadTexture no_vram_alloc "PanelSprites/snaz_m_l"
	LoadTexture no_vram_alloc "PanelSprites/snaz_m_m"
	LoadTexture no_vram_alloc "PanelSprites/snaz_m_r"
	LoadTexture no_vram_alloc "PanelSprites/snaz_b_l"
	LoadTexture no_vram_alloc "PanelSprites/snaz_b_m"
	LoadTexture no_vram_alloc "PanelSprites/snaz_b_r"
	
    // top and bottom block
    LoadTexture no_vram_alloc "PanelSprites/strip_1"
	LoadTexture no_vram_alloc "PanelSprites/strip_2"
	LoadTexture no_vram_alloc "PanelSprites/strip_3"
	LoadTexture no_vram_alloc "PanelSprites/strip_4"
	LoadTexture no_vram_alloc "PanelSprites/strip_5"
	LoadTexture no_vram_alloc "PanelSprites/strip_6"
	LoadTexture no_vram_alloc "PanelSprites/strip_7"
	LoadTexture no_vram_alloc "PanelSprites/strip_8"
	LoadTexture no_vram_alloc "PanelSprites/strip_9"
	LoadTexture no_vram_alloc "PanelSprites/strip_10"
	
	LoadTexture no_vram_alloc "PanelSprites/streak_2"
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/checkmark"
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/checkbox"
	
	// cutscene camera hud piece
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/recdot"
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/videoscreen"
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/hangoverscreen"
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/videoborder"
	LoadTexture no_vram_alloc "MainmenuSprites/SharedSprites/videowhite"
	
endscript

debug_sprites = 0

script load_array_of_textures pre_file="panelsprites.pre"
	GetArraySize <textures>
	index=0
	
	PushMemProfile  "Fonts and Bitmaps"
	if ( <pre_file> = "Themes.pre" )
		MemPushContext ThemeHeap
	endif
	if NOT GotParam unload
		LoadLevelPreFile    <pre_file>
	endif
		begin
            if GotParam unload
				if ( debug_sprites = 1 )
					printf "unloading %t" t=(<textures>[<index>])
				endif
				UnloadTexture (<textures>[<index>])
			else
				if ( debug_sprites = 1 )
					printf "loading %t" t=(<textures>[<index>])
				endif
				LoadTexture no_vram_alloc (<textures>[<index>])
			endif
			index=(<index> + 1)
		repeat <array_size>
	if NOT GotParam unload
		UnLoadPreFile    <pre_file> dont_assert
	endif
	if ( <pre_file> = "Themes.pre" )
		MemPopContext
	endif
	PopMemProfile  //"Fonts and Bitmaps"
endscript

script load_theme_textures_to_main_memory
	pre_file="Themes.pre"
    
	/*
	// unused icons?
	LoadTexture no_vram_alloc "PanelSprites/Themes/pa_theme/PA_rescore"
    LoadTexture no_vram_alloc "PanelSprites/Themes/pa_theme/PA_fonts"
    LoadTexture no_vram_alloc "PanelSprites/Themes/pa_theme/PA_set_cust"
    LoadTexture no_vram_alloc "PanelSprites/Themes/pa_theme/PA_skip_cust"
    LoadTexture no_vram_alloc "PanelSprites/Themes/pa_theme/PA_restart"
    LoadTexture no_vram_alloc "PanelSprites/Themes/pa_theme/PA_cheats"
	LoadTexture no_vram_alloc "PanelSprites/Themes/pa_theme/PA_pause"
    LoadTexture no_vram_alloc "PanelSprites/Themes/pa_theme/PA_create"
	*/
	
	if GotParam unload_current
		theme=current_theme_prefix
		unload=1
		printf "load_theme_textures_to_main_memory unload_current %t" t=<theme>
	else
		if GotParam unload
			theme=last_theme_prefix
			printf "load_theme_textures_to_main_memory unload %t" t=<theme>
		else
			theme=current_theme_prefix
			printf "load_theme_textures_to_main_memory %t" t=<theme>
		endif
	endif
	
    switch <theme>
		case 0	
			// DE icons
			textures=[
				"Themes/de_theme/DE_paused_piece"
				"Themes/de_theme/DE_paused_icon"
				"Themes/de_theme/DE_grunge"
				"Themes/de_theme/DE_sub_frame"
				
				"Themes/de_theme/DE_continue"
				"Themes/de_theme/DE_options"
				"Themes/de_theme/DE_level"
				"Themes/de_theme/DE_save"
				"Themes/de_theme/DE_load"
				"Themes/de_theme/DE_replay"
				"Themes/de_theme/DE_end"
				"Themes/de_theme/DE_gap"
				"Themes/de_theme/DE_quit"
				"Themes/de_theme/DE_model"
				"Themes/de_theme/DE_retry"
				"Themes/de_theme/DE_view"
				"Themes/de_theme/DE_sound"
				"Themes/de_theme/DE_screen"
				"Themes/de_theme/DE_stats"
				"Themes/de_theme/DE_trick"
				"Themes/de_theme/DE_pro"
				"Themes/de_theme/DE_test_play"
				"Themes/de_theme/DE_theme"
				"Themes/de_theme/DE_resize"
				"Themes/de_theme/DE_nuke"
				"Themes/de_theme/DE_set_players"
				"Themes/de_theme/de_snaz_icon"
				"Themes/de_theme/de_online"
				"Themes/de_theme/de_edit_skater"
				"Themes/de_theme/de_skateshop"
				"Themes/de_theme/de_cheats"
				"Themes/de_theme/de_time"
				
				// edit tricks
				"Themes/de_theme/DE_grab" 
				"Themes/de_theme/DE_flip"
				"Themes/de_theme/DE_lip"
				"Themes/de_theme/DE_special"
			
				// create a trick
				"Themes/de_theme/DE_load_cat"
				"Themes/de_theme/DE_save_cat"
				"Themes/de_theme/DE_preview"
				"Themes/de_theme/DE_new"
				"Themes/de_theme/DE_back"
				"Themes/de_theme/DE_CAT"
				
				"Themes/de_theme/DE_CAD"
				"Themes/de_theme/DE_control"
				"Themes/de_theme/DE_movie"
				"Themes/de_theme/DE_career_ops"
				"Themes/de_theme/DE_2_player"
				"Themes/de_theme/DE_split"
				
				"Themes/de_theme/DE_mainmenu"
				"Themes/de_theme/DE_mainicon"
                "Themes/de_theme/DE_sponsor"
				"Themes/de_theme/DE_name_cat"
				"Themes/de_theme/DE_assign_cat"
				
				"Themes/de_theme/DE_homie"
				"Themes/de_theme/DE_vault"
			]
			
		case 1	
			// PA icons
			textures=[
				"Themes/pa_theme/PA_paused_piece"
				"Themes/pa_theme/PA_paused_icon"
				"Themes/pa_theme/PA_grunge"
				"Themes/pa_theme/PA_sub_frame"
				
				"Themes/pa_theme/PA_continue"
				"Themes/pa_theme/PA_retry" 
				"Themes/pa_theme/PA_end"
				"Themes/pa_theme/PA_view"
				"Themes/pa_theme/PA_level"
				"Themes/pa_theme/PA_save"
				"Themes/pa_theme/PA_load"
				"Themes/pa_theme/PA_options"
				"Themes/pa_theme/PA_model"
				"Themes/pa_theme/PA_quit"
				"Themes/pa_theme/PA_gap"
				"Themes/pa_theme/PA_replay"
				"Themes/pa_theme/PA_sound"
				"Themes/pa_theme/PA_screen"
				"Themes/pa_theme/PA_Stats"
				"Themes/pa_theme/PA_trick"
				"Themes/pa_theme/PA_pro"
				"Themes/pa_theme/PA_test_play"
				"Themes/pa_theme/PA_theme"
				"Themes/pa_theme/PA_resize"
				"Themes/pa_theme/PA_nuke"
				"Themes/pa_theme/PA_set_players"
				"Themes/pa_theme/PA_snaz_icon"
				"Themes/pa_theme/PA_online"
				"Themes/pa_theme/PA_edit_skater"
				"Themes/pa_theme/PA_skateshop"
				"Themes/pa_theme/PA_cheats"
				"Themes/pa_theme/PA_time"
				
				// edit tricks
				"Themes/pa_theme/PA_grab" 
				"Themes/pa_theme/PA_flip"
				"Themes/pa_theme/PA_lip"
				"Themes/pa_theme/PA_special"
				
				// create a trick
				"Themes/pa_theme/PA_load_cat"
				"Themes/pa_theme/PA_save_cat"
				"Themes/pa_theme/PA_preview"
				"Themes/pa_theme/PA_new"
				"Themes/pa_theme/PA_back"
				"Themes/pa_theme/PA_CAT"
						  	 
				"Themes/pa_theme/PA_CAD"
				"Themes/pa_theme/PA_control"
				"Themes/pa_theme/PA_movie"
				"Themes/pa_theme/PA_career_ops"
				"Themes/pa_theme/PA_2_player"
				"Themes/pa_theme/PA_split"
				
				"Themes/pa_theme/PA_mainmenu"
				"Themes/pa_theme/PA_mainicon"
				"Themes/pa_theme/PA_sponsor"
				"Themes/pa_theme/PA_name_cat"
				"Themes/pa_theme/PA_assign_cat"
				
				"Themes/pa_theme/PA_homie"
				"Themes/pa_theme/PA_vault"
			]
		
		case 2	
			// AL icons
			textures=[
				"Themes/al_theme/AL_paused_piece"
				"Themes/al_theme/AL_paused_icon"
				"Themes/al_theme/AL_grunge"
				"Themes/al_theme/AL_sub_frame"
				
				"Themes/al_theme/AL_continue"
				"Themes/al_theme/AL_options"
				"Themes/al_theme/AL_level"
				"Themes/al_theme/AL_save"
				"Themes/al_theme/AL_load"
				"Themes/al_theme/AL_replay"
				"Themes/al_theme/AL_end"
				"Themes/al_theme/AL_gap"
				"Themes/al_theme/AL_quit"
				"Themes/al_theme/AL_model"
				"Themes/al_theme/AL_retry"
				"Themes/al_theme/AL_view"
				"Themes/al_theme/AL_sound"
				"Themes/al_theme/AL_screen"
				"Themes/al_theme/AL_stats"
				"Themes/al_theme/AL_trick"
				"Themes/al_theme/AL_pro"
				"Themes/al_theme/AL_test_play"
				"Themes/al_theme/AL_theme"
				"Themes/al_theme/AL_resize"
				"Themes/al_theme/AL_nuke"
				"Themes/al_theme/AL_set_players"
				"Themes/al_theme/AL_snaz_icon"
				"Themes/al_theme/AL_online"
				"Themes/al_theme/AL_edit_skater"
				"Themes/al_theme/AL_skateshop"
				"Themes/al_theme/AL_cheats"
				"Themes/al_theme/AL_time"
			
				// edit tricks
				"Themes/al_theme/AL_grab" 
				"Themes/al_theme/AL_flip"
				"Themes/al_theme/AL_lip"
				"Themes/al_theme/AL_special"
				
				// create a trick
				"Themes/al_theme/AL_load_cat"
				"Themes/al_theme/AL_save_cat"
				"Themes/al_theme/AL_preview"
				"Themes/al_theme/AL_new"
				"Themes/al_theme/AL_back"
				"Themes/al_theme/AL_CAT"
						  	 
				"Themes/al_theme/AL_CAD"
				"Themes/al_theme/AL_control"
				"Themes/al_theme/AL_movie"
				"Themes/al_theme/AL_career_ops"
				"Themes/al_theme/AL_2_player"
				"Themes/al_theme/AL_split"
				
				"Themes/al_theme/AL_mainmenu"
				"Themes/al_theme/AL_mainicon"
				"Themes/al_theme/AL_sponsor"
				"Themes/al_theme/AL_name_cat"
				"Themes/al_theme/AL_assign_cat"
				
				"Themes/al_theme/AL_homie"
				"Themes/al_theme/AL_vault"
			]
		
		case 3
			// FU icons
			textures=[
				"Themes/fu_theme/FU_paused_piece"
				"Themes/fu_theme/FU_paused_icon"
				"Themes/fu_theme/FU_grunge"
				"Themes/fu_theme/FU_sub_frame"
				
				"Themes/fu_theme/FU_continue"
				"Themes/fu_theme/FU_options"
				"Themes/fu_theme/FU_level"
				"Themes/fu_theme/FU_save"
				"Themes/fu_theme/FU_load"
				"Themes/fu_theme/FU_replay"
				"Themes/fu_theme/FU_end"
				"Themes/fu_theme/FU_gap"
				"Themes/fu_theme/FU_quit"
				"Themes/fu_theme/FU_model"
				"Themes/fu_theme/FU_retry"
				"Themes/fu_theme/FU_view"
				"Themes/fu_theme/FU_sound"
				"Themes/fu_theme/FU_screen"
				"Themes/fu_theme/FU_stats"
				"Themes/fu_theme/FU_trick"
				"Themes/fu_theme/FU_pro"
				"Themes/fu_theme/FU_test_play"
				"Themes/fu_theme/FU_theme"
				"Themes/fu_theme/FU_resize"
				"Themes/fu_theme/FU_nuke"
				"Themes/fu_theme/FU_set_players"
				"Themes/fu_theme/FU_snaz_icon"
				"Themes/fu_theme/FU_online"
				"Themes/fu_theme/FU_edit_skater"
				"Themes/fu_theme/FU_skateshop"
				"Themes/fu_theme/FU_cheats"
				"Themes/fu_theme/FU_time"
				
				// edit tricks
				"Themes/fu_theme/FU_grab" 
				"Themes/fu_theme/FU_flip"
				"Themes/fu_theme/FU_lip"
				"Themes/fu_theme/FU_special"
				
				// create a trick
				"Themes/fu_theme/FU_load_cat"
				"Themes/fu_theme/FU_save_cat"
				"Themes/fu_theme/FU_preview"
				"Themes/fu_theme/FU_new"
				"Themes/fu_theme/FU_back"
				"Themes/fu_theme/FU_CAT"
						  	 
				"Themes/fu_theme/FU_CAD"
				"Themes/fu_theme/FU_control"
				"Themes/fu_theme/FU_movie"
				"Themes/fu_theme/FU_career_ops"
				"Themes/fu_theme/FU_2_player"
				"Themes/fu_theme/FU_split"
				
				"Themes/fu_theme/FU_mainmenu"
				"Themes/fu_theme/FU_mainicon"
				"Themes/fu_theme/FU_sponsor"
				"Themes/fu_theme/FU_name_cat"
				"Themes/fu_theme/FU_assign_cat"
				
				"Themes/fu_theme/FU_homie"
				"Themes/fu_theme/FU_vault"
			]
		
		case 4
			// NS icons
			textures=[
				"Themes/ns_theme/NS_paused_piece"
				"Themes/ns_theme/NS_paused_icon"
				"Themes/ns_theme/NS_grunge"
				"Themes/ns_theme/NS_sub_frame"
				
				"Themes/ns_theme/NS_continue"
				"Themes/ns_theme/NS_options"
				"Themes/ns_theme/NS_level"
				"Themes/ns_theme/NS_save"
				"Themes/ns_theme/NS_load"
				"Themes/ns_theme/NS_replay"
				"Themes/ns_theme/NS_end"
				"Themes/ns_theme/NS_gap"
				"Themes/ns_theme/NS_quit"
				"Themes/ns_theme/NS_model"
				"Themes/ns_theme/NS_retry"
				"Themes/ns_theme/NS_view"
				"Themes/ns_theme/NS_sound"
				"Themes/ns_theme/NS_screen"
				"Themes/ns_theme/NS_stats"
				"Themes/ns_theme/NS_trick"
				"Themes/ns_theme/NS_pro"
				"Themes/ns_theme/NS_test_play"
				"Themes/ns_theme/NS_theme"
				"Themes/ns_theme/NS_resize"
				"Themes/ns_theme/NS_nuke"
				"Themes/ns_theme/NS_set_players"
				"Themes/ns_theme/NS_snaz_icon"
				"Themes/ns_theme/NS_online"
				"Themes/ns_theme/NS_edit_skater"
				"Themes/ns_theme/NS_skateshop"
				"Themes/ns_theme/NS_cheats"
				"Themes/ns_theme/NS_time"
				
				// edit tricks
				"Themes/ns_theme/NS_grab" 
				"Themes/ns_theme/NS_flip"
				"Themes/ns_theme/NS_lip"
				"Themes/ns_theme/NS_special"
				
				// create a trick
				"Themes/ns_theme/NS_load_cat"
				"Themes/ns_theme/NS_save_cat"
				"Themes/ns_theme/NS_preview"
				"Themes/ns_theme/NS_new"
				"Themes/ns_theme/NS_back"
				"Themes/ns_theme/NS_CAT"
								 
				"Themes/ns_theme/NS_CAD"
				"Themes/ns_theme/NS_control"
				"Themes/ns_theme/NS_movie"
				"Themes/ns_theme/NS_career_ops"
				"Themes/ns_theme/NS_2_player"
				"Themes/ns_theme/NS_split"
				
				"Themes/ns_theme/NS_mainmenu"
				"Themes/ns_theme/NS_mainicon"
				"Themes/ns_theme/NS_sponsor"
				"Themes/ns_theme/NS_name_cat"
				"Themes/ns_theme/NS_assign_cat"
				
				"Themes/ns_theme/NS_homie"
				"Themes/ns_theme/NS_vault"
			]
			
		case 5
			// UG icons
			textures=[
				"Themes/ug_theme/UG_paused_piece"
				"Themes/ug_theme/UG_paused_icon"
				"Themes/ug_theme/UG_grunge"
				"Themes/ug_theme/UG_sub_frame"
				
				"Themes/ug_theme/UG_continue"
				"Themes/ug_theme/UG_options"
				"Themes/ug_theme/UG_level"
				"Themes/ug_theme/UG_save"
				"Themes/ug_theme/UG_load"
				"Themes/ug_theme/UG_replay"
				"Themes/ug_theme/UG_end"
				"Themes/ug_theme/UG_gap"
				"Themes/ug_theme/UG_quit"
				"Themes/ug_theme/UG_model"
				"Themes/ug_theme/UG_retry"
				"Themes/ug_theme/UG_view"
				"Themes/ug_theme/UG_sound"
				"Themes/ug_theme/UG_screen"
				"Themes/ug_theme/UG_stats"
				"Themes/ug_theme/UG_trick"
				"Themes/ug_theme/UG_pro"
				"Themes/ug_theme/UG_test_play"
				"Themes/ug_theme/UG_theme"
				"Themes/ug_theme/UG_resize"
				"Themes/ug_theme/UG_nuke"
				"Themes/ug_theme/UG_set_players"
				"Themes/ug_theme/UG_snaz_icon"
				"Themes/ug_theme/UG_online"
				"Themes/ug_theme/UG_edit_skater"
				"Themes/ug_theme/UG_skateshop"
				"Themes/ug_theme/UG_cheats"
				"Themes/ug_theme/UG_time"
				
				// edit tricks
				"Themes/ug_theme/UG_grab" 
				"Themes/ug_theme/UG_flip"
				"Themes/ug_theme/UG_lip"
				"Themes/ug_theme/UG_special"
				
				// create a trick
				"Themes/ug_theme/UG_load_cat"
				"Themes/ug_theme/UG_save_cat"
				"Themes/ug_theme/UG_preview"
				"Themes/ug_theme/UG_new"
				"Themes/ug_theme/UG_back"
				"Themes/ug_theme/UG_CAT"
								 
				"Themes/ug_theme/UG_CAD"
				"Themes/ug_theme/UG_control"
				"Themes/ug_theme/UG_movie"
				"Themes/ug_theme/UG_career_ops"
				"Themes/ug_theme/UG_2_player"
				"Themes/ug_theme/UG_split"
				
				"Themes/ug_theme/UG_mainmenu"
				"Themes/ug_theme/UG_mainicon"
				"Themes/ug_theme/UG_sponsor"
				"Themes/ug_theme/UG_name_cat"
				"Themes/ug_theme/UG_assign_cat"
				
				"Themes/ug_theme/UG_homie"
				"Themes/ug_theme/UG_vault"
			]
		
		case 6
		case 7
		case 8
		case 9
		case 10
		case 11
		case 12
		case 13
		case 14
            // Color specific pieces
			switch <theme>
				// sponsor sets
				case 6
					textures=[
						"Themes/sp1_theme/SP1_mainmenu"
						"Themes/sp1_theme/SP1_mainicon"
						"Themes/sp1_theme/SP1_paused_piece"
						"Themes/sp1_theme/SP1_sponsor"
					]
				case 7
					textures=[
						"Themes/sp2_theme/SP2_mainmenu"
						"Themes/sp2_theme/SP2_mainicon"
						"Themes/sp2_theme/SP2_paused_piece"
						"Themes/sp2_theme/SP2_sponsor"
					]
				case 8
					textures=[
						"Themes/sp3_theme/SP3_mainmenu"
						"Themes/sp3_theme/SP3_mainicon"
						"Themes/sp3_theme/SP3_paused_piece"
						"Themes/sp3_theme/SP3_sponsor"
					]
				case 9
					textures=[
						"Themes/sp4_theme/SP4_mainmenu"
						"Themes/sp4_theme/SP4_mainicon"
						"Themes/sp4_theme/SP4_paused_piece"
						"Themes/sp4_theme/SP4_sponsor"
					]
				case 10
					textures=[
						"Themes/sp5_theme/SP5_mainmenu"
						"Themes/sp5_theme/SP5_mainicon"
						"Themes/sp5_theme/SP5_paused_piece"
						"Themes/sp5_theme/SP5_sponsor"
					]
				// secret sets
				case 11
					textures=[
						"Themes/ss1_theme/SS1_mainmenu"
						"Themes/ss1_theme/SS1_mainicon"
						"Themes/ss1_theme/SS1_paused_piece"
						"Themes/ss1_theme/SS1_sponsor"
					]
				case 12
					textures=[
						"Themes/ss2_theme/SS2_mainmenu"
						"Themes/ss2_theme/SS2_mainicon"
						"Themes/ss2_theme/SS2_paused_piece"
						"Themes/ss2_theme/SS2_sponsor"
					]
				case 13
					textures=[
						"Themes/ss3_theme/SS3_mainmenu"
						"Themes/ss3_theme/SS3_mainicon"
						"Themes/ss3_theme/SS3_paused_piece"
						"Themes/ss3_theme/SS3_sponsor"
					]
				/*case 14
					textures=[
						"Themes/ss4_theme/SS4_mainmenu"
						"Themes/ss4_theme/SS4_mainicon"
						"Themes/ss4_theme/SS4_paused_piece"
						"Themes/ss4_theme/SS4_sponsor"
					]*/
				default
					printf "the game just crashed cause the theme swap got confused..."
				
			endswitch
            
			load_array_of_textures <...>
			
			// SP icons
			textures=[
                "Themes/sp_theme/SP_paused_icon"
				"Themes/sp_theme/SP_grunge"
				"Themes/sp_theme/SP_sub_frame"
				
				"Themes/sp_theme/SP_continue"
				"Themes/sp_theme/SP_options"
				"Themes/sp_theme/SP_level"
				"Themes/sp_theme/SP_save"
				"Themes/sp_theme/SP_load"
				"Themes/sp_theme/SP_replay"
				"Themes/sp_theme/SP_end"
				"Themes/sp_theme/SP_gap"
				"Themes/sp_theme/SP_quit"
				"Themes/sp_theme/SP_model"
				"Themes/sp_theme/SP_retry"
				"Themes/sp_theme/SP_view"
				"Themes/sp_theme/SP_sound"
				"Themes/sp_theme/SP_screen"
				"Themes/sp_theme/SP_stats"
				"Themes/sp_theme/SP_trick"
				"Themes/sp_theme/SP_pro"
				"Themes/sp_theme/SP_test_play"
				"Themes/sp_theme/SP_theme"
				"Themes/sp_theme/SP_resize"
				"Themes/sp_theme/SP_nuke"
				"Themes/sp_theme/SP_set_players"
				"Themes/sp_theme/SP_snaz_icon"
				"Themes/sp_theme/SP_online"
				"Themes/sp_theme/SP_edit_skater"
				"Themes/sp_theme/SP_skateshop"
				"Themes/sp_theme/SP_cheats"
				"Themes/sp_theme/SP_time"
				
				// edit tricks
				"Themes/sp_theme/SP_grab" 
				"Themes/sp_theme/SP_flip"
				"Themes/sp_theme/SP_lip"
				"Themes/sp_theme/SP_special"
				
				// create a trick
				"Themes/sp_theme/SP_load_cat"
				"Themes/sp_theme/SP_save_cat"
				"Themes/sp_theme/SP_preview"
				"Themes/sp_theme/SP_new"
				"Themes/sp_theme/SP_back"
				"Themes/sp_theme/SP_CAT"
								 
				"Themes/sp_theme/SP_CAD"
				"Themes/sp_theme/SP_control"
				"Themes/sp_theme/SP_movie"
				"Themes/sp_theme/SP_career_ops"
				"Themes/sp_theme/SP_2_player"
				"Themes/sp_theme/SP_split"
				
				"Themes/sp_theme/SP_name_cat"
				"Themes/sp_theme/SP_assign_cat"
				
				"Themes/sp_theme/SP_homie"
				"Themes/sp_theme/SP_vault"
			]
        
		default
			return
	endswitch
	
	load_array_of_textures <...>
endscript

script load_level_select_textures_to_main_memory
	pre_file="Levelselect.pre"
	
	// Level select!
	if GotParam unload
		printf "load_level_select_textures_to_main_memory unload"
	else
		printf "load_level_select_textures_to_main_memory"
	endif
    
	textures=[
		"LevelSelect/level_selected_dot"
		"LevelSelect/level_dot"
		"LevelSelect/secret_level_dot"
		"LevelSelect/map_graphic_1"
		"LevelSelect/map_graphic_2"
		"LevelSelect/map_graphic_3"
		"LevelSelect/map_graphic_4"
		"LevelSelect/map_graphic_5"
		"LevelSelect/map_graphic_6"
		
		// also used in chapter menus
		"Chapters/chapter_bg"
		"PanelSprites/bg_elements"
	]
	
	load_array_of_textures <...> 
    
    printf "done load_level_select_textures_to_main_memory"
endscript

script load_chapter_textures_to_main_memory
	pre_file="Chapters.pre"
	// chapter menu
	if GotParam unload
		printf "load_chapter_textures_to_main_memory unload"
	else
		printf "load_chapter_textures_to_main_memory"
	endif
	
	textures=[
		"PanelSprites/filmstripbar"
		"PanelSprites/final"
        "PanelSprites/bg_elements"
		"PanelSprites/bg_vector_2"
		
		"Chapters/chap_dot"
		"Chapters/chap_dot_done"
		"Chapters/chap_dot_highlight"
		"Chapters/chapter_bg"
		
		"Chapters/chap_graphic_1"
		"Chapters/chap_graphic_2"
		"Chapters/chap_graphic_3"
		"Chapters/chap_graphic_4"
		"Chapters/chap_graphic_5"
		"Chapters/chap_graphic_6"
		"Chapters/chap_graphic_7"
		"Chapters/chap_graphic_8"
		;"Chapters/chap_graphic_9"
		"Chapters/chap_graphic_10"
		;"Chapters/chap_graphic_11"
		;"Chapters/chap_graphic_12"
		;"Chapters/chap_graphic_13"
		;"Chapters/chap_graphic_14"
		;"Chapters/chap_graphic_15"
		;"Chapters/chap_graphic_16"
		;"Chapters/chap_graphic_17"
		;"Chapters/chap_graphic_18"
		;"Chapters/chap_graphic_19"
		;"Chapters/chap_graphic_20"
		;"Chapters/chap_graphic_21"
		;"Chapters/chap_graphic_22"
		;"Chapters/chap_graphic_23"
		;"Chapters/chap_graphic_24"
		"Chapters/chap_graphic_25"
		"Chapters/chap_graphic_26"
	]
	
	load_array_of_textures <...>
endscript

script load_cas_textures_to_main_memory
	pre_file="MainmenuSprites.pre"
	if GotParam unload
		printf "load_cas_textures_to_main_memory unload"
	else
		printf "load_cas_textures_to_main_memory"
	endif
	textures=[
		// edit skater
		"MainmenuSprites/SharedSprites/tab1"
		"MainmenuSprites/SharedSprites/tab2"
		"MainmenuSprites/SharedSprites/tab3"
		"MainmenuSprites/SharedSprites/repeat_piece"
		"MainmenuSprites/SharedSprites/repeat_piece2"
		"MainmenuSprites/SharedSprites/repeat_piece3"
		"MainmenuSprites/SharedSprites/menu_bottom"
		"MainmenuSprites/SharedSprites/ED_board"
		"MainmenuSprites/SharedSprites/ED_done"
		"MainmenuSprites/SharedSprites/ED_head"
		"MainmenuSprites/SharedSprites/ED_info"
		"MainmenuSprites/SharedSprites/ED_legs"
		"MainmenuSprites/SharedSprites/ED_pads"
		"MainmenuSprites/SharedSprites/ED_resize"
		"MainmenuSprites/SharedSprites/ED_secret"
		"MainmenuSprites/SharedSprites/ED_scale"
		"MainmenuSprites/SharedSprites/ED_tat"
		"MainmenuSprites/SharedSprites/ED_torso"
		"MainmenuSprites/SharedSprites/ED_tricks"
		"MainmenuSprites/SharedSprites/edit_bar"
		"MainmenuSprites/SharedSprites/rot_bar"
		"MainmenuSprites/SharedSprites/scale_bar"
		
		// face mapping
		"MainmenuSprites/myf_example"
		"MainmenuSprites/myf_arrow"
		"MainmenuSprites/myf_crosshair"
		"MainmenuSprites/myf_dot"
		"MainmenuSprites/myf_x"
		"MainmenuSprites/myf_frame"
		"MainmenuSprites/myf_box_left"
		"MainmenuSprites/myf_box_mid"
		"MainmenuSprites/myf_box_right"
		"PanelSprites/nokia_phone"
		
		// Create A Deck
		"MainmenuSprites/SharedSprites/CD_base"
		"MainmenuSprites/SharedSprites/CD_layer1"
		"MainmenuSprites/SharedSprites/CD_layer2"
		"MainmenuSprites/SharedSprites/CD_layer3"
		"MainmenuSprites/SharedSprites/CD_layer4"
		"MainmenuSprites/SharedSprites/CD_layer5"
		
		// Color sliders
		"MainmenuSprites/SharedSprites/bw_slider"
		"MainmenuSprites/SharedSprites/colorbar"
		"MainmenuSprites/SharedSprites/scalebar"
		"MainmenuSprites/SharedSprites/scale_down"
		"MainmenuSprites/SharedSprites/scale_up"
		
		// CAD logos
		"../textures/board_layers/CD_NSN_graphic_01"
		"../textures/board_layers/CD_NSN_graphic_02"
		"../textures/board_layers/CD_NSN_graphic_03"
		"../textures/board_layers/CD_NSN_graphic_04"
		"../textures/board_layers/CD_NSN_graphic_05"
		"../textures/board_layers/CD_NSN_graphic_06"
		"../textures/board_layers/CD_NSN_graphic_07"
		"../textures/board_layers/CD_NSN_graphic_08"
		"../textures/board_layers/CD_NSN_graphic_09"
		"../textures/board_layers/CD_NSN_graphic_10"
        "../textures/board_layers/CD_graphic_T01_01"
        "../textures/board_layers/CD_graphic_T01_02"
        "../textures/board_layers/CD_graphic_T01_03"
        "../textures/board_layers/CD_graphic_T01_04"
        "../textures/board_layers/CD_graphic_T01_05"
		"../textures/board_layers/CD_graphic_T01_06"
		"../textures/board_layers/CD_graphic_T01_07"
		"../textures/board_layers/CD_graphic_T01_08"
		"../textures/board_layers/CD_graphic_T01_09"
		"../textures/board_layers/CD_graphic_T01_10"
		"../textures/board_layers/CD_graphic_T01_11"
		"../textures/board_layers/CD_graphic_T01_12"
		"../textures/board_layers/CD_graphic_T01_13"
		"../textures/board_layers/CD_graphic_T01_14"
		"../textures/board_layers/CD_graphic_T01_15"
		"../textures/board_layers/CD_graphic_T01_16"
		"../textures/board_layers/CD_graphic_T01_17"
		"../textures/board_layers/CD_graphic_T01_18"
		"../textures/board_layers/CD_graphic_T01_19"
		"../textures/board_layers/CD_graphic_T01_20"
		"../textures/board_layers/CD_graphic_T01_21"
        "../textures/board_layers/CD_graphic_T02_01"
        "../textures/board_layers/CD_graphic_T02_02"
        "../textures/board_layers/CD_graphic_T02_03"
        "../textures/board_layers/CD_graphic_T02_04"
        "../textures/board_layers/CD_graphic_T02_05"
        "../textures/board_layers/CD_graphic_T03_01"
        "../textures/board_layers/CD_graphic_T03_02"
        "../textures/board_layers/CD_graphic_T03_03"
        "../textures/board_layers/CD_graphic_T03_04"
        "../textures/board_layers/CD_graphic_T03_05"
        "../textures/board_layers/CD_graphic_T04_01"
        "../textures/board_layers/CD_graphic_T04_02"
        "../textures/board_layers/CD_graphic_T04_03"
        "../textures/board_layers/CD_graphic_T04_04"
        "../textures/board_layers/CD_graphic_T04_05"
		"../textures/board_layers/CD_graphic_T06_01"
		"../textures/board_layers/CD_graphic_T06_02"
		"../textures/board_layers/CD_graphic_T06_03"
		"../textures/board_layers/CD_graphic_T06_04"
		"../textures/board_layers/CD_graphic_T06_05"
		"../textures/board_layers/CD_graphic_T07_01"
		"../textures/board_layers/CD_graphic_T07_02"
		"../textures/board_layers/CD_graphic_T07_03"
		"../textures/board_layers/CD_graphic_T07_04"
		"../textures/board_layers/CD_graphic_T07_05"
		"../textures/board_layers/CD_graphic_T08_01"
		"../textures/board_layers/CD_graphic_T08_02"
		"../textures/board_layers/CD_graphic_T08_03"
		"../textures/board_layers/CD_graphic_T08_04"
		"../textures/board_layers/CD_graphic_T08_05"
		"../textures/board_layers/CD_graphic_T09_01"
		"../textures/board_layers/CD_graphic_T09_02"
		"../textures/board_layers/CD_graphic_T09_03"
		"../textures/board_layers/CD_graphic_T10_01"
		"../textures/board_layers/CD_graphic_T10_02"
		"../textures/board_layers/CD_graphic_T10_03"
		"../textures/board_layers/CD_graphic_T10_04"
		"../textures/board_layers/CD_graphic_T10_05"
		"../textures/board_layers/CD_graphic_T10_06"
		"../textures/board_layers/CD_graphic_T10_07"
		"../textures/board_layers/CD_graphic_T10_08"
		"../textures/board_layers/CD_graphic_T10_09"
		"../textures/board_layers/CD_graphic_T10_10"
		"../textures/board_layers/CD_graphic_T10_11"
		"../textures/board_layers/CD_graphic_T10_12"
		"../textures/board_layers/CD_graphic_T10_13"
		"../textures/board_layers/CD_graphic_T10_14"
		"../textures/board_layers/CD_graphic_T10_15"
		"../textures/board_layers/CD_graphic_T10_16"
		"../textures/board_layers/CD_graphic_T10_17"
		"../textures/board_layers/CD_graphic_T10_18"
		"../textures/board_layers/CD_graphic_T10_19"
		"../textures/board_layers/CD_graphic_T10_20"
		"../textures/board_layers/CD_graphic_T10_21"
		"../textures/board_layers/CD_graphic_T10_22"
		"../textures/board_layers/CD_graphic_T10_23"
		"../textures/board_layers/CD_graphic_T10_24"
		"../textures/board_layers/CD_graphic_T10_25"
		"../textures/board_layers/CD_graphic_T10_26"
		"../textures/board_layers/CD_graphic_T10_27"
		"../textures/board_layers/CD_graphic_T10_28"
		"../textures/board_layers/CD_graphic_T10_29"
		"../textures/board_layers/CD_graphic_T10_30"
		"../textures/board_layers/CD_graphic_T10_31"
		"../textures/board_layers/CD_graphic_T10_32"
		"../textures/board_layers/CD_graphic_T10_33"
		"../textures/board_layers/CD_graphic_T10_34"
		"../textures/board_layers/CD_graphic_T10_35"
		"../textures/board_layers/CD_graphic_T10_36"
		"../textures/board_layers/CD_graphic_T11_01"
		"../textures/board_layers/CD_graphic_T11_02"
		"../textures/board_layers/CD_graphic_T11_03"
		"../textures/board_layers/CD_graphic_T11_04"
		"../textures/board_layers/CD_graphic_T11_05"
		"../textures/board_layers/CD_graphic_T11_06"
		"../textures/board_layers/CD_graphic_T11_07"
		"../textures/board_layers/CD_graphic_T11_08"
		"../textures/board_layers/CD_graphic_T11_09"
		"../textures/board_layers/CD_graphic_T11_10"
		"../textures/board_layers/CD_graphic_T11_11"
		"../textures/board_layers/CD_graphic_T11_12"
		"../textures/board_layers/CD_graphic_T11_13"
		"../textures/board_layers/CD_graphic_T12_01"
		"../textures/board_layers/CD_graphic_T12_02"
		"../textures/board_layers/CD_graphic_T12_03"
		"../textures/board_layers/CD_graphic_T12_04"
		"../textures/board_layers/CD_graphic_T12_05"
		"../textures/board_layers/CD_graphic_T12_06"
		"../textures/board_layers/CD_graphic_T12_07"
		"../textures/board_layers/CD_graphic_T12_08"
		"../textures/board_layers/CD_graphic_T12_09"
		"../textures/board_layers/CD_graphic_T12_10"
		"../textures/board_layers/CD_graphic_T12_11"
		"../textures/board_layers/CD_graphic_T12_12"
		"../textures/board_layers/CD_graphic_T12_13"
		"../textures/board_layers/CD_graphic_T13_01"
		"../textures/board_layers/CD_graphic_T13_02"
		"../textures/board_layers/CD_graphic_T13_03"
		"../textures/board_layers/CD_graphic_T13_04"
		"../textures/board_layers/CD_graphic_T13_05"
		"../textures/board_layers/CD_graphic_T13_06"
		"../textures/board_layers/CD_graphic_T13_07"
		"../textures/board_layers/CD_graphic_T13_08"
		"../textures/board_layers/CD_graphic_T13_09"
		"../textures/board_layers/CD_graphic_T13_10"
		"../textures/board_layers/CD_graphic_T13_11"
		"../textures/board_layers/CD_graphic_T13_12"
		"../textures/board_layers/CD_graphic_T13_13"
		"../textures/board_layers/CD_graphic_T14_01"
		"../textures/board_layers/CD_graphic_T14_02"
		"../textures/board_layers/CD_graphic_T14_03"
		"../textures/board_layers/CD_graphic_T14_04"
		"../textures/board_layers/CD_graphic_T14_05"
		"../textures/board_layers/CD_graphic_T14_06"
		"../textures/board_layers/CD_graphic_T14_07"
		"../textures/board_layers/CD_graphic_T14_08"
		"../textures/board_layers/CD_graphic_T14_09"
		"../textures/board_layers/CD_graphic_T14_10"
		"../textures/board_layers/CD_graphic_T14_11"
		"../textures/board_layers/CD_graphic_T14_12"


        
		// CAD deck graphics
		"../textures/boards/casB01"
		"../textures/boards/casB02"
		"../textures/boards/casB03"
		"../textures/boards/casB04"
		"../textures/boards/casB05"
		"../textures/boards/casB06"
		"../textures/boards/casB07"
		"../textures/boards/casB08"
		"../textures/boards/casB09"
		"../textures/boards/casB10"
		"../textures/boards/casB11"
		"../textures/boards/casB12"
		"../textures/boards/casB13"
		"../textures/boards/casB14"
		"../textures/boards/casB15"
		"../textures/boards/casB16"
		"../textures/boards/casB17"
		"../textures/boards/casB18"
		"../textures/boards/casB19"
		"../textures/boards/casB20"
		"../textures/boards/casB21"
		"../textures/boards/casB22"
		"../textures/boards/casB23"
		"../textures/boards/casB24"
		"../textures/boards/casB25"
		"../textures/boards/casB26"
		"../textures/boards/casB27"
		"../textures/boards/casB28"
		"../textures/boards/casB29"
		"../textures/boards/casB30"
		"../textures/boards/casB31"
		"../textures/boards/casB32"
		"../textures/boards/casB33"
		"../textures/boards/casB34"
		"../textures/boards/casB35"
		"../textures/boards/casB36"
		"../textures/boards/casB37"
		"../textures/boards/casB38"
	
		
		
		// shirt logos
		"../textures/logos/Sht_Activision01"
		"../textures/logos/Sht_Adio01"
        "../textures/logos/Sht_Almost01"
		"../textures/logos/Sht_baker01"
		"../textures/logos/Sht_billabong01"
		"../textures/logos/Sht_birdhouse01"
		"../textures/logos/Sht_bootleg01"
		"../textures/logos/Sht_Burnquist01"
        "../textures/logos/Sht_Butterfinger01"
		"../textures/logos/Sht_circa01"
		"../textures/logos/Sht_DCShoes01"
		"../textures/logos/Sht_element01"
		"../textures/logos/Sht_emerica01"
		"../textures/logos/Sht_es01"
		"../textures/logos/Sht_etnies01"
		"../textures/logos/Sht_firm01"
		"../textures/logos/Sht_flip01"
		"../textures/logos/Sht_girl01"
		"../textures/logos/Sht_globe01"
		"../textures/logos/Sht_hawkc01"
		"../textures/logos/Sht_hawks01"
		"../textures/logos/Sht_hurley01"
		"../textures/logos/Sht_independent01"
		"../textures/logos/Sht_krux01"
		"../textures/logos/Sht_Mcdonalds01"
		"../textures/logos/Sht_Mcdonalds02"
		"../textures/logos/Sht_Neversoft01"
        "../textures/logos/Sht_Newline01"
        "../textures/logos/Sht_Nixon01"
		"../textures/logos/Sht_Nokia01"
		"../textures/logos/Sht_Nokia02"
        "../textures/logos/Sht_peralta01"
		"../textures/logos/Sht_quiksilver01"
		"../textures/logos/Sht_ricta01"
		"../textures/logos/Sht_shortys01"
		"../textures/logos/Sht_skatelab01"
        "../textures/logos/Sht_slamcity01"
		"../textures/logos/Sht_spot01"		
        "../textures/logos/Sht_THPS101"
		"../textures/logos/Sht_THPS201"
		"../textures/logos/Sht_THPS301"
		"../textures/logos/Sht_thps401"
		"../textures/logos/Sht_thug"
        "../textures/logos/Sht_transworld01"
		"../textures/logos/Sht_vans01"
		"../textures/logos/Sht_volcom01"
		"../textures/logos/Sht_vonzipper01"		
        "../textures/logos/Sht_zero01"
        "../textures/logos/Sht_westies01"
		"../textures/logos/Sht_Cab_Sign"
		"../textures/logos/Sht_Cab_Zen"
        "../textures/logos/Sht_deadend01"
        "../textures/logos/Sht_braineaters01"
        "../textures/logos/Sht_riktor01"
        "../textures/logos/Sht_test"

        
        		
        // hat logos
		"../textures/logos/Hat_Activision01"
		"../textures/logos/Hat_Adio01"
        "../textures/logos/Hat_Almost01"
		"../textures/logos/Hat_baker01"
		"../textures/logos/Hat_billabong01"
		"../textures/logos/Hat_birdhouse01"
		"../textures/logos/Hat_bootleg01"
		"../textures/logos/Hat_burnquist01"		
		"../textures/logos/Hat_butterfinger01"        
        "../textures/logos/Hat_circa01"
		"../textures/logos/Hat_dcshoes01"		
        "../textures/logos/Hat_element01"
		"../textures/logos/Hat_emerica01"
		"../textures/logos/Hat_es01"
		"../textures/logos/Hat_etnies01"
		"../textures/logos/Hat_firm01"
		"../textures/logos/Hat_flip01"
		"../textures/logos/Hat_girl01"
		"../textures/logos/Hat_globe01"
		"../textures/logos/Hat_hawkc01"
		"../textures/logos/Hat_hawks01"
		"../textures/logos/Hat_hurley01"
		"../textures/logos/Hat_independent01"
		"../textures/logos/Hat_krux01"
		"../textures/logos/Hat_Mcdonalds01"		
		"../textures/logos/Hat_Mcdonalds02"        
		"../textures/logos/Hat_Newline01"        
        "../textures/logos/Hat_Neversoft01"
		"../textures/logos/Hat_Nixon01"        
		"../textures/logos/Hat_Nokia01"
        "../textures/logos/Hat_peralta01"
        "../textures/logos/Hat_powell01"		
        "../textures/logos/Hat_quiksilver01"
		"../textures/logos/Hat_ricta01"
		"../textures/logos/Hat_shortys01"
		"../textures/logos/Hat_skatelab01"
		"../textures/logos/Hat_slamcity01"
		"../textures/logos/Hat_spot01"
		"../textures/logos/Hat_THPS101"
		"../textures/logos/Hat_THPS201"
		"../textures/logos/Hat_THPS301"
		"../textures/logos/Hat_THPS401"
		"../textures/logos/Hat_THUG01"
		"../textures/logos/Hat_Transworld01"
		"../textures/logos/Hat_vans01"
		"../textures/logos/Hat_volcom01"
		"../textures/logos/Hat_vonzipper01"		
        "../textures/logos/Hat_zero01"
        "../textures/logos/Hat_westies01"
		
		// tattoos
		// head
		"../textures/skater_male/CS_DM_Tat_Head_Chest_07"
		"../textures/skater_male/CS_DM_Tat_Head_2"
		"../textures/skater_male/CS_DM_Tat_Head_3"
		"../textures/skater_male/CS_DM_Tat_Head_4"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_32"
		"../textures/skater_male/CS_DM_Tat_Chest_2"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_11"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_15"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_21"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_36"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_41"
		"../textures/skater_male/CS_NN_tat_head02"
		"../textures/skater_male/CS_NN_tat_head03"
		"../textures/skater_male/CS_DM_tat_head_5"
		"../textures/skater_male/CS_DM_tat_head_6"
		"../textures/skater_male/CS_DM_Tat_Extra_Head_Chest_1"
		"../textures/skater_male/CS_DM_Tat_Extra_Head_Chest_2"
		"../textures/skater_male/CS_DM_Tat_Extra_Head_Chest_3"
		"../textures/skater_male/CS_DM_Tat_Extra_Head_Chest_4"
		"../textures/skater_male/CS_DM_Tat_Extra_Head_Chest_5"
		"../textures/skater_male/CS_DM_Tat_Extra_Head_Chest_6"
		"../textures/skater_male/CS_DM_Tat_Extra_Head_Chest_7"
		"../textures/skater_male/CS_DM_Tat_Extra_Head_Chest_8"
		"../textures/skater_male/CS_DM_Tat_Extra_Head_Chest_9"
		"../textures/skater_male/CS_DM_Tat_Extra_Head_Chest_10"
			  	   		
		// chest
		"../textures/skater_male/CS_DM_Tat_Chest_1"
        "../textures/skater_male/CS_DM_Tat_Chest_4"
		"../textures/skater_male/CS_DM_Tat_Chest_6"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_10"
		"../textures/skater_male/CS_DM_Tat_Chest_9"
		"../textures/skater_male/CS_DM_Tat_Chest_13"
		"../textures/skater_male/CS_DM_Tat_Chest_14"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_18"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_06"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_25"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_26"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_29"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_30"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_34"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_42"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_43"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_44"
        "../textures/skater_male/CS_NN_Thomas_Tat_chest01"
		
		// back
        "../textures/skater_male/CS_DM_Tat_Head_Chest_39"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_31"
		"../textures/skater_male/CS_DM_Tat_Head_Chest_12"
		
		// arms and legs
		"../textures/skater_male/CS_DM_Tat_Arm1"
		"../textures/skater_male/CS_DM_Tat_Arm2"
		"../textures/skater_male/CS_DM_Tat_Arm3"
		"../textures/skater_male/CS_DM_Tat_Arm4"
		"../textures/skater_male/CS_DM_Tat_Arm5"
		"../textures/skater_male/CS_DM_Tat_Arm6"
		"../textures/skater_male/CS_DM_Tat_Arm7"
		"../textures/skater_male/CS_DM_Tat_Arm8"
		"../textures/skater_male/CS_DM_Tat_Arm9"
		"../textures/skater_male/CS_DM_Tat_Arm10"
		"../textures/skater_male/CS_DM_Tat_Arm11"
		"../textures/skater_male/CS_DM_Tat_Arm12"
		"../textures/skater_male/CS_DM_Tat_Arm13"
		"../textures/skater_male/CS_DM_Tat_Arm14"
		"../textures/skater_male/CS_DM_Tat_Arm15"
		
		"../textures/skater_male/CS_DM_Tat_FArm1"
		"../textures/skater_male/CS_DM_Tat_FArm2"
		"../textures/skater_male/CS_DM_Tat_FArm3"
		
		"../textures/skater_male/CS_DM_Tat_BArm1"
		"../textures/skater_male/CS_DM_Tat_BArm2"
		"../textures/skater_male/CS_DM_Tat_BArm3"
		"../textures/skater_male/CS_DM_Tat_BArm4"
		"../textures/skater_male/CS_DM_Tat_BArm5"
		"../textures/skater_male/CS_DM_Tat_BArm6"
		"../textures/skater_male/CS_DM_Tat_BArm7"
		"../textures/skater_male/CS_DM_Tat_BArm8"
		"../textures/skater_male/CS_DM_Tat_BArm9"
		"../textures/skater_male/CS_DM_Tat_BArm10"
		"../textures/skater_male/CS_DM_Tat_Extra_Arm_1"
		"../textures/skater_male/CS_DM_Tat_Extra_Arm_2"

		
	]
	
	load_array_of_textures <...>
endscript

script load_boardshop_textures_to_main_memory
   	pre_file="MainmenuSprites.pre"
	if GotParam unload
		printf "load_boardshop_textures_to_main_memory unload"
	else
		printf "load_boardshop_textures_to_main_memory"
	endif
	textures=[
		// edit skater
		"MainmenuSprites/SharedSprites/tab1"
		"MainmenuSprites/SharedSprites/tab2"
		"MainmenuSprites/SharedSprites/tab3"
		"MainmenuSprites/SharedSprites/repeat_piece"
		"MainmenuSprites/SharedSprites/repeat_piece2"
		"MainmenuSprites/SharedSprites/repeat_piece3"
		"MainmenuSprites/SharedSprites/menu_bottom"
		"MainmenuSprites/SharedSprites/ED_board"
		"MainmenuSprites/SharedSprites/ED_done"
		"MainmenuSprites/SharedSprites/ED_head"
		"MainmenuSprites/SharedSprites/ED_info"
		"MainmenuSprites/SharedSprites/ED_legs"
		"MainmenuSprites/SharedSprites/ED_pads"
		"MainmenuSprites/SharedSprites/ED_resize"
		"MainmenuSprites/SharedSprites/ED_secret"
		"MainmenuSprites/SharedSprites/ED_scale"
		"MainmenuSprites/SharedSprites/ED_tat"
		"MainmenuSprites/SharedSprites/ED_torso"
		"MainmenuSprites/SharedSprites/ED_tricks"
		"MainmenuSprites/SharedSprites/edit_bar"
		
        // Create A Deck
		"MainmenuSprites/SharedSprites/CD_base"
		"MainmenuSprites/SharedSprites/CD_layer1"
		"MainmenuSprites/SharedSprites/CD_layer2"
		"MainmenuSprites/SharedSprites/CD_layer3"
		"MainmenuSprites/SharedSprites/CD_layer4"
		"MainmenuSprites/SharedSprites/CD_layer5"
		
		// Color sliders
		"MainmenuSprites/SharedSprites/bw_slider"
		"MainmenuSprites/SharedSprites/colorbar"
		"MainmenuSprites/SharedSprites/scalebar"
		"MainmenuSprites/SharedSprites/scale_down"
		"MainmenuSprites/SharedSprites/scale_up"
		
        // Skater Decks
		"../textures/boards/PR_AL_deck01"
		"../textures/boards/PR_AL_deck02"        		
		"../textures/boards/PR_BA_deck03"
        "../textures/boards/PR_BA_deck04"        
        "../textures/boards/PR_BH_deck05"
        "../textures/boards/PR_BH_deck06"
        "../textures/boards/PR_BO_deck07"
        "../textures/boards/PR_EL_deck08"                
        "../textures/boards/PR_EL_deck09"
        "../textures/boards/PR_FR_deck10"        
        "../textures/boards/PR_FR_deck11"        
        "../textures/boards/PR_FL_deck12" 
        "../textures/boards/PR_FL_deck13"                 
        "../textures/boards/PR_GR_deck14"
        "../textures/boards/PR_GR_deck15"                
        "../textures/boards/PR_PO_deck16"
        "../textures/boards/PR_SH_deck17"
        "../textures/boards/PR_SH_deck18"                        
        "../textures/boards/PR_ZR_deck19" 
        "../textures/boards/PR_ZR_deck20"                 
        "../textures/boards/BH_deck01"
		"../textures/boards/BH_deck02"
		"../textures/boards/BH_deck03"
		"../textures/boards/BH_deck04"
		"../textures/boards/BH_deck05"
		"../textures/boards/BH_deck06"
		"../textures/boards/BH_deck07"
		"../textures/boards/BH_deck08"
		"../textures/boards/BH_deck09"
		"../textures/boards/BH_deck10"
        "../textures/boards/EL_deck01"
        "../textures/boards/EL_deck02"
        "../textures/boards/EL_deck03"
        "../textures/boards/EL_deck04"
        "../textures/boards/EL_deck05"
        "../textures/boards/EL_deck06"
        "../textures/boards/EL_deck07"
        "../textures/boards/EL_deck08"
        "../textures/boards/EL_deck09"
        "../textures/boards/EL_deck10"                
        "../textures/boards/FL_deck01"
        "../textures/boards/FL_deck02"
        "../textures/boards/FL_deck03"
        "../textures/boards/FL_deck04"
        "../textures/boards/FL_deck05"
        "../textures/boards/FL_deck06"
        "../textures/boards/FL_deck07"
        "../textures/boards/FL_deck08"
        "../textures/boards/FL_deck09"
        "../textures/boards/FL_deck10"
        "../textures/boards/GR_deck01"
        "../textures/boards/GR_deck02"
        "../textures/boards/GR_deck03"
        "../textures/boards/GR_deck04"
        "../textures/boards/GR_deck05"
        "../textures/boards/GR_deck06"
        "../textures/boards/GR_deck07"
        "../textures/boards/GR_deck08"
        "../textures/boards/GR_deck09"
        "../textures/boards/GR_deck10"
        "../textures/boards/ZR_deck01"
        "../textures/boards/ZR_deck02"
        "../textures/boards/ZR_deck03"
        "../textures/boards/ZR_deck04"
        "../textures/boards/ZR_deck05"
        "../textures/boards/ZR_deck06"
        "../textures/boards/ZR_deck07"
        "../textures/boards/ZR_deck08"
        "../textures/boards/ZR_deck09"
        "../textures/boards/ZR_deck10"
		
		// Griptape
		"../textures/boards/GenericG01"
		"../textures/boards/GenericG02"
		"../textures/boards/GenericG03"
		"../textures/boards/GenericG04"
		"../textures/boards/GenericG05"
		;"../textures/boards/GenericG06"
		"../textures/boards/GenericG07"
		"../textures/boards/GenericG08"
		"../textures/boards/GenericG09"
		"../textures/boards/GenericG10"
		"../textures/boards/GenericG11"
		"../textures/boards/GenericG12"
		"../textures/boards/GenericG13"
		"../textures/boards/GenericG14"
		"../textures/boards/GenericG15"
		"../textures/boards/HawkG01"
		"../textures/boards/CaballeroG01"
		"../textures/boards/GlifbergG01"
		"../textures/boards/KostonG01"
		"../textures/boards/MullenG01"
		"../textures/boards/MuskaG01"
		"../textures/boards/ThomasG01"
		
	]
	
	load_array_of_textures <...>
endscript

ParkedTexturesAreLoaded=0
script load_parked_textures_to_main_memory
    printscriptinfo
    // K: Added this to make this script safe to call twice in a row.
    // If the textures are already loaded, it will return without doing anything.
    // This is needed because when the parkeditor theme is changed, it reruns the
    // Load_Sk5Ed script, which will hence call load_parked_textures_to_main_memory again.
    // (Note: load_parked_textures_to_main_memory needs to be called from Load_Sk5Ed because
    // it needs to be called as early as possible, to prevent bottom-up fragmentation when switching themes)
	if GotParam unload
        Change ParkedTexturesAreLoaded=0        
    else
        if (ParkedTexturesAreLoaded=1)
            return
        endif
        Change ParkedTexturesAreLoaded=1
    endif    
        
	pre_file="MainmenuSprites.pre"
	if GotParam unload
		printf "load_parked_textures_to_main_memory unload"
	else
		printf "load_parked_textures_to_main_memory"
	endif
	textures=[
        // Need these
        "MainMenuSprites/SharedSprites/PA_startauto"
		
		// theme mainmenu bg
		"MainMenuSprites/MM_T_L"
		"MainMenuSprites/MM_T_M"
		"MainMenuSprites/MM_T_R"
		"MainMenuSprites/MM_M_L"
		"MainMenuSprites/MM_M_M"
		"MainMenuSprites/MM_M_R"
		"MainMenuSprites/MM_B_L"
		"MainMenuSprites/MM_B_M"
		"MainMenuSprites/MM_B_R"
		
		"MainMenuSprites/SharedSprites/generic_sub_frame"
		
		// Need all of these?
		"MainMenuSprites/SharedSprites/PA_shop"
        "MainMenuSprites/SharedSprites/PA_stopauto"
        "MainMenuSprites/SharedSprites/PA_hardware"
		"MainMenuSprites/SharedSprites/PA_connection"
		
		"MainmenuSprites/SharedSprites/mainbar"
		"MainmenuSprites/SharedSprites/longbar_edgy"
		"MainmenuSprites/SharedSprites/grungeframe_top"
		"MainmenuSprites/SharedSprites/bottom_l_cap"
		"MainmenuSprites/SharedSprites/bottom_mid"
		"MainmenuSprites/SharedSprites/bottom_r_cap"
		"MainmenuSprites/SharedSprites/highlight_skater"
		"MainmenuSprites/SharedSprites/lock_skater"
		"MainmenuSprites/SharedSprites/longbar"
		"MainmenuSprites/SharedSprites/longbar_cap"
        "MainmenuSprites/SharedSprites/mainbar_join"
		"MainmenuSprites/SharedSprites/off_skater"
		"MainmenuSprites/SharedSprites/stats_bg"
		"MainmenuSprites/SharedSprites/tab"
        "MainmenuSprites/SharedSprites/level_top_piece"
		"MainmenuSprites/SharedSprites/level_repeat_mid"
		"MainmenuSprites/SharedSprites/level_lower_piece"
		"MainmenuSprites/SharedSprites/level_bottom_piece"
		"MainmenuSprites/SharedSprites/level_bottom_cap"
        "MainmenuSprites/SharedSprites/grungeframe_mid"
		"MainmenuSprites/SharedSprites/grungeframe_bot"
	]
	
	load_array_of_textures <...>
endscript

script load_mainmenu_textures_to_main_memory
    printscriptinfo
	
	pre_file="MainmenuSprites.pre"
	// Main Menu
    if GotParam unload
		printf "load_mainmenu_textures_to_main_memory unload"
	else
		printf "load_mainmenu_textures_to_main_memory"
	endif
	
	textures=[
		// Sharedsprites
		"MainMenuSprites/SharedSprites/PA_shop"
		"MainMenuSprites/SharedSprites/PA_startauto"
		"MainMenuSprites/SharedSprites/PA_stopauto"
        "MainMenuSprites/SharedSprites/PA_hardware"
		"MainMenuSprites/SharedSprites/PA_connection"
		
		// main menu
		"MainMenuSprites/mm_vector_bg_1"
		"MainMenuSprites/bg_vector_1"
		"MainMenuSprites/mm_building"
        "MainMenuSprites/mm_clouds"
		
        // sound options
		"MainMenuSprites/SO_icon_1"
		"MainMenuSprites/SO_icon_2"
		"MainMenuSprites/SO_icon_3"
		"MainMenuSprites/SO_star"
		// movies
		"MainMenuSprites/MO_icon_1"
		"MainMenuSprites/MO_icon_2"
		"MainMenuSprites/MO_icon_3"
		"MainMenuSprites/MO_film"
		"MainMenuSprites/MO_star"
        // control setup
		"MainMenuSprites/CO_icon_1"
		"MainMenuSprites/CO_icon_2"
		"MainMenuSprites/CO_icon_3"
		"MainMenuSprites/CO_icon_3_b"
		"MainMenuSprites/CO_icon_4"
		"MainMenuSprites/CO_star"
		
		// screen mode
		"MainMenuSprites/sc_icon_1"
		"MainMenuSprites/sc_icon_2"
		
		// network setup
		"MainMenuSprites/NE_star"
		
		// network setup
		"MainMenuSprites/TA_star"
		
		// theme mainmenu bg
		"MainMenuSprites/MM_T_L"
		"MainMenuSprites/MM_T_M"
		"MainMenuSprites/MM_T_R"
		"MainMenuSprites/MM_M_L"
		"MainMenuSprites/MM_M_M"
		"MainMenuSprites/MM_M_R"
		"MainMenuSprites/MM_B_L"
		"MainMenuSprites/MM_B_M"
		"MainMenuSprites/MM_B_R"
		
		// blue bg
		"MainMenuSprites/mm_bg_2"
        
		// select skater
		"MainmenuSprites/SharedSprites/highlight_skater"
		"MainmenuSprites/SharedSprites/lock_skater"
		"MainmenuSprites/SharedSprites/off_skater"
		
		"HeadshotSprites/ss_tony"
		"HeadshotSprites/ss_bob"
		"HeadshotSprites/ss_steve"
		"HeadshotSprites/ss_kareem"
		"HeadshotSprites/ss_rune"
        "HeadshotSprites/ss_eric"
		"HeadshotSprites/ss_bucky"
		"HeadshotSprites/ss_bam"
		"HeadshotSprites/ss_rodney"
		"HeadshotSprites/ss_chad"
		"HeadshotSprites/ss_andrew"
		"HeadshotSprites/ss_paul"
		"HeadshotSprites/ss_geoff"
		"HeadshotSprites/ss_arto"
		"HeadshotSprites/ss_elissa"
		"HeadshotSprites/ss_jamie"
		"HeadshotSprites/ss_mike"
		"HeadshotSprites/SS_cas"
		"HeadshotSprites/SS_secret"
		"HeadshotSprites/SS_gene"
		"HeadshotSprites/SS_iron"
		"HeadshotSprites/SS_creature"
		"HeadshotSprites/SS_ped"
        "HeadshotSprites/SS_highlightbox"
        
		"MainmenuSprites/SS_sidewall"
		
        // old level select
		"MainmenuSprites/SharedSprites/level_top_piece"
		"MainmenuSprites/SharedSprites/level_repeat_mid"
		"MainmenuSprites/SharedSprites/level_lower_piece"
		"MainmenuSprites/SharedSprites/level_bottom_piece"
		"MainmenuSprites/SharedSprites/level_bottom_cap"
		"MainmenuSprites/SharedSprites/longbar_edgy"
		
		// network host options menu
		"MainmenuSprites/SharedSprites/grungeframe_top"
		"MainmenuSprites/SharedSprites/grungeframe_mid"
		"MainmenuSprites/SharedSprites/grungeframe_bot"
		
		// more internet stuff
		"MainmenuSprites/dnas"
		"MainmenuSprites/globe"
		"MainmenuSprites/satellite"
		"MainmenuSprites/io_play"
		"MainmenuSprites/io_face"
		"MainmenuSprites/io_login"
		"MainmenuSprites/io_up_park"
		"MainmenuSprites/io_down_park"
		"MainmenuSprites/io_stats"
		"MainmenuSprites/io_settings"
		"MainmenuSprites/satellite_beam"
		"MainmenuSprites/stat_scores"
		"MainmenuSprites/stat_combos"
		"MainmenuSprites/stat_personal"
		"MainmenuSprites/stat_players"
		"MainmenuSprites/mini_map"
		"MainMenuSprites/chat_bracket"
		"MainMenuSprites/neversoft"
		"MainMenuSprites/homie"
		"PanelSprites/best"
		
		// online ranking icons
		"MainmenuSprites/rank_0"
		"MainmenuSprites/rank_1"
		"MainmenuSprites/rank_2"
		"MainmenuSprites/rank_3"
		"MainmenuSprites/rank_4"
		"MainmenuSprites/rank_5"
		"MainmenuSprites/rank_6"
		"MainmenuSprites/rank_7"
		"MainmenuSprites/rank_8"
		"MainmenuSprites/rank_9"
		"MainmenuSprites/rank_10"
	]
	
    load_array_of_textures <...>
	
	if GotParam unload
		// Need UnloadAsset Script!
		;UnloadAsset "models\UI_bg\UI_bg.mdl"
		;UnloadAsset "models\mainmenu_bg\mainmenu_bg.mdl"
	else
		PushMemProfile  "Permanent Models"
			;LoadAsset "models\UI_bg\UI_bg.mdl"
			LoadAsset "models\mainmenu_bg\mainmenu_bg.mdl"
		PopMemProfile  //"Permanent Models"
	endif
endscript


