/*****************************************************************************
**																			**
**					   	  Neversoft Entertainment							**
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		Core Library											**
**																			**
**	Module:			Math (MTH)			   									**
**																			**
**	File name:		core/math/rot90.cpp										**
**																			**
**	Created:		07/17/02	-	grj										**
**																			**
**	Description:	Rotation 90 Math Class									**
**																			**
*****************************************************************************/

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

#include <core/math.h>
#include <core/math/rot90.h>

namespace Mth
{
	
/*****************************************************************************
**								  Externals									**
*****************************************************************************/

/*****************************************************************************
**								   Defines									**
*****************************************************************************/

/*****************************************************************************
**								DBG Defines									**
*****************************************************************************/

/*****************************************************************************
**								Private Types								**
*****************************************************************************/

/*****************************************************************************
**								 Private Data								**
*****************************************************************************/

/*****************************************************************************
**								 Public Data								**
*****************************************************************************/

/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/

/*****************************************************************************
**							   Private Functions							**
*****************************************************************************/

/*****************************************************************************
**								Public Functions							**
*****************************************************************************/

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

void		RotateY90( ERot90 angle, int32& x, int32& y, int32& z )
{
	int32 temp;

	switch (angle)
	{
	case ROT_0:
		break;

	case ROT_90:
		temp = x;
		x = z;
		z = -temp;
		break;

	case ROT_180:
		x = -x;
		z = -z;
		break;

	case ROT_270:
		temp = x;
		x = -z;
		z = temp;
		break;

	default:
		Dbg_MsgAssert(0, ("RotateY90() out of range: %d", angle));
		break;
	}
}

} // namespace Mth

