/*****************************************************************************
**																			**
**					   	  Neversoft Entertainment							**
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		Core Library											**
**																			**
**	Module:			Host (HOST_)											**
**																			**
**	File name:		core/host.h												**
**																			**
**	Created: 		05/27/99	-	mjb										**
**																			**
*****************************************************************************/

#ifndef __CORE_DEBUG_MEM_STAT_H
#define __CORE_DEBUG_MEM_STAT_H

#ifdef __NOPT_DEBUG__

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/


/*****************************************************************************
**								   Defines									**
*****************************************************************************/


/*****************************************************************************
**							     Type Defines								**
*****************************************************************************/

class Dbg_MEMORY_STATS
{

public :

	Dbg_MEMORY_STATS (  uint total = 0,	uint spike = 0,
						uint system = 0,	uint fixed = 0 );

private :

	uint		total;		// total memory currently allocated on behalf of this module/project
	uint		spike;		// peak total memory allocated on behalf of this module/project
	uint		system;		// current module/project private memory that is adjustable by the user
	uint		fixed;		// current module/project private memory that is a fixed overhead

};

/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/


/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/


/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/


/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/


/*****************************************************************************
**									Macros									**
*****************************************************************************/
									

/*****************************************************************************
**								Inline Functions							**
*****************************************************************************/

inline Dbg_MEMORY_STATS::Dbg_MEMORY_STATS ( uint total,  uint spike, 
											uint system, uint fixed )
	:	total ( total ), spike ( spike ), 
		system ( system ), fixed ( fixed )
{
}

#endif	// __NOPT_DEBUG__

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

#endif	// __CORE_DEBUG_SIGNATRS_H




