/* SCE CONFIDENTIAL
 "PlayStation 2" Programmer Tool Runtime Library Release 2.7
 */
/*
 *                      Emotion Engine Library
 *                          Version 1.70
 *                           Shift-JIS
 *
 *      Copyright (C) 1998-1999 Sony Computer Entertainment Inc.
 *                        All Rights Reserved.
 *
 *                       libkernel - app.cmd
 *                        kernel libraly
 *
 *       Version        Date            Design      Log
 *  --------------------------------------------------------------------
 *      0.11            May.10.1999     horikawa    
 *      1.10            Oct.12.1999     horikawa   add .stack section
 *      1.20            Nov.09.1999     horikawa   add _heap_end
 *      1.50            Feb.29.2000     horikawa   remove .indata section
 *      1.60            May.08.2000     horikawa   modify start address
 *      1.70            Jun.08.2000     horikawa   modify .text section
 */

_stack_size = 0x0010000;
_stack = -1;
_heap_size = -1;

GROUP(-lc -lkernl -lgcc)
ENTRY(ENTRYPOINT)
SECTIONS {
	/* Place DNAS library code/data/misc in a separate, shared location with game data */
	.dnas		0x100B280: {
		__dnas_org = .;
		C:\usr\local\sce\ee\lib\dnas_net.a(.text)
		C:\usr\local\sce\ee\lib\dnas_net.a(.data)
		C:\usr\local\sce\ee\lib\dnas_net.a(.*)
		C:\usr\local\sce\ee\lib\dnas_nete.a(.text)
		C:\usr\local\sce\ee\lib\dnas_nete.a(.data)
		C:\usr\local\sce\ee\lib\dnas_nete.a(.*)
		C:\usr\local\sce\ee\lib\dnas_neti.a(.text)
		C:\usr\local\sce\ee\lib\dnas_neti.a(.data)
		C:\usr\local\sce\ee\lib\dnas_neti.a(.*)
	 }
	.text		0x00100000: {
		__text_org = .;
		/*crt0.obj(.text)*/
		*(.text)
		*(.text.*)
    		*(.gnu.linkonce.t*)
		QUAD(0)
		__text_objend = .;
	}
	.ctors 			  : {
		KEEP (*crtbegin.o(.ctors))
		KEEP (*(EXCLUDE_FILE (*crtend.o) .ctors))
	    	KEEP (*(SORT(.ctors.*)))
		KEEP (*(.ctors))	
	}
  	.dtors    : 	{
    		KEEP (*crtbegin.o(.dtors))
    		KEEP (*(EXCLUDE_FILE (*crtend.o) .dtors))
    		KEEP (*(SORT(.dtors.*)))
    		KEEP (*(.dtors))
  	}

	.reginfo		  : { KEEP(*(.reginfo)) }
	.data		ALIGN(128): { 
		__data_org = .;
		*(.data)
	    *(.data.*)
    	*(.gnu.linkonce.d*)
	 }	 
	/* FOR DLL .sndata     ALIGN(128): { sn_dll_header_root = .; . += 582564; }*/
	
	.rodata		ALIGN(128): {
		__rodata_org = .;
		*(.rodata)
		*(.rodata.*)
		*(.gnu.linkonce.r*)
	}
	.rdata		ALIGN(128): { *(.rdata) }
	.gcc_except_table ALIGN(128): { *(.gcc_except_table) }
	
	_gp = ALIGN(128) + 0x7ff0;	 /*  MICK */ 
	
	.lit8       	ALIGN(128): { *(.lit8) }
	.lit4       	ALIGN(128): { *(.lit4) }
	.sdata		ALIGN(128): {
		*(.sdata)
		*(.sdata.*)
		*(.gnu.linkonce.s*)
	 }
	.sbss		ALIGN(128): { _fbss = .; *(.sbss) *(.scommon) }
	.bss		ALIGN(128): { 
		__bss_org = .;
		*(.bss) 
		__bss_objend = .;
	}
	.mem		ALIGN(16): 
	{ 
		_mem_obj = .;
		*(.mem) 
	}		
	.stdend		0x01ff0000 : 
	{ 
		_stdend_obj = .;		
		*(.stdend) 
	}		
	.script_heap	0x02900000: 
	{ 
		_script_heap_obj = .;
		*(.script_heap) 
	}		
	.debug_heap		0x03100000: 
	{ 
		_debug_heap_obj = .;
		*(.debug_heap) 
	}		
	.callstack		0x05100000: 
	{ 
		_callstack_obj = .;
		*(.callstack) 
	}		
	.symbols		0x06700000: 
	{ 
		_symbols_obj = .;	
		*(.symbols) 
	}		
	.map_file		0x06A00000: 
	{ 
		_map_file_obj = .;
		*(.map_file) 
	}		
	.mem_dump		0x06D00000: 
	{ 
		_mem_dump_obj = .;
		*(.mem_dump) 
	}		
	.log_info		0x06E00000: 
	{ 
		_log_info_obj = .;
		*(.log_info) 
	}		
	.script_debugger	0x06E00080: 
	{ 
		_script_debugger_obj = .;
		*(.script_debugger) 
	}		
	.script			0x06E00100: 
	{ 
		_script_obj = .;				
		*(.script) 
	}		
	.end_128k		0x08000000: 
	{ 
		_end_128k_obj = .;
		*(.end_128k) 
	}		
	
	.spad		0x70000000: {
		. = ALIGN( 4 );
		 *(.spad)
	}
	end = .;
	_end = .;
	/* _heap_end = . + _heap_size */
	.spad		0x70000000: {
		 /*crt0.obj(.spad)*/
		 *(.spad)
	}

	_std_stack = _stdend_obj;
/*	_gp	= 0x80010000; */					/*  MICK   */
	_fbss = __bss_org;
	_end = __bss_objend;

	_code_start	= __text_org;
	_code_end = __data_org;
	_data_end = __bss_objend;

	_heap_size = 0x00010000;
	_mem_start = _mem_obj + _heap_size;

	_std_mem_end = _stdend_obj - 0x10;
	_mem_end = _callstack_obj - 0x10;

	_script_heap_start = _script_heap_obj;
	_debug_heap_start = _debug_heap_obj;
	_callstack_start = _callstack_obj;
	_symbols_start = _symbols_obj;
	_map_file_start	= _map_file_obj;
	_mem_dump_start	= _mem_dump_obj;
	_log_info_start = _log_info_obj;
	_log_info_end = _script_obj - 0x10;
	_script_debugger_start = _script_debugger_obj;
	_script_start = _script_obj;
	_script_end	= _end_128k_obj - 0x10;
	_end = __bss_objend;
	_dnas_start = __dnas_org;
	_dnas_size = SIZEOF( .dnas );
}
