//****************************************************************************
//
// com_menu.h
//
// communication menu definitions
//
//****************************************************************************

#ifndef _com_menu_definitions_
#define _com_menu_definitions_



// =========================================================================

MenuSectionType ChangePortSpeedSection1 =
   {
   //|_NUM|_CE_| Section Type
         5,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "9600 BAUD\0", // text
         "Set Port Speed to 9600 baud.\0", // help
         &PortSpeed, // ptr
         9600
         },

         {
         status_active,
         entrytype_choice,
         "14400 BAUD\0", // text
         "Set Port Speed to 14400 baud.\0", // help
         &PortSpeed, // ptr
         14400
         },

         {
         status_active,
         entrytype_choice,
         "19200 BAUD\0", // text
         "Set Port Speed to 19200 baud.\0", // help
         &PortSpeed, // ptr
         19200
         },

         {
         status_active,
         entrytype_choice,
         "38400 BAUD\0", // text
         "Set Port Speed to 38400 baud.\0", // help
         &PortSpeed, // ptr
         38400
         },

         {
         status_active,
         entrytype_choice,
         "57600 BAUD\0", // text
         "Set Port Speed to 57600 baud.\0", // help
         &PortSpeed, // ptr
         57600
         },
      }
   };

MenuType ChangePortSpeedMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Change Port Speed\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &ChangePortSpeedSection1,
      }
   };
// =========================================================================

MenuSectionType PortSetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         4,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_display,
         entrytype_displayvalue,
         "COM Port Number\0", // text
         "\0", // help
         &ComPort, // ptr
         valuetype_decimal,
         },

         {
         status_display,
         entrytype_displayvalue,
         "IRQ Number\0", // text
         "\0", // help
         &IrqNumber, // ptr
         valuetype_decimal,
         },

         {
         status_display,
         entrytype_displayvalue,
         "UART Address\0", // text
         "\0", // help
         &UartAddress, // ptr
         valuetype_hexadecimal,
         },

         {
         status_display,
         entrytype_displayvalue,
         "Port Speed\0", // text
         "\0", // help
         &PortSpeed, // ptr
         valuetype_decimal,
         },
      }
   };

MenuSectionType PortSetupSection2 =
   {
   //|_NUM|_CE_| Section Type
         4,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_entervalue,
         "Change COM Port\0", // text
         "Change the COM Port number\0", // help
         &ComPort, // ptr
         valuetype_decimal,
         1,
         4,
         },

         {
         status_active,
         entrytype_entervalue,
         "Change IRQ number\0", // text
         "Change the IRQ number of the COM Port\0", // help
         &IrqNumber, // ptr
         valuetype_decimal,
         1,
         15,
         },

         {
         status_active,
         entrytype_entervalue,
         "Change UART address\0", // text
         "Change the UART address of the COM Port.\0", // help
         &UartAddress, // ptr
         valuetype_hexadecimal,
         0x0,
         0xffff,
         },

         {
         status_active,
         entrytype_menulink,
         "Change Port Speed\0", // text
         "Choose Modem and dialing options.\0", // help
         &ChangePortSpeedMenu, // ptr
         },
      }
   };

MenuType PortSetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         2,  -1,  -1,menutype_leftjustified,
   // Window Header
      "COM Port Setup\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &PortSetupSection1,
      &PortSetupSection2,
      }
   };
// =========================================================================

MenuSectionType ModemSetupSection2 =
   {
   //|_NUM|_CE_| Section Type
         2,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_value,
         "TONE dialing\0", // text
         "Use TONE dialing for all modem calls.\0", // help
         &ToneDial, // ptr
         1,
         },

         {
         status_active,
         entrytype_value,
         "PULSE dialing\0", // text
         "Use PULSE dialing for all modem calls.\0", // help
         &ToneDial, // ptr
         0,
         },
      }
   };

MenuSectionType ModemSetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         8,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_display,
         entrytype_menulink,
         "Modem Name\0", // text
         "\0", // help
         NULL, // ptr
         },

         {
         status_display,
         entrytype_displaystring,
         "\0", // text
         "\0", // help
         ModemName, // ptr
         MAXMODEMSTRING,
         },
         {
         status_display,
         entrytype_menulink,
         "Initialization String\0", // text
         "\0", // help
         NULL, // ptr
         },

         {
         status_display,
         entrytype_displaystring,
         "\0", // text
         "\0", // help
         InitString, // ptr
         MAXMODEMSTRING,
         },

         {
         status_display,
         entrytype_menulink,
         "Hangup String\0", // text
         "\0", // help
         NULL, // ptr
         },

         {
         status_display,
         entrytype_displaystring,
         "\0", // text
         "\0", // help
         HangupString, // ptr
         MAXMODEMSTRING,
         },

         {
         status_display,
         entrytype_menulink,
         "Dialout String\0", // text
         "\0", // help
         NULL, // ptr
         },

         {
         status_display,
         entrytype_displaystring,
         "\0", // text
         "\0", // help
         DialoutString, // ptr
         MAXMODEMSTRING,
         },
      }
   };

MenuSectionType ModemSetupSection3 =
   {
   //|_NUM|_CE_| Section Type
         4,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_fromfile,
         "Choose Modem\0", // text
         "Choose a modem from a modem file\0", // help
         "MODEM.PCK", // ptr
         4,
         ModemName,
         InitString,
         HangupString,
         NULL,
         },
         {
         status_active,
         entrytype_string,
         "Change Init String\0", // text
         "Change the initialization string for your modem\0", // help
         InitString, // ptr
         MAXMODEMSTRING,
         },

         {
         status_active,
         entrytype_string,
         "Change Hangup String\0", // text
         "Change the hangup string for your modem\0", // help
         HangupString, // ptr
         MAXMODEMSTRING,
         },

         {
         status_active,
         entrytype_string,
         "Change Dialout String\0", // text
         "Change the dialout string for your modem\0", // help
         DialoutString, // ptr
         MAXMODEMSTRING,
         },
      }
   };

MenuType ModemSetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         3,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Modem Setup\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &ModemSetupSection1,
      &ModemSetupSection2,
      &ModemSetupSection3,
      }
   };

// =========================================================================

MenuSectionType NetworkSetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         1,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_display,
         entrytype_displayvalue,
         "Socket Number\0", // text
         "\0", // help
         &SocketNumber, // ptr
         valuetype_hexadecimal,
         },
      }
   };

MenuSectionType NetworkSetupSection2 =
   {
   //|_NUM|_CE_| Section Type
         1,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_entervalue,
         "Change Socket Number\0", // text
         "Change the socket number used for all network communications\0", // help
         &SocketNumber, // ptr
         valuetype_hexadecimal,
         0,
         0xffff,
         },
      }
   };

MenuType NetworkSetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         2,  -1,  -1,menutype_centered,
   // Window Header
      "Network Socket #\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &NetworkSetupSection1,
      &NetworkSetupSection2,
      }
   };

// =========================================================================
MenuSectionType MacrosSetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         10,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_displaystring,
         "Macro #1 \0", // text
         "Change the current macro\0", // help
         &CommbatMacro[0], // ptr
         MAXMACROLENGTH
         },

         {
         status_active,
         entrytype_displaystring,
         "Macro #2 \0", // text
         "Change the current macro\0", // help
         &CommbatMacro[1], // ptr
         MAXMACROLENGTH
         },

         {
         status_active,
         entrytype_displaystring,
         "Macro #3 \0", // text
         "Change the current macro\0", // help
         &CommbatMacro[2], // ptr
         MAXMACROLENGTH
         },

         {
         status_active,
         entrytype_displaystring,
         "Macro #4 \0", // text
         "Change the current macro\0", // help
         &CommbatMacro[3], // ptr
         MAXMACROLENGTH
         },

         {
         status_active,
         entrytype_displaystring,
         "Macro #5 \0", // text
         "Change the current macro\0", // help
         &CommbatMacro[4], // ptr
         MAXMACROLENGTH
         },

         {
         status_active,
         entrytype_displaystring,
         "Macro #6 \0", // text
         "Change the current macro\0", // help
         &CommbatMacro[5], // ptr
         MAXMACROLENGTH
         },

         {
         status_active,
         entrytype_displaystring,
         "Macro #7 \0", // text
         "Change the current macro\0", // help
         &CommbatMacro[6], // ptr
         MAXMACROLENGTH
         },

         {
         status_active,
         entrytype_displaystring,
         "Macro #8 \0", // text
         "Change the current macro\0", // help
         &CommbatMacro[7], // ptr
         MAXMACROLENGTH
         },

         {
         status_active,
         entrytype_displaystring,
         "Macro #9 \0", // text
         "Change the current macro\0", // help
         &CommbatMacro[8], // ptr
         MAXMACROLENGTH
         },

         {
         status_active,
         entrytype_displaystring,
         "Macro #10\0", // text
         "Change the current macro\0", // help
         &CommbatMacro[9], // ptr
         MAXMACROLENGTH
         },
      }
   };

MenuType MacrosSetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Comm-Bat Macros Setup\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &MacrosSetupSection1,
      }
   };
// =========================================================================
extern MenuType PhoneNumberMenu;

#define PHONEHELP "(E) to Change name and phone number, Enter selects number\0"
#define PHONENAME "Name for Phone Entry\0"
#define PHONENUMBER "Number for Phone Entry\0"

MenuSectionType PhoneNumberSection1 =
   {
   //|_NUM|_CE_| Section Type
         10,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_dualstring,
         PhoneNames[0], // string 1
         PHONEHELP,
         PHONENAMELENGTH,
         PhoneNumbers[0], // string 2
         PHONENUMBERLENGTH,
         PHONENAME,
         PHONENUMBER,
         PhoneNumber
         },

         {
         status_active,
         entrytype_dualstring,
         PhoneNames[1], // string 1
         PHONEHELP,
         PHONENAMELENGTH,
         PhoneNumbers[1], // string 2
         PHONENUMBERLENGTH,
         PHONENAME,
         PHONENUMBER,
         PhoneNumber
         },

         {
         status_active,
         entrytype_dualstring,
         PhoneNames[2], // string 1
         PHONEHELP,
         PHONENAMELENGTH,
         PhoneNumbers[2], // string 2
         PHONENUMBERLENGTH,
         PHONENAME,
         PHONENUMBER,
         PhoneNumber
         },

         {
         status_active,
         entrytype_dualstring,
         PhoneNames[3], // string 1
         PHONEHELP,
         PHONENAMELENGTH,
         PhoneNumbers[3], // string 2
         PHONENUMBERLENGTH,
         PHONENAME,
         PHONENUMBER,
         PhoneNumber
         },

         {
         status_active,
         entrytype_dualstring,
         PhoneNames[4], // string 1
         PHONEHELP,
         PHONENAMELENGTH,
         PhoneNumbers[4], // string 2
         PHONENUMBERLENGTH,
         PHONENAME,
         PHONENUMBER,
         PhoneNumber
         },

         {
         status_active,
         entrytype_dualstring,
         PhoneNames[5], // string 1
         PHONEHELP,
         PHONENAMELENGTH,
         PhoneNumbers[5], // string 2
         PHONENUMBERLENGTH,
         PHONENAME,
         PHONENUMBER,
         PhoneNumber
         },

         {
         status_active,
         entrytype_dualstring,
         PhoneNames[6], // string 1
         PHONEHELP,
         PHONENAMELENGTH,
         PhoneNumbers[6], // string 2
         PHONENUMBERLENGTH,
         PHONENAME,
         PHONENUMBER,
         PhoneNumber
         },

         {
         status_active,
         entrytype_dualstring,
         PhoneNames[7], // string 1
         PHONEHELP,
         PHONENAMELENGTH,
         PhoneNumbers[7], // string 2
         PHONENUMBERLENGTH,
         PHONENAME,
         PHONENUMBER,
         PhoneNumber
         },

         {
         status_active,
         entrytype_dualstring,
         PhoneNames[8], // string 1
         PHONEHELP,
         PHONENAMELENGTH,
         PhoneNumbers[8], // string 2
         PHONENUMBERLENGTH,
         PHONENAME,
         PHONENUMBER,
         PhoneNumber
         },

         {
         status_active,
         entrytype_dualstring,
         PhoneNames[9], // string 1
         PHONEHELP,
         PHONENAMELENGTH,
         PhoneNumbers[9], // string 2
         PHONENUMBERLENGTH,
         PHONENAME,
         PHONENUMBER,
         PhoneNumber
         },
      }
   };

MenuType PhoneNumberMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Phone Numbers\0",
   // Window Footer
      "Esc Exits   Move  E to Edit Entry   Selects\0",
   //
   // menu body
   //
      {
      &PhoneNumberSection1,
      }
   };

// =========================================================================

MenuSectionType NetworkGameSection1 =
   {
   //|_NUM|_CE_| Section Type
         3,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_display,
         entrytype_displaystring,
         "Player Name\0", // text
         "\0", // help
         &PlayerName, // ptr
         },
         {
         status_display,
         entrytype_displayvalue,
         "Number of Players\0", // text
         "\0", // help
         &NumberPlayers, // ptr
         valuetype_decimal,
         },
         {
         status_display,
         entrytype_displaystring,
         "RTS File\0", // text
         "\0", // help
         &RTSName, // ptr
         },
      }
   };

MenuSectionType NetworkGameSection2 =
   {
   //|_NUM|_CE_| Section Type
         6,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_entervalue,
         "Change Number of Players\0", // text
         "Change number of players in network game\0", // help
         &NumberPlayers, // ptr
         valuetype_slider,
         2,
         MAXPLAYERS
         },

         {
         status_active,
         entrytype_menulink,
         "Setup Network Socket Number\0", // text
         "Change Socket number\0", // help
         &NetworkSetupMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Setup Macros\0", // text
         "Change Comm-bat macros\0", // help
         &MacrosSetupMenu, // ptr
         },

         {
         status_active,
         entrytype_choosefile,
         "Change " RTSEXTENSION " file\0", // text
         "Select a Remote Ridicule RTS file to use in " GAMENAME "\0", // help
         RTSName, // ptr
         "*." RTSEXTENSION "\0",
         },

         {
         status_active,
         entrytype_string,
         "Change Player Name\0", // text
         "Change name you would like to use in Comm-bat\0", // help
         PlayerName, // ptr
         MAXPLAYERNAMELENGTH,
         },

         {
         status_active,
         entrytype_functionlink,
         "Launch " GAMENAME "\0", // help
         "Launch a network game of " GAMENAME "\0", // help
         &LaunchMultiPlayer,
         gametype_network
         },
      }
   };

MenuType NetworkGameMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         2,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Network Game\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &NetworkGameSection1,
      &NetworkGameSection2,
      }
   };


// =========================================================================

MenuSectionType ModemGameSection1 =
   {
   //|_NUM|_CE_| Section Type
         3,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_display,
         entrytype_displaystring,
         "Phone Number\0", // text
         NULL, // help
         &PhoneNumber, // ptr
         PHONENUMBERLENGTH
         },
         {
         status_display,
         entrytype_displaystring,
         "RTS File\0", // text
         "\0", // help
         &RTSName, // ptr
         },
         {
         status_display,
         entrytype_displaystring,
         "Player Name\0", // text
         "\0", // help
         &PlayerName, // ptr
         },
      }
   };

MenuSectionType ModemGameSection2 =
   {
   //|_NUM|_CE_| Section Type
         3,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_value,
         "Already Connected\0", // text
         "You have already established a modem connection\0", // help
         &ConnectType, // ptr
         connecttype_alreadyconnected,
         },

         {
         status_active,
         entrytype_value,
         "Wait For Call\0", // text
         "Wait for your opponent to call you\0", // help
         &ConnectType, // ptr
         connecttype_answer,
         },

         {
         status_active,
         entrytype_value,
         "Dial your opponent\0", // text
         "Dial your opponent using the phone number shown\0", // help
         &ConnectType, // ptr
         connecttype_dialing,
         },
      }
   };

MenuSectionType ModemGameSection3 =
   {
   //|_NUM|_CE_| Section Type
         7,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_menulink,
         "Setup COM port\0", // text
         "Setup COM port number, IRQ and UART address.\0", // help
         &PortSetupMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Setup Modem\0", // text
         "Choose Modem and dialing options.\0", // help
         &ModemSetupMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Setup Macros\0", // text
         "Change Comm-bat macros\0", // help
         &MacrosSetupMenu, // ptr
         },
         {
         status_active,
         entrytype_choosefile,
         "Change " RTSEXTENSION " file\0", // text
         "Select a Remote Ridicule RTS file to use in " GAMENAME "\0", // help
         RTSName, // ptr
         "*." RTSEXTENSION "\0",
         },

         {
         status_active,
         entrytype_string,
         "Change Player Name\0", // text
         "Change name you would like to use in Comm-bat\0", // help
         PlayerName, // ptr
         MAXPLAYERNAMELENGTH,
         },

         {
         status_active,
         entrytype_menulink,
         "Phone Number List\0", // text
         "Change phone number to use when dialing\0", // help
         &PhoneNumberMenu, // ptr
         },

         {
         status_active,
         entrytype_functionlink,
         "Launch " GAMENAME "\0", // help
         "Launch a modem game of " GAMENAME "\0", // help
         &LaunchMultiPlayer,
         gametype_modem
         },
      }
   };


MenuType ModemGameMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         3,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Modem Game\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &ModemGameSection1,
      &ModemGameSection2,
      &ModemGameSection3,
      }
   };

// =========================================================================

MenuSectionType SerialGameSection1 =
   {
   //|_NUM|_CE_| Section Type
         2,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_display,
         entrytype_displaystring,
         "Player Name\0", // text
         "\0", // help
         &PlayerName, // ptr
         },
         {
         status_display,
         entrytype_displaystring,
         "RTS File\0", // text
         "\0", // help
         &RTSName, // ptr
         },
      }
   };

MenuSectionType SerialGameSection2 =
   {
   //|_NUM|_CE_| Section Type
         5,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_menulink,
         "Setup COM port\0", // text
         "Setup COM port number, IRQ and UART address.\0", // help
         &PortSetupMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Setup Macros\0", // text
         "Change Comm-bat macros\0", // help
         &MacrosSetupMenu, // ptr
         },

         {
         status_active,
         entrytype_choosefile,
         "Change " RTSEXTENSION " file\0", // text
         "Select a Remote Ridicule RTS file to use in " GAMENAME "\0", // help
         RTSName, // ptr
         "*." RTSEXTENSION "\0",
         },

         {
         status_active,
         entrytype_string,
         "Change Player Name\0", // text
         "Change name you would like to use in Comm-bat\0", // help
         PlayerName, // ptr
         MAXPLAYERNAMELENGTH,
         },

         {
         status_active,
         entrytype_functionlink,
         "Launch " GAMENAME "\0", // help
         "Launch a serial game of " GAMENAME "\0", // help
         &LaunchMultiPlayer,
         gametype_serial
         },
      }
   };


MenuType SerialGameMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         2,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Serial Game\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &SerialGameSection1,
      &SerialGameSection2,
      }
   };

#endif
















































































































































































































































