#ifndef __SOUND_H
#define __SOUND_H
#include "typedefs.h"

/***********************************************************************
 * Type definitions
 **********************************************************************/

class SAMPLE
{
public:
	int hVoice;
	virtual void callback( void ) = 0;
};


/***********************************************************************
 * Exported variables
 **********************************************************************/

extern int gFXDevice;
extern int gMusicDevice;


/***********************************************************************
 * Function prototypes
 **********************************************************************/
extern void sndPlaySong( char *song, BOOL loopflag );
extern BOOL sndIsSongPlaying( void );
extern void sndStopSong( void );

extern void sndStartSample( char *sampleName, int nVol, int nChannel = -1 );
/* Play a sound at the given volume.  Use this function for interface and other
non-3D sound effects. */

extern void sndKillAllSounds( void );
/* Stop all interface sounds.  This could potentially kill all 3D sounds, too.
*/

extern void sndInit( void );
extern void sndTerm( void );

#endif //__SOUND_H
