#include "db.h"
#include "engine.h"
#include "globals.h"
#include "options.h"
#include "warp.h"

/***********************************************************************
 * Global Data
 **********************************************************************/
ZONE gStartZone[kMaxPlayers];

/***********************************************************************
 * InitPlayerStartZones()
 *
 **********************************************************************/
void InitPlayerStartZones( void )
{
	for ( int nSprite = 0; nSprite < kMaxSprites; nSprite++ )
		if (sprite[nSprite].statnum < kMaxStatus)
		{
			SPRITE *pSprite = &sprite[nSprite];
			XSPRITE *pXSprite = &xsprite[pSprite->extra];
			switch( pSprite->type )
			{
				case kMarkerPlayerStart:
					if ( (gNetMode == kNetModeOff || gNetMode == kNetModeCoop)
					&& (pXSprite->data1 >= 0 && pXSprite->data1 < kMaxPlayers) )
					{
						ZONE *pZone = &gStartZone[pXSprite->data1];
						pZone->x = pSprite->x;
						pZone->y = pSprite->y;
						pZone->z = pSprite->z;
						pZone->sector = pSprite->sectnum;
						pZone->angle = pSprite->ang;
					}
					deletesprite( (short)nSprite );
					break;
				case kMarkerDeathStart:
					if ( gNetMode == kNetModeBloodBath
					&& (pXSprite->data1 >= 0 && pXSprite->data1 < kMaxPlayers) )
					{
						ZONE *pZone = &gStartZone[pXSprite->data1];
						pZone->x = pSprite->x;
						pZone->y = pSprite->y;
						pZone->z = pSprite->z;
						pZone->sector = pSprite->sectnum;
						pZone->angle = pSprite->ang;
					}
					deletesprite( (short)nSprite );
					break;
			}
		}
}
