#ifndef _textlib_private_
#define _textlib_private_

//
// Defines
//

//#define TEXTLINEWIDTH 160

//
// Macros
//

//******************************************************************************
//
// TextAddress (x, y)
//
//******************************************************************************
#ifdef __FLAT__
#define TextAddress(x,y) ( ( (byte *) (0xb8000) + (textylookup[y]) + (x<<1) ) )
#else
#define TextAddress(x,y) ( ( (byte far *) (MK_FP(0xB800,0)) + (textylookup[y]) + (x<<1) ) )
#endif

//******************************************************************************
//
// PlotCharacter (x, y, character)
//
//******************************************************************************
#define PlotCharacter(x,y,character)                                     \
   {                                                                     \
   *( TextAddress((x),(y)) + 0 ) = (byte)(character);\
   }

//******************************************************************************
//
// PlotAttribute (x, y, attribute)
//
//******************************************************************************
#define PlotAttribute(x,y,attribute)                                         \
   {                                                                         \
   *( TextAddress((x),(y)) + 1 ) = (byte)(attribute);\
   }

//******************************************************************************
//
// PlotBoth(x, y, character, attribute)
//
//******************************************************************************
#define PlotBoth(x,y,character,attribute)                   \
   {                                                         \
   *( (uint16 *) TextAddress((x),(y)) ) =             \
   (uint16)( ( (byte)(attribute) << 8 ) + ( (byte)(character) ) );  \
   }

//******************************************************************************
//
// Plot(x, y, character, lowattribute, highattribute)
//
//******************************************************************************
#define Plot(x,y,character,lowattribute,highattribute)      \
   {                                                         \
   *( (uint16 *) TextAddress( (x),(y) ) ) =                   \
   (uint16) (  (                                              \
                  (                                           \
                     (byte)                                   \
                     (                                        \
                        (                                     \
                           ((highattribute)&15) << 4          \
                        ) +                                   \
                        ((lowattribute)&15)                   \
                     )                                        \
                  ) << 8                                      \
               )                                              \
               +                                              \
               (                                              \
                 (byte)                                       \
                 (                                            \
                    (character) & 255                         \
                 )                                            \
               )                                              \
            );                                                \
   }

//
// Functions
//

void TurnOffTextCursor ( void );
void ToggleBlinking ( void );
void LimitXY
   (
   int32 * x,
   int32 * y
   );


#endif
