//****************************************************************************
//
// snd_menu.h
//
// sound menu definitions
//
//****************************************************************************

#ifndef _snd_menu_definitions_
#define _snd_menu_definitions_



//***************************************************************************
//
// Sound And Music Menus
//
//***************************************************************************

// =========================================================================
// Sound FX Menu
// Sound FX Section 1

MenuSectionType SoundFXSection =
   {
   //|_NUM|_CE_| Section Type
        9,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_functionlink,
         "None\0", // text
         "You don't want any digital sound\0", // help
         &SetupSound, // ptr
         NumSoundCards,
         },

         {
         status_active,
         entrytype_functionlink,
         "Gravis Ultrasound\0", // text
         "You have a Gravis Ultrasound\0", // help
         &SetupSound, // ptr
         UltraSound,
         },

         {
         status_active,
         entrytype_functionlink,
         "Sound Blaster\0", // text
         "You have a Sound Blaster, SB Pro, SB 16 or SB Compatible\0", // help
         &SetupSound, // ptr
         SoundBlaster,
         },

         {
         status_active,
         entrytype_functionlink,
         "Sound Man 16\0", // text
         "You have a Sound Man 16\0", // help
         &SetupSound, // ptr
         SoundMan16,
         },

         {
         status_active,
         entrytype_functionlink,
         "Pro Audio Spectrum\0", // text
         "You have a Pro Audio Spectrum\0", // help
         &SetupSound, // ptr
         ProAudioSpectrum,
         },

         {
         status_active,
         entrytype_functionlink,
         "AWE 32\0", // text
         "You have an AWE 32\0", // help
         &SetupSound, // ptr
         Awe32,
         },

         {
         status_active,
         entrytype_functionlink,
         "Sound Scape\0", // text
         "You have a Ensoniq Sound Scape\0", // help
         &SetupSound, // ptr
         SoundScape,
         },

         {
         status_active,
         entrytype_functionlink,
         "Disney Sound Source\0", // text
         "You have a Disney Sound Source\0", // help
         &SetupSound, // ptr
         SoundSource,
         },

         {
         status_active,
         entrytype_functionlink,
         "Tandy Sound Source\0", // text
         "You have a Tandy Sound Source\0", // help
         &SetupSound, // ptr
         TandySoundSource,
         },
      }
   };

MenuType SoundFXMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Choose Sound FX Card\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &SoundFXSection
      }
   };

// =========================================================================
// Music Menu
// Music Section 1


MenuSectionType MusicSection =
   {
   //|_NUM|_CE_| Section Type
        11,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_functionlink,
         "None\0", // text
         "You don't want music\0", // help
         &SetupMusic, // ptr
         NumSoundCards,
         },

         {
         status_active,
         entrytype_functionlink,
         "Ultrasound\0", // text
         "You have a Gravis Ultrasound\0", // help
         &SetupMusic, // ptr
         UltraSound,
         },

         {
         status_active,
         entrytype_functionlink,
         "Sound Blaster\0", // text
         "You have a Sound Blaster, SB Pro, SB 16 or SB Compatible\0", // help
         &SetupMusic, // ptr
         SoundBlaster,
         },

         {
         status_active,
         entrytype_functionlink,
         "Sound Man 16\0", // text
         "You have a Sound Man 16\0", // help
         &SetupMusic, // ptr
         SoundMan16,
         },

         {
         status_active,
         entrytype_functionlink,
         "Pro Audio Spectrum\0", // text
         "You have a Pro Audio Spectrum\0", // help
         &SetupMusic, // ptr
         ProAudioSpectrum,
         },

         {
         status_active,
         entrytype_functionlink,
         "AWE 32\0", // text
         "You have an AWE 32\0", // help
         &SetupMusic, // ptr
         Awe32,
         },

         {
         status_active,
         entrytype_functionlink,
         "Sound Scape\0", // text
         "You have a Ensoniq Sound Scape\0", // help
         &SetupMusic, // ptr
         SoundScape,
         },

         {
         status_active,
         entrytype_functionlink,
         "Wave Blaster\0", // text
         "You have a Wave Blaster\0", // help
         &SetupMusic, // ptr
         WaveBlaster,
         },

         {
         status_active,
         entrytype_functionlink,
         "General Midi\0", // text
         "You have a General Midi music card\0", // help
         &SetupMusic, // ptr
         GenMidi,
         },

         {
         status_active,
         entrytype_functionlink,
         "Sound Canvas\0", // text
         "You have a Roland Sound Canvas\0", // help
         &SetupMusic, // ptr
         SoundCanvas,
         },

         {
         status_active,
         entrytype_functionlink,
         "Adlib\0", // text
         "You have an Adlib\0", // help
         &SetupMusic, // ptr
         Adlib,
         },

      }
   };

MenuType MusicMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Choose Music Card\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &MusicSection
      }
   };

// =========================================================================
// Sound Setup Menu
// Sound Setup Section 1

MenuSectionType SoundSetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         4,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_display,
         entrytype_translatevalue,
         "Current Sound FX Card\0", // text
         "\0", // help
         &SoundCardName, // ptr
         &FXDevice, // ptr
         },
         {
         status_display,
         entrytype_translatevalue,
         "   Current Music Card\0", // text
         "\0", // help
         &SoundCardName, // ptr
         &MusicDevice, // ptr
         },

         {
         status_display,
         entrytype_displayvalue,
         "      Sound FX Volume\0", // text
         "\0", // help
         &FXVolume, // ptr
         valuetype_decimal,
         },

         {
         status_display,
         entrytype_displayvalue,
         "         Music Volume\0", // text
         "\0", // help
         &MusicVolume, // ptr
         valuetype_decimal,
         },
      }
   };

MenuSectionType SoundSetupSection2 =
   {
   //|_NUM|_CE_| Section Type
        7,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_menulink,
         "Choose Sound FX Card\0", // text
         "Setup digital sound device for " GAMENAME "\0", // help
         &SoundFXMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Choose Music Card\0", // text
         "Setup Music device for " GAMENAME "\0", // help
         &MusicMenu, // ptr
         },

         {
#ifdef __FLAT__
         status_active,
#else
         status_inactive,
#endif
         entrytype_functionlink,
         "Test Sound FX Card\0", // text
         "Test Digital Sound Device\0", // help
         &TestSound, // ptr
         },

         {
#ifdef __FLAT__
         status_active,
#else
         status_inactive,
#endif
         entrytype_functionlink,
         "Test Music Card\0", // text
         "Test Music Device\0", // help
         &TestMusic, // ptr
         },

         {
         status_active,
         entrytype_entervalue,
         "Sound FX Volume\0", // text
         "Set Sound FX Volume\0", // help
         &FXVolume, // ptr
         valuetype_slider,
         0,
         255
         },

         {
         status_active,
         entrytype_entervalue,
         "Music Volume\0", // text
         "Set Music Volume\0", // help
         &MusicVolume, // ptr
         valuetype_slider,
         0,
         255
         },

         {
         status_active,
         entrytype_togglebutton,
         "Reverse Stereo\0", // text
         "Reverse Left and Right Stereo Channels\0", // help
         &ReverseStereo, // ptr
         },

      }
   };

MenuType SoundSetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         2,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Sound Setup\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &SoundSetupSection1,
      &SoundSetupSection2
      }
   };

// =========================================================================
// Blaster Address Menu
// Blaster Address Section 1

MenuSectionType BlasterAddressSection1 =
   {
   //|_NUM|_CE_| Section Type
         7,  1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "0x210\0", // text
         "Set Sound Blaster Port Address to 0x210\0", // help
         &BlasterConfig.Address, // ptr
         0x210,
         },
         {
         status_active,
         entrytype_choice,
         "0x220\0", // text
         "Set Sound Blaster Port Address to 0x220\0", // help
         &BlasterConfig.Address, // ptr
         0x220,
         },
         {
         status_active,
         entrytype_choice,
         "0x230\0", // text
         "Set Sound Blaster Port Address to 0x230\0", // help
         &BlasterConfig.Address, // ptr
         0x230,
         },
         {
         status_active,
         entrytype_choice,
         "0x240\0", // text
         "Set Sound Blaster Port Address to 0x240\0", // help
         &BlasterConfig.Address, // ptr
         0x240,
         },
         {
         status_active,
         entrytype_choice,
         "0x250\0", // text
         "Set Sound Blaster Port Address to 0x250\0", // help
         &BlasterConfig.Address, // ptr
         0x250,
         },
         {
         status_active,
         entrytype_choice,
         "0x260\0", // text
         "Set Sound Blaster Port Address to 0x260\0", // help
         &BlasterConfig.Address, // ptr
         0x260,
         },
         {
         status_active,
         entrytype_choice,
         "0x280\0", // text
         "Set Sound Blaster Port Address to 0x280\0", // help
         &BlasterConfig.Address, // ptr
         0x280,
         },

      }
   };

MenuType BlasterAddressMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Sound Blaster Address\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &BlasterAddressSection1
      }
   };

// =========================================================================
// Blaster Type Menu
// Blaster Type Section 1

MenuSectionType BlasterTypeSection1 =
   {
   //|_NUM|_CE_| Section Type
         5,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "Sound Blaster or compatible", //text
         "You have a Sound Blaster or compatible\0", // help
         &BlasterConfig.Type, // ptr
         fx_SB,
         },

         {
         status_active,
         entrytype_choice,
         "Sound Blaster 2.0",
         "You have a Sound Blaster 2.0\0", // help
         &BlasterConfig.Type, // ptr
         fx_SB20,
         },

         {
         status_active,
         entrytype_choice,
         "Sound Blaster Pro (old)",
         "You have a Sound Blaster Pro\0", // help
         &BlasterConfig.Type, // ptr
         fx_SBPro,
         },

         {
         status_active,
         entrytype_choice,
         "Sound Blaster Pro 2.0 (new)",
         "You have a Sound Blaster Pro 2.0\0", // help
         &BlasterConfig.Type, // ptr
         fx_SBPro2,
         },

         {
         status_active,
         entrytype_choice,
         "Sound Blaster 16 or AWE32",
         "You have a Sound Blaster 16 or AWE32\0", // help
         &BlasterConfig.Type, // ptr
         fx_SB16,
         },
      }
   };

MenuType BlasterTypeMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Sound Blaster Type\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &BlasterTypeSection1
      }
   };

// =========================================================================
// Blaster Interrupt Menu
// Blaster Interrupt Section 1

MenuSectionType BlasterInterruptSection1 =
   {
   //|_NUM|_CE_| Section Type
         8,  2, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "IRQ 2", //text
         "Your Sound Blaster is set to Interrupt 2\0", // help
         &BlasterConfig.Interrupt, // ptr
         2,
         },

         {
         status_active,
         entrytype_choice,
         "IRQ 3", //text
         "Your Sound Blaster is set to Interrupt 3\0", // help
         &BlasterConfig.Interrupt, // ptr
         3,
         },

         {
         status_active,
         entrytype_choice,
         "IRQ 5", //text
         "Your Sound Blaster is set to Interrupt 5\0", // help
         &BlasterConfig.Interrupt, // ptr
         5,
         },

         {
         status_active,
         entrytype_choice,
         "IRQ 7", //text
         "Your Sound Blaster is set to Interrupt 7\0", // help
         &BlasterConfig.Interrupt, // ptr
         7,
         },

         {
         status_active,
         entrytype_choice,
         "IRQ 10", //text
         "Your Sound Blaster is set to Interrupt 10\0", // help
         &BlasterConfig.Interrupt, // ptr
         10,
         },

         {
         status_active,
         entrytype_choice,
         "IRQ 11", //text
         "Your Sound Blaster is set to Interrupt 11\0", // help
         &BlasterConfig.Interrupt, // ptr
         11,
         },

         {
         status_active,
         entrytype_choice,
         "IRQ 12", //text
         "Your Sound Blaster is set to Interrupt 12\0", // help
         &BlasterConfig.Interrupt, // ptr
         12,
         },

         {
         status_active,
         entrytype_choice,
         "IRQ 15", //text
         "Your Sound Blaster is set to Interrupt 15\0", // help
         &BlasterConfig.Interrupt, // ptr
         15,
         },
      }
   };

MenuType BlasterInterruptMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Sound Blaster Interrupt\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &BlasterInterruptSection1
      }
   };

// =========================================================================
// Blaster 8Dma Menu
// Blaster 8Dma Section 1

MenuSectionType Blaster8DmaSection1 =
   {
   //|_NUM|_CE_| Section Type
         3,  1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "DMA channel 0", //text
         "Your Sound Blaster's 8-bit DMA is set to DMA 0\0", // help
         &BlasterConfig.Dma8, // ptr
         0,
         },
         {
         status_active,
         entrytype_choice,
         "DMA channel 1", //text
         "Your Sound Blaster's 8-bit DMA is set to DMA 1\0", // help
         &BlasterConfig.Dma8, // ptr
         1,
         },
         {
         status_active,
         entrytype_choice,
         "DMA channel 3", //text
         "Your Sound Blaster's 8-bit DMA is set to DMA 3\0", // help
         &BlasterConfig.Dma8, // ptr
         3,
         },
      }
   };

MenuType Blaster8DmaMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Sound Blaster 8-bit DMA\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &Blaster8DmaSection1
      }
   };

// =========================================================================
// Blaster 16Dma Menu
// Blaster 16Dma Section 1

MenuSectionType Blaster16DmaSection1 =
   {
   //|_NUM|_CE_| Section Type
         3,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "DMA channel 5", //text
         "Your Sound Blaster's 16-bit DMA is set to DMA 5\0", // help
         &BlasterConfig.Dma16, // ptr
         5,
         },
         {
         status_active,
         entrytype_choice,
         "DMA channel 6", //text
         "Your Sound Blaster's 16-bit DMA is set to DMA 6\0", // help
         &BlasterConfig.Dma16, // ptr
         6,
         },
         {
         status_active,
         entrytype_choice,
         "DMA channel 7", //text
         "Your Sound Blaster's 16-bit DMA is set to DMA 7\0", // help
         &BlasterConfig.Dma16, // ptr
         7,
         },
      }
   };

MenuType Blaster16DmaMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Sound Blaster 16-bit DMA\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &Blaster16DmaSection1
      }
   };

// =========================================================================
// Blaster Setup Menu
// Blaster Setup Section 1

MenuSectionType BlasterSetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         5,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_display,
         entrytype_displayvalue,
         "Current Address   \0", // text
         "\0", // help
         &BlasterConfig.Address, // ptr
         valuetype_hexadecimal,
         },

         {
         status_display,
         entrytype_translatevalue,
         "Current Type      \0", // text
         "\0", // help
         &BlasterTypeName, // ptr
         &BlasterConfig.Type, // ptr
         },

         {
         status_display,
         entrytype_displayvalue,
         "Current Interrupt \0", // text
         "\0", // help
         &BlasterConfig.Interrupt, // ptr
         valuetype_decimal,
         },

         {
         status_display,
         entrytype_displayvalue,
         "Current 8-bit DMA \0", // text
         "\0", // help
         &BlasterConfig.Dma8, // ptr
         valuetype_decimal,
         },

         {
         status_display,
         entrytype_displayvalue,
         "Current 16-bit DMA\0", // text
         "\0", // help
         &BlasterConfig.Dma16, // ptr
         valuetype_decimal,
         },

      }
   };

MenuSectionType BlasterSetupSection2 =
   {
   //|_NUM|_CE_| Section Type
        1,  -1, sectiontype_choose,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_functionlink,
         "Use Current Settings\0", // text
         "Use the settings above and continue with sound setup\0", // help
         NULL, // ptr
         },
      }
   };

MenuSectionType BlasterSetupSection3 =
   {
   //|_NUM|_CE_| Section Type
        5,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_menulink,
         "Change Address\0", // text
         "Change the address of the card\0", // help
         &BlasterAddressMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Change Sound Card Type\0", // text
         "Change the type of card\0", // help
         &BlasterTypeMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Change Interrupt\0", // text
         "Change the interrupt of the card\0", // help
         &BlasterInterruptMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Change 8-bit DMA Channel\0", // text
         "Change the 8-bit DMA channel\0", // help
         &Blaster8DmaMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Change 16-bit DMA Channel\0", // text
         "Change the 16-bit DMA channel\0", // help
         &Blaster16DmaMenu, // ptr
         },
      }
   };

MenuType BlasterSetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         3,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Sound Blaster Configuration\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &BlasterSetupSection1,
      &BlasterSetupSection2,
      &BlasterSetupSection3
      }
   };

// =========================================================================
// NumVoices Menu
// NumVoices Section 1

MenuSectionType NumVoicesSection1 =
   {
   //|_NUM|_CE_| Section Type
         8,  3, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "1 Voice\0", // text
         "1 Digital Voice\0", // help
         &NumVoices, // ptr
         1,
         },
         {
         status_active,
         entrytype_choice,
         "2 Voices\0", // text
         "2 Digital Voices\0", // help
         &NumVoices, // ptr
         2,
         },
         {
         status_active,
         entrytype_choice,
         "3 Voices\0", // text
         "3 Digital Voices\0", // help
         &NumVoices, // ptr
         3,
         },
         {
         status_active,
         entrytype_choice,
         "4 Voices\0", // text
         "4 Digital Voices\0", // help
         &NumVoices, // ptr
         4,
         },
         {
         status_active,
         entrytype_choice,
         "5 Voices\0", // text
         "5 Digital Voices\0", // help
         &NumVoices, // ptr
         5,
         },
         {
         status_active,
         entrytype_choice,
         "6 Voices\0", // text
         "6 Digital Voices\0", // help
         &NumVoices, // ptr
         6,
         },
         {
         status_active,
         entrytype_choice,
         "7 Voices\0", // text
         "7 Digital Voices\0", // help
         &NumVoices, // ptr
         7,
         },
         {
         status_active,
         entrytype_choice,
         "8 Voices\0", // text
         "8 Digital Voices\0", // help
         &NumVoices, // ptr
         8,
         },
      }
   };

MenuType NumVoicesMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Number of Voices\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &NumVoicesSection1
      }
   };

// =========================================================================
// NumBits Menu
// NumBits Section 1

MenuSectionType NumBitsSection1 =
   {
   //|_NUM|_CE_| Section Type
         2,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "8 Bit mixing\0", // text
         "Sounds are mixed with 8 Bits (lower quality)\0", // help
         &NumBits, // ptr
         8,
         },

         {
         status_active,
         entrytype_choice,
         "16 Bit mixing\0", // text
         "Sounds are mixed with 16 Bits (higher quality)\0", // help
         &NumBits, // ptr
         16,
         },
      }
   };

MenuType NumBitsMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Number of Mixing Bits\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &NumBitsSection1
      }
   };

// =========================================================================
// NumChannels Menu
// NumChannels Section 1

MenuSectionType NumChannelsSection1 =
   {
   //|_NUM|_CE_| Section Type
         2,  1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "Mono Sound\0", // text
         "Mono sound, no stereo imaging\0", // help
         &NumChannels, // ptr
         1,
         },

         {
         status_active,
         entrytype_choice,
         "Stereo Sound\0", // text
         "Stereo Sound, full stereo imaging\0", // help
         &NumChannels, // ptr
         2,
         },
      }
   };

MenuType NumChannelsMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Number of Channels\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &NumChannelsSection1
      }
   };

// =========================================================================
// MixRate Menu
// MixRate Section 1

MenuSectionType MixRateSection1 =
   {
   //|_NUM|_CE_| Section Type
         4,  1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "8 Khz\0", // text
         "Set the mixing rate to 8 Khz\0", // help
         &MixRate, // ptr
         8000,
         },

         {
         status_active,
         entrytype_choice,
         "11 Khz\0", // text
         "Set the mixing rate to 11 Khz\0", // help
         &MixRate, // ptr
         11000,
         },

         {
         status_active,
         entrytype_choice,
         "16 Khz\0", // text
         "Set the mixing rate to 16 Khz\0", // help
         &MixRate, // ptr
         16000,
         },

         {
         status_active,
         entrytype_choice,
         "22 Khz\0", // text
         "Set the mixing rate to 22 Khz\0", // help
         &MixRate, // ptr
         22000,
         },
      }
   };

MenuType MixRateMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Mixing Rate\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &MixRateSection1
      }
   };

// =========================================================================
// BlasterEmu Menu
// BlasterEmu Section 1

MenuSectionType BlasterEmuSection1 =
   {
   //|_NUM|_CE_| Section Type
         7,  1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "0x610\0", // text
         "Set Sound Blaster Emu Address to 0x610\0", // help
         &BlasterConfig.Emu, // ptr
         0x610,
         },
         {
         status_active,
         entrytype_choice,
         "0x620\0", // text
         "Set Sound Blaster Emu Address to 0x620\0", // help
         &BlasterConfig.Emu, // ptr
         0x620,
         },
         {
         status_active,
         entrytype_choice,
         "0x630\0", // text
         "Set Sound Blaster Emu Address to 0x630\0", // help
         &BlasterConfig.Emu, // ptr
         0x630,
         },
         {
         status_active,
         entrytype_choice,
         "0x640\0", // text
         "Set Sound Blaster Emu Address to 0x640\0", // help
         &BlasterConfig.Emu, // ptr
         0x640,
         },
         {
         status_active,
         entrytype_choice,
         "0x650\0", // text
         "Set Sound Blaster Emu Address to 0x650\0", // help
         &BlasterConfig.Emu, // ptr
         0x650,
         },
         {
         status_active,
         entrytype_choice,
         "0x660\0", // text
         "Set Sound Blaster Emu Address to 0x660\0", // help
         &BlasterConfig.Emu, // ptr
         0x660,
         },
         {
         status_active,
         entrytype_choice,
         "0x680\0", // text
         "Set Sound Blaster Emu Address to 0x680\0", // help
         &BlasterConfig.Emu, // ptr
         0x680,
         },

      }
   };

MenuType BlasterEmuAddressMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "AWE 32 Emu Address\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &BlasterEmuSection1
      }
   };

// =========================================================================
// MidiPort Menu
// MidiPort Section 1

MenuSectionType MidiPortSection1 =
   {
   //|_NUM|_CE_| Section Type
         12,  6, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "0x220\0", // text
         "Set Midi Port to 0x220\0", // help
         &MidiPort, // ptr
         0x220,
         },
         {
         status_active,
         entrytype_choice,
         "0x230\0", // text
         "Set Midi Port to 0x230\0", // help
         &MidiPort, // ptr
         0x230,
         },
         {
         status_active,
         entrytype_choice,
         "0x240\0", // text
         "Set Midi Port to 0x240\0", // help
         &MidiPort, // ptr
         0x240,
         },
         {
         status_active,
         entrytype_choice,
         "0x250\0", // text
         "Set Midi Port to 0x250\0", // help
         &MidiPort, // ptr
         0x250,
         },
         {
         status_active,
         entrytype_choice,
         "0x300\0", // text
         "Set Midi Port to 0x300\0", // help
         &MidiPort, // ptr
         0x300,
         },
         {
         status_active,
         entrytype_choice,
         "0x320\0", // text
         "Set Midi Port to 0x320\0", // help
         &MidiPort, // ptr
         0x320,
         },
         {
         status_active,
         entrytype_choice,
         "0x330\0", // text
         "Set Midi Port to 0x330\0", // help
         &MidiPort, // ptr
         0x330,
         },
         {
         status_active,
         entrytype_choice,
         "0x332\0", // text
         "Set Midi Port to 0x332\0", // help
         &MidiPort, // ptr
         0x332,
         },
         {
         status_active,
         entrytype_choice,
         "0x334\0", // text
         "Set Midi Port to 0x334\0", // help
         &MidiPort, // ptr
         0x334,
         },
         {
         status_active,
         entrytype_choice,
         "0x336\0", // text
         "Set Midi Port to 0x336\0", // help
         &MidiPort, // ptr
         0x336,
         },
         {
         status_active,
         entrytype_choice,
         "0x340\0", // text
         "Set Midi Port to 0x340\0", // help
         &MidiPort, // ptr
         0x340,
         },
         {
         status_active,
         entrytype_choice,
         "0x360\0", // text
         "Set Midi Port to 0x360\0", // help
         &MidiPort, // ptr
         0x360,
         },
      }
   };

MenuType MidiPortMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "MIDI Port\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &MidiPortSection1
      }
   };


#endif










