#include <process.h>
#include <io.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "types.h"
#include "scriplib.h"
#include "file_lib.h"
#include "util_lib.h"


#define SETUPEXE   "setmain.exe"
#define LAUNCHPROG "launch.tmp"

void ShutDown( void )
  {
  }
#define MAXARGS 30
int32 main
   (
   int argc,
   char *argv[]
   )

   {
   char    *newargs[MAXARGS];
   int32   argnum=1;
   int32   i;

   unlink(LAUNCHPROG);

   if (argc>MAXARGS)
      argc = MAXARGS;

   for( i = 1; i < argc; i++ )
      {
	   newargs[ argnum++ ] = argv[ i ];
      }
   newargs[ argnum ] = NULL;

   newargs[ 0 ] = SETUPEXE;

   if (spawnvp ( P_WAIT, SETUPEXE , newargs)!=0)
      {
      printf("Spawn Error: %s\n",strerror(errno));
      return( -1 );
      }

   if (access (LAUNCHPROG,F_OK) == 0)
      {
      LoadScript ( LAUNCHPROG, true );
      unlink(LAUNCHPROG);
      i = 0;
      while (TokenAvailable(false))
         {
         char * temp;
         GetToken (false,false);
         temp = SafeMalloc(strlen(token)+1);
         strcpy(temp,token);
         newargs[i++] = temp;
         }
      newargs[ i ] = NULL;
      FreeScript();
      execvp ( newargs[0], newargs);
      printf("Exec Error: %s\n",strerror(errno));
      return( -1 );
      }

   return( 0 );
   }

