#include <conio.h>

#include "textio.h"


#define kBufSize	1024
#define kJoyPort	0x201

char data[kBufSize];

int axis[4];
int button[4];

void ReadJoystick( void )
{
	int i, j, mask;

	// write a dummy value to start resistive timing
	i = 0;
	outp(kJoyPort, 0xFF);
	while ( i < kBufSize )
		data[i++] = (char)inp(kJoyPort);

	for (j = 0, mask = 0x10; j < 4; j++, mask <<= 1)
		button[j] = (data[0] & mask) == 0;

	for (i = 0, mask = 1; i < 4; i++, mask <<= 1)
	{
		for (j = 0; j < kBufSize && (data[j] & mask) != 0; j++);
		axis[i] = j;
	}
}


void main( void )
{
	tioInit(1);

	while ( !kbhit() )
	{
		ReadJoystick();
		tioSetPos(0, 0);
		tioPrint("X0=%4d Y0=%4d X1=%4d Y1=%4d  Buttons: %d %d %d %d",
			axis[0], axis[1], axis[2], axis[3], button[0], button[1], button[2], button[3]);
	}
	getch();
}





